/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.JaiI18N;

public class TIFFLZWDecoder {
    byte[][] stringTable;
    byte[] data = null;
    byte[] uncompData;
    int tableIndex;
    int bitsToGet = 9;
    int bytePointer;
    int bitPointer;
    int dstIndex;
    int w;
    int h;
    int predictor;
    int samplesPerPixel;
    int nextData = 0;
    int nextBits = 0;
    int[] andTable = new int[]{511, 1023, 2047, 4095};

    public TIFFLZWDecoder(int n2, int n3, int n4) {
        this.w = n2;
        this.predictor = n3;
        this.samplesPerPixel = n4;
    }

    public byte[] decode(byte[] byArray, byte[] byArray2, int n2) {
        int n3;
        if (byArray[0] == 0 && byArray[1] == 1) {
            throw new UnsupportedOperationException(JaiI18N.getString("TIFFLZWDecoder0"));
        }
        this.initializeStringTable();
        this.data = byArray;
        this.h = n2;
        this.uncompData = byArray2;
        this.bytePointer = 0;
        this.bitPointer = 0;
        this.dstIndex = 0;
        this.nextData = 0;
        this.nextBits = 0;
        int n4 = 0;
        while ((n3 = this.getNextCode()) != 257 && this.dstIndex < byArray2.length) {
            byte[] byArray3;
            if (n3 == 256) {
                this.initializeStringTable();
                n3 = this.getNextCode();
                if (n3 == 257) break;
                this.writeString(this.stringTable[n3]);
                n4 = n3;
                continue;
            }
            if (n3 < this.tableIndex) {
                byArray3 = this.stringTable[n3];
                this.writeString(byArray3);
                this.addStringToTable(this.stringTable[n4], byArray3[0]);
                n4 = n3;
                continue;
            }
            byArray3 = this.stringTable[n4];
            byArray3 = this.composeString(byArray3, byArray3[0]);
            this.writeString(byArray3);
            this.addStringToTable(byArray3);
            n4 = n3;
        }
        if (this.predictor == 2) {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = this.samplesPerPixel * (i2 * this.w + 1);
                for (int i3 = this.samplesPerPixel; i3 < this.w * this.samplesPerPixel; ++i3) {
                    int n6 = n5;
                    byArray2[n6] = (byte)(byArray2[n6] + byArray2[n5 - this.samplesPerPixel]);
                    ++n5;
                }
            }
        }
        return byArray2;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i2 = 0; i2 < 256; ++i2) {
            this.stringTable[i2] = new byte[1];
            this.stringTable[i2][0] = (byte)i2;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.uncompData[this.dstIndex++] = byArray[i2];
        }
    }

    public void addStringToTable(byte[] byArray, byte by) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        this.stringTable[this.tableIndex++] = byArray2;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] byArray) {
        this.stringTable[this.tableIndex++] = byArray;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] byArray, byte by) {
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 1];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        byArray2[n2] = by;
        return byArray2;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.data[this.bytePointer++] & 0xFF;
                this.nextBits += 8;
            }
            int n2 = this.nextData >> this.nextBits - this.bitsToGet & this.andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 257;
        }
    }
}

