/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoder;
import com.fr.third.JAI.SeekableStream;
import com.fr.third.JAI.TIFFDecodeParam;
import com.fr.third.JAI.TIFFEncodeParam;
import com.fr.third.JAI.TIFFImageDecoder;
import com.fr.third.JAI.TIFFImageEncoder;
import java.awt.image.RenderedImage;
import java.io.OutputStream;

public final class TIFFCodec
extends ImageCodec {
    public String getFormatName() {
        return "tiff";
    }

    public Class getEncodeParamClass() {
        return TIFFEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return TIFFDecodeParam.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        return new TIFFImageEncoder(outputStream, imageEncodeParam);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new TIFFImageDecoder(seekableStream, imageDecodeParam);
    }

    public int getNumHeaderBytes() {
        return 4;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        if (byArray[0] == 73 && byArray[1] == 73 && byArray[2] == 42 && byArray[3] == 0) {
            return true;
        }
        return byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && byArray[3] == 42;
    }
}

