/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.CustomPasswordCryptProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodeUtils {
    public static final int ENCODE_LEN = 4;
    public static final int HEX = 16;
    public static final double COEFFICIENT = 1.5;
    public static final int ASC_CODE_A = 65;
    public static final int ASC_CODE_Z = 90;
    public static final int ASC_CODEA = 97;
    public static final int ASC_CODEZ = 122;
    public static final int ASC_CODE_0 = 48;
    public static final int ASC_CODE_9 = 57;
    public static final int ASC_CODE_DEL = 127;
    public static final int ASC_CODE_LEFT_BRACKET = 91;
    public static final int ASC_CODE_RIGHT_BRACKET = 93;
    public static final int EIGHTTIMES2 = 256;
    private static final String[] HEXDIGITS;
    private static Pattern bracketPattern;
    private static Pattern textPattern;
    private static Pattern blankPattern;
    private static int JUDGE_HELPER_LEN;
    private static final boolean[] JUDGE_HELPER;
    private static final char[] APPEND_HELPER;
    private static final int COPYRIGHT_HELPER_LEN = 9000;
    private static final boolean[] COPYRIGHT_HELPER;
    private static final int[] PASSWORD_MASK_ARRAY;

    private CodeUtils() {
    }

    public static String javascriptEncode(String string) {
        StringBuilderHelper stringBuilderHelper = new StringBuilderHelper(string);
        if (StringUtils.isNotEmpty(string)) {
            char c2 = '\u0000';
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = c2;
                c2 = string.charAt(i2);
                if (c2 < JUDGE_HELPER_LEN && c2 > '\uffffffff') {
                    if (JUDGE_HELPER[c2]) {
                        stringBuilderHelper.append('\\', i2);
                        stringBuilderHelper.append(CodeUtils.APPEND_HELPER[c2], i2);
                        stringBuilderHelper.move();
                        continue;
                    }
                    if (c2 == '/') {
                        if (c3 == '<') {
                            stringBuilderHelper.append('\\', i2);
                        }
                        stringBuilderHelper.append(c2, i2);
                        stringBuilderHelper.move();
                        continue;
                    }
                }
                if (!CodeUtils.isCopyRightSymbol(c2)) continue;
                String string2 = "000" + Integer.toHexString(c2);
                stringBuilderHelper.append('\\', i2);
                stringBuilderHelper.append('u', i2).append(string2.substring(string2.length() - 4), i2);
                stringBuilderHelper.move();
            }
        } else {
            return "";
        }
        return stringBuilderHelper.toString();
    }

    public static final boolean isCopyRightSymbol(char c2) {
        return c2 < '\u2328' && c2 > '\uffffffff' && COPYRIGHT_HELPER[c2] || c2 < '\u0000';
    }

    public static String javascriptDecode(String string) {
        return CodeUtils.encodeString(string, new String[][]{{"\\", "'", "\""}, {"\\\\", "\\'", "\\\""}});
    }

    public static String encodeString(String string, String[][] stringArray) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        block0: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            for (int i3 = 0; i3 < stringArray[1].length; ++i3) {
                if (c2 != stringArray[1][i3].charAt(0)) continue;
                stringBuilder.append(stringArray[0][i3]);
                continue block0;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String encodeURIComponent(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return CodeUtils.encodeString(string, new String[][]{{"%20", "%23", "%24", "%26", "%2B", "%2C", "%2F", "%3A", "%3B", "%3D", "%3F", "%40", "%25"}, {" ", "#", "$", "&", "+", ",", "/", ":", ";", "=", "?", "@", "%"}});
        }
    }

    public static String attributeHtmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n2 = charSequence.length();
        StringBuffer stringBuffer = new StringBuffer((int)((double)n2 * 1.5));
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (CodeUtils.isLetterOrNumber(c2)) {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append("&#").append((int)c2).append(';');
        }
        return stringBuffer.toString();
    }

    public static String attributeHtmlDecode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            char c2 = charSequence.charAt(i2);
            boolean bl = false;
            if (c2 == '&' && i2 + 1 < n2 && charSequence.charAt(i2 + 1) == '#' && (n3 = charSequence.toString().indexOf(";", i2 + 1)) != -1 && n3 < i2 + 3 + 3) {
                String string = charSequence.subSequence(i2 + 2, n3).toString();
                char c3 = (char)Integer.parseInt(string);
                stringBuilder.append(c3);
                i2 = n3;
                bl = true;
            }
            if (bl) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static boolean isLetterOrNumber(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9';
    }

    public static String htmlEncode(CharSequence charSequence) {
        if (charSequence == null) {
            return "";
        }
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            i2 = CodeUtils.dealWithChar(c2, stringBuilder, n2, i2, charSequence);
        }
        return CodeUtils.replaceBlankToHtmlBlank(stringBuilder.toString());
    }

    private static int dealWithChar(char c2, StringBuilder stringBuilder, int n2, int n3, CharSequence charSequence) {
        switch (c2) {
            case '<': {
                stringBuilder.append("&lt;");
                break;
            }
            case '>': {
                stringBuilder.append("&gt;");
                break;
            }
            case '&': {
                stringBuilder.append("&amp;");
                break;
            }
            case '\"': {
                stringBuilder.append("&quot;");
                break;
            }
            case '\r': {
                if (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == '\n') {
                    ++n3;
                }
                stringBuilder.append("<br>");
                break;
            }
            case '\\': {
                if (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == 'n') {
                    ++n3;
                    stringBuilder.append("<br>");
                    break;
                }
                if (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == '\\') {
                    ++n3;
                }
                stringBuilder.append(c2);
                break;
            }
            case '\n': {
                stringBuilder.append("<br>");
                break;
            }
            default: {
                stringBuilder.append(c2);
            }
        }
        return n3;
    }

    private static String replaceBlankToHtmlBlank(String string) {
        Matcher matcher = blankPattern.matcher(string);
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (matcher.find()) {
            n3 = matcher.start();
            stringBuffer.append(string.substring(n2, n3));
            n2 = matcher.end();
            String string2 = matcher.group();
            stringBuffer.append(" ");
            int n4 = string2.length();
            if (n4 <= 1) continue;
            for (int i2 = n4; i2 > 1; --i2) {
                stringBuffer.append("&nbsp;");
            }
            stringBuffer.append(" ");
        }
        if (n2 == 0) {
            return string;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String cjkEncode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (CodeUtils.needToEncode(c2)) {
                stringBuilder.append('[');
                stringBuilder.append(Integer.toString(c2, 16));
                stringBuilder.append(']');
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static boolean needToEncode(char c2) {
        return c2 > '\u007f' || c2 == '[' || c2 == ']';
    }

    public static String cjkDecode(String string) throws Exception {
        if (string == null) {
            return "";
        }
        if (!CodeUtils.isCJKEncoded(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            char c2 = string.charAt(i2);
            if (c2 == '[' && (n2 = string.indexOf(93, i2 + 1)) > i2 + 1) {
                String string2 = string.substring(i2 + 1, n2);
                if (string2.length() > 0) {
                    c2 = (char)Integer.parseInt(string2, 16);
                }
                i2 = n2;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static boolean isCJKEncoded(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        Matcher matcher = bracketPattern.matcher(string);
        while (matcher.find()) {
            int n2;
            bl = true;
            int n3 = matcher.start();
            String string2 = string.substring(n3 + 1, (n2 = matcher.end()) - 1);
            if (textPattern.matcher(string2).matches()) continue;
            return false;
        }
        return bl;
    }

    public static String passwordEncode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("___");
        if (string == null) {
            return stringBuilder.toString();
        }
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (n2 == PASSWORD_MASK_ARRAY.length) {
                n2 = 0;
            }
            int n3 = string.charAt(i2) ^ PASSWORD_MASK_ARRAY[n2];
            String string2 = Integer.toHexString(n3);
            int n4 = string2.length();
            for (int i3 = 0; i3 < 4 - n4; ++i3) {
                string2 = "0" + string2;
            }
            stringBuilder.append(string2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String passwordDecode(String string) {
        if (string != null && string.startsWith("___")) {
            string = string.substring(3);
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            for (int i2 = 0; i2 <= string.length() - 4; i2 += 4) {
                if (n2 == PASSWORD_MASK_ARRAY.length) {
                    n2 = 0;
                }
                String string2 = string.substring(i2, i2 + 4);
                int n3 = Integer.parseInt(string2, 16) ^ PASSWORD_MASK_ARRAY[n2];
                stringBuilder.append((char)n3);
                ++n2;
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String decodeText(String string) {
        if (string == null) {
            return null;
        }
        if (CodeUtils.isCJKEncoded(string)) {
            try {
                return CodeUtils.cjkDecode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static String md5Encode(String string, Object object, String string2) {
        try {
            String string3;
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            String string4 = string3 = string == null ? "" : string;
            if (object != null && StringUtils.isNotEmpty(object.toString())) {
                string3 = string3 + "{" + object.toString() + "}";
            }
            byte[] byArray = messageDigest.digest(string3.getBytes("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuilder.append(CodeUtils.byteToHexString(byArray[i2]));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String byteToHexString(byte n2) {
        int n3 = n2;
        if (n3 < 0) {
            n3 = 256 + n3;
        }
        int n4 = n3 / 16;
        int n5 = n3 % 16;
        return HEXDIGITS[n4] + HEXDIGITS[n5];
    }

    public static String customPasswordEncode(String string) {
        CustomPasswordCryptProcessor customPasswordCryptProcessor;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (customPasswordCryptProcessor = (CustomPasswordCryptProcessor)extraClassManagerProvider.getSingle("CustomPasswordCryptProcessor")) != null) {
            return customPasswordCryptProcessor.encodePassword(string);
        }
        return CodeUtils.passwordEncode(string);
    }

    public static void main(String[] stringArray) {
    }

    static {
        int n2;
        HEXDIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        bracketPattern = Pattern.compile("\\[[^\\]]*\\]");
        textPattern = Pattern.compile("[0-9a-f]{2,4}", 2);
        blankPattern = Pattern.compile("\\s+");
        JUDGE_HELPER_LEN = 100;
        JUDGE_HELPER = new boolean[JUDGE_HELPER_LEN];
        APPEND_HELPER = new char[JUDGE_HELPER_LEN];
        CodeUtils.JUDGE_HELPER[92] = true;
        CodeUtils.APPEND_HELPER[92] = 92;
        CodeUtils.JUDGE_HELPER[34] = true;
        CodeUtils.APPEND_HELPER[34] = 34;
        CodeUtils.JUDGE_HELPER[9] = true;
        CodeUtils.APPEND_HELPER[9] = 116;
        CodeUtils.JUDGE_HELPER[10] = true;
        CodeUtils.APPEND_HELPER[10] = 110;
        CodeUtils.JUDGE_HELPER[13] = true;
        CodeUtils.APPEND_HELPER[13] = 114;
        CodeUtils.JUDGE_HELPER[12] = true;
        CodeUtils.APPEND_HELPER[12] = 102;
        CodeUtils.JUDGE_HELPER[8] = true;
        CodeUtils.APPEND_HELPER[8] = 98;
        COPYRIGHT_HELPER = new boolean[9000];
        for (n2 = 0; n2 < 32; ++n2) {
            CodeUtils.COPYRIGHT_HELPER[n2] = true;
        }
        for (n2 = 128; n2 < 160; ++n2) {
            CodeUtils.COPYRIGHT_HELPER[n2] = true;
        }
        for (n2 = 8192; n2 < 8448; ++n2) {
            CodeUtils.COPYRIGHT_HELPER[n2] = true;
        }
        CodeUtils.COPYRIGHT_HELPER[169] = true;
        CodeUtils.COPYRIGHT_HELPER[174] = true;
        PASSWORD_MASK_ARRAY = new int[]{19, 78, 10, 15, 100, 213, 43, 23};
    }

    private static final class StringBuilderHelper {
        private StringBuilder sb;
        private String baseString;
        private int start = 0;

        private StringBuilderHelper(String string) {
            this.baseString = string;
        }

        private void initSB(int n2) {
            if (this.sb == null) {
                this.sb = new StringBuilder(this.baseString.length());
            }
            if (this.start != n2) {
                this.sb.append(this.baseString, this.start, n2);
                this.start = n2;
            }
        }

        private StringBuilderHelper append(char c2, int n2) {
            this.initSB(n2);
            this.sb.append(c2);
            return this;
        }

        private void move() {
            ++this.start;
        }

        private StringBuilderHelper append(String string, int n2) {
            this.initSB(n2);
            this.sb.append(string);
            return this;
        }

        public String toString() {
            if (this.sb == null) {
                return this.baseString;
            }
            this.initSB(this.baseString.length());
            return this.sb.toString();
        }
    }
}

