/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.poly;

import com.fr.general.ComparatorUtils;
import com.fr.report.block.Block;
import com.fr.report.block.ResultBlock;
import com.fr.report.poly.AbstractPolyReport;
import com.fr.report.poly.PolyWorkSheet;
import com.fr.report.stable.PolyBlockAttr;
import com.fr.stable.unit.FU;
import com.fr.stable.unit.UNIT;
import com.fr.stable.unit.UNITConstants;
import com.fr.stable.unit.UnitRectangle;
import java.util.ArrayList;

public class PolyCoreUtils {
    public static UNIT afterRight(Block block, Block block2) {
        if (ComparatorUtils.equals(block.getBounds().x, block2.getBounds().x)) {
            return UNIT.ZERO;
        }
        if (block.getBounds().x.subtract(block2.getBounds().x).more_than_zero()) {
            return FU.getInstance(block.getBounds().x.toFU() - (block2.getBounds().x.toFU() + block2.getBounds().width.toFU()));
        }
        return FU.getInstance(block2.getBounds().x.toFU() - (block.getBounds().x.toFU() + block.getBounds().width.toFU()));
    }

    public static UNIT afterBottom(Block block, Block block2) {
        if (ComparatorUtils.equals(block.getBounds().y, block2.getBounds().y)) {
            return UNIT.ZERO;
        }
        if (block.getBounds().y.subtract(block2.getBounds().y).more_than_zero()) {
            return FU.getInstance(block.getBounds().y.toFU() - (block2.getBounds().y.toFU() + block2.getBounds().height.toFU()));
        }
        return FU.getInstance(block2.getBounds().y.toFU() - (block.getBounds().y.toFU() + block.getBounds().height.toFU()));
    }

    public static boolean isAllOnLeft(Block block, Block block2) {
        UNIT uNIT = block.getBounds().x;
        UNIT uNIT2 = block.getBounds().width;
        UNIT uNIT3 = block2.getBounds().x;
        return uNIT.add(uNIT2).subtract(uNIT3).subtract(UNITConstants.DELTA).less_than_or_equal_zero();
    }

    public static boolean isAllOnTop(Block block, Block block2) {
        UNIT uNIT = block.getBounds().y;
        UNIT uNIT2 = block.getBounds().height;
        UNIT uNIT3 = block2.getBounds().y;
        return uNIT.add(uNIT2).subtract(uNIT3).subtract(UNITConstants.DELTA).less_than_or_equal_zero();
    }

    public static void addX(UnitRectangle unitRectangle, UNIT uNIT) {
        unitRectangle.x = FU.getInstance(unitRectangle.x.toFU() + uNIT.toFU());
    }

    public static void addY(UnitRectangle unitRectangle, UNIT uNIT) {
        unitRectangle.y = FU.getInstance(unitRectangle.y.toFU() + uNIT.toFU());
    }

    public static void addW(UnitRectangle unitRectangle, UNIT uNIT) {
        unitRectangle.width = FU.getInstance(unitRectangle.width.toFU() + uNIT.toFU());
    }

    public static void addH(UnitRectangle unitRectangle, UNIT uNIT) {
        unitRectangle.height = FU.getInstance(unitRectangle.height.toFU() + uNIT.toFU());
    }

    private static int num(UNIT uNIT, UNIT uNIT2) {
        FU fU = uNIT.subtract(uNIT2);
        int n2 = 1;
        while (fU.more_than_zero()) {
            fU = fU.subtract(uNIT2);
            ++n2;
        }
        return n2;
    }

    public static UnitRectangle getDefaultBlockBounds() {
        FU fU = UNIT.ZERO;
        for (int i2 = 0; i2 < 3; ++i2) {
            fU = fU.add(UNITConstants.DEFAULT_COL_WIDTH);
        }
        FU fU2 = UNIT.ZERO;
        for (int i3 = 0; i3 < 6; ++i3) {
            fU2 = fU2.add(UNITConstants.DEFAULT_ROW_HEIGHT);
        }
        return new UnitRectangle(UNIT.ZERO, UNIT.ZERO, fU, fU2);
    }

    private static boolean isHasCombinBlock() {
        return false;
    }

    private static Block creatNewBlock(Block[] blockArray) {
        UNIT uNIT = blockArray[0].getBounds().x;
        UNIT uNIT2 = blockArray[0].getBounds().y;
        UNIT uNIT3 = blockArray[0].getBounds().width;
        UNIT uNIT4 = blockArray[0].getBounds().height;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 1; i2 < blockArray.length; ++i2) {
            if (blockArray[i2].getBounds().x.subtract(blockArray[n2].getBounds().x).more_than_zero()) {
                n2 = i2;
            }
            if (blockArray[i2].getBounds().y.subtract(blockArray[n3].getBounds().y).more_than_zero()) {
                n3 = i2;
            }
            uNIT = UNIT.min(uNIT, blockArray[i2].getBounds().x);
            uNIT2 = UNIT.min(uNIT2, blockArray[i2].getBounds().y);
        }
        uNIT3 = blockArray[n2].getBounds().x.subtract(uNIT).add(blockArray[n2].getBounds().width);
        uNIT4 = blockArray[n3].getBounds().y.subtract(uNIT2).add(blockArray[n3].getBounds().height);
        UnitRectangle unitRectangle = new UnitRectangle(uNIT, uNIT2, uNIT3, uNIT4);
        Block block = null;
        block.setBounds(unitRectangle);
        return block;
    }

    private static ResultBlock creatNewResultBlock(Block[] blockArray) {
        return null;
    }

    private static boolean isChangeCurrentBlock(Block block, Block block2) {
        double d2;
        int n2 = 96;
        double d3 = block2.getBounds().x.toPixD(n2);
        double d4 = block2.getBounds().y.toPixD(n2);
        double d5 = block.getBounds().x.toPixD(n2);
        double d6 = block.getBounds().y.toPixD(n2);
        double d7 = Math.hypot(d3, d4);
        if (d7 > (d2 = Math.hypot(d5, d6))) {
            return true;
        }
        return d7 == d2 && d4 > d6;
    }

    public static void relayout(AbstractPolyReport abstractPolyReport, PolyWorkSheet polyWorkSheet) {
        ArrayList<Block> arrayList = new ArrayList<Block>(abstractPolyReport.getBlockCount());
        int n2 = abstractPolyReport.getBlockCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Block block;
            int n3;
            Block block2 = polyWorkSheet.getBlockByName(abstractPolyReport.getBlock(i2).getBlockName());
            int n4 = i2;
            while (arrayList.indexOf(block2) != -1) {
                n4 = n4 < n2 - 1 ? n4 + 1 : 0;
                block2 = polyWorkSheet.getBlockByName(abstractPolyReport.getBlock(n4).getBlockName());
            }
            for (n3 = 0; n3 < n2; ++n3) {
                block = polyWorkSheet.getBlockByName(abstractPolyReport.getBlock(n3).getBlockName());
                if (arrayList.indexOf(block) != -1 || !PolyCoreUtils.isChangeCurrentBlock(block, block2)) continue;
                block2 = block;
            }
            arrayList.add(block2);
            for (n3 = 0; n3 < n2; ++n3) {
                block = (ResultBlock)abstractPolyReport.getBlock(n3);
                Block block3 = polyWorkSheet.getBlockByName(block.getBlockName());
                if (arrayList.indexOf(block3) != -1) continue;
                ResultBlock resultBlock = (ResultBlock)abstractPolyReport.getBlockByName(block2.getBlockName());
                PolyCoreUtils.modifyBlock(block2, block3, (ResultBlock)block, resultBlock, polyWorkSheet);
            }
        }
    }

    private static void modifyBlock(Block block, Block block2, ResultBlock resultBlock, ResultBlock resultBlock2, PolyWorkSheet polyWorkSheet) {
        UNIT uNIT;
        UNIT uNIT2;
        if (!PolyCoreUtils.isAllOnLeft(block2, block)) {
            if (PolyCoreUtils.isNeedModifyX(block, block2, resultBlock, resultBlock2)) {
                uNIT2 = PolyCoreUtils.afterRight(block2, block);
                uNIT = PolyCoreUtils.afterRight(resultBlock, resultBlock2);
                PolyCoreUtils.modifyX(resultBlock, uNIT, uNIT2);
            }
        } else if (PolyCoreUtils.isNeedModifyX(block2, block, resultBlock2, resultBlock) && !PolyCoreUtils.isAllOnTop(block, block2)) {
            uNIT2 = PolyCoreUtils.afterRight(block, block2);
            uNIT = PolyCoreUtils.afterRight(resultBlock2, resultBlock);
            PolyCoreUtils.modifyX(resultBlock2, uNIT, uNIT2);
        }
        if (!PolyCoreUtils.isAllOnTop(block2, block)) {
            if (PolyCoreUtils.isNeedModifyY(block, block2, resultBlock, resultBlock2)) {
                uNIT2 = PolyCoreUtils.afterBottom(block2, block);
                uNIT = PolyCoreUtils.afterBottom(resultBlock, resultBlock2);
                PolyCoreUtils.modifyY(resultBlock, uNIT, uNIT2);
            }
        } else if (PolyCoreUtils.isNeedModifyY(block2, block, resultBlock2, resultBlock)) {
            uNIT2 = PolyCoreUtils.afterBottom(block, block2);
            uNIT = PolyCoreUtils.afterBottom(resultBlock2, resultBlock);
            PolyCoreUtils.modifyY(resultBlock2, uNIT, uNIT2);
        }
    }

    private static boolean isNeedModifyX(Block block, Block block2, Block block3, Block block4) {
        return !PolyCoreUtils.isAllOnTop(block2, block) || !PolyCoreUtils.isAllOnTop(block3, block4);
    }

    private static boolean isNeedModifyY(Block block, Block block2, Block block3, Block block4) {
        if (PolyCoreUtils.isAllOnLeft(block2, block) && PolyCoreUtils.isAllOnLeft(block3, block4)) {
            return false;
        }
        return !PolyCoreUtils.isAllOnLeft(block, block2) || PolyCoreUtils.isAllOnTop(block, block2);
    }

    private static void modifyX(ResultBlock resultBlock, UNIT uNIT, UNIT uNIT2) {
        if (uNIT2.add(UNITConstants.DELTA).more_than_or_equal_zero() && uNIT2.toFU() >= uNIT.toFU()) {
            PolyCoreUtils.addX(resultBlock.getBounds(), FU.getInstance(uNIT2.toFU() - uNIT.toFU()));
        }
    }

    private static void modifyY(ResultBlock resultBlock, UNIT uNIT, UNIT uNIT2) {
        if (uNIT2.add(UNITConstants.DELTA).more_than_or_equal_zero() && uNIT2.toFU() >= uNIT.toFU()) {
            PolyCoreUtils.addY(resultBlock.getBounds(), FU.getInstance(uNIT2.toFU() - uNIT.toFU()));
        }
    }

    public static boolean isFreezeWidth(Block block) {
        PolyBlockAttr polyBlockAttr = block.getBlockAttr();
        return polyBlockAttr != null && polyBlockAttr.isFreezeWidth();
    }

    public static boolean isFreezeHeight(Block block) {
        PolyBlockAttr polyBlockAttr = block.getBlockAttr();
        return polyBlockAttr != null && polyBlockAttr.isFreezeHeight();
    }
}

