/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.allocation;

import com.fr.base.FileNode;
import com.fr.general.ComparatorUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class FileFrag
implements XMLable {
    private static final long serialVersionUID = 5307405323031974800L;
    private String path;
    private boolean isDir = false;

    public FileFrag() {
    }

    public FileFrag(String string) {
        this.path = string;
        this.isDir = !string.endsWith(".cpt");
    }

    public FileFrag(String string, boolean bl) {
        this.path = string;
        this.isDir = bl;
    }

    public String getPath() {
        if (StringUtils.isBlank(this.path)) {
            return null;
        }
        String string = StringUtils.perfectStart(this.path, "/");
        if (this.isDir) {
            string = StringUtils.perfectEnd(string, "/");
        }
        return string;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public boolean isDir() {
        return this.isDir;
    }

    public void setDir(boolean bl) {
        this.isDir = bl;
    }

    public FileNode toFileNode() {
        return new FileNode(this.path, this.isDir);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("path", null);
            if (string != null) {
                this.setPath(string);
            }
            this.setDir(xMLableReader.getAttrAsBoolean("isDir", false));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FileFrag").attr("path", this.getPath());
        if (this.isDir()) {
            xMLPrintWriter.attr("isDir", "true");
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        return object instanceof FileFrag && ((FileFrag)object).isDir == this.isDir && ComparatorUtils.equals(((FileFrag)object).path, this.path);
    }

    public String toString() {
        return this.path + (this.isDir ? "[Dir]" : "");
    }
}

