/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin;

import com.fr.base.FRContext;
import com.fr.file.DefaultClusterServerProcessor;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.general.Inter;
import com.fr.plugin.ExtraXMLFileManager;
import com.fr.plugin.PluginLicenseManager;
import com.fr.plugin.proxy.PluginInstanceProxyFactory;
import com.fr.record.FunctionRecorderManager;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.collections.map.CloseableContainedMap;
import com.fr.stable.collections.set.CloseableContainedSet;
import com.fr.stable.collections.set.PluginCompatibleInjectionContainer;
import com.fr.stable.file.XMLFileManagerProvider;
import com.fr.stable.fun.Authorize;
import com.fr.stable.fun.ClusterServerProcessor;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.fun.Level;
import com.fr.stable.fun.LocaleFinder;
import com.fr.stable.fun.RequestInterceptor;
import com.fr.stable.fun.Service;
import com.fr.stable.fun.mark.Layer;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.script.FunctionDef;
import com.fr.stable.web.RequestCMDReceiver;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraClassManager
extends ExtraXMLFileManager
implements ExtraClassManagerProvider {
    private static ExtraClassManager classManager;
    private Set<Service> services = new CloseableContainedSet<Service, HashSet>(HashSet.class);
    private Set<XMLFileManagerProvider> xmlFileManagers = null;
    private Map<RequestInterceptor.ActionKey, Map<Integer, RequestInterceptor>> hackActionMap = null;
    private PluginCompatibleInjectionContainer<FunctionDef> functions = new PluginCompatibleInjectionContainer();

    public static synchronized ExtraClassManager getInstance() {
        if (classManager == null) {
            classManager = new ExtraClassManager();
            classManager.readXMLFile();
        }
        return classManager;
    }

    private static synchronized void envChanged() {
        classManager = null;
    }

    public Service[] getServices() {
        return this.services.toArray(new Service[this.services.size()]);
    }

    private void addService(String string, PluginSimplify pluginSimplify) {
        if (StringUtils.isNotBlank(string)) {
            try {
                Class clazz = GeneralUtils.classForName(string);
                this.services.add((Service)new PluginInstanceProxyFactory(clazz, pluginSimplify).addProxy("isClosed").getProxyObj());
            }
            catch (Exception exception) {
                this.recordClassLoadError(string);
            }
        }
    }

    public XMLFileManagerProvider[] getXmlFileManagers() {
        return this.xmlFileManagers == null ? new XMLFileManagerProvider[]{} : this.xmlFileManagers.toArray(new XMLFileManagerProvider[this.xmlFileManagers.size()]);
    }

    public void addXMLFileManager(String string, PluginSimplify pluginSimplify) {
        if (this.xmlFileManagers == null) {
            this.xmlFileManagers = new CloseableContainedSet<XMLFileManagerProvider, HashSet>(HashSet.class);
        }
        try {
            Class<?> clazz = loader.loadClass(string);
            Authorize authorize = clazz.getAnnotation(Authorize.class);
            if (authorize != null) {
                PluginLicenseManager.getInstance().registerPaid(authorize, pluginSimplify);
            }
            XMLFileManagerProvider xMLFileManagerProvider = (XMLFileManagerProvider)StableUtils.getInstance(clazz);
            XMLFileManagerProvider xMLFileManagerProvider2 = (XMLFileManagerProvider)new PluginInstanceProxyFactory(xMLFileManagerProvider, pluginSimplify).addProxy("isClosed").getProxyObj();
            this.xmlFileManagers.add(xMLFileManagerProvider2);
        }
        catch (Exception exception) {
            this.recordClassLoadError(string);
        }
    }

    public FunctionProcessor getFunctionProcessor() {
        return FunctionRecorderManager.getInstance();
    }

    public void addLocaleFinder(Level level, PluginSimplify pluginSimplify) throws Exception {
        this.validAPILevel(level, 1, pluginSimplify.getPluginName());
        LocaleFinder localeFinder = (LocaleFinder)level;
        Inter.loadLanguageFromPlugin(localeFinder);
        StableFactory.registerLocaleFile(new String[]{localeFinder.find()});
    }

    public RequestCMDReceiver getActionCMD(String string, String string2) {
        return this.getActionCMD(string, string2, "");
    }

    public RequestCMDReceiver getActionCMD(String string, String string2, String string3) {
        return this.getActionCMD(string, string2, string3, RequestCMDReceiver.class);
    }

    public <T extends RequestCMDReceiver> T getActionCMD(String string, String string2, Class<T> clazz) {
        return this.getActionCMD(string, string2, "", clazz);
    }

    public <T extends RequestCMDReceiver> T getActionCMD(String string, String string2, String string3, Class<T> clazz) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return null;
        }
        if (this.hackActionMap == null) {
            return null;
        }
        RequestInterceptor.ActionKey actionKey = RequestInterceptor.ActionKey.create(string, string2, string3);
        Map<Integer, RequestInterceptor> map = this.hackActionMap.get(actionKey);
        if (map == null) {
            return null;
        }
        Layer layer = null;
        for (Map.Entry<Integer, RequestInterceptor> entry : map.entrySet()) {
            if (layer == null) {
                layer = entry.getValue();
                continue;
            }
            if (layer.layerIndex() >= entry.getValue().layerIndex()) continue;
            layer = entry.getValue();
        }
        if (layer != null && StableUtils.objectInstanceOf(layer, clazz)) {
            return (T)layer;
        }
        return null;
    }

    public void addHackActionCMD(String string, String string2, String string3, String string4) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return;
        }
        try {
            Class clazz = GeneralUtils.classForName(string4);
            RequestInterceptor requestInterceptor = (RequestInterceptor)clazz.newInstance();
            this.addHackActionCMD(string, string2, string3, requestInterceptor);
        }
        catch (Exception exception) {
            this.recordClassLoadError(string4);
        }
    }

    private void addHackActionCMD(String string, String string2, String string3, String string4, PluginSimplify pluginSimplify) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return;
        }
        try {
            Class clazz = GeneralUtils.classForName(string4);
            RequestInterceptor requestInterceptor = (RequestInterceptor)clazz.newInstance();
            RequestInterceptor requestInterceptor2 = (RequestInterceptor)new PluginInstanceProxyFactory(requestInterceptor, pluginSimplify).addProxy("isClosed").getProxyObj();
            this.addHackActionCMD(string, string2, string3, requestInterceptor2);
        }
        catch (Exception exception) {
            this.recordClassLoadError(string4);
        }
    }

    private void addHackActionCMD(String string, String string2, String string3, RequestInterceptor requestInterceptor) {
        RequestInterceptor.ActionKey actionKey;
        Map<Integer, RequestInterceptor> map;
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string2)) {
            return;
        }
        if (this.hackActionMap == null) {
            this.hackActionMap = new HashMap<RequestInterceptor.ActionKey, Map<Integer, RequestInterceptor>>();
        }
        if ((map = this.hackActionMap.get(actionKey = RequestInterceptor.ActionKey.create(string, string2, string3))) == null || map.isEmpty()) {
            map = new CloseableContainedMap<Integer, RequestInterceptor, HashMap>(HashMap.class);
            this.hackActionMap.put(actionKey, map);
        }
        map.put(requestInterceptor.layerIndex(), requestInterceptor);
    }

    public FunctionDef[] getFunctionDef() {
        Set<FunctionDef> set = this.functions.getSet();
        return set.toArray(new FunctionDef[set.size()]);
    }

    private void addFunctionDef(String string, String string2, String string3, PluginSimplify pluginSimplify) {
        if (StringUtils.isBlank(string) || StringUtils.isBlank(string3)) {
            return;
        }
        FunctionDef functionDef = new FunctionDef(string, string2, string3);
        Object object = new PluginInstanceProxyFactory(functionDef, pluginSimplify).addProxy("isClosed").getProxyObj();
        this.functions.put(object, functionDef);
    }

    private void recordClassLoadError(String string) {
        FRContext.getLogger().error("Error to load:" + string);
    }

    @Override
    public String fileName() {
        return "extra.xml";
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        this.readXML(xMLableReader, null, PluginSimplify.NULL);
    }

    @Override
    public void readXML(XMLableReader xMLableReader, List<String> list, PluginSimplify pluginSimplify) {
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (StringUtils.isEmpty(string2)) {
                return;
            }
            if (list != null) {
                list.add(string2);
            }
            if (StringUtils.isEmpty(string = xMLableReader.getAttrAsString("class", ""))) {
                return;
            }
            if (string2.equals("XMLFileManagerProvider")) {
                this.addXMLFileManager(string, pluginSimplify);
            } else if (string2.equals("WebService")) {
                this.addService(string, pluginSimplify);
            } else if (string2.equals("RequestInterceptor") || string2.equals("ActionCMD")) {
                String string3 = xMLableReader.getAttrAsString("op", "");
                String string4 = xMLableReader.getAttrAsString("cmd", "");
                String string5 = xMLableReader.getAttrAsString("pid", "");
                this.addHackActionCMD(string3, string4, string5, string, pluginSimplify);
            } else if (string2.equals("FunctionDefineProvider")) {
                String string6 = xMLableReader.getAttrAsString("name", "");
                String string7 = xMLableReader.getAttrAsString("description", "");
                this.addFunctionDef(string6, string7, string, pluginSimplify);
            } else {
                this.readStandard(string2, string, pluginSimplify, xMLableReader);
            }
        }
    }

    @Override
    protected void readSpecific(String string, Level level, PluginSimplify pluginSimplify, XMLableReader xMLableReader) throws Exception {
        if (string.equals("LocaleFinder")) {
            this.addLocaleFinder(level, pluginSimplify);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ExtraClassManager");
        xMLPrintWriter.end();
    }

    @Deprecated
    public ClusterServerProcessor getClusterServerProcessor() {
        return (ClusterServerProcessor)((Object)classManager.getSingle("ClusterServerProcessor", DefaultClusterServerProcessor.class));
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ExtraClassManager.envChanged();
            }
        });
    }
}

