/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.general.FRLogger;
import com.fr.performance.dao.FileManager;
import com.fr.performance.dao.FilterInfoSaver;
import com.fr.performance.dao.InfoSaver;
import com.fr.performance.dao.JSONInfoSaver;
import com.fr.performance.dao.NoHeaderObjectOutputStream;
import com.fr.performance.dao.QueueInfoSaver;
import com.fr.performance.dao.ReportInfoMatcher;
import com.fr.performance.dao.SerializerInfoSaver;
import com.fr.performance.info.IReportPerformanceInfo;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

public class PerformanceSaverManager {
    private static InfoSaver reportInfoSaver;
    private static long lastCreateTime;
    private static ReentrantLock createTimeLock;

    public static InfoSaver getReportInfoSaver() {
        if (reportInfoSaver == null) {
            FilterInfoSaver filterInfoSaver = new FilterInfoSaver(new QueueInfoSaver(PerformanceSaverManager.createJSONInfoSaver()));
            filterInfoSaver.setMatcher(new ReportInfoMatcher());
            reportInfoSaver = filterInfoSaver;
        }
        return reportInfoSaver;
    }

    private static SerializerInfoSaver createSerializerInfoSaver() {
        SerializerInfoSaver serializerInfoSaver = new SerializerInfoSaver();
        NoHeaderObjectOutputStream noHeaderObjectOutputStream = null;
        try {
            noHeaderObjectOutputStream = new NoHeaderObjectOutputStream(new BufferedOutputStream(new FileOutputStream(FileManager.getInfoSaveFile(), true)));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        serializerInfoSaver.setOutput(noHeaderObjectOutputStream);
        return serializerInfoSaver;
    }

    private static JSONInfoSaver createJSONInfoSaver() {
        return JSONInfoSaver.create(FileManager.getInfoSaveFile());
    }

    public static void saveReportPerformanceInfo(IReportPerformanceInfo iReportPerformanceInfo) {
        PerformanceSaverManager.getReportInfoSaver().save(iReportPerformanceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getUniqueCreateTime() {
        long l2 = System.currentTimeMillis();
        try {
            createTimeLock.lock();
            if (l2 > lastCreateTime) {
                lastCreateTime = l2;
                long l3 = l2;
                return l3;
            }
            lastCreateTime = l2 = lastCreateTime + 1L;
            long l4 = l2;
            return l4;
        }
        finally {
            createTimeLock.unlock();
        }
    }

    static {
        createTimeLock = new ReentrantLock();
    }
}

