/*
 * Decompiled with CFR 0.152.
 */
package com.fr.parser;

import com.fr.general.GeneralUtils;
import com.fr.general.script.FunctionHelper;
import com.fr.parser.BinaryExpression;
import com.fr.stable.OperationUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

public abstract class MathExpression
extends BinaryExpression {
    protected Object objectBinaryOperation(Object object, Object object2, String string) throws UtilEvalError {
        Object object3;
        if (object == OperationUtils.POSITIVE_INFINITY) {
            if (object2 == OperationUtils.POSITIVE_INFINITY) {
                return this.ccPIPI(string);
            }
            if (object2 == OperationUtils.NEGATIVE_INFINITY) {
                return this.ccPINI(string);
            }
            return this.ccPIRE(object2, string);
        }
        if (object == OperationUtils.NEGATIVE_INFINITY) {
            if (object2 == OperationUtils.POSITIVE_INFINITY) {
                return this.ccNIPI(string);
            }
            if (object2 == OperationUtils.NEGATIVE_INFINITY) {
                return this.ccNINI(string);
            }
            return this.ccNIRE(object2, string);
        }
        if (object2 == OperationUtils.POSITIVE_INFINITY) {
            return this.ccREPI(object, string);
        }
        if (object2 == OperationUtils.NEGATIVE_INFINITY) {
            return this.ccRENI(object, string);
        }
        Number number = GeneralUtils.objectToNumber(object, true);
        Number number2 = GeneralUtils.objectToNumber(object2, true);
        if (number != null && number2 != null) {
            object = number;
            object2 = number2;
        }
        if ((object3 = this.ccRERE(object, object2, string)) instanceof Number) {
            if (object3 instanceof BigDecimal) {
                return this.checkZeroEnd((BigDecimal)object3);
            }
            return FunctionHelper.asNumber(((Number)object3).doubleValue());
        }
        return object3;
    }

    private Number checkZeroEnd(BigDecimal bigDecimal) {
        String string = StableUtils.convertNumberStringToString(bigDecimal);
        int n2 = string.indexOf(".");
        if (n2 == -1 || !string.endsWith("0")) {
            return bigDecimal;
        }
        int n3 = 0;
        for (int i2 = string.length() - 1; i2 > 0; --i2) {
            if (string.charAt(i2) == '0') continue;
            n3 = i2;
            break;
        }
        return new BigDecimal(string.substring(0, n3 + 1));
    }

    protected abstract Object ccPIPI(String var1);

    protected abstract Object ccPINI(String var1);

    protected abstract Object ccPIRE(Object var1, String var2);

    protected abstract Object ccNIPI(String var1);

    protected abstract Object ccNINI(String var1);

    protected abstract Object ccNIRE(Object var1, String var2);

    protected abstract Object ccREPI(Object var1, String var2);

    protected abstract Object ccRENI(Object var1, String var2);

    protected abstract Object ccRERE(Object var1, Object var2, String var3) throws UtilEvalError;

    protected Object numberOperation(Object object, Object object2, String string) {
        Number number = (Number)(object instanceof Number ? object : GeneralUtils.objectToNumber(object, false));
        Number number2 = (Number)(object2 instanceof Number ? object2 : GeneralUtils.objectToNumber(object2, false));
        try {
            if (number instanceof BigDecimal || number2 instanceof BigDecimal || number instanceof BigInteger || number2 instanceof BigInteger) {
                return this.decimalOperation(number instanceof BigDecimal ? (BigDecimal)number : new BigDecimal(number.toString()), number2 instanceof BigDecimal ? (BigDecimal)number2 : new BigDecimal(number2.toString()), string);
            }
            if (number instanceof Double || number2 instanceof Double || number instanceof Float || number2 instanceof Float) {
                Object object3 = this.doubleOperation(number.doubleValue(), number2.doubleValue(), string);
                if (Pattern.compile("0000|9999").matcher(String.valueOf(object3)).find()) {
                    return this.numberOperation(new BigDecimal(String.valueOf(number)), new BigDecimal(String.valueOf(number2)), string);
                }
                return object3;
            }
            return this.longOperation(number.longValue(), number2.longValue(), string);
        }
        catch (NumberFormatException numberFormatException) {
            Object object4 = this.checkNumInfinity(number);
            return object4 != Primitive.NULL ? object4 : this.checkNumInfinity(number2);
        }
    }

    private Object checkNumInfinity(Number number) {
        String string = StableUtils.checkInfinity(number);
        if (StringUtils.isNotEmpty(string)) {
            return number;
        }
        return Primitive.NULL;
    }

    protected abstract Object decimalOperation(BigDecimal var1, BigDecimal var2, String var3);

    protected abstract Object doubleOperation(double var1, double var3, String var5);

    protected abstract Object longOperation(long var1, long var3, String var5);

    protected Object processLongValue(long l2) {
        if (l2 != (long)((int)l2)) {
            return new Long(l2);
        }
        return new Integer((int)l2);
    }
}

