/*
 * Decompiled with CFR 0.152.
 */
package com.fr.general;

import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.GeneralUtils;
import com.fr.stable.ArrayUtils;
import com.fr.stable.CodeUtils;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.OperatingSystem;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.encoder.GIFEncoder;
import com.fr.stable.fun.ResourcePathTransformer;
import com.fr.stable.fun.ResourceReadProcessor;
import com.fr.stable.pinyin.ChineseHelper;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import com.fr.zip4j.core.ZipFile;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtils {
    private static final String ZIP_ENTRY_NAME = "finereport_cpt";
    public static final int ONE_MB = 1024;
    private static final int TEN_MB = 10240;
    public static final int TW_MB = 32768;
    private static LinkedHashMap<String, BufferedImage> imageMap = new LinkedHashMap<String, BufferedImage>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 500;
        }
    };
    private static ReadWriteLock lock = new ReentrantReadWriteLock(false);
    private static final int MAXIMUMIMAGECACHE = 500;

    public static boolean renameTo(File file, File file2) {
        if (file2.exists()) {
            file2.delete();
        }
        try {
            StableUtils.makesureFileExist(file);
            boolean bl = file.renameTo(file2);
            if (bl) {
                return true;
            }
            StableUtils.makesureFileExist(file2);
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            IOUtils.copyBinaryTo(fileInputStream, fileOutputStream);
            fileInputStream.close();
            ((OutputStream)fileOutputStream).close();
            return file.delete();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("error:" + exception.getMessage());
            return false;
        }
    }

    public static String concatFiles(String[] stringArray, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(IOUtils.readResourceAsString(stringArray[i2]));
            if (i2 >= stringArray.length - 1) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static void copyFilesInDirByPath(String string, String string2) throws IOException {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2)) {
            return;
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!StableUtils.mkdirs(file2) || !file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file3 = fileArray[i2];
            IOUtils.copy(file3, file2);
        }
    }

    public static void copy(File file, File file2) throws IOException {
        File file3;
        if (file.isFile()) {
            IOUtils.copy(new FileInputStream(file), file.getName(), file2);
        } else if (file.isDirectory() && StableUtils.mkdirs(file3 = new File(file2, file.getName()))) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                IOUtils.copy(fileArray[i2], file3);
            }
        }
    }

    public static void copy(InputStream inputStream, String string, File file) throws IOException {
        File file2 = new File(file, string);
        StableUtils.makesureFileExist(file2);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        IOUtils.copyBinaryTo(inputStream, fileOutputStream);
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    public static void copyBinaryTo(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int n2;
            byte[] byArray = new byte[10240];
            while ((n2 = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static java.util.zip.ZipOutputStream toZipOut(OutputStream outputStream) throws Exception {
        java.util.zip.ZipOutputStream zipOutputStream = new java.util.zip.ZipOutputStream(outputStream);
        java.util.zip.ZipEntry zipEntry = new java.util.zip.ZipEntry(ZIP_ENTRY_NAME);
        zipOutputStream.putNextEntry(zipEntry);
        return zipOutputStream;
    }

    public static ZipInputStream toZipIn(InputStream inputStream) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        java.util.zip.ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry != null && ComparatorUtils.equals(ZIP_ENTRY_NAME, zipEntry.getName())) {
            return zipInputStream;
        }
        return null;
    }

    public static void zip(java.util.zip.ZipOutputStream zipOutputStream, File file) throws Exception {
        IOUtils.zip(zipOutputStream, file, null);
    }

    private static void zip(java.util.zip.ZipOutputStream zipOutputStream, File file, String string) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (string != null) {
                zipOutputStream.putNextEntry(new java.util.zip.ZipEntry(string + "/"));
            }
            string = string == null || string.length() == 0 ? "" : string + "/";
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                IOUtils.zip(zipOutputStream, fileArray[i2], string + fileArray[i2].getName());
            }
        } else {
            FRLogger.getLogger().info("compress files" + string);
            zipOutputStream.putNextEntry(new java.util.zip.ZipEntry(string));
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = 0;
            byte[] byArray = new byte[1024];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n2);
            }
            fileInputStream.close();
            zipOutputStream.flush();
        }
    }

    public static void zip(ZipOutputStream zipOutputStream, File file, String string) throws Exception {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (string != null) {
                zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
            }
            string = string == null || string.length() == 0 ? "" : string + "/";
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                IOUtils.zip(zipOutputStream, fileArray[i2], string + fileArray[i2].getName());
            }
        } else {
            FRLogger.getLogger().info("compress files" + string);
            zipOutputStream.putNextEntry(new ZipEntry(string));
            FileInputStream fileInputStream = new FileInputStream(file);
            int n2 = 0;
            byte[] byArray = new byte[1024];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n2);
            }
            fileInputStream.close();
            zipOutputStream.flush();
        }
    }

    public static void unzip(File file, String string) {
        IOUtils.unzip(file, string, null);
    }

    public static void unzip(File file, String string, String string2) {
        try {
            FRLogger.getLogger().info("start unzip file:" + file.getAbsolutePath());
            ZipFile zipFile = new ZipFile(file);
            if (StringUtils.isNotEmpty(string2)) {
                zipFile.setFileNameCharset(string2);
            }
            zipFile.extractAll(string);
            FRLogger.getLogger().info("unzip file:" + file.getAbsolutePath() + " finished");
        }
        catch (Exception exception) {
            FRLogger.getLogger().error("error when unzip:" + exception.getMessage(), exception);
        }
    }

    public static void openWindowsFolder(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            try {
                if (OperatingSystem.isWindows()) {
                    Runtime.getRuntime().exec("explorer /select, \"" + file.getAbsolutePath() + '\"');
                } else if (OperatingSystem.isMacOS()) {
                    Runtime.getRuntime().exec("/usr/bin/open -R " + file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {}
        } else if (file.isDirectory()) {
            try {
                if (OperatingSystem.isWindows()) {
                    String string2 = file.getAbsolutePath();
                    Runtime.getRuntime().exec("explorer /select, \"" + string2 + '\"');
                } else if (OperatingSystem.isMacOS()) {
                    Runtime.getRuntime().exec("/usr/bin/open " + file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String inputStream2String(InputStream inputStream) throws UnsupportedEncodingException {
        return new String(IOUtils.inputStream2Bytes(inputStream), "UTF-8");
    }

    public static String inputStream2String(InputStream inputStream, String string) throws UnsupportedEncodingException {
        return new String(IOUtils.inputStream2Bytes(inputStream), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static byte[] inputStream2Bytes(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream;
        block9: {
            int n2;
            byte[] byArray = new byte[32768];
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = inputStream.read(byArray)) > 0) {
                byte[] byArray2 = byArray.length == n2 ? byArray : ArrayUtils.subarray(byArray, 0, n2);
                byteArrayOutputStream.write(byArray2);
            }
            Object var6_6 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
            break block9;
            {
                catch (IOException iOException) {
                    FRLogger.getLogger().error(iOException.getMessage(), iOException);
                    Object var6_7 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        FRLogger.getLogger().error(iOException2.getMessage(), iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FRLogger.getLogger().error(iOException.getMessage(), iOException);
                }
                throw throwable;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void copyCharTo(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[32768];
        while ((n2 = reader.read(cArray)) > 0) {
            writer.write(cArray, 0, n2);
        }
        writer.flush();
    }

    public static BufferedImage readImageWithCache(String string) {
        return IOUtils.readImage(string, true);
    }

    public static Map<String, BufferedImage> getCacheImageMap() {
        return imageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readCacheImage(String string) {
        try {
            lock.readLock().lock();
            BufferedImage bufferedImage = imageMap.get(string);
            Object var3_2 = null;
            lock.readLock().unlock();
            return bufferedImage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readImage(String string, boolean bl) {
        BufferedImage bufferedImage = null;
        if (bl) {
            bufferedImage = IOUtils.readCacheImage(string);
        }
        if (bufferedImage instanceof BufferedImage) {
            return bufferedImage;
        }
        InputStream inputStream = null;
        if (IOUtils.isOnlineUrl(string)) {
            try {
                inputStream = new URL(string).openStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = IOUtils.readFromChinesePath(string);
            }
            catch (IOException iOException) {
                FRLogger.getLogger().error(iOException.getMessage(), iOException);
            }
        } else {
            inputStream = IOUtils.readResource(string);
        }
        if (inputStream == null) {
            return null;
        }
        BufferedImage bufferedImage2 = null;
        try {
            bufferedImage2 = IOUtils.readImage(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        if (bl && string != null && bufferedImage2 != null) {
            try {
                lock.writeLock().lock();
                imageMap.put(string, bufferedImage2);
                Object var7_8 = null;
                lock.writeLock().unlock();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                lock.writeLock().unlock();
                throw throwable;
            }
        }
        return bufferedImage2 != null ? bufferedImage2 : CoreGraphHelper.createBufferedImage(0, 0);
    }

    private static boolean isOnlineUrl(String string) {
        return StringUtils.isNotEmpty(string) && (string.toLowerCase().startsWith("http:") || string.toLowerCase().startsWith("ftp:"));
    }

    private static InputStream readFromChinesePath(String string) {
        InputStream inputStream = null;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (ChineseHelper.isChineseCharacter(c2)) {
                    stringBuffer.append(URLEncoder.encode(String.valueOf(c2), "UTF-8"));
                    continue;
                }
                stringBuffer.append(c2);
            }
            inputStream = new URL(stringBuffer.toString()).openStream();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
        return inputStream;
    }

    public static BufferedImage readImage(String string) {
        return IOUtils.readImage(string, false);
    }

    public static Icon readIcon(String string) {
        BufferedImage bufferedImage = IOUtils.readImageWithCache(string);
        if (bufferedImage == null) {
            FRLogger.getLogger().error(string);
            return new ImageIcon();
        }
        return new ImageIcon(bufferedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeAllImageCache() {
        int n2 = imageMap.size();
        try {
            lock.writeLock().lock();
            imageMap.clear();
            Object var2_1 = null;
            lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            lock.writeLock().unlock();
            throw throwable;
        }
        return n2;
    }

    public static BufferedImage readImage(InputStream inputStream) throws IOException {
        return ImageIO.read(inputStream);
    }

    private static boolean checkPrivilege(String string) {
        return string.indexOf("..") == -1 && !string.endsWith(".xml") && !string.endsWith(".cpt");
    }

    public static InputStream readResource(String string) {
        Object object;
        if (string == null || string.length() <= 0) {
            return null;
        }
        String string2 = IOUtils.transformPath(string);
        if (StringUtils.isNotEmpty(string2)) {
            string = string2;
        }
        InputStream inputStream = null;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (object = (ResourceReadProcessor)extraClassManagerProvider.getSingle("ResourceReadProcessor")) != null) {
            inputStream = object.readResource(string);
        }
        if (inputStream == null) {
            inputStream = string.startsWith("/") ? GeneralUtils.class.getResourceAsStream(string) : GeneralUtils.class.getResourceAsStream("/" + string);
        }
        if (inputStream != null && IOUtils.checkPrivilege(string)) {
            return inputStream;
        }
        try {
            try {
                object = new File(string);
                if (((File)object).exists()) {
                    return new FileInputStream(string);
                }
                return IOUtils.checkEmbered(string);
            }
            catch (SecurityException securityException) {
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return null;
    }

    private static String transformPath(String string) {
        Set set;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getExtraClassManager();
        if (extraClassManagerProvider != null && !(set = extraClassManagerProvider.getArray("ResourcePathTransformer")).isEmpty()) {
            for (ResourcePathTransformer resourcePathTransformer : set) {
                if (!resourcePathTransformer.accept(string)) continue;
                return resourcePathTransformer.transform(string);
            }
        }
        return string;
    }

    private static InputStream checkEmbered(String string) {
        InputStream inputStream = null;
        try {
            if (string.endsWith(".cpt")) {
                inputStream = GeneralContext.getEnvProvider().readBean(string, "reportlets");
            }
            if (string.endsWith(".xml")) {
                inputStream = GeneralContext.getEnvProvider().readBean(string, "resources");
            }
            if (inputStream != null) {
                String string2 = CodeUtils.passwordEncode(IOUtils.inputStream2String(inputStream, "UTF-8"));
                return new ByteArrayInputStream(string2.getBytes("UTF-8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    public static void writeImage(Image image, String string, OutputStream outputStream) {
        CoreGraphHelper.waitForImage(image);
        try {
            if ("gif".equalsIgnoreCase(string)) {
                GIFEncoder gIFEncoder = new GIFEncoder(image, outputStream);
                gIFEncoder.encode();
            } else {
                ImageIO.write((RenderedImage)CoreGraphHelper.toBufferedImage(image), string, outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readResourceAsString(String string) {
        return IOUtils.readResourceAsString(string, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readResourceAsString(String string, String string2) {
        StringBuffer stringBuffer;
        block13: {
            stringBuffer = new StringBuffer();
            InputStream inputStream = IOUtils.readResource(string);
            String string3 = null;
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append(string3);
                }
                Object var7_8 = null;
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    FRLogger.getLogger().error(iOException.getMessage(), iOException);
                }
                break block13;
                {
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        FRLogger.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                        Object var7_9 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            FRLogger.getLogger().error(iOException.getMessage(), iOException);
                        }
                        break block13;
                    }
                    catch (IOException iOException) {
                        FRLogger.getLogger().error(iOException.getMessage(), iOException);
                        Object var7_10 = null;
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {
                            FRLogger.getLogger().error(iOException2.getMessage(), iOException2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        FRLogger.getLogger().error(iOException.getMessage(), iOException);
                    }
                    throw throwable;
                }
            }
        }
        return stringBuffer.toString();
    }

    public static BufferedImage downloadImageFromUrl(String string) {
        try {
            Image image = IOUtils.readImageFromPath(string, true);
            return (BufferedImage)image;
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return null;
        }
    }

    private static Image readImageFromPath(Object object, boolean bl) {
        String string;
        BufferedImage bufferedImage;
        String string2 = (String)object;
        if (string2.endsWith("/") || string2.endsWith("\\")) {
            object = string2.substring(0, ((String)object).length() - 1);
        }
        if ((bufferedImage = IOUtils.getBufferedImage(bl, string = ((String)object).trim())) == null && GeneralContext.getEnvProvider() != null && StringUtils.isNotBlank((String)object)) {
            String string3 = StableUtils.pathJoin(new File(GeneralContext.getEnvProvider().getPath()).getParent(), GeneralUtils.objectToString(object));
            bufferedImage = IOUtils.getBufferedImage(bl, string3);
        }
        return bufferedImage;
    }

    private static BufferedImage getBufferedImage(boolean bl, String string) {
        BufferedImage bufferedImage = null;
        if (bl) {
            bufferedImage = IOUtils.readCacheImage(string);
            if (bufferedImage != null) {
                return bufferedImage;
            }
            bufferedImage = IOUtils.readImageWithCache(string);
            return bufferedImage;
        }
        bufferedImage = IOUtils.readImage(string);
        return bufferedImage;
    }

    public static boolean unZipFilesGBK(String string, String string2) throws Exception {
        System.setProperty("sun.zip.encoding", System.getProperty("sun.jnu.encoding"));
        try {
            StableUtils.deleteFile(new File(string2));
            new File(string2).mkdirs();
            File file = new File(string);
            org.apache.tools.zip.ZipFile zipFile = new org.apache.tools.zip.ZipFile(string, "GBK");
            if (!file.exists() && file.length() <= 0L) {
                throw new Exception("no zip file!");
            }
            File file2 = new File(string2);
            String string3 = file2.getAbsolutePath();
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                int n2;
                Object object;
                Object object2;
                String string4;
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                String string5 = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    string4 = string3 + File.separator + string5;
                    object2 = new File(string4);
                    ((File)object2).mkdirs();
                    continue;
                }
                object2 = zipFile.getInputStream(zipEntry);
                BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object2);
                string5 = zipEntry.getName();
                string4 = string3 + File.separator + string5;
                String string6 = string5;
                for (int i2 = 0; i2 < string6.length(); ++i2) {
                    File file3;
                    if (!string6.substring(i2, i2 + 1).equalsIgnoreCase("/") || (file3 = new File((String)(object = string3 + File.separator + string6.substring(0, i2)))).exists()) continue;
                    file3.mkdir();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                object = new BufferedOutputStream(fileOutputStream);
                while ((n2 = bufferedInputStream.read()) != -1) {
                    ((BufferedOutputStream)object).write((byte)n2);
                }
                ((FilterOutputStream)object).close();
                fileOutputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServletStop() {
                try {
                    lock.writeLock().lock();
                    imageMap.clear();
                    Object var2_1 = null;
                    lock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    lock.writeLock().unlock();
                    throw throwable;
                }
            }
        });
    }
}

