/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.web.button;

import com.fr.base.IconManager;
import com.fr.base.TemplateUtils;
import com.fr.form.ui.Button;
import com.fr.form.ui.ToolBarMenuButton;
import com.fr.form.web.button.Excel;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public final class Export
extends ToolBarMenuButton {
    private boolean excelPAvailable = true;
    private boolean excelOAvailable = true;

    public Export() {
        super(TemplateUtils.i18nTpl("Export"), IconManager.EXPORT.getName());
    }

    public boolean isExcelPAvailable() {
        return this.excelPAvailable;
    }

    public void setExcelPAvailable(boolean bl) {
        this.excelPAvailable = bl;
    }

    public boolean isExcelOAvailable() {
        return this.excelOAvailable;
    }

    public void setExcelOAvailable(boolean bl) {
        this.excelOAvailable = bl;
    }

    public boolean isExcelAvailable() {
        return this.excelPAvailable || this.excelOAvailable;
    }

    public boolean supportMobile() {
        return false;
    }

    public Button[] createMenuItems() {
        ArrayList<Excel> arrayList = new ArrayList<Excel>();
        if (this.isExcelAvailable()) {
            arrayList.add(new Excel(this.excelPAvailable, this.excelOAvailable));
        }
        return arrayList.toArray(new Button[arrayList.size()]);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Buttons")) {
            this.setExcelPAvailable(xMLableReader.getAttrAsBoolean("excelP", true));
            this.setExcelOAvailable(xMLableReader.getAttrAsBoolean("excelO", true));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Buttons").attr("excelP", this.excelPAvailable).attr("excelO", this.excelOAvailable).end();
    }

    public boolean equals(Object object) {
        return object instanceof Export && super.equals(object) && ((Export)object).excelPAvailable == this.excelPAvailable && ((Export)object).excelOAvailable == this.excelOAvailable;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("widgetName", this.getClass().getSimpleName());
        return jSONObject;
    }
}

