/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.tree;

import com.fr.base.Utils;
import com.fr.data.AbstractDataModel;
import com.fr.data.Dictionary;
import com.fr.form.ui.tree.LayerConfig;
import com.fr.form.ui.tree.LayerDependence;
import com.fr.form.ui.tree.TreeValuePath;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.script.Calculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerData {
    private final int layerIndex;
    private int modelColumn;
    private int viewColumn;
    private boolean removeRepeat = true;
    private List<LayerDependence> dependenceList;
    private DataModel dataModel;
    private Map<NodeKey, List<Dictionary.MV>> structurizedDatas;

    public LayerData(LayerConfig layerConfig, Calculator calculator, boolean bl) {
        this.layerIndex = layerConfig.getIndex();
        this.removeRepeat = bl;
        try {
            if (bl) {
                this.initNonRepetitiveModel(layerConfig, calculator);
            } else {
                this.initModel(layerConfig, calculator);
            }
            this.initStructurizedData();
        }
        catch (TableDataException tableDataException) {
            throw new RuntimeException(tableDataException);
        }
    }

    private void initModel(LayerConfig layerConfig, Calculator calculator) {
        this.dataModel = layerConfig.getTableData().createDataModel(calculator);
        this.viewColumn = layerConfig.getViewColumn();
        this.modelColumn = layerConfig.getModelColumn();
        this.dependenceList = layerConfig.getDependenceList();
    }

    private void initNonRepetitiveModel(LayerConfig layerConfig, Calculator calculator) throws TableDataException {
        DataModel dataModel = layerConfig.getTableData().createDataModel(calculator);
        Set<Integer> set = this.getConcernedColumnIndexes(layerConfig);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        int n2 = 0;
        for (Integer n3 : set) {
            hashMap.put(n3, n2);
            hashMap2.put(n2, n3);
            ++n2;
        }
        this.dataModel = this.createNewDataModel(dataModel, hashMap2);
        this.initIndexConcernedInfos(layerConfig, hashMap);
    }

    private NonRepetitiveDataModel createNewDataModel(DataModel dataModel, Map<Integer, Integer> map) throws TableDataException {
        NonRepetitiveDataModel nonRepetitiveDataModel = new NonRepetitiveDataModel();
        int n2 = dataModel.getRowCount();
        int n3 = map.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            NonRepetitiveDataModel.Row row = new NonRepetitiveDataModel.Row();
            for (int i3 = 0; i3 < n3; ++i3) {
                int n4 = map.get(i3);
                row.addColumn(Utils.objectToString(dataModel.getValueAt(i2, n4)));
            }
            nonRepetitiveDataModel.addRow(row);
        }
        return nonRepetitiveDataModel;
    }

    private void initIndexConcernedInfos(LayerConfig layerConfig, Map<Integer, Integer> map) {
        this.viewColumn = map.get(layerConfig.getViewColumn());
        this.modelColumn = map.get(layerConfig.getModelColumn());
        this.dependenceList = new ArrayList<LayerDependence>();
        for (LayerDependence layerDependence : layerConfig.getDependenceList()) {
            LayerDependence layerDependence2 = new LayerDependence(layerDependence.getLayerIndex(), map.get(layerDependence.getThisColumnIndex()));
            this.dependenceList.add(layerDependence2);
        }
    }

    private Set<Integer> getConcernedColumnIndexes(LayerConfig layerConfig) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(layerConfig.getModelColumn());
        hashSet.add(layerConfig.getViewColumn());
        for (LayerDependence layerDependence : layerConfig.getDependenceList()) {
            hashSet.add(layerDependence.getThisColumnIndex());
        }
        return hashSet;
    }

    private void initStructurizedData() {
        if (this.layerIndex == 1) {
            return;
        }
        int n2 = 0;
        try {
            n2 = this.dataModel.getRowCount();
            this.structurizedDatas = new HashMap<NodeKey, List<Dictionary.MV>>();
        }
        catch (TableDataException tableDataException) {
            // empty catch block
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.getModel(i2);
            String string2 = this.getView(i2);
            NodeKey nodeKey = this.createNodeKey(i2);
            List<Dictionary.MV> list = this.structurizedDatas.get(nodeKey);
            if (list == null) {
                list = new ArrayList<Dictionary.MV>();
                this.structurizedDatas.put(nodeKey, list);
            }
            list.add(new Dictionary.MV(string, string2));
        }
    }

    public String getModel(int n2) {
        try {
            return Utils.objectToString(this.dataModel.getValueAt(n2, this.modelColumn));
        }
        catch (TableDataException tableDataException) {
            throw new RuntimeException(tableDataException);
        }
    }

    public String getView(int n2) {
        try {
            return Utils.objectToString(this.dataModel.getValueAt(n2, this.viewColumn));
        }
        catch (TableDataException tableDataException) {
            throw new RuntimeException(tableDataException);
        }
    }

    public List<Dictionary.MV> getMVsAsChildren(TreeValuePath treeValuePath) {
        NodeKey nodeKey = this.createNodeKey(treeValuePath);
        List<Dictionary.MV> list = this.structurizedDatas.get(nodeKey);
        if (list == null) {
            list = new ArrayList<Dictionary.MV>();
        }
        return list;
    }

    private NodeKey createNodeKey(int n2) {
        NodeKey nodeKey = new NodeKey();
        for (LayerDependence layerDependence : this.dependenceList) {
            String string;
            int n3 = layerDependence.getLayerIndex();
            try {
                string = Utils.objectToString(this.dataModel.getValueAt(n2, layerDependence.getThisColumnIndex()));
            }
            catch (TableDataException tableDataException) {
                throw new RuntimeException(tableDataException);
            }
            nodeKey.add(n3, string);
        }
        return nodeKey;
    }

    private NodeKey createNodeKey(TreeValuePath treeValuePath) {
        NodeKey nodeKey = new NodeKey();
        for (LayerDependence layerDependence : this.dependenceList) {
            int n2 = layerDependence.getLayerIndex();
            nodeKey.add(n2, treeValuePath.getValue(n2));
        }
        return nodeKey;
    }

    public int getRowCount() throws TableDataException {
        return this.dataModel.getRowCount();
    }

    private static final class NodeKey {
        Map<Integer, String> concernedLayerValue = new HashMap<Integer, String>();

        public void add(int n2, String string) {
            this.concernedLayerValue.put(n2, string);
        }

        public boolean equals(Object object) {
            Set<Integer> set;
            if (!object.getClass().equals(this.getClass())) {
                return false;
            }
            Map<Integer, String> map = ((NodeKey)object).concernedLayerValue;
            Set<Integer> set2 = this.concernedLayerValue.keySet();
            if (!set2.containsAll(set = map.keySet()) || !set.containsAll(set2)) {
                return false;
            }
            for (Integer n2 : set2) {
                if (this.concernedLayerValue.get(n2).equals(map.get(n2))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n2 = 0;
            for (Map.Entry<Integer, String> entry : this.concernedLayerValue.entrySet()) {
                n2 += entry.getValue().hashCode();
            }
            return n2;
        }
    }

    private static final class NonRepetitiveDataModel
    extends AbstractDataModel
    implements DataModel {
        private List<Row> rows = new ArrayList<Row>();
        private Set<Row> rowSet = new HashSet<Row>();
        private int columnCount;

        private NonRepetitiveDataModel() {
        }

        public void addRow(Row row) {
            if (this.rows.isEmpty()) {
                this.columnCount = row.getColumnCount();
            }
            if (this.invalid(row) || this.rowSet.contains(row)) {
                return;
            }
            this.rows.add(row);
            this.rowSet.add(row);
        }

        private boolean invalid(Row row) {
            return row.getColumnCount() == 0 || row.getColumnCount() != this.columnCount;
        }

        public int getColumnCount() throws TableDataException {
            return this.columnCount;
        }

        public boolean hasRow(int n2) throws TableDataException {
            return n2 < this.rows.size();
        }

        public int getRowCount() throws TableDataException {
            return this.rows.size();
        }

        public Object getValueAt(int n2, int n3) throws TableDataException {
            Row row = this.rows.get(n2);
            return row.getValueAt(n3);
        }

        @Deprecated
        public void release() throws Exception {
        }

        @Deprecated
        public String getColumnName(int n2) throws TableDataException {
            return null;
        }

        public static final class Row {
            private List<Object> objects = new ArrayList<Object>();

            public void addColumn(Object object) {
                this.objects.add(object);
            }

            public int getColumnCount() {
                return this.objects.size();
            }

            public Object getValueAt(int n2) {
                return this.objects.get(n2);
            }

            public int hashCode() {
                int n2 = 0;
                for (Object object : this.objects) {
                    n2 += object.hashCode();
                }
                return n2;
            }

            public boolean equals(Object object) {
                if (!object.getClass().equals(this.getClass())) {
                    return false;
                }
                Row row = (Row)object;
                if (row.getColumnCount() != this.getColumnCount()) {
                    return false;
                }
                for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
                    Object object2;
                    Object object3 = row.getValueAt(i2);
                    if (object3.equals(object2 = this.getValueAt(i2))) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

