/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui.container;

import com.fr.form.ui.Widget;
import com.fr.form.ui.container.WLayout;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Dimension;

public abstract class WSplitLayout
extends WLayout {
    public static final String CENTER = "center";
    public static final String ASIDE = "aside";
    private double ratio = 0.5;
    private Widget center;
    private Widget aside;

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d2) {
        this.ratio = d2;
    }

    public void addWidget(Widget widget, Object object) {
        if (ComparatorUtils.equals((Object)ASIDE, object)) {
            this.addAside(widget);
        } else {
            this.addCenter(widget);
        }
    }

    public void addCenter(Widget widget) {
        super.addWidget(widget);
        this.center = widget;
    }

    public void addAside(Widget widget) {
        super.addWidget(widget);
        this.aside = widget;
    }

    public Widget getLayoutWidget(Object object) {
        if (ComparatorUtils.equals((Object)ASIDE, object)) {
            return this.aside;
        }
        return this.center;
    }

    public void removeWidget(Widget widget) {
        super.removeWidget(widget);
        if (ComparatorUtils.equals(widget, this.center)) {
            this.center = null;
        } else if (ComparatorUtils.equals(widget, this.aside)) {
            this.aside = null;
        }
    }

    public String getLayoutToolTip() {
        return Inter.getLocText("WLayout-Split-ToolTips");
    }

    public Dimension getMinDesignSize() {
        return new Dimension();
    }

    public void removeAll() {
        super.removeAll();
        this.center = null;
        this.aside = null;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("ratio", this.ratio);
        return jSONObject;
    }

    protected JSONArray createJSONItems(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject;
        JSONArray jSONArray = new JSONArray();
        if (this.aside != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", ASIDE);
            jSONObject.put("el", this.aside.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        if (this.center != null) {
            jSONObject = new JSONObject();
            jSONObject.put("region", CENTER);
            jSONObject.put("el", this.center.createJSONConfig(repository, calculator, nodeVisitor));
            jSONArray.put(jSONObject);
        }
        return jSONArray;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Center")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WSplitLayout.this.addCenter((Widget)GeneralXMLTools.readXMLable(xMLableReader));
                    }
                });
            } else if (string.equals("Aside")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        WSplitLayout.this.addAside((Widget)GeneralXMLTools.readXMLable(xMLableReader));
                    }
                });
            } else if (string.equals("SplitAttr")) {
                this.setRatio(xMLableReader.getAttrAsDouble("ratio", 0.5));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        this.widgetList.clear();
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("SplitAttr").attr("ratio", this.ratio).end();
        if (this.center != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.center, "Center");
        }
        if (this.aside != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.aside, "Aside");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WSplitLayout wSplitLayout = (WSplitLayout)super.clone();
        if (this.center != null) {
            wSplitLayout.center = this.center;
        }
        if (this.aside != null) {
            wSplitLayout.aside = this.aside;
        }
        return this.aside;
    }
}

