/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.FieldEditor;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public class FileEditor
extends FieldEditor {
    public static final String EVENT_UPLOAD_CALLBACK = "callback";
    private String allowTypes;
    private String url;
    private double maxSize = -1.0;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public double getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(double d2) {
        this.maxSize = d2;
    }

    public String getAllowTypes() {
        return this.allowTypes;
    }

    public void setAllowTypes(String string) {
        this.allowTypes = string;
    }

    public String getXType() {
        return "file";
    }

    public boolean supportMobile() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{"afterinit", EVENT_UPLOAD_CALLBACK};
    }

    public boolean equals(Object object) {
        if (!(object instanceof FileEditor)) {
            return false;
        }
        return ComparatorUtils.equals(((FileEditor)object).allowTypes, this.allowTypes);
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (!StringUtils.isBlank(this.url)) {
            jSONObject.put("url", this.url);
        }
        if (!StringUtils.isEmpty(this.allowTypes)) {
            jSONObject.put("allowTypes", this.allowTypes);
        }
        if (this.maxSize != -1.0) {
            jSONObject.put("maxSize", this.maxSize);
        }
        return jSONObject;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("FileAttr")) {
            String string = null;
            this.setUrl(xMLableReader.getAttrAsString("url", null));
            string = xMLableReader.getAttrAsString("allowTypes", null);
            if (string != null) {
                this.setAllowTypes(string);
            }
            this.setMaxSize(xMLableReader.getAttrAsInt("maxSize", -1));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("FileAttr");
        if (this.url != null) {
            xMLPrintWriter.attr("url", this.url);
        }
        if (!StringUtils.isEmpty(this.allowTypes)) {
            xMLPrintWriter.attr("allowTypes", this.allowTypes);
        }
        if (this.maxSize != -1.0) {
            xMLPrintWriter.attr("maxSize", this.maxSize);
        }
        xMLPrintWriter.end();
    }
}

