/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.data;

import com.fr.base.BaseXMLUtils;
import com.fr.base.DynamicNumberList;
import com.fr.base.FRContext;
import com.fr.base.TableData;
import com.fr.data.core.DataCoreUtils;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;

public class DataTableConfig
implements XMLable {
    public static final String XML_TAG = "tableDataConfig";
    public static final DataTableConfig DEFAULT_TABLE_DATA_CONFIG = new DataTableConfig();
    public static final String EXAMPLE = "example";
    private String tableName;
    private boolean showTitle = true;
    private ArrayList modelNameList = new ArrayList();
    private ArrayList columnNameList = new ArrayList();
    private DynamicNumberList columnWidthList_DEC = new DynamicNumberList(50);
    private int rowHeight = 30;

    public DataTableConfig() {
        this(null, null);
    }

    public DataTableConfig(String string, TableData tableData) {
        this.tableName = string;
        if (tableData != null) {
            try {
                DataModel dataModel = tableData.createDataModel(Calculator.createCalculator());
                int n2 = dataModel.getColumnCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.columnNameList.add(dataModel.getColumnName(i2));
                    this.modelNameList.add(dataModel.getColumnName(i2));
                }
            }
            catch (TableDataException tableDataException) {
                FRContext.getLogger().error(tableDataException.getMessage(), tableDataException);
            }
        }
    }

    public String getTableDataName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setShowTitle(boolean bl) {
        this.showTitle = bl;
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public int getColumnCount() {
        return this.columnNameList.size();
    }

    public String getColumnName(int n2) {
        return (String)this.columnNameList.get(n2);
    }

    public void setTitle(int n2, String string) {
    }

    public int getColumnWidth(int n2) {
        return this.columnWidthList_DEC.get(n2);
    }

    public void setColumnWidth(int n2, int n3) {
        this.columnWidthList_DEC.set(n2, n3);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n2) {
        this.rowHeight = n2;
    }

    public int getRowCount() {
        return 1;
    }

    public void setColumns(String[] stringArray) {
        this.columnNameList.clear();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!this.modelNameList.contains(stringArray[i2])) continue;
            this.columnNameList.add(stringArray[i2]);
        }
    }

    public JSONObject createAttrResult(Calculator calculator) {
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < this.columnNameList.size(); ++i2) {
            jSONArray.put(this.columnNameList.get(i2));
            jSONArray2.put(this.columnWidthList_DEC.get(i2));
        }
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("head", jSONArray).put("columnWidth", jSONArray2).put("rowHeight", this.rowHeight).put("showHead", this.showTitle);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage(), jSONException);
        }
        TableData tableData = DataCoreUtils.getTableData(calculator, this.tableName);
        if (tableData != null) {
            this.createJo(calculator, tableData, jSONObject);
        } else if (ComparatorUtils.equals(this.tableName, EXAMPLE)) {
            JSONArray jSONArray3 = new JSONArray();
            JSONArray jSONArray4 = new JSONArray().put("Apple").put(2).put("$10");
            jSONArray3.put(jSONArray4);
            try {
                jSONObject.put("tablecontent", jSONArray3);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().error(jSONException.getMessage(), jSONException);
            }
        }
        return jSONObject;
    }

    private void createJo(Calculator calculator, TableData tableData, JSONObject jSONObject) {
        int n2;
        DataModel dataModel = tableData.createDataModel(calculator);
        Object[] objectArray = this.columnNameList.toArray(new String[0]);
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = -1;
        }
        try {
            int n3;
            for (n2 = 0; n2 < dataModel.getColumnCount(); ++n2) {
                n3 = ArrayUtils.indexOf(objectArray, dataModel.getColumnName(n2));
                if (n3 == -1) continue;
                nArray[n3] = n2;
            }
            JSONArray jSONArray = new JSONArray();
            for (n3 = 0; n3 < dataModel.getRowCount(); ++n3) {
                JSONArray jSONArray2 = new JSONArray();
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    if (nArray[i2] != -1) {
                        jSONArray2.put(dataModel.getValueAt(n3, nArray[i2]));
                        continue;
                    }
                    jSONArray2.put("");
                }
                jSONArray.put(jSONArray2);
            }
            jSONObject.put("tablecontent", jSONArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals(string, "config")) {
                this.showTitle = xMLableReader.getAttrAsBoolean("showTilte", true);
                this.rowHeight = xMLableReader.getAttrAsInt("rowHeight", 30);
                this.tableName = xMLableReader.getAttrAsString("tableName", "");
            } else if (ComparatorUtils.equals(string, "modelList")) {
                this.modelNameList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals(string = xMLableReader.getTagName(), "modelName")) {
                            DataTableConfig.this.modelNameList.add(xMLableReader.getAttrAsString("name", ""));
                        }
                    }
                });
            } else if (ComparatorUtils.equals(string, "columnList")) {
                this.columnNameList = new ArrayList();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        String string;
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals(string = xMLableReader.getTagName(), "columnName")) {
                            DataTableConfig.this.columnNameList.add(xMLableReader.getAttrAsString("name", ""));
                        }
                    }
                });
            } else if (ComparatorUtils.equals(string, "columnWidth")) {
                this.columnWidthList_DEC = BaseXMLUtils.readDynamicNumberList(xMLableReader);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n2;
        xMLPrintWriter.startTAG("config").attr("showTilte", this.showTitle).attr("rowHeight", this.rowHeight).attr("tableName", this.tableName).end();
        xMLPrintWriter.startTAG("columnWidth");
        BaseXMLUtils.writeDynamicNumberList(xMLPrintWriter, this.columnWidthList_DEC);
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("modelList");
        for (n2 = 0; n2 < this.modelNameList.size(); ++n2) {
            xMLPrintWriter.startTAG("modelName").attr("name", this.modelNameList.get(n2).toString()).end();
        }
        xMLPrintWriter.end();
        xMLPrintWriter.startTAG("columnList");
        for (n2 = 0; n2 < this.columnNameList.size(); ++n2) {
            xMLPrintWriter.startTAG("columnName").attr("name", this.columnNameList.get(n2).toString()).end();
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        DataTableConfig dataTableConfig = (DataTableConfig)super.clone();
        dataTableConfig.modelNameList = new ArrayList();
        dataTableConfig.modelNameList.addAll(this.modelNameList);
        dataTableConfig.columnNameList = new ArrayList();
        dataTableConfig.columnNameList.addAll(this.columnNameList);
        dataTableConfig.columnWidthList_DEC = (DynamicNumberList)this.columnWidthList_DEC.clone();
        return dataTableConfig;
    }

    static {
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.tableName = EXAMPLE;
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.columnNameList.add("class");
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.modelNameList.add("class");
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.columnNameList.add("count");
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.modelNameList.add("count");
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.columnNameList.add("price");
        DataTableConfig.DEFAULT_TABLE_DATA_CONFIG.modelNameList.add("price");
    }
}

