/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.DBUtils;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.TriggerAction;
import com.fr.data.core.db.dml.DML;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Insert;
import com.fr.data.core.db.dml.Select;
import com.fr.data.core.db.dml.Update;
import com.fr.data.dao.JdbcOperator;
import com.fr.data.dao.ResultSetExtractor;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import java.io.Serializable;
import java.sql.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDataAccessObjectTemplate
implements Serializable {
    private Connection conn;
    private boolean transaction = false;
    private Dialect dialect;

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public void setTransaction(boolean bl) {
        this.transaction = bl;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void execute(String string) throws Exception {
        this.checkConnectionAndDialect();
        try {
            JdbcOperator.execute(this.conn, string);
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(String string, ResultSetExtractor<T> resultSetExtractor) throws Exception {
        this.checkConnectionAndDialect();
        try {
            T t2 = JdbcOperator.query(this.conn, string, resultSetExtractor);
            return t2;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeQuery(Select select, ResultSetExtractor<T> resultSetExtractor) throws Exception {
        this.checkConnectionAndDialect();
        try {
            T t2 = JdbcOperator.executeQuery(this.conn, this.dialect, select, resultSetExtractor);
            return t2;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    public Serializable execute(Insert insert, boolean bl) throws Exception {
        this.checkConnectionAndDialect();
        boolean bl2 = ComparatorUtils.equals(insert.getColumnName(0), "id");
        Serializable serializable = null;
        if (!this.transaction) {
            try {
                boolean bl3 = this.conn.getAutoCommit();
                this.dialect.setAutoCommit(this.conn, false);
                serializable = this.getSerializable(insert, bl, bl2);
                this.conn.commit();
                this.dialect.setAutoCommit(this.conn, bl3);
                Serializable serializable2 = serializable;
                return serializable2;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage());
                if (this.conn != null) {
                    try {
                        this.conn.rollback();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                throw exception;
            }
            finally {
                DBUtils.closeConnection(this.conn);
                this.conn = null;
            }
        }
        serializable = this.getSerializable(insert, bl, bl2);
        return serializable;
    }

    private Serializable getSerializable(Insert insert, boolean bl, boolean bl2) throws Exception {
        Serializable serializable;
        if (bl2) {
            this.dialect.notifyTriggerChange(this.conn, insert.getTable(), TriggerAction.DISABLE);
            serializable = JdbcOperator.execute(this.conn, this.dialect, insert, bl);
            this.dialect.notifyTriggerChange(this.conn, insert.getTable(), TriggerAction.ENABLE);
        } else {
            serializable = JdbcOperator.execute(this.conn, this.dialect, insert, bl);
        }
        return serializable;
    }

    public void execute(DML dML) throws Exception {
        this.checkConnectionAndDialect();
        try {
            JdbcOperator.execute(this.conn, this.dialect, dML);
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    public int executeDelete(Delete delete) throws Exception {
        this.checkConnectionAndDialect();
        try {
            int n2 = JdbcOperator.executeDelete(this.conn, this.dialect, delete);
            return n2;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    public int executeUpdate(Update update) throws Exception {
        this.checkConnectionAndDialect();
        try {
            int n2 = JdbcOperator.executeUpdate(this.conn, this.dialect, update);
            return n2;
        }
        finally {
            if (!this.transaction) {
                DBUtils.closeConnection(this.conn);
            }
            this.conn = null;
        }
    }

    private void checkConnectionAndDialect() {
        if (this.conn == null) {
            throw new RuntimeException("No Connection!");
        }
        if (this.dialect == null) {
            throw new RuntimeException("No Dialect!");
        }
    }

    public void setForeignKeyChecks(int n2) {
        if (this.dialect == null) {
            return;
        }
        this.dialect.setForeignKeyChecks(this.conn, n2);
    }
}

