/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.ScreenResolution;
import com.fr.base.Utils;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.base.TimeSwitchAttr;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.FRFont;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import com.fr.stable.web.Repository;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryAxisGlyph
extends AxisGlyph {
    private static final long serialVersionUID = -6116809732597680006L;
    public static final double LABEL_OFFSET = 0.5;
    public static final double PRE_LABEL_HEIGHT = 20.0;
    private static final String ELLIPSIS = "\u2026";
    private static final double DE_LABEL_WIDTH = 8.0;
    protected ArrayList categoryLabelList = new ArrayList();
    private ArrayList secondLabels = new ArrayList();
    private ArrayList thirdLabels = new ArrayList();
    private int mainType = 1;
    private int secondType = 1;
    private ArrayList<TimeSwitchAttr> timeSwitchMap;

    public void setMainType(int n2) {
        this.mainType = n2;
    }

    public int getMainType() {
        return this.mainType;
    }

    public void setSecondType(int n2) {
        this.secondType = n2;
    }

    public int getSecondType() {
        return this.secondType;
    }

    public void setTimeSwitchMap(ArrayList<TimeSwitchAttr> arrayList) {
        this.timeSwitchMap = arrayList;
    }

    @Override
    public void initMinMaxValue(double d2, double d3) {
        this.maxValue = d3;
        this.minValue = d2;
        this.mainUnit = new BigDecimal("1");
        this.setSecUnit(0.2);
    }

    @Override
    protected double getMaxLabelWidthAndInitStartEndLabelDim(int n2) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d2 = 8.0;
        Object[] objectArray = this.categoryLabelList.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Dimension2D dimension2D = this.getAxisLabelDim(Utils.objectToString(objectArray[i2]), n2);
            if (i2 == 0) {
                this.startLabelDim = dimension2D;
            } else {
                this.endLabelDim = dimension2D;
            }
            double d3 = this.getAxisLabelWidth(Utils.objectToString(objectArray[i2]), n2);
            d2 = d3 < d2 ? d2 : d3;
        }
        return d2;
    }

    private double getMaxLength(int n2) {
        if (!this.isShowAxisLabel) {
            return 0.0;
        }
        double d2 = 0.0;
        Object[] objectArray = this.categoryLabelList.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            double d3 = this.getAxisLabelMoreWidth(Utils.objectToString(objectArray[i2]), n2);
            d2 = d3 < d2 ? d2 : d3;
        }
        return d2;
    }

    private double getAxisLabelMoreWidth(String string, int n2) {
        Dimension2D dimension2D = this.getAxisLabelDim(string, n2);
        Dimension2D dimension2D2 = GlyphUtils.calculateTextDimensionWithRotation("a", this.textAttr, n2);
        if (this.textAttr.getAlignText() == 0) {
            if (this.shouldBeHeight()) {
                double d2 = this.unitLength - dimension2D2.getWidth();
                return dimension2D.getHeight() + (dimension2D.getHeight() + 4.0) * (double)this.calculateTimes4Horizontal(string, d2, n2);
            }
            return dimension2D.getWidth();
        }
        if (this.shouldBeHeight()) {
            return dimension2D.getHeight();
        }
        return this.calculateAllWidth4Vertical(string, this.unitLength - 6.0, n2);
    }

    private double calculateAllWidth4Vertical(String string, double d2, int n2) {
        double d3 = -3.0;
        String string2 = string;
        double d4 = 4.0 + this.getTickLengthShow();
        block0: do {
            d3 += 3.0;
            for (int i2 = 1; i2 <= string2.length(); ++i2) {
                boolean bl;
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2.substring(0, i2), this.textAttr, n2);
                boolean bl2 = bl = dimension2D.getWidth() >= this.axisLabelWidth - d4 || dimension2D.getHeight() > d2;
                if (i2 == 1 && bl) {
                    string2 = "";
                    dimension2D = GlyphUtils.calculateTextDimensionWithRotation(ELLIPSIS, this.textAttr, n2);
                    d3 += dimension2D.getWidth();
                    continue block0;
                }
                double d5 = dimension2D.getHeight();
                if (d5 > d2 && i2 != 1) {
                    d3 += dimension2D.getWidth();
                    string2 = string2.substring(i2 - 1);
                    continue;
                }
                if (i2 != string2.length()) continue;
                string2 = "";
                d3 += dimension2D.getWidth();
            }
        } while (StringUtils.isNotEmpty(string2));
        return d3;
    }

    private int calculateTimes4Horizontal(String string, double d2, int n2) {
        int n3 = 0;
        String string2 = string;
        block0: while (StringUtils.isNotEmpty(string2)) {
            for (int i2 = 1; i2 <= string2.length(); ++i2) {
                Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string2.substring(0, i2), this.textAttr, n2);
                if (dimension2D.getWidth() > d2 && i2 != 1) {
                    ++n3;
                    string2 = string2.substring(i2 - 1);
                    continue block0;
                }
                string2 = dimension2D.getWidth() > d2 && i2 == 1 ? "" : (i2 == string2.length() ? "" : string2);
            }
        }
        return n3;
    }

    @Override
    public double getPreLeftWidth4DataSheet(int n2) {
        this.calculateTitleDimesion(n2);
        double d2 = 0.0;
        if (this.titleDim.getWidth() > 0.0) {
            d2 = this.titleDim.getWidth() + 4.0;
        }
        double d3 = this.getMaxLabelWidthAndInitStartEndLabelDim(n2);
        return this.position == 2 ? d3 + d2 : 0.0;
    }

    public void deletedRepeatLabel() {
        ArrayList arrayList = new ArrayList();
        for (Object e2 : this.categoryLabelList) {
            if (arrayList.contains(e2)) continue;
            arrayList.add(e2);
        }
        this.categoryLabelList.clear();
        this.categoryLabelList = arrayList;
        this.initMinMaxValue(0.0, this.categoryLabelList.size());
    }

    @Override
    protected void calculateAxisLengthUnit() {
        double d2 = this.getMaxValue() - this.getMinValue();
        if (d2 <= 0.0) {
            this.unitLength = 1.0;
            return;
        }
        this.unitLength = this.isDrawBetweenTick() ? this.axisLength / d2 : this.axisLength / Math.max(1.0, d2 - 1.0);
    }

    @Override
    protected double dealWithPlotBounds() {
        double d2 = this.getMaxLength(ScreenResolution.getScreenResolution());
        if (d2 > 0.0) {
            d2 += 4.0;
        }
        if ((d2 += this.getTickLengthShow()) <= this.axisLabelWidth) {
            return 0.0;
        }
        d2 = this.shouldBeHeight() ? Math.min(this.plotZeroBounds.getHeight() * 0.28 + 4.0 + this.getTickLengthShow(), d2) : Math.min(this.plotZeroBounds.getWidth() * 0.28 + 4.0 + this.getTickLengthShow(), d2);
        double d3 = d2 - this.axisLabelWidth;
        this.axisLabelWidth = d2;
        return d3;
    }

    @Override
    protected Rectangle2D getBottomTitleBounds(Dimension2D dimension2D, int n2) {
        double d2 = this.getAxisLabelWidth() + 4.0;
        if (!this.secondLabels.isEmpty()) {
            d2 += 20.0;
        }
        if (!this.thirdLabels.isEmpty()) {
            d2 += 20.0;
        }
        return new Rectangle2D.Double(this.getTopBottomX(n2), d2, dimension2D.getWidth(), dimension2D.getHeight());
    }

    @Override
    protected void calBoundsWithMoreLabel4Cate(Rectangle2D rectangle2D) {
        if (this.getPosition() == 3 && this.isShowAxisLabel) {
            double d2 = this.secondLabels.isEmpty() ? 0.0 : 20.0;
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - (d2 += this.thirdLabels.isEmpty() ? 0.0 : 20.0));
        }
    }

    public void addCategoryLabel(Object object) {
        this.categoryLabelList.add(object);
    }

    public void setCategoryLabelList(ArrayList arrayList) {
        this.categoryLabelList = arrayList;
    }

    public void addSecondLabel(Object object) {
        this.secondLabels.add(object);
    }

    public void addThirdLabel(Object object) {
        this.thirdLabels.add(object);
    }

    public int getTickNumber4CalDim() {
        int n2 = 1;
        double d2 = this.getMaxTickValue() - this.getMinValue();
        while (Math.ceil(d2 / ((double)n2 * this.getDateTypeNumber())) > 1.0) {
            ++n2;
        }
        return n2;
    }

    @Override
    public int getTickSamplingTime() {
        int n2 = 1;
        double d2 = this.getMaxTickValue() - this.getMinValue();
        if (d2 < 0.0) {
            return n2;
        }
        while (this.axisLength > 1.0 && this.axisLength / Math.ceil(d2 / (this.getMainUnit() * (double)n2 * this.getDateTypeNumber())) < 1.0) {
            ++n2;
        }
        return n2;
    }

    protected double getDateTypeNumber() {
        return 1.0;
    }

    public int getLabelSamplingTime(int n2, boolean bl, int n3, int n4, double d2) {
        int n5 = n2 * n3;
        GeneralPath generalPath = new GeneralPath();
        int n6 = this.categoryLabelList.size();
        for (int i2 = 0; i2 < n6; i2 += n5) {
            String string = this.getLabelString(i2, bl);
            Rectangle2D rectangle2D = this.getLabelBounds(i2, d2, string, n4);
            if (generalPath.intersects(rectangle2D)) {
                return this.getLabelSamplingTime(n2, bl, ++n3, n4, d2);
            }
            generalPath.append(rectangle2D, false);
        }
        return n3;
    }

    private boolean isToNumber() {
        boolean bl = true;
        int n2 = this.categoryLabelList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = this.categoryLabelList.toArray();
            Number number = Utils.objectToNumber(objectArray[i2], true);
            if (number == null) {
                bl = false;
            }
            if (!bl) break;
        }
        return bl;
    }

    public String getLabelString(int n2, boolean bl) {
        Object e2 = this.categoryLabelList.get(n2);
        String string = Utils.objectToString(e2);
        if (this.format != null && StringUtils.isNotEmpty(string)) {
            Date date;
            string = bl ? this.format.format(Double.valueOf(string)) : ((date = DateUtils.object2Date(e2, true)) == null ? string : this.format.format(date));
        }
        return string;
    }

    @Override
    public void drawAxisGrid(Graphics graphics) {
        if (this.axisLength <= 1.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d2 = this.getMaxTickValue();
        int n2 = this.getTickSamplingTime();
        if (this.getMainGridStyle() != 0 && this.getMainUnit() > 0.0 && this.getMainGridColor() != null) {
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(this.getMainGridColor());
            graphics2D.setStroke(GraphHelper.getStroke(this.getMainGridStyle()));
            for (double d3 = (this.getMainUnit() + this.getCrossValue()) * (double)n2; d3 <= d2; d3 += this.getMainUnit() * (double)n2) {
                Line2D[] line2DArray = this.getGridLine(d3);
                for (int i2 = 0; i2 < line2DArray.length; ++i2) {
                    graphics2D.draw(line2DArray[i2]);
                }
            }
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }

    @Override
    protected void drawAxisLine(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Stroke stroke = graphics2D.getStroke();
        int n3 = this.getLineStyle();
        if (this.getLineColor() != null && n3 != 0) {
            graphics2D.setStroke(GraphHelper.getStroke(n3));
            graphics2D.setPaint(this.lineColor);
            Line2D.Double double_ = new Line2D.Double(this.getPoint2D(this.getCrossValue()), this.getPoint2D(this.getMaxTickValue()));
            graphics2D.draw(double_);
            this.drawArrow(graphics2D, double_.getP1(), double_.getP2());
        }
        this.drawTicks(graphics2D, n2);
        this.drawMoreTickLabel(graphics2D, n2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private void drawMoreTickLabel(Graphics graphics, int n2) {
        if (!this.isShowAxisLabel) {
            return;
        }
        this.drawMore(graphics, this.secondLabels, 0, n2);
        this.drawMore(graphics, this.thirdLabels, 1, n2);
        this.drawMoreTicks(graphics, 0);
        this.drawMoreTicks(graphics, 1);
    }

    private void drawMore(Graphics graphics, ArrayList arrayList, int n2, int n3) {
        GeneralPath generalPath = new GeneralPath();
        TextAttr textAttr = new TextAttr();
        textAttr.setFRFont(FRFont.getInstance("Microsoft YaHei", 0, 9.0f));
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            String string = Utils.objectToString(arrayList.get(i2));
            Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithRotation(string, textAttr, n3);
            double d2 = this.getSecondX(i2, n4);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2 - dimension2D.getWidth() / 2.0, this.axisLabelWidth + (double)n2 * 20.0, dimension2D.getWidth(), dimension2D.getHeight());
            if (generalPath.intersects(double_)) continue;
            generalPath.append(double_, false);
            GlyphUtils.drawStrings(graphics, string, textAttr, double_, n3);
        }
    }

    private void drawMoreTicks(Graphics graphics, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList = n2 == 0 ? this.secondLabels : this.thirdLabels;
        if (arrayList == null || arrayList.isEmpty()) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n3 = (int)((double)(n2 + 1) * 20.0 + this.axisLabelWidth);
        int n4 = this.categoryLabelList.size() / arrayList.size();
        for (double d2 = 0.0; d2 <= (double)arrayList.size(); d2 += 1.0) {
            Line2D line2D = this.getTickLine(d2 * (double)n4, n3, this.getTickMarkType());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
    }

    @Override
    public void draw4ThreeD(Graphics graphics, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        this.drawTickLable(graphics, n2);
        this.drawMoreTickLabel(graphics, n2);
        this.drawAxisTitle(graphics2D, n2);
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
    }

    protected void drawTickLable(Graphics graphics, int n2) {
        if (this.axisLength <= 1.0) {
            return;
        }
        int n3 = this.getTickSamplingTime();
        boolean bl = this.isToNumber();
        double d2 = this.isDrawBetweenTick() ? 0.5 : 0.0;
        int n4 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getLabelSamplingTime(n3, bl, 1, n2, d2) * n3;
        int n5 = this.categoryLabelList.size();
        for (int i2 = 0; i2 < n5; i2 += n4) {
            this.drawLabel(graphics, i2, d2, this.getLabelString(i2, bl), n2);
        }
    }

    private double getSecondX(double d2, double d3) {
        double d4 = this.getBounds().getWidth();
        return d4 * (d2 + 0.5) / d3;
    }

    @Override
    protected void drawTicks(Graphics graphics, int n2) {
        int n3;
        Line2D line2D;
        double d2;
        if (this.axisLength <= 1.0) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        int n4 = this.getTickSamplingTime();
        double d3 = this.getMaxTickValue();
        int n5 = this.secondLabels.isEmpty() ? 5 : (int)this.axisLabelWidth;
        for (d2 = this.getCrossValue() + (double)n4; d2 <= d3; d2 += (double)n4) {
            line2D = this.getTickLine(d2, n5, this.getTickMarkType());
            this.drawTickLine(graphics, line2D, basicStroke);
        }
        if (n4 <= 1) {
            for (d2 = this.getCrossValue() + this.getSecUnit(); d2 <= d3; d2 += this.getSecUnit()) {
                line2D = this.getTickLine(d2, 3, this.getSecTickMarkType());
                this.drawTickLine(graphics, line2D, basicStroke);
            }
        }
        boolean bl = this.isToNumber();
        double d4 = this.isDrawBetweenTick() ? 0.5 : 0.0;
        int n6 = n3 = this.getLabelNumber() > 0 ? this.getLabelNumber() : this.getLabelSamplingTime(n4, bl, 1, n2, d4) * n4;
        if (this.isLabelWrap && n3 == 1) {
            int n7 = this.categoryLabelList.size();
            for (int i2 = 0; i2 < n7; i2 += n3) {
                this.drawLabelWrapWhenNeed(graphics, i2, d4, this.getLabelString(i2, bl), n2);
            }
        } else {
            int n8 = this.categoryLabelList.size();
            for (int i3 = 0; i3 < n8; i3 += n3) {
                this.drawLabel(graphics, i3, d4, this.getLabelString(i3, bl), n2);
            }
        }
    }

    protected double getMaxTickValue() {
        double d2 = this.getMaxValue();
        if (!this.isDrawBetweenTick() && this.categoryLabelList != null && this.categoryLabelList.size() > 1) {
            d2 -= this.getMainUnit();
        }
        return d2;
    }

    @Override
    public double getCrossValue() {
        return this.getMinValue();
    }

    @Override
    public double getArrowValue() {
        return this.getMaxValue();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CategoryAxisGlyph && super.equals(object) && ComparatorUtils.equals((Object)((CategoryAxisGlyph)object).categoryLabelList, (Object)this.categoryLabelList);
    }

    @Override
    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        if (!this.categoryLabelList.isEmpty()) {
            jSONObject.put("categoryLabelList", this.categoryLabelList.toArray());
        }
        if (!this.secondLabels.isEmpty()) {
            jSONObject.put("secondLabels", this.secondLabels.toArray());
        }
        if (!this.thirdLabels.isEmpty()) {
            jSONObject.put("thirdLabels", this.thirdLabels.toArray());
        }
        if (this.timeSwitchMap != null && !this.timeSwitchMap.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (TimeSwitchAttr timeSwitchAttr : this.timeSwitchMap) {
                jSONArray.put(timeSwitchAttr.toJSONObject());
            }
            jSONObject.put("timeSwitchArray", jSONArray);
        }
        return jSONObject;
    }

    @Override
    public String getJSAxisType() {
        return "CategoryAxisGlyph";
    }

    @Override
    public String getAxisName() {
        return "CategoryAxis";
    }
}

