/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.FRContext;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.AttrBarSeries;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrLineSeries;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartCustomRendererType;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.AreaPlot;
import com.fr.chart.chartattr.Bar2DPlot;
import com.fr.chart.chartattr.Bar3DPlot;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.CategoryPlot;
import com.fr.chart.chartattr.ChartFactory;
import com.fr.chart.chartattr.ChartXMLCompatibleUtils;
import com.fr.chart.chartattr.LinePlot;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AreaPlotGlyph;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.Bar3DPlotGlyph;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.CustomAttr;
import com.fr.chart.chartglyph.CustomPlotGlyph;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.LinePlotGlyph;
import com.fr.chart.chartglyph.Marker;
import com.fr.chart.chartglyph.MarkerFactory;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.script.Calculator;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomPlot
extends CategoryPlot {
    private static final long serialVersionUID = 4202124515267193546L;
    private static final double DEFAULT_SEREIS_GAP = -0.15;
    private static final double MARKER_SIZE = 0.6;
    private static final String[] CUSTOM_SERIES = new String[]{"Rect", "Line"};
    private static final String[][] CUSTOM_VALUES = new String[][]{{"4", "7", "6", "8", "9.5", "9"}, {"5", "8", "7", "9", "9.7", "9.5"}};
    private Bar2DPlot bar2DPlot = new Bar2DPlot();
    private Bar2DPlot bar2DPlotStack = new Bar2DPlot(true);
    private Bar3DPlot bar3DPlot = new Bar3DPlot();
    private Bar3DPlot bar3DPlotStack = new Bar3DPlot(true);
    private LinePlot linePlot = new LinePlot();
    private AreaPlot areaPlotStack = new AreaPlot();
    private ConditionCollection customTypeCondition = new ConditionCollection();
    private transient double pointMaxMinValue;
    private transient double[] barStackMaxMinValue;
    private transient double areaStackMaxMinValue;
    private boolean isNeedCompatible = true;
    private ArrayList<Integer[]> stackedList;

    public CustomPlot() {
        this.setxAxis(new CategoryAxis(3));
        this.setyAxis(new ValueAxis(2));
        this.setSecondAxis(new ValueAxis(4));
        ConditionCollection conditionCollection = new ConditionCollection();
        conditionCollection.setDefaultAttr(new CustomAttr());
        this.setConditionCollection(conditionCollection);
    }

    @Override
    public boolean isSupportZoomCategoryAxis() {
        return true;
    }

    public void setBar2DPlot(Bar2DPlot bar2DPlot) {
        this.bar2DPlot = bar2DPlot;
    }

    public Bar2DPlot getBar2DPlot() {
        return this.bar2DPlot;
    }

    public void setBar2DPlotStack(Bar2DPlot bar2DPlot) {
        this.bar2DPlotStack = bar2DPlot;
    }

    public Bar2DPlot getBar2DPlotStack() {
        return this.bar2DPlotStack;
    }

    public void setLinePlot(LinePlot linePlot) {
        this.linePlot = linePlot;
    }

    public LinePlot getLinePlot() {
        return this.linePlot;
    }

    public void setAreaPlotStack(AreaPlot areaPlot) {
        this.areaPlotStack = areaPlot;
    }

    public AreaPlot getAreaPlotStack() {
        return this.areaPlotStack;
    }

    @Override
    public boolean isSupportDataLabelAttr() {
        return false;
    }

    @Override
    public String getPlotName() {
        String string = Inter.getLocText("ChartF-Comb_Chart");
        if (this.getDataSheet().isVisible() && this.getDataSheet().isVisible()) {
            string = Inter.getLocText(new String[]{"Data", "Table"}) + string;
        }
        return string;
    }

    @Override
    public String[] getAlertLinePaneTitle() {
        return new String[]{"Main_Value_Axis", "Second_Value_Axis"};
    }

    @Override
    public PlotGlyph createPlotGlyph(ChartData chartData) {
        this.calculateStackedList(chartData);
        CustomPlotGlyph customPlotGlyph = this.createCustomPlotGlyph();
        customPlotGlyph.setCustomTypeCondition(this.customTypeCondition);
        this.install4PlotGlyph(customPlotGlyph, chartData);
        this.installAxisGlyph(customPlotGlyph, chartData);
        return customPlotGlyph;
    }

    public CustomPlotGlyph createCustomPlotGlyph() {
        return new CustomPlotGlyph();
    }

    public ConditionCollection getCustomTypeCondition() {
        return this.customTypeCondition;
    }

    @Override
    public ConditionCollection getConditionCollection() {
        if (this.isNeedCompatible) {
            this.isNeedCompatible = false;
            ConditionCollection conditionCollection = super.getConditionCollection();
            ConditionCollection conditionCollection2 = new ConditionCollection();
            CustomAttr customAttr = (CustomAttr)conditionCollection.getDefaultAttr();
            CustomAttr customAttr2 = customAttr.createSimpleCustomAttr();
            CustomAttr customAttr3 = customAttr.createTypeConditionAttr();
            conditionCollection2.setDefaultAttr(customAttr2);
            this.customTypeCondition.setDefaultAttr(customAttr3);
            int n2 = conditionCollection.getConditionAttrSize();
            for (int i2 = 0; i2 < n2; ++i2) {
                CustomAttr customAttr4 = (CustomAttr)conditionCollection.getConditionAttr(i2);
                CustomAttr customAttr5 = customAttr4.createSimpleCustomAttr();
                CustomAttr customAttr6 = customAttr4.createTypeConditionAttr();
                if (customAttr5.getDataSeriesConditionCount() > 0) {
                    conditionCollection2.addConditionAttr(customAttr5);
                }
                this.customTypeCondition.addConditionAttr(customAttr6);
            }
            this.setConditionCollection(conditionCollection2);
        }
        return super.getConditionCollection();
    }

    @Override
    protected DataSeries createDataSeries(int n2) {
        CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getAttrBySeriesIndex(n2);
        if (ChartCustomRendererType.AREA_STACK == customAttr.getRenderer()) {
            return new DataSeries4Area(n2);
        }
        return new DataSeries(n2);
    }

    public void install4PlotGlyph(CustomPlotGlyph customPlotGlyph, ChartData chartData) {
        this.addCondition4EveryTypeInCustom(this.bar2DPlot, ChartCustomRendererType.BAR_RENDERER);
        this.addCondition4EveryTypeInCustom(this.bar2DPlotStack, ChartCustomRendererType.BAR_STACK);
        this.addCondition4EveryTypeInCustom(this.bar3DPlot, ChartCustomRendererType.BAR3D);
        this.addCondition4EveryTypeInCustom(this.bar3DPlotStack, ChartCustomRendererType.BAR3D_STACK);
        this.addCondition4EveryTypeInCustom(this.linePlot, ChartCustomRendererType.LINE_RENDERER);
        this.addCondition4EveryTypeInCustom(this.areaPlotStack, ChartCustomRendererType.AREA_STACK);
        this.initCustomShapeStatus(customPlotGlyph);
        super.install4PlotGlyph(customPlotGlyph, chartData);
        Bar2DPlotGlyph bar2DPlotGlyph = (Bar2DPlotGlyph)this.bar2DPlot.createPlotGlyph(chartData);
        bar2DPlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        bar2DPlotGlyph.setPlotStyle(this.getPlotStyle());
        customPlotGlyph.setBar2DPlotGlyph(bar2DPlotGlyph);
        Bar2DPlotGlyph bar2DPlotGlyph2 = (Bar2DPlotGlyph)this.bar2DPlotStack.createPlotGlyph(chartData);
        bar2DPlotGlyph2.setPlotFillStyle(this.getPlotFillStyle());
        bar2DPlotGlyph2.setSeriesOverlapPercent(1.0);
        bar2DPlotGlyph2.setPlotStyle(this.getPlotStyle());
        customPlotGlyph.setBar2DPlotGlyphStack(bar2DPlotGlyph2);
        Bar3DPlotGlyph bar3DPlotGlyph = (Bar3DPlotGlyph)this.bar3DPlot.createPlotGlyph(chartData);
        bar3DPlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        bar3DPlotGlyph.setPlotStyle(this.getPlotStyle());
        customPlotGlyph.setBar3DPlotGlyph(bar3DPlotGlyph);
        Bar3DPlotGlyph bar3DPlotGlyph2 = (Bar3DPlotGlyph)this.bar3DPlotStack.createPlotGlyph(chartData);
        bar3DPlotGlyph2.setPlotFillStyle(this.getPlotFillStyle());
        bar3DPlotGlyph2.setSeriesOverlapPercent(1.0);
        bar3DPlotGlyph2.setPlotStyle(this.getPlotStyle());
        customPlotGlyph.setBar3DPlotGlyphStack(bar3DPlotGlyph2);
        LinePlotGlyph linePlotGlyph = (LinePlotGlyph)this.linePlot.createPlotGlyph(chartData);
        linePlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        customPlotGlyph.setLinePlotGlyph(linePlotGlyph);
        AreaPlotGlyph areaPlotGlyph = (AreaPlotGlyph)this.areaPlotStack.createPlotGlyph(chartData);
        areaPlotGlyph.setPlotFillStyle(this.getPlotFillStyle());
        customPlotGlyph.setAreaPlotGlyphStack(areaPlotGlyph);
    }

    private void addCondition4EveryTypeInCustom(Plot plot, ChartCustomRendererType chartCustomRendererType) {
        ConditionAttr conditionAttr;
        int n2;
        ConditionCollection conditionCollection = this.getConditionCollection();
        ConditionCollection conditionCollection2 = plot.getConditionCollection();
        conditionCollection2.clearConditionAttr();
        try {
            for (int i2 = 0; i2 < conditionCollection.getConditionAttrSize(); ++i2) {
                conditionCollection2.addConditionAttr((CustomAttr)conditionCollection.getConditionAttr(i2).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
        }
        CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getDefaultAttr();
        if (customAttr.needTransformToNormalCondition() && ComparatorUtils.equals((Object)customAttr.getRenderer(), (Object)chartCustomRendererType)) {
            conditionCollection2.setDefaultAttr(customAttr.getNormalConditionAttr());
        }
        int n3 = this.customTypeCondition.getConditionAttrSize();
        for (n2 = 0; n2 < n3; ++n2) {
            conditionAttr = (CustomAttr)this.customTypeCondition.getConditionAttr(n2);
            if (!((CustomAttr)conditionAttr).needTransformToNormalCondition() || !ComparatorUtils.equals((Object)((CustomAttr)conditionAttr).getRenderer(), (Object)chartCustomRendererType)) continue;
            conditionCollection2.combineConditionAttr(((CustomAttr)conditionAttr).getNormalConditionAttr());
        }
        if (chartCustomRendererType == ChartCustomRendererType.LINE_RENDERER) {
            n3 = conditionCollection2.getConditionAttrSize();
            for (n2 = 0; n2 < n3; ++n2) {
                AttrBackground attrBackground;
                Background background;
                conditionAttr = conditionCollection2.getConditionAttr(n2);
                if (conditionAttr.getExisted(AttrBackground.class) == null || (background = (attrBackground = conditionAttr.getExisted(AttrBackground.class)).getSeriesBackground()) == null || !ComparatorUtils.equals(background.getBackgroundType(), "ColorBackground")) continue;
                Color color = ((ColorBackground)background).getColor();
                conditionAttr.addDataSeriesCondition(new AttrColor(color));
            }
        }
    }

    private void initCustomShapeStatus(CustomPlotGlyph customPlotGlyph) {
        CustomAttr customAttr;
        CustomAttr customAttr2;
        int n2;
        boolean bl = false;
        ConditionAttr[] conditionAttrArray = this.customTypeCondition.getAllConditionAttrList();
        int n3 = conditionAttrArray.length;
        for (n2 = 0; n2 < n3 && !bl; ++n2) {
            customAttr2 = (CustomAttr)conditionAttrArray[n2];
            bl = customAttr2.has3DShape();
        }
        customPlotGlyph.setHas3DShape(bl);
        if (bl) {
            n3 = conditionAttrArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                customAttr2 = (CustomAttr)conditionAttrArray[n2];
                customAttr2.changeTo3DRenderer();
            }
        }
        if ((customAttr = this.getFirstBarShapeAttr()) != null && customAttr.getExisted(AttrBarSeries.class) != null) {
            AttrBarSeries attrBarSeries = customAttr.getExisted(AttrBarSeries.class);
            customPlotGlyph.setCategoryIntervalPercent(attrBarSeries.getCategoryIntervalPercent());
            customPlotGlyph.setSeriesOverlapPercent(attrBarSeries.getSeriesOverlapPercent());
        }
    }

    private CustomAttr getFirstBarShapeAttr() {
        ConditionAttr[] conditionAttrArray = this.customTypeCondition.getAllConditionAttrList();
        CustomAttr customAttr = null;
        int n2 = conditionAttrArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CustomAttr customAttr2 = (CustomAttr)conditionAttrArray[i2];
            if (!customAttr2.is2DBarShapeRender()) continue;
            customAttr = customAttr2;
            break;
        }
        return customAttr;
    }

    private void installAxisGlyph(CustomPlotGlyph customPlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        customPlotGlyph.setxAxisGlyph(axisGlyph);
        axisGlyph.setAxisType("xAxis");
        axisGlyph.setDrawBetweenTick(true);
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        customPlotGlyph.setyAxisGlyph(axisGlyph2);
        axisGlyph2.setAxisType("yAxis");
        axisGlyph2.initMinMaxValue(this.getAxisMinValueFromData(chartData, ChartAxisPosition.AXIS_LEFT, axisGlyph2.isLog(), customPlotGlyph), this.getAxisMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT, customPlotGlyph));
        if (this.isUseSecondAxis()) {
            AxisGlyph axisGlyph3 = this.getSecondAxis().createAxisGlyph(chartData);
            customPlotGlyph.setSecondAxisGlyph(axisGlyph3);
            axisGlyph3.setAxisType("secondAxis");
            axisGlyph3.initMinMaxValue(this.getAxisMinValueFromData(chartData, ChartAxisPosition.AXIS_RIGHT, axisGlyph3.isLog(), customPlotGlyph), this.getAxisMaxValueFromData(chartData, ChartAxisPosition.AXIS_RIGHT, customPlotGlyph));
        }
        customPlotGlyph.axisExtendsMaxMinValueWithTrendLine(customPlotGlyph.getxAxisGlyph());
    }

    private void calculateStackedList(ChartData chartData) {
        if (chartData != null) {
            NormalChartData normalChartData = (NormalChartData)chartData;
            this.stackedList = new ArrayList();
            int n2 = normalChartData.getSeriesCount();
            int n3 = this.customTypeCondition.getConditionAttrSize();
            for (int i2 = 0; i2 < n3; ++i2) {
                CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getConditionAttr(i2);
                if (!customAttr.isStackedBarShape()) continue;
                this.stackedList.add(customAttr.getStackedSeriesList(n2));
            }
            CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getDefaultAttr();
            if (customAttr.isStackedBarShape()) {
                Integer[] integerArray = this.customTypeCondition.getUnUsedSeriesIndex(n2);
                this.stackedList.add(integerArray);
            }
        }
    }

    private int getStackedBarIndex(int n2) {
        for (int i2 = 0; i2 < this.stackedList.size(); ++i2) {
            Integer[] integerArray = this.stackedList.get(i2);
            for (int i3 = 0; i3 < integerArray.length; ++i3) {
                int n3 = integerArray[i3];
                if (n2 != n3) continue;
                return i2;
            }
        }
        return 0;
    }

    @Override
    public boolean isUseSecondAxis() {
        boolean bl = false;
        int n2 = this.customTypeCondition.getConditionAttrSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getConditionAttr(i2);
            if (customAttr == null || !ComparatorUtils.equals((Object)ChartAxisPosition.AXIS_RIGHT, (Object)customAttr.getAxisPosition())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean matchPlotType(Plot plot) {
        return plot instanceof CustomPlot;
    }

    private double getAxisMinValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition, boolean bl, RectanglePlotGlyph rectanglePlotGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        double d3 = 0.0;
        if (bl) {
            d2 = Double.MAX_VALUE;
            d3 = 1.0;
        }
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            this.resetValue(bl);
            for (int i3 = 0; i3 < normalChartData.getSeriesCount(); ++i3) {
                if (normalChartData.getValueAt(i3, i2) == null) continue;
                double d4 = normalChartData.getValueAt(i3, i2).doubleValue();
                DataSeries dataSeries = rectanglePlotGlyph.getSeries(i3);
                CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getAttrByResult(dataSeries);
                DataPoint dataPoint = rectanglePlotGlyph.getSeries(i3).getDataPoint(i2);
                if (!this.isInCategoryField(rectanglePlotGlyph.getxAxisGlyph(), dataPoint.getCategoryName())) continue;
                ChartAxisPosition chartAxisPosition2 = customAttr.getAxisPosition();
                if (!(d4 < d3) || !ComparatorUtils.equals((Object)chartAxisPosition2, (Object)chartAxisPosition)) continue;
                this.addValueInRender(customAttr.getRenderer(), false, d4, i3);
                d2 = bl && d4 < d3 && d2 > d4 ? d4 : d2;
            }
            if (bl) continue;
            double d5 = this.getMaxOrMinFromArray(this.barStackMaxMinValue, false);
            d2 = Math.min(d2, Math.min(d5, Math.min(this.areaStackMaxMinValue, this.pointMaxMinValue)));
        }
        if (d2 == Double.MAX_VALUE) {
            return 1.0;
        }
        return d2;
    }

    private double getAxisMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition, RectanglePlotGlyph rectanglePlotGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d2 = 0.0;
        for (int i2 = 0; i2 < normalChartData.getCategoryLabelCount(); ++i2) {
            this.resetValue(false);
            for (int i3 = 0; i3 < normalChartData.getSeriesCount(); ++i3) {
                if (normalChartData.getValueAt(i3, i2) == null) continue;
                double d3 = normalChartData.getValueAt(i3, i2).doubleValue();
                DataSeries dataSeries = rectanglePlotGlyph.getSeries(i3);
                CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getAttrByResult(dataSeries);
                DataPoint dataPoint = rectanglePlotGlyph.getSeries(i3).getDataPoint(i2);
                if (!this.isInCategoryField(rectanglePlotGlyph.getxAxisGlyph(), dataPoint.getCategoryName())) continue;
                ChartAxisPosition chartAxisPosition2 = customAttr.getAxisPosition();
                if (!(d3 >= 0.0) || !ComparatorUtils.equals((Object)chartAxisPosition2, (Object)chartAxisPosition)) continue;
                this.addValueInRender(customAttr.getRenderer(), true, d3, i3);
            }
            double d4 = this.getMaxOrMinFromArray(this.barStackMaxMinValue, true);
            d2 = Math.max(d2, Math.max(d4, Math.max(this.areaStackMaxMinValue, this.pointMaxMinValue)));
        }
        if (d2 == this.getAxisMinValueFromData(normalChartData, chartAxisPosition, false, rectanglePlotGlyph)) {
            return d2 + 10.0;
        }
        return d2;
    }

    double getMaxOrMinFromArray(double[] dArray, boolean bl) {
        if (dArray.length == 0) {
            return 0.0;
        }
        double d2 = bl ? Double.MIN_VALUE : Double.MAX_VALUE;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 = bl ? Math.max(d2, dArray[i2]) : Math.min(d2, dArray[i2]);
        }
        return d2;
    }

    private void addValueInRender(ChartCustomRendererType chartCustomRendererType, boolean bl, double d2, int n2) {
        if (chartCustomRendererType == ChartCustomRendererType.BAR_STACK || chartCustomRendererType == ChartCustomRendererType.BAR3D_STACK) {
            int n3;
            int n4 = n3 = this.getStackedBarIndex(n2);
            this.barStackMaxMinValue[n4] = this.barStackMaxMinValue[n4] + d2;
        } else if (chartCustomRendererType == ChartCustomRendererType.AREA_STACK) {
            this.areaStackMaxMinValue += d2;
        } else {
            this.pointMaxMinValue = bl ? Math.max(this.pointMaxMinValue, d2) : Math.min(this.pointMaxMinValue, d2);
        }
    }

    private void resetValue(boolean bl) {
        this.pointMaxMinValue = 0.0;
        this.barStackMaxMinValue = new double[this.stackedList.size()];
        this.areaStackMaxMinValue = 0.0;
        if (bl) {
            this.pointMaxMinValue = 1.0;
        }
    }

    @Override
    protected LineMarkerIcon getLegendMarkerIcon(DataSeries dataSeries, Color[] colorArray) {
        LineMarkerIcon lineMarkerIcon = new LineMarkerIcon();
        CustomAttr customAttr = (CustomAttr)this.customTypeCondition.getAttrByResult(dataSeries);
        if (customAttr.getRenderer() == ChartCustomRendererType.LINE_RENDERER || customAttr.getRenderer() == ChartCustomRendererType.AREA_RENDERER) {
            AttrBackground attrBackground = (AttrBackground)this.getConditionCollection().getDataSeriesCondition(AttrBackground.class, dataSeries, colorArray);
            AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataSeries, colorArray);
            AttrLineStyle attrLineStyle = (AttrLineStyle)this.customTypeCondition.getDataSeriesCondition(AttrLineStyle.class, dataSeries, colorArray);
            lineMarkerIcon.setLineStyle(attrLineStyle.getLineStyle());
            lineMarkerIcon.setBackground(attrBackground.getSeriesBackground());
            lineMarkerIcon.setAlpha(attrAlpha.getAlpha());
            AttrLineSeries attrLineSeries = (AttrLineSeries)this.customTypeCondition.getDataSeriesCondition(AttrLineSeries.class, dataSeries, colorArray);
            Marker marker = MarkerFactory.createMarker(attrLineSeries.getMarkerType());
            marker.setSize(marker.getSize() * 0.6);
            marker.setBackground(attrBackground.getSeriesBackground());
            lineMarkerIcon.setMarker(marker);
        } else {
            this.dealCondition(lineMarkerIcon, dataSeries, colorArray);
        }
        return lineMarkerIcon;
    }

    @Override
    public void clearConditionAttrAndRenewLegend(Plot plot) {
        super.clearConditionAttrAndRenewLegend(plot);
        ChartFactory.createSeriesMap4CustomPlot(this);
    }

    @Override
    public ChartData defaultChartData() {
        CategoryAxis categoryAxis = (CategoryAxis)this.getxAxis();
        return categoryAxis.isDate() ? new NormalChartData(ChartUtils.LONG_CATEGORY_DATE, CUSTOM_SERIES, CUSTOM_VALUES) : new NormalChartData(ChartUtils.LONG_CATEGORY_STRING, CUSTOM_SERIES, CUSTOM_VALUES);
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            this.comXML(xMLableReader);
        }
    }

    private void comXML(XMLableReader xMLableReader) {
        String string = xMLableReader.getTagName();
        if (ComparatorUtils.equals(string, "CustomLine")) {
            xMLableReader.readXMLObject(new LinePlot());
        } else if (ComparatorUtils.equals(string, "CustomAreaStack")) {
            xMLableReader.readXMLObject(new AreaPlot());
        } else if (ComparatorUtils.equals(string, "CustomBar")) {
            xMLableReader.readXMLObject(new Bar2DPlot());
        } else if (ComparatorUtils.equals(string, "CustomBarStack")) {
            xMLableReader.readXMLObject(new Bar2DPlot());
        } else if (ComparatorUtils.equals(string, "CustomLineStack")) {
            xMLableReader.readXMLObject(new AreaPlot());
        } else if (ComparatorUtils.equals(string, "CustomArea")) {
            xMLableReader.readXMLObject(new LinePlot());
        } else if (ComparatorUtils.equals(string, "Attr")) {
            if (!xMLableReader.getAttrAsBoolean("isShowLine", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
            }
            if (!xMLableReader.getAttrAsBoolean("isShowMarker", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
            }
            this.getLinePlot().setNullValueBreak(xMLableReader.getAttrAsBoolean("isLineNullValueBreak", true));
            this.getBar2DPlot().setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("categoryIntervalPercent", 1.0));
            this.getBar2DPlot().setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("seriesOverlapPercent", -0.15));
            this.getBar2DPlot().setSimulation3D(xMLableReader.getAttrAsBoolean("isSimulation3D", true));
            if (!xMLableReader.getAttrAsBoolean("isShowLine_stack", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), true);
            }
            if (!xMLableReader.getAttrAsBoolean("isShowMarker_stack", true)) {
                ChartXMLCompatibleUtils.changeAttrNone(this.getConditionCollection(), false);
            }
            this.getBar2DPlotStack().setSimulation3D(xMLableReader.getAttrAsBoolean("isSimulation3D_stack", true));
            this.getBar2DPlotStack().setCategoryIntervalPercent(xMLableReader.getAttrAsDouble("categoryIntervalPercent_stack", 1.0));
            this.getBar2DPlotStack().setSeriesOverlapPercent(xMLableReader.getAttrAsDouble("seriesOverlapPercent_stack", 1.0));
            this.getAreaPlotStack().setCurve(xMLableReader.getAttrAsBoolean("isCurveAreaStack", false));
            this.getLinePlot().setCurve(xMLableReader.getAttrAsBoolean("isCurveLine", false));
        } else if (ComparatorUtils.equals("CustomTypeConditionCollection", string)) {
            this.customTypeCondition = (ConditionCollection)xMLableReader.readXMLObject(new ConditionCollection());
            this.isNeedCompatible = false;
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CategoryPlot");
        super.writeXML(xMLPrintWriter);
        if (this.customTypeCondition != null) {
            xMLPrintWriter.startTAG("CustomTypeConditionCollection");
            this.customTypeCondition.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof CustomPlot && ComparatorUtils.equals(((CustomPlot)object).customTypeCondition, this.customTypeCondition) && super.equals(object);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CustomPlot customPlot = (CustomPlot)super.clone();
        if (this.linePlot != null) {
            customPlot.linePlot = (LinePlot)this.linePlot.clone();
        }
        if (this.areaPlotStack != null) {
            customPlot.areaPlotStack = (AreaPlot)this.areaPlotStack.clone();
        }
        if (this.bar2DPlot != null) {
            customPlot.bar2DPlot = (Bar2DPlot)this.bar2DPlot.clone();
        }
        if (this.bar2DPlotStack != null) {
            customPlot.bar2DPlotStack = (Bar2DPlot)this.bar2DPlotStack.clone();
        }
        if (this.bar3DPlot != null) {
            customPlot.bar3DPlot = (Bar3DPlot)this.bar3DPlot.clone();
        }
        if (this.bar3DPlotStack != null) {
            customPlot.bar3DPlotStack = (Bar3DPlot)this.bar3DPlotStack.clone();
        }
        if (this.customTypeCondition != null) {
            customPlot.customTypeCondition = (ConditionCollection)this.customTypeCondition.clone();
        }
        return customPlot;
    }

    @Override
    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/custom/0";
    }

    @Override
    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.COMB;
    }

    @Override
    public int getDetailType() {
        return 0;
    }

    @Override
    protected boolean isSupportAxisLabelWrapShow() {
        return true;
    }

    @Override
    public boolean isSupportTooltipSeriesType() {
        return true;
    }

    @Override
    public boolean isSupportAxisReverse() {
        return false;
    }

    @Override
    public void dependence(CalculatorProvider calculatorProvider, List<String> list) {
        super.dependence(calculatorProvider, list);
        if (this.customTypeCondition != null) {
            this.customTypeCondition.dependence(calculatorProvider, list);
        }
    }

    @Override
    public void dealFormula(Calculator calculator) {
        super.dealFormula(calculator);
        if (this.customTypeCondition != null) {
            this.customTypeCondition.dealFormula(calculator);
        }
    }

    @Override
    public void buidExecuteSequenceList(List list, Calculator calculator) {
        super.buidExecuteSequenceList(list, calculator);
        if (this.customTypeCondition != null) {
            this.customTypeCondition.buidExecuteSequenceList(list, calculator);
        }
    }

    @Override
    public void modFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        super.modFormulaString(mOD_COLUMN_ROW);
        if (this.customTypeCondition != null) {
            this.customTypeCondition.modFormulaString(mOD_COLUMN_ROW);
        }
    }

    @Override
    public boolean accept(Class<? extends Plot> clazz) {
        return ComparatorUtils.equals(CustomPlot.class, clazz);
    }

    @Override
    public String getPlotID() {
        return "FineReportCustomChart";
    }

    @Override
    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.CUSTOM_CHART;
    }
}

