/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.BaseUtils;
import com.fr.base.CoreDecimalFormat;
import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.GraphHelper;
import com.fr.base.Painter;
import com.fr.base.Utils;
import com.fr.base.background.ImageBackground;
import com.fr.data.DataUtils;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRFont;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.unit.PT;
import com.fr.stable.web.Repository;
import com.fr.stable.web.ServletContext;
import com.fr.stable.web.ServletContextAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.sql.Clob;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Style
implements Serializable,
Cloneable {
    private static Rectangle2D tempRectangle2D = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    public static final int TEXTSTYLE_WRAPTEXT = 0;
    public static final int TEXTSTYLE_SINGLELINE = 1;
    public static final int TEXTSTYLE_SINGLELINEADJUSTFONT = 2;
    public static final int TEXTSTYLE_MULTILINEADJUSTFONT = 3;
    public static final int VERTICALTEXT = 1;
    public static final int HORIZONTALTEXT = 0;
    public static final int LEFT_TO_RIGHT = 1;
    public static final int RIGHT_TO_LEFT = 0;
    public static final int PADDING_ARG = 27;
    public static final int DEFAULT_PADDING = 2;
    public static final Style NULL_STYLE = null;
    public static Style DEFAULT_STYLE = new Style();
    public static Style BORDER_STYLE = new Style();
    private static final long serialVersionUID = -1675056857456167839L;
    private static final int MAX_FONT_SIZE = 100;
    private static final int N_SIZE = 9;
    private static final int MIN_SIZE = 8;
    private static final int MAX_SIZE = 26;
    private static final int STYLE_NO = 2;
    private static final int INDEX = 4;
    private static final int LINE_HEIGHT_FIX = 4;
    private static final int LINE_HEIGHT_FIX2 = 3;
    private static Map clsFontFamily = null;
    private static Map initializeStyle = new ConcurrentHashMap();
    private Format format = null;
    private FRFont frFont = null;
    private Background background = null;
    private byte border_top = 0;
    private byte border_left = 0;
    private byte border_bottom = 0;
    private byte border_right = 0;
    private Color border_top_color = Color.BLACK;
    private Color border_left_color = Color.BLACK;
    private Color border_bottom_color = Color.BLACK;
    private Color border_right_color = Color.BLACK;
    private int horizontal_alignment = -1;
    private int vertical_alignment = 0;
    private int textStyle = 0;
    private int verticalText = 0;
    private int textDirection = 0;
    private int rotation = 0;
    private byte imageLayout = 1;
    private int paddingLeft = 2;
    private int paddingRight = 2;
    private byte spacingBefore = 0;
    private byte spacingAfter = 0;
    private byte lineSpacing = 0;
    private String contentClsCss = "";
    private Map contentStyleCssMap = new HashMap();
    private String borderClsCss = "";
    private Map borderStyleCssMap = new HashMap();
    private transient int hashCode = -1;

    protected Style() {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        this.frFont = defaultValues.getFRFont();
        this.contentClsCss = this.contentStyle2class(this.contentStyleCssMap);
        this.borderClsCss = this.border2Class(this.borderStyleCssMap);
    }

    private Style(Background background, Format format, FRFont fRFont, int n2, Color color, int n3, Color color2, int n4, Color color3, int n5, Color color4, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        this.background = background;
        this.format = format;
        this.frFont = fRFont;
        this.border_top = (byte)n2;
        this.border_top_color = color;
        this.border_bottom = (byte)n3;
        this.border_bottom_color = color2;
        this.border_left = (byte)n4;
        this.border_left_color = color3;
        this.border_right = (byte)n5;
        this.border_right_color = color4;
        this.horizontal_alignment = (byte)n6;
        this.vertical_alignment = (byte)n7;
        this.textStyle = (byte)n8;
        this.verticalText = (byte)n9;
        this.textDirection = (byte)n10;
        this.rotation = (short)n11;
        this.imageLayout = (byte)n12;
        this.paddingLeft = n13;
        this.paddingRight = n14;
        this.spacingBefore = (byte)n15;
        this.spacingAfter = (byte)n16;
        this.lineSpacing = (byte)n17;
        this.contentClsCss = this.contentStyle2class(this.contentStyleCssMap);
        this.borderClsCss = this.border2Class(this.borderStyleCssMap);
    }

    private static Map getclsFontFamily() {
        if (clsFontFamily == null) {
            clsFontFamily = new HashMap(){
                {
                    this.put("Arial Black", "fnab");
                    this.put("Basic Sans SF", "fnbs");
                    this.put("Book Antiqua", "fnba");
                    this.put("Calibri", "fnci");
                    this.put("Comic Sans MS", "fncs");
                    this.put("Courier New", "fncn");
                    this.put("Elementary SF", "fnes");
                    this.put("Garamond", "fngd");
                    this.put("Georgia", "fnga");
                    this.put("Letter Gothic", "fnlg");
                    this.put("Lucida Console", "fnlc");
                    this.put("Marigold", "fnmd");
                    this.put("MS Sans Serif", "fnms");
                    this.put("MS Gothic", "fnmg");
                    this.put("MS PGothic", "fnmpg");
                    this.put("MS Mincho", "fnmm");
                    this.put("MS P Mincho", "fnmpm");
                    this.put("MingLiU", "fnml");
                    this.put("SimHei", "fnsh");
                    this.put("System", "fnsm");
                    this.put("Tahoma", "fnta");
                    this.put("Times New Roman", "fntn");
                    this.put("Trebuchet MS", "fntms");
                    this.put("Verdana", "fnva");
                    this.put("SimSun", "fnss");
                    this.put("Arial", "fnar");
                    this.put("Microsoft YaHei", "fnyh");
                    this.put("KaiTi", "fnkt");
                }
            };
        }
        return clsFontFamily;
    }

    public Style deriveFormat(Format format) {
        return Style.getInstance(this.background, format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public static Style getInstance(Format format) {
        return DEFAULT_STYLE.deriveFormat(format);
    }

    public Style deriveFRFont(FRFont fRFont) {
        return Style.getInstance(this.background, this.format, fRFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    private static void initStyle() {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        DEFAULT_STYLE = DEFAULT_STYLE.deriveFRFont(defaultValues.getFRFont());
    }

    private static void initValue() {
        DefaultValues defaultValues = FRContext.getDefaultValues();
        BORDER_STYLE = BORDER_STYLE.deriveFRFont(defaultValues.getFRFont());
        BORDER_STYLE = BORDER_STYLE.deriveBorder(1, Color.black, 1, Color.black, 1, Color.black, 1, Color.black);
    }

    public static Style getInstance() {
        Style style = new Style();
        Object v2 = initializeStyle.get(style);
        if (v2 != null) {
            return (Style)v2;
        }
        initializeStyle.put(style, style);
        return style;
    }

    private static Style getInstance(Background background, Format format, FRFont fRFont, int n2, Color color, int n3, Color color2, int n4, Color color3, int n5, Color color4, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        Style style = new Style(background, format, fRFont, n2, color, n3, color2, n4, color3, n5, color4, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
        Object v2 = initializeStyle.get(style);
        if (v2 != null) {
            return (Style)v2;
        }
        initializeStyle.put(style, style);
        return style;
    }

    public static Style getInstance(FRFont fRFont) {
        if (fRFont == null) {
            return Style.getInstance();
        }
        return DEFAULT_STYLE.deriveFRFont(fRFont);
    }

    public Style deriveBackground(Background background) {
        if (background instanceof ImageBackground) {
            return new Style(background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
        }
        return Style.getInstance(background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public static Style getInstance(Background background) {
        return DEFAULT_STYLE.deriveBackground(background);
    }

    public Style deriveBorderBackgroundNone() {
        return Style.getInstance(null, this.format, this.frFont, 0, this.border_top_color, 0, this.border_bottom_color, 0, this.border_left_color, 0, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorder(int n2, Color color, int n3, Color color2, int n4, Color color3, int n5, Color color4) {
        return Style.getInstance(this.background, this.format, this.frFont, n2, color, n3, color2, n4, color3, n5, color4, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderTop(int n2, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, n2, color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderBottom(int n2, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, n2, color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderLeft(int n2, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, n2, color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveBorderRight(int n2, Color color) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, n2, color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveHorizontalAlignment(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, n2, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveVerticalAlignment(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, n2, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveTextStyle(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, n2, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveTextDirection(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, n2, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveVerticalText(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, n2, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveRotation(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, n2, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveImageLayout(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, n2, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style derivePadding(int n2, int n3) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, n2, n3, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style derivePaddingLeft(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, n2, this.paddingRight, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style derivePaddingRight(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, n2, this.spacingBefore, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveSpacingBefore(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, n2, this.spacingAfter, this.lineSpacing);
    }

    public Style deriveSpacingAfter(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, n2, this.lineSpacing);
    }

    public Style deriveLineSpacing(int n2) {
        return Style.getInstance(this.background, this.format, this.frFont, this.border_top, this.border_top_color, this.border_bottom, this.border_bottom_color, this.border_left, this.border_left_color, this.border_right, this.border_right_color, this.horizontal_alignment, this.vertical_alignment, this.textStyle, this.verticalText, this.textDirection, this.rotation, this.imageLayout, this.paddingLeft, this.paddingRight, this.spacingBefore, this.spacingAfter, n2);
    }

    public JSONObject toJSONObject(Repository repository, Dimension dimension) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.background != null) {
            jSONObject.put("background", this.background.toJSONObject(repository, dimension));
        }
        if (this.frFont != null && !ComparatorUtils.equals(this.frFont, FRContext.getDefaultValues().getFRFont())) {
            jSONObject.put("font", this.frFont.toJSONObject(repository));
        }
        if (!this.checkLeftRightTopBottom4b0()) {
            jSONObject.put("border", this.border2JSONObject());
            jSONObject.put("borderCss", this.borderClsCss);
        }
        this.createAlignAndTextStyleConfig(jSONObject);
        if (this.rotation != 0) {
            jSONObject.put("ro", this.rotation);
        }
        if (this.imageLayout != 1) {
            jSONObject.put("il", this.imageLayout);
        }
        this.createSpacingAndPaddingConfig(jSONObject);
        return jSONObject;
    }

    private void createAlignAndTextStyleConfig(JSONObject jSONObject) throws JSONException {
        if (this.horizontal_alignment != -1) {
            jSONObject.put("ha", this.horizontal_alignment);
        }
        if (this.vertical_alignment != 0) {
            jSONObject.put("va", this.vertical_alignment);
        }
        if (this.textStyle != 0) {
            jSONObject.put("ts", this.textStyle);
        }
        if (this.verticalText != 0) {
            jSONObject.put("vt", this.verticalText);
        }
        if (this.textDirection != 0) {
            jSONObject.put("td", this.textDirection);
        }
        jSONObject.put("contentCss", this.contentClsCss);
    }

    private void createSpacingAndPaddingConfig(JSONObject jSONObject) throws JSONException {
        if (this.paddingLeft != 2) {
            jSONObject.put("pl", this.paddingLeft);
        }
        if (this.paddingRight != 2) {
            jSONObject.put("pr", this.paddingRight);
        }
        if (this.spacingBefore != 0) {
            jSONObject.put("sb", this.spacingBefore);
        }
        if (this.spacingAfter != 0) {
            jSONObject.put("sa", this.spacingAfter);
        }
        if (this.lineSpacing != 0) {
            jSONObject.put("ls", this.lineSpacing);
        }
    }

    public FRFont getFRFont() {
        if (this.frFont == null) {
            this.frFont = FRContext.getDefaultValues().getFRFont();
        }
        return this.frFont;
    }

    public Format getFormat() {
        return this.format;
    }

    public Background getBackground() {
        return this.background;
    }

    public int getBorderTop() {
        return this.border_top;
    }

    public int getBorderTopWidth() {
        return GraphHelper.getLineStyleSize(this.getBorderTop());
    }

    public int getBorderLeft() {
        return this.border_left;
    }

    public int getBorderLeftWidth() {
        return GraphHelper.getLineStyleSize(this.getBorderLeft());
    }

    public int getBorderRightWidth() {
        return GraphHelper.getLineStyleSize(this.getBorderRight());
    }

    public int getBorderBottomWidth() {
        return GraphHelper.getLineStyleSize(this.getBorderBottom());
    }

    public int getBorderBottom() {
        return this.border_bottom;
    }

    public int getBorderRight() {
        return this.border_right;
    }

    public Color getBorderTopColor() {
        return this.border_top_color;
    }

    public Color getBorderLeftColor() {
        return this.border_left_color;
    }

    public Color getBorderBottomColor() {
        return this.border_bottom_color;
    }

    public Color getBorderRightColor() {
        return this.border_right_color;
    }

    public int getHorizontalAlignment() {
        return this.horizontal_alignment;
    }

    public int getVerticalAlignment() {
        return this.vertical_alignment;
    }

    public int getTextStyle() {
        return this.textStyle;
    }

    public int getVerticalText() {
        return this.verticalText;
    }

    public int getTextDirection() {
        return this.textDirection;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getImageLayout() {
        return this.imageLayout;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public byte getSpacingBefore() {
        return this.spacingBefore;
    }

    public byte getSpacingAfter() {
        return this.spacingAfter;
    }

    public byte getLineSpacing() {
        return this.lineSpacing;
    }

    public String getContentClsCss() {
        return this.contentClsCss;
    }

    public String getContentClsCss(Object object) {
        return this.contentStyle2class(this.contentStyleCssMap, object);
    }

    public Map getContentStyleCssMap() {
        return this.contentStyleCssMap;
    }

    public String getBorderClsCss() {
        return this.borderClsCss;
    }

    public Map getBorderStyleCssMap() {
        return this.borderStyleCssMap;
    }

    private String contentStyle2class(Map map) {
        return this.contentStyle2class(map, null);
    }

    protected String contentStyle2class(Map map, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("fh");
        int n2 = BaseUtils.getAlignment4Horizontal(this, object);
        switch (n2) {
            case 0: {
                stringBuffer.append(" tac");
                break;
            }
            case 4: {
                stringBuffer.append(" tar");
            }
        }
        switch (this.vertical_alignment) {
            case 3: {
                stringBuffer.append(" vab");
                break;
            }
            case 1: {
                stringBuffer.append(" vat");
            }
        }
        if (this.textStyle != 0 && this.textStyle != 3) {
            stringBuffer.append(" nw");
        } else {
            stringBuffer.append(" bw");
        }
        FRFont fRFont = this.getFRFont();
        if (fRFont != null) {
            stringBuffer.append(Style.font2Class(fRFont, map, this.lineSpacing));
        }
        int n3 = this.paddingLeft;
        int n4 = this.paddingRight;
        if (n3 <= 2) {
            stringBuffer.append(" pl" + n3);
        } else {
            map.put("padding-left", n3 + "pt");
        }
        if (n4 < 2) {
            stringBuffer.append(" pr" + n4);
        } else if (n4 > 2) {
            map.put("padding-right", n4 + "pt");
        }
        return stringBuffer.toString().trim();
    }

    public JSONObject border2JSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.checkLeftRightTopBottom4b1()) {
            jSONObject.put("b1", true);
        } else {
            this.border2JSONObject(jSONObject, this.border_top, this.border_top_color, "t");
            this.border2JSONObject(jSONObject, this.border_left, this.border_left_color, "l");
            this.border2JSONObject(jSONObject, this.border_bottom, this.border_bottom_color, "b");
            this.border2JSONObject(jSONObject, this.border_right, this.border_right_color, "r");
        }
        return jSONObject;
    }

    private void border2JSONObject(JSONObject jSONObject, byte by, Color color, String string) throws JSONException {
        if (by == 1 && ComparatorUtils.equals(color, Color.black)) {
            jSONObject.put(string, new JSONObject().put("w", 1));
        } else {
            int n2 = BaseUtils.getBorderWidth(by);
            if (n2 > 0) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("w", n2);
                if (!ComparatorUtils.equals(color, Color.black)) {
                    jSONObject2.put("c", StableUtils.javaColorToCSSColor(color));
                }
                jSONObject2.put("s", this.borderLine2String(by));
                jSONObject.put(string, jSONObject2);
            }
        }
    }

    private String borderLine2String(int n2) {
        switch (n2) {
            case 1: {
                return "t";
            }
            case 2: {
                return "m";
            }
            case 5: {
                return "tk";
            }
            case 6: {
                return "de";
            }
            case 7: {
                return "dt";
            }
            case 9: {
                return "dadt";
            }
            case 11: {
                return "ddd";
            }
        }
        return "dash";
    }

    private String border2Class(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.checkLeftRightTopBottom4b0()) {
            stringBuffer.append(" b0");
            return stringBuffer.toString().trim();
        }
        if (this.checkLeftRightTopBottom4b1()) {
            stringBuffer.append(" b1");
            return stringBuffer.toString().trim();
        }
        Style.visible_border_css(this.border_right, this.border_right_color, stringBuffer, map, "r");
        Style.visible_border_css(this.border_bottom, this.border_bottom_color, stringBuffer, map, "b");
        Style.visible_border_css(this.border_left, this.border_left_color, stringBuffer, map, "l");
        Style.visible_border_css(this.border_top, this.border_top_color, stringBuffer, map, "t");
        return stringBuffer.toString().trim();
    }

    private boolean checkLeftRightTopBottom4b0() {
        return this.border_left == 0 && this.border_right == 0 && this.border_top == 0 && this.border_bottom == 0;
    }

    private boolean checkLeftRightTopBottom4b1() {
        return this.border_left == 1 && this.border_right == 1 && this.border_top == 1 && this.border_bottom == 1 && ComparatorUtils.equals(this.border_left_color, Color.black) && ComparatorUtils.equals(this.border_right_color, Color.black) && ComparatorUtils.equals(this.border_top_color, Color.black) && ComparatorUtils.equals(this.border_bottom_color, Color.black);
    }

    private static void visible_border_css(byte by, Color color, StringBuffer stringBuffer, Map map, String string) {
        int n2;
        if (by == 1 && ComparatorUtils.equals(color, Color.black)) {
            stringBuffer.append(" b" + string + "1");
        }
        if ((n2 = BaseUtils.getBorderWidth(by)) > 0) {
            stringBuffer.append(" b" + string + "w" + n2);
            stringBuffer.append(" " + Style.__border2Class(by, string));
            if (ComparatorUtils.equals(color, Color.black)) {
                stringBuffer.append(" b" + string + "cb");
            } else {
                map.put(Style._position2Colorcss(string), StableUtils.javaColorToCSSColor(color));
            }
        } else {
            stringBuffer.append(" b" + string + "0");
        }
    }

    private static String _position2Colorcss(String string) {
        if (ComparatorUtils.equals(string, "r")) {
            return "border-right-color";
        }
        if (ComparatorUtils.equals(string, "b")) {
            return "border-bottom-color";
        }
        if (ComparatorUtils.equals(string, "l")) {
            return "border-left-color";
        }
        if (ComparatorUtils.equals(string, "t")) {
            return "border-top-color";
        }
        return "border-color";
    }

    private static String __border2Class(int n2, String string) {
        switch (n2) {
            case 1: {
                return "b" + string + "ss";
            }
            case 2: {
                return "b" + string + "ss";
            }
            case 5: {
                return "b" + string + "ss";
            }
            case 6: {
                return "b" + string + "sd";
            }
            case 7: {
                return "b" + string + "sdo";
            }
            case 9: {
                return "b" + string + "sdo";
            }
            case 11: {
                return "b" + string + "sdo";
            }
        }
        return "b" + string + "sda";
    }

    private static String font2Class(Font font, Map map, byte by) {
        StringBuffer stringBuffer = new StringBuffer();
        if (font.isBold()) {
            stringBuffer.append(" fwb");
        }
        if (font.isItalic()) {
            stringBuffer.append(" fsi");
        }
        String string = font.getName();
        String string2 = (String)Style.getclsFontFamily().get(string);
        if (string2 == null) {
            map.put("font-family", string);
        } else if (!ComparatorUtils.equals(string2, "fnss")) {
            stringBuffer.append(" " + string2);
        }
        float f2 = font.getSize2D();
        if (f2 != 9.0f) {
            if (f2 >= 8.0f && f2 <= 26.0f) {
                f2 = Utils.round5(f2);
                stringBuffer.append(" f" + String.valueOf(f2).replace('.', '-'));
            } else {
                map.put("font-size", font.getSize2D() + "pt");
            }
        }
        if (by != 0) {
            FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
            map.put("line-height", (fontMetrics.getHeight() + by) * 4 / 3 + "px");
        }
        Style.font2ClassOnFRFont(font, map, stringBuffer);
        return stringBuffer.toString();
    }

    private static void font2ClassOnFRFont(Font font, Map map, StringBuffer stringBuffer) {
        if (font instanceof FRFont) {
            Color color;
            if (((FRFont)font).isStrikethrough()) {
                if (((FRFont)font).getUnderline() != 0) {
                    stringBuffer.append(" tdstu");
                } else {
                    stringBuffer.append(" tdst");
                }
            } else if (((FRFont)font).getUnderline() != 0) {
                stringBuffer.append(" tdu");
            }
            if (((FRFont)font).isSubscript()) {
                stringBuffer.append(" suber");
            } else if (((FRFont)font).isSuperscript()) {
                stringBuffer.append(" super");
            }
            if (((FRFont)font).isShadow()) {
                stringBuffer.append(" shadow");
            }
            if (!ComparatorUtils.equals(color = ((FRFont)font).getForeground(), Color.black) && color != null) {
                map.put("color", StableUtils.javaColorToCSSColor(color));
            }
        }
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int n2 = this.border_top ^ this.border_bottom ^ this.border_left ^ this.border_right ^ this.border_top_color.hashCode() ^ this.border_bottom_color.hashCode() ^ this.border_left_color.hashCode() ^ this.border_right_color.hashCode() ^ this.horizontal_alignment ^ this.imageLayout ^ this.verticalText ^ this.paddingLeft ^ this.paddingRight ^ this.rotation ^ this.textDirection ^ this.textStyle ^ this.vertical_alignment;
            if (this.frFont != null) {
                n2 ^= this.frFont.hashCode();
            }
            if (this.background != null) {
                n2 = this.background.fixHashCode(n2);
            }
            this.hashCode = n2;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Style)) {
            return false;
        }
        Style style = (Style)object;
        return ComparatorUtils.equals(style.getFormat(), this.getFormat()) && ComparatorUtils.equals(style.getFRFont(), this.getFRFont()) && ComparatorUtils.equals(style.getBackground(), this.getBackground()) && style.getBorderTop() == this.getBorderTop() && style.getBorderLeft() == this.getBorderLeft() && style.getBorderBottom() == this.getBorderBottom() && style.getBorderRight() == this.getBorderRight() && ComparatorUtils.equals(style.getBorderTopColor(), this.getBorderTopColor()) && ComparatorUtils.equals(style.getBorderLeftColor(), this.getBorderLeftColor()) && ComparatorUtils.equals(style.getBorderBottomColor(), this.getBorderBottomColor()) && ComparatorUtils.equals(style.getBorderRightColor(), this.getBorderRightColor()) && BaseUtils.getAlignment4Horizontal(style) == BaseUtils.getAlignment4Horizontal(this) && style.getVerticalAlignment() == this.getVerticalAlignment() && style.getTextStyle() == this.getTextStyle() && style.getVerticalText() == this.getVerticalText() && style.getTextDirection() == this.getTextDirection() && style.getRotation() == this.getRotation() && style.getImageLayout() == this.getImageLayout() && style.getPaddingLeft() == this.getPaddingLeft() && style.getPaddingRight() == this.getPaddingRight() && style.getSpacingBefore() == this.getSpacingBefore() && style.getSpacingAfter() == this.getSpacingAfter() && style.getLineSpacing() == this.getLineSpacing();
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }

    protected Object readResolve() throws InvalidObjectException {
        if (this.getClass() != Style.class) {
            throw new InvalidObjectException("subclass didn't correctly implement readResolve");
        }
        Object object = initializeStyle.get(this);
        if (object == null) {
            object = this;
            initializeStyle.put(this, object);
        }
        return object;
    }

    public static void paintContent(Graphics2D graphics2D, Object object, Style style, int n2, int n3, int n4) {
        if (object == null || n2 == 0 || n3 == 0) {
            return;
        }
        if (style == null) {
            style = DEFAULT_STYLE.deriveImageLayout(1);
        }
        if (object instanceof Formula) {
            object = ((Formula)object).getResult();
        }
        if (object instanceof Painter) {
            ((Painter)object).paint(graphics2D, n2, n3, n4, style);
        } else if (object instanceof Image) {
            int n5 = CoreGraphHelper.changeImageLayout4Draw((Image)object, style.getImageLayout(), n2, n3);
            int n6 = 96;
            double d2 = (double)n4 * 1.0 / (double)n6;
            n2 = (int)((double)n2 / d2);
            n3 = (int)((double)n3 / d2);
            graphics2D.scale(d2, d2);
            GraphHelper.paintImage(graphics2D, n2, n3, (Image)object, n5, style.getHorizontalAlignment(), style.getVerticalAlignment(), -1, -1);
            graphics2D.scale((double)n6 * 1.0 / (double)n4, (double)n6 * 1.0 / (double)n4);
        } else {
            String string = Style.valueToText(object, style.getFormat());
            Style.paintCellStyleString(graphics2D, n2, n3, string, style, n4);
        }
    }

    public static void paintContent(Graphics2D graphics2D, Object object, int n2, Style style, Rectangle rectangle, Rectangle rectangle2) {
        Shape shape = graphics2D.getClip();
        graphics2D.translate(rectangle.getX(), rectangle.getY());
        graphics2D.clip(rectangle2);
        Style.paintContent(graphics2D, object, style, rectangle.width, rectangle.height, n2);
        graphics2D.translate(-rectangle.getX(), -rectangle.getY());
        graphics2D.setClip(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintBackground(Graphics2D graphics2D, Style style, double d2, double d3) {
        if (style == null) {
            return;
        }
        Background background = style.getBackground();
        if (background == null) {
            return;
        }
        background.layoutDidChange((int)d2, (int)d3);
        Rectangle2D rectangle2D = tempRectangle2D;
        synchronized (rectangle2D) {
            tempRectangle2D.setRect(0.0, 0.0, d2, d3);
            background.paint(graphics2D, tempRectangle2D);
        }
    }

    public static void paintBackground(Graphics2D graphics2D, Style style, Rectangle rectangle, Rectangle rectangle2) {
        Background background;
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        if ((background = style.getBackground()) != null) {
            background.paint(graphics2D, new Rectangle(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y, rectangle2.width, rectangle2.height));
        }
    }

    public static void paintBorder(Graphics2D graphics2D, Style style, double d2, double d3) {
        int n2;
        int n3;
        if (style == null) {
            return;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        if (style.getBorderLeft() != 0) {
            n3 = GraphHelper.getLineStyleSize(style.getBorderLeft());
            d4 = n3 / 2;
        }
        if (style.getBorderRight() != 0) {
            n3 = GraphHelper.getLineStyleSize(style.getBorderRight());
            d5 = n3 / 2;
        }
        double d6 = 0.0;
        double d7 = 0.0;
        if (style.getBorderTop() != 0) {
            n2 = GraphHelper.getLineStyleSize(style.getBorderTop());
            d6 = n2 / 2;
        }
        if (style.getBorderBottom() != 0) {
            n2 = GraphHelper.getLineStyleSize(style.getBorderBottom());
            d7 = n2 / 2;
        }
        if (style.getBorderTop() != 0) {
            graphics2D.setPaint(style.getBorderTopColor());
            GraphHelper.drawLine(graphics2D, 0.0 - d4, 0.0, d2 + d5, 0.0, style.getBorderTop());
        }
        if (style.getBorderLeft() != 0) {
            graphics2D.setPaint(style.getBorderLeftColor());
            GraphHelper.drawLine(graphics2D, 0.0, 0.0 - d6, 0.0, d3 + d7, style.getBorderLeft());
        }
        if (style.getBorderBottom() != 0) {
            graphics2D.setPaint(style.getBorderBottomColor());
            GraphHelper.drawLine(graphics2D, 0.0 - d4, d3, d2 + d5, d3, style.getBorderBottom());
        }
        if (style.getBorderRight() != 0) {
            graphics2D.setPaint(style.getBorderRightColor());
            GraphHelper.drawLine(graphics2D, d2, 0.0 - d6, d2, d3 + d7, style.getBorderRight());
        }
    }

    public static void paintBorder(Graphics2D graphics2D, Style style, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        graphics2D.translate(rectangle.getX(), rectangle.getY());
        Rectangle rectangle3 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        if (rectangle2 != null) {
            rectangle3 = rectangle3.intersection(rectangle2);
        }
        graphics2D.translate(rectangle3.getX(), rectangle3.getY());
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        Style.paintBorder(graphics2D, style, rectangle3.getWidth(), rectangle3.getHeight());
        graphics2D.translate(-rectangle3.getX(), -rectangle3.getY());
        graphics2D.translate(-rectangle.getX(), -rectangle.getY());
    }

    public static String valueToText(Object object, Format format) {
        if (format == null) {
            return Utils.objectToString(object);
        }
        Object object2 = object;
        String string = null;
        String string2 = StableUtils.checkInfinity(object);
        if (StringUtils.isNotEmpty(string2)) {
            return string2;
        }
        if (object != null) {
            if (object instanceof Formula) {
                Formula formula = (Formula)object;
                if (StableUtils.isNull(formula.getResult())) {
                    return "";
                }
                object2 = formula.getResult();
            } else if (object instanceof Clob) {
                object2 = DataUtils.clob2String((Clob)object);
            }
            if (format != null) {
                if (format instanceof DateFormat) {
                    string = Style.valueInDateFormat(format, object2);
                } else if (format instanceof NumberFormat) {
                    string = Style.valueInNumberFormat(format, object2);
                } else {
                    try {
                        string = format.format(object2);
                    }
                    catch (Exception exception) {
                        string = Utils.objectToString(object2);
                    }
                }
            } else {
                string = Utils.objectToString(object2);
            }
        } else {
            string = "";
        }
        return string;
    }

    protected static String valueInNumberFormat(Format format, Object object) {
        Number number = GeneralUtils.objectToNumberReturnNull(object);
        if (number != null) {
            try {
                if (format instanceof CoreDecimalFormat) {
                    return ((CoreDecimalFormat)format).formatRoundingModeUp(number);
                }
                return format.format(number);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Utils.objectToString(object);
    }

    private static String valueInDateFormat(Format format, Object object) {
        String string = "";
        Date date = null;
        if (format instanceof DateFormat) {
            if (object instanceof Date) {
                date = (Date)object;
            } else {
                try {
                    date = ((DateFormat)format).parse(Utils.objectToString(object));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (date == null) {
            date = DateUtils.object2Date(object, true);
        }
        string = date != null ? format.format(date) : Utils.objectToString(object);
        return string;
    }

    public static void paintCellStyleString(Graphics2D graphics2D, int n2, int n3, String string, Style style, int n4) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        Paint paint = graphics2D.getPaint();
        if (style == null) {
            style = DEFAULT_STYLE;
        }
        Font font = BaseUtils.getStyleFont(graphics2D, style, n4);
        if (style.getRotation() != 0 && style.getVerticalText() == 0) {
            BaseUtils.drawStringStyleInRotation(graphics2D, n2, n3, string, style, n4);
        } else if (style.getTextStyle() == 2 || style.getTextStyle() == 3) {
            List list = BaseUtils.getLineTextList(string, style, font, n3, n2);
            if (n2 <= 0 || list.isEmpty()) {
                return;
            }
            int n5 = graphics2D.getFontMetrics().getAscent();
            int n6 = graphics2D.getFontMetrics().getHeight();
            int n7 = 0;
            int n8 = n6 * list.size();
            double d2 = PT.pt2pix(style.getSpacingBefore(), n4);
            double d3 = PT.pt2pix(style.getSpacingAfter(), n4);
            double d4 = PT.pt2pix(style.getLineSpacing(), n4);
            n8 = (int)((double)n8 + (d2 + d3 + d4 * (double)list.size()));
            if (style.getVerticalAlignment() != 1) {
                if (style.getVerticalAlignment() == 0) {
                    if (n3 > n8) {
                        n7 = (n3 - n8) / 2;
                    }
                } else if (style.getVerticalAlignment() == 3) {
                    n7 = n3 - n8;
                }
            }
            n7 += n5;
            n7 = (int)((double)n7 + (d2 + d4));
            if (style.getTextStyle() == 2) {
                ContentLineGroup contentLineGroup = Style.singleLineAdjustFont(style, list, n2, n3, graphics2D, n4, true);
                Style._drawContentLineGroup(contentLineGroup, graphics2D, n7, n3, n2, BaseUtils.getAlignment4Horizontal(style, string));
            } else if (style.getTextStyle() == 3) {
                ContentLineGroup contentLineGroup = Style.mulitiLineAdjustFont(style, list, n2, n3, graphics2D, n4, true);
                Style._drawContentLineGroup(contentLineGroup, graphics2D, n7, n3, n2, BaseUtils.getAlignment4Horizontal(style, string));
            }
        } else {
            BaseUtils.drawStringStyleInRotation(graphics2D, n2, n3, string, style, n4);
        }
        graphics2D.setPaint(paint);
    }

    private static void _drawContentLineGroup(ContentLineGroup contentLineGroup, Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        Style style = contentLineGroup.style;
        Font font = graphics2D.getFont();
        graphics2D.setFont(style.getFRFont());
        if (style.getVerticalAlignment() == 1) {
            n2 = 0;
        } else if (style.getVerticalAlignment() == 0) {
            n2 = n3 > contentLineGroup.totalHeight() ? (n3 - contentLineGroup.totalHeight()) / 2 : 0;
        } else if (style.getVerticalAlignment() == 3) {
            n2 = n3 - contentLineGroup.totalHeight();
        }
        n2 += graphics2D.getFontMetrics().getAscent();
        for (int i2 = 0; i2 < contentLineGroup.newLineTextList.size(); ++i2) {
            double d2 = style.getPaddingLeft();
            int n6 = GraphHelper.getFontMetrics(style.getFRFont()).stringWidth((String)contentLineGroup.newLineTextList.get(i2));
            if (n5 != 2) {
                if (n5 == 0) {
                    d2 = (double)(n4 - n6 - style.getPaddingRight()) / 2.0;
                } else if (n5 == 4) {
                    d2 = n4 - style.getPaddingRight() - n6;
                } else if (n5 == 6) {
                    // empty if block
                }
            }
            if (n5 == 6) {
                String string = (String)contentLineGroup.newLineTextList.get(i2);
                double d3 = (n4 - style.getPaddingLeft() - style.getPaddingRight() - graphics2D.getFontMetrics().charWidth(string.charAt(string.length() - 1))) / (string.length() - 1);
                for (int i3 = 0; i3 < string.length(); ++i3) {
                    char c2 = string.charAt(i3);
                    String string2 = new String(new StringBuffer().append(c2));
                    double d4 = (double)style.getPaddingLeft() + (double)i3 * d3;
                    GraphHelper.drawString(graphics2D, string2, d4, n2);
                }
            } else {
                GraphHelper.drawString(graphics2D, (String)contentLineGroup.newLineTextList.get(i2), d2, n2);
            }
            n2 += contentLineGroup.newTextHeight;
        }
        graphics2D.setFont(font);
    }

    private static ContentLineGroup singleLineAdjustFont(Style style, List list, int n2, int n3, Graphics2D graphics2D, int n4, boolean bl) {
        FRFont fRFont = (FRFont)style.getFRFont().applyResolutionNP(n4);
        int n5 = 0;
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(fRFont);
        int n6 = fontMetrics.getHeight() * list.size();
        String string = "";
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (fontMetrics.stringWidth((String)list.get(i2)) <= n5) continue;
            string = (String)list.get(i2);
            n5 = fontMetrics.stringWidth((String)list.get(i2));
        }
        if (n5 > 0 || n6 > 0) {
            if (n5 > n2 - style.getPaddingLeft() - style.getPaddingRight() || n6 > n3) {
                while (fRFont.getSize() > 1) {
                    fRFont = fRFont.applySize((float)fRFont.getSize() - 1.0f);
                    n5 = GraphHelper.getFontMetrics(fRFont).stringWidth(string);
                    n6 = GraphHelper.getFontMetrics(fRFont).getHeight() * list.size();
                    if (n5 > n2 - style.getPaddingLeft() - style.getPaddingRight() || n6 > n3) continue;
                    break;
                }
            } else if (n5 >= n2 - style.getPaddingLeft() - style.getPaddingRight() || n6 < n3) {
                // empty if block
            }
        }
        FRFont fRFont2 = style.getFRFont().applySize(bl ? fRFont.getSize2D() : FRFont.convResolution(fRFont.getSize2D(), n4));
        return new ContentLineGroup(style.deriveFRFont(fRFont2), list, GraphHelper.getFontMetrics(fRFont, graphics2D).getHeight());
    }

    private static ContentLineGroup mulitiLineAdjustFont(Style style, List list, int n2, int n3, Graphics2D graphics2D, int n4, boolean bl) {
        FRFont fRFont = (FRFont)style.getFRFont().applyResolutionNP(n4);
        List list2 = new ArrayList();
        Style style2 = DEFAULT_STYLE;
        style2 = style2.deriveTextStyle(0);
        int n5 = GraphHelper.getFontMetrics(fRFont, graphics2D).getHeight();
        list2 = Style.resovleLineTextListByStyle(fRFont, list, style2, n2);
        if (list2.size() * n5 > n3) {
            while (fRFont.getSize() > 1) {
                fRFont = fRFont.applySize((float)fRFont.getSize() - 1.0f);
                list2 = Style.resovleLineTextListByStyle(fRFont, list, style2, n2);
                n5 = GraphHelper.getFontMetrics(fRFont, graphics2D).getHeight();
                if (list2.size() * n5 > n3) continue;
                break;
            }
        } else if (list2.size() * n5 < n3) {
            while (fRFont.getSize() < 100) {
                fRFont = fRFont.applySize((float)fRFont.getSize() + 1.0f);
                list2 = Style.resovleLineTextListByStyle(fRFont, list, style2, n2);
                n5 = GraphHelper.getFontMetrics(fRFont, graphics2D).getHeight();
                if (list2.size() * n5 <= n3) continue;
                fRFont = fRFont.applySize(fRFont.getSize() - 1);
                list2 = Style.resovleLineTextListByStyle(fRFont, list, style2, n2);
                n5 = GraphHelper.getFontMetrics(fRFont, graphics2D).getHeight();
                break;
            }
        }
        FRFont fRFont2 = style2.getFRFont().applySize(bl ? fRFont.getSize2D() : FRFont.convResolution(fRFont.getSize2D(), n4));
        style2.deriveFRFont(fRFont2);
        return new ContentLineGroup(style2, list2, n5);
    }

    private static List resovleLineTextListByStyle(Font font, List list, Style style, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List list2 = BaseUtils.getLineTextList((String)list.get(i2), style, font, n2);
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                arrayList.add((String)list2.get(i3));
            }
        }
        return arrayList;
    }

    public static Style modCellStyleString(int n2, int n3, String string, Style style, int n4) {
        List list = BaseUtils.getLineTextList(string, style, null, n3, n2);
        if (style.getTextStyle() == 2) {
            style = Style.singleLineAdjustFont((Style)style, (List)list, (int)n2, (int)n3, null, (int)n4, (boolean)false).style;
        } else if (style.getTextStyle() == 3) {
            style = Style.mulitiLineAdjustFont((Style)style, (List)list, (int)n2, (int)n3, null, (int)n4, (boolean)false).style;
        }
        return style;
    }

    static {
        ServletContext.addServletContextListener(new ServletContextAdapter(){

            public void onServletStop() {
                initializeStyle.clear();
            }
        });
    }

    private static class ContentLineGroup {
        Style style;
        List newLineTextList;
        int newTextHeight;

        public ContentLineGroup(Style style, List list, int n2) {
            this.style = style;
            this.newLineTextList = list;
            this.newTextHeight = n2;
        }

        public int totalHeight() {
            return this.newTextHeight * this.newLineTextList.size();
        }
    }
}

