/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.DoubleDimension2D;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.StringUtils;
import com.fr.stable.core.FontProvider;
import com.fr.stable.fun.FontProcessor;
import com.fr.stable.fun.GraphDrawProcessor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GraphHelper {
    private static Line2D tmpLine2D = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    private static final float MITERLIMIT = 10.0f;
    private static final float DASHINCR = 8.0f;
    private static final float DASHMIN = 4.0f;
    private static final char A = '\uac00';
    private static final char B = '\ud7a3';
    private static final char C = '\u3130';
    private static final char D = '\u318f';
    private static final char E = '\u1100';
    private static final char F = '\u11ff';
    private static final char G = '\u20a9';
    private static Font oldFont = null;
    private static FontMetrics oldFontMetrics = null;
    private static Map fontMetricsHash = new ConcurrentHashMap();
    private static Stroke[] LineStrokeArray = new Stroke[15];

    private GraphHelper() {
    }

    public static void draw(Graphics graphics, Shape shape) {
        GraphHelper.draw(graphics, shape, 1);
    }

    public static void draw(Graphics graphics, Shape shape, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = (BasicStroke)GraphHelper.getStroke(n2);
        if (shape instanceof RoundRectangle2D && GraphHelper.getLineStyleSize(n2) == 1) {
            basicStroke = new BasicStroke(0.2f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        }
        GraphHelper.setStroke(graphics2D, basicStroke);
        graphics2D.draw(shape);
        graphics2D.setStroke(stroke);
    }

    public static void drawLine(Graphics graphics, double d2, double d3, double d4, double d5) {
        GraphHelper.drawLine(graphics, d2, d3, d4, d5, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(Graphics graphics, double d2, double d3, double d4, double d5, int n2) {
        double d6;
        int n3;
        double d7;
        if (n2 == 0) {
            return;
        }
        if (n2 == 6) {
            d7 = d4 - d2;
            double d8 = d5 - d3;
            int n4 = (int)Math.sqrt(d7 * d7 + d8 * d8);
            if (n4 != 0) {
                int n5 = (int)(-d8 / (double)n4);
                int n6 = (int)(d7 / (double)n4);
                GraphHelper.drawLine(graphics, d2 - (double)n5, d3 - (double)n6, d4 - (double)n5, d5 - (double)n6, 1);
                GraphHelper.drawLine(graphics, d2 + (double)n5, d3 + (double)n6, d4 + (double)n5, d5 + (double)n6, 1);
                return;
            }
        } else if (n2 == 15 && (n3 = (int)Math.sqrt((d7 = d4 - d2) * d7 + (d6 = d5 - d3) * d6)) != 0) {
            boolean bl = true;
            int n7 = (int)(-d6 * (double)bl / (double)n3);
            int n8 = (int)(d7 * (double)bl / (double)n3);
            GraphHelper.drawLine(graphics, d2, d3, d4, d5, 7);
            GraphHelper.drawLine(graphics, d2 + (double)n7, d3 + (double)n8, d4 + (double)n7, d5 + (double)n8, 7);
            return;
        }
        Line2D line2D = tmpLine2D;
        synchronized (line2D) {
            tmpLine2D.setLine(d2, d3, d4, d5);
            GraphHelper.draw(graphics, tmpLine2D, n2);
        }
    }

    public static void drawRect(Graphics graphics, double d2, double d3, double d4, double d5) {
        GraphHelper.drawRect(graphics, d2, d3, d4, d5, 1);
    }

    public static void drawRect(Graphics graphics, double d2, double d3, double d4, double d5, int n2) {
        GraphHelper.draw(graphics, new Rectangle2D.Double(d2, d3, d4, d5), n2);
    }

    public static void drawArc(Graphics graphics, double d2, double d3, double d4, double d5, double d6, double d7) {
        GraphHelper.drawArc(graphics, d2, d3, d4, d5, d6, d7, 1);
    }

    public static void drawArc(Graphics graphics, double d2, double d3, double d4, double d5, double d6, double d7, int n2) {
        GraphHelper.draw(graphics, new Arc2D.Double(d2, d3, d4, d5, d6, d7, 2), n2);
    }

    public static void fill(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(shape);
    }

    public static void fillRect(Graphics graphics, double d2, double d3, double d4, double d5) {
        GraphHelper.fill(graphics, new Rectangle2D.Double(d2, d3, d4, d5));
    }

    public static void fillArc(Graphics graphics, double d2, double d3, double d4, double d5, double d6, double d7) {
        GraphHelper.fill(graphics, new Arc2D.Double(d2, d3, d4, d5, d6, d7, 2));
    }

    public static void drawString(Graphics graphics, String string, double d2, double d3) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (graphics.getFont() instanceof FRFont) {
            FRFont fRFont = (FRFont)graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(fRFont);
            int n2 = fRFont.getStyle();
            if (fRFont.isSuperscript()) {
                d3 -= (double)(fontMetrics.getAscent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n2, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            } else if (fRFont.isSubscript()) {
                d3 += (double)(fontMetrics.getDescent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n2, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            }
            if (fRFont.isShadow()) {
                Color color = graphics.getColor();
                graphics.setColor(color.brighter());
                GraphHelper.drawNormalString(graphics, string, d2 + 1.0, d3 + 1.0);
                graphics.setColor(color);
            }
            GraphHelper.drawNormalString(graphics, string, d2, d3);
            if (fRFont.getUnderline() != 0) {
                double d4 = d3 + (double)fontMetrics.getDescent() + (double)GraphHelper.getLineStyleSize(fRFont.getUnderline());
                GraphHelper.drawLine(graphics, d2, d4, d2 + (double)fontMetrics.stringWidth(string), d4, fRFont.getUnderline());
            }
            if (fRFont.isStrikethrough()) {
                int n3 = fontMetrics.getHeight() + 1;
                double d5 = d3 - (double)fontMetrics.getAscent() + (double)(n3 / 2);
                GraphHelper.drawLine(graphics, d2, d5, d2 + (double)fontMetrics.stringWidth(string), d5, 1);
            }
        } else {
            GraphHelper.drawNormalString(graphics, string, d2, d3);
        }
    }

    private static void drawNormalString(Graphics graphics, String string, double d2, double d3) {
        if (StringUtils.isEmpty(string)) {
            return;
        }
        Font font = GraphHelper.initFont(graphics);
        FRFont fRFont = FRFont.getInstance(Inter.getLocText("FR-Base-Song_TypeFace"), font.getStyle(), font.getSize());
        char[] cArray = new char[1];
        int n2 = (int)d2;
        int n3 = (int)d3;
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            if (font.canDisplay(c2)) {
                cArray[0] = c2;
                graphics.drawChars(cArray, 0, 1, n2, n3);
                n2 += GraphHelper.getFontMetrics(font).charWidth(c2);
                continue;
            }
            if (GraphHelper.isKoreanCharacter(string, fRFont)) {
                Font font2 = new Font("", font.getSize(), font.getSize());
                graphics.setFont(font2);
            } else {
                graphics.setFont(fRFont);
            }
            cArray[0] = c2;
            graphics.drawChars(cArray, 0, 1, n2, n3);
            n2 += GraphHelper.getFontMetrics(fRFont).charWidth(c2);
            graphics.setFont(font);
        }
    }

    private static Font initFont(Graphics graphics) {
        Font font = graphics.getFont();
        FontProcessor fontProcessor = (FontProcessor)ExtraClassManager.getInstance().getSingle("FontProcessor");
        if (fontProcessor != null) {
            font = fontProcessor.readExtraFont(font);
            graphics.setFont(font);
        }
        return font;
    }

    private static boolean isKoreanCharacter(String string, Font font) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!GraphHelper.inKoreanCharacter(cArray[i2]) && font.canDisplay(cArray[i2])) continue;
            return true;
        }
        return false;
    }

    private static boolean inKoreanCharacter(char c2) {
        return c2 >= '\uac00' && c2 <= '\ud7a3' || c2 > '\u3130' && c2 < '\u318f' || c2 > '\u1100' && c2 < '\u11ff' || c2 == '\u20a9';
    }

    public static void drawString2(Graphics graphics, String string, double d2, double d3, int n2) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (graphics.getFont() instanceof FRFont) {
            FRFont fRFont = (FRFont)graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(fRFont);
            int n3 = fRFont.getStyle();
            if (fRFont.isSuperscript()) {
                d3 -= (double)(fontMetrics.getAscent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n3, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            } else if (fRFont.isSubscript()) {
                d3 += (double)(fontMetrics.getDescent() / 3);
                fRFont = FRFont.getInstance(fRFont.getName(), n3, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
                fontMetrics = graphics.getFontMetrics(fRFont);
                graphics.setFont(fRFont);
            }
            if (fRFont.isShadow()) {
                Color color = graphics.getColor();
                graphics.setColor(color.brighter());
                GraphHelper.drawNormalString2(graphics, string, d2 + 1.0, d3 + 1.0, n2);
                graphics.setColor(color);
            }
            GraphHelper.drawNormalString2(graphics, string, d2, d3, n2);
            if (fRFont.getUnderline() != 0) {
                double d4 = d3 + (double)fontMetrics.getDescent() + (double)GraphHelper.getLineStyleSize(fRFont.getUnderline());
                GraphHelper.drawLine(graphics, d2, d4, d2 + (double)fontMetrics.stringWidth(string), d4, fRFont.getUnderline());
            }
            if (fRFont.isStrikethrough()) {
                int n4 = fontMetrics.getHeight() + 1;
                double d5 = d3 - (double)fontMetrics.getAscent() + (double)(n4 / 2);
                GraphHelper.drawLine(graphics, d2, d5, d2 + (double)fontMetrics.stringWidth(string), d5, 1);
            }
        } else {
            GraphHelper.drawNormalString2(graphics, string, d2, d3, n2);
        }
    }

    private static void drawNormalString2(Graphics graphics, String string, double d2, double d3, int n2) {
        int n3;
        PP[] pPArray;
        if (StringUtils.isEmpty(string)) {
            return;
        }
        Font font = graphics.getFont();
        Font font2 = null;
        char[] cArray = new char[1];
        int n4 = (int)d2;
        int n5 = (int)d3;
        int n6 = string.length();
        n4 = GraphHelper.initPPsAndChartX(string, n6, n4, font2, font, graphics, pPArray = new PP[n6]);
        int n7 = n4 - (int)d2;
        if (n7 < n2 - 1 && n6 > 1) {
            n3 = n2 - n7;
            int n8 = n3 / (n6 - 1);
            int n9 = n3 % (n6 - 1);
            double d4 = 0.0;
            if (n9 != 0) {
                d4 = (double)n9 / (double)(n6 - 1);
            }
            double d5 = 0.0;
            int n10 = 0;
            for (int i2 = 1; i2 < pPArray.length; ++i2) {
                n10 += n8;
                if ((d5 += d4) > 1.0) {
                    ++n10;
                    d5 -= 1.0;
                }
                PP pP = pPArray[i2];
                pP.textX = pP.textX + n10;
            }
        }
        for (n3 = 0; n3 < pPArray.length; ++n3) {
            if (pPArray[n3].font != font) {
                graphics.setFont(pPArray[n3].font);
            }
            cArray[0] = pPArray[n3].c;
            graphics.drawChars(cArray, 0, 1, pPArray[n3].textX, n5);
            if (pPArray[n3].font == font) continue;
            graphics.setFont(font);
        }
    }

    private static int initPPsAndChartX(String string, int n2, int n3, Font font, Font font2, Graphics graphics, PP[] pPArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (font2.canDisplay(c2)) {
                pPArray[i2] = new PP(c2, font2, n3);
                n3 += GraphHelper.getFontMetrics(font2).charWidth(c2);
                continue;
            }
            if (font == null) {
                font = new Font(Inter.getLocText("FR-Base-Song_TypeFace"), font2.getStyle(), font2.getSize());
            }
            graphics.setFont(font);
            pPArray[i2] = new PP(c2, font, n3);
            n3 += GraphHelper.getFontMetrics(font).charWidth(c2);
            graphics.setFont(font2);
        }
        return n3;
    }

    public static void drawRotatedString(Graphics graphics, String string, double d2, double d3, int n2) {
        GraphHelper.drawRotatedString(graphics, string, d2, d3, n2, 1.0);
    }

    public static void drawRotatedString(Graphics graphics, String string, double d2, double d3, int n2, double d4) {
        if (string == null || string.length() == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        if (font instanceof FRFont) {
            GraphHelper.createCellFont(graphics2D, (FRFont)font, d3);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        double d5 = lineMetrics.getDescent();
        double d6 = lineMetrics.getLeading();
        double[] dArray = new double[]{-rectangle2D.getWidth() / 2.0, -d5 - d6 + rectangle2D.getHeight() / 2.0};
        double[] dArray2 = new double[]{rectangle2D.getWidth() / 2.0, d5 + d6 - rectangle2D.getHeight() / 2.0};
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.transform(AffineTransform.getRotateInstance(Math.toRadians(n2), d2 + dArray[0] + dArray2[0], d3 + dArray[1] + dArray2[1]));
        if (graphics2D.getFont() instanceof FRFont) {
            GraphHelper.drawTextWithFRFont((FRFont)graphics2D.getFont(), graphics2D, string, d2, d3, d4, fontMetrics, dArray);
        } else {
            TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
            graphics2D.scale(d4, d4);
            textLayout.draw(graphics2D, (float)((d2 + dArray[0]) / d4), (float)((d3 + dArray[1]) / d4));
            graphics2D.scale(1.0 / d4, 1.0 / d4);
        }
        graphics2D.setTransform(affineTransform);
    }

    private static void drawTextWithFRFont(FRFont fRFont, Graphics2D graphics2D, String string, double d2, double d3, double d4, FontMetrics fontMetrics, double[] dArray) {
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), graphics2D.getFontRenderContext());
        float f2 = (float)(d2 + dArray[0]);
        float f3 = (float)(d3 + dArray[1]);
        if (fRFont.isShadow()) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(color.brighter());
            graphics2D.scale(d4, d4);
            textLayout.draw(graphics2D, (float)((double)(f2 + 1.0f) / d4), (float)((double)(f3 + 1.0f) / d4));
            graphics2D.scale(1.0 / d4, 1.0 / d4);
            graphics2D.setColor(color);
        }
        int n2 = fontMetrics.stringWidth(string);
        GraphHelper.drawLine(graphics2D, f2, f3 + (float)fontMetrics.getDescent(), f2 + (float)n2, f3 + (float)fontMetrics.getDescent(), fRFont.getUnderline());
        if (fRFont.isStrikethrough()) {
            GraphHelper.drawLine(graphics2D, f2, f3 + (float)fontMetrics.getDescent() - (float)(fontMetrics.getAscent() / 2) - (float)(fontMetrics.getDescent() / 2), f2 + (float)n2, f3 + (float)fontMetrics.getDescent() - (float)(fontMetrics.getAscent() / 2) - (float)(fontMetrics.getDescent() / 2));
        }
        graphics2D.scale(d4, d4);
        textLayout.draw(graphics2D, (float)((double)f2 / d4), (float)((double)f3 / d4));
        graphics2D.scale(1.0 / d4, 1.0 / d4);
    }

    private static void createCellFont(Graphics2D graphics2D, FRFont fRFont, double d2) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics(fRFont);
        int n2 = fRFont.getStyle();
        if (fRFont.isSuperscript()) {
            d2 -= (double)(fontMetrics.getAscent() / 3);
            fRFont = FRFont.getInstance(fRFont.getName(), n2, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
            graphics2D.setFont(fRFont);
        } else if (fRFont.isSubscript()) {
            d2 += (double)(fontMetrics.getDescent() / 3);
            fRFont = FRFont.getInstance(fRFont.getName(), n2, fRFont.getSize() * 2 / 3, fRFont.getForeground(), fRFont.getUnderline(), fRFont.isStrikethrough(), fRFont.isShadow(), fRFont.isSuperscript(), fRFont.isSubscript());
            graphics2D.setFont(fRFont);
        }
    }

    public static BufferedImage createBufferedImageFromImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        CoreGraphHelper.waitForImage(image);
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static BufferedImage createBufferedImageFromImageWithLayout(Image image, int n2, int n3, Style style) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        CoreGraphHelper.waitForImage(image);
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n4 = CoreGraphHelper.changeImageLayout4Draw(image, style.getImageLayout(), n2, n3);
        GraphHelper.paintImage(graphics2D, n2, n3, image, n4, style.getHorizontalAlignment(), style.getVerticalAlignment(), -1, -1);
        return bufferedImage;
    }

    public static void setStroke(Graphics2D graphics2D, Stroke stroke) {
        Stroke stroke2 = graphics2D.getStroke();
        if (stroke.hashCode() != stroke2.hashCode()) {
            graphics2D.setStroke(stroke);
        }
    }

    public static Stroke getStroke(int n2) {
        Stroke stroke = null;
        if (n2 < LineStrokeArray.length) {
            stroke = LineStrokeArray[n2];
            if (stroke != null) {
                return stroke;
            }
        } else {
            Stroke[] strokeArray = LineStrokeArray;
            LineStrokeArray = new Stroke[Math.max(10, strokeArray.length * 2)];
            System.arraycopy(strokeArray, 0, LineStrokeArray, 0, strokeArray.length);
        }
        int n3 = 0;
        int n4 = 0;
        if ((stroke = GraphHelper.createStrokeWithLineStyle(stroke, n2)) == null) {
            stroke = new BasicStroke(1.0f, n3, n4);
        }
        GraphHelper.LineStrokeArray[n2] = stroke;
        return stroke;
    }

    private static Stroke createStrokeWithLineStyle(Stroke stroke, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (n2 == 1 || n2 == 21) {
            stroke = new BasicStroke(1.0f, n3, n4);
        } else if (n2 == 2 || n2 == 22) {
            stroke = new BasicStroke(2.0f, n3, n4);
        } else if (n2 == 16) {
            stroke = new BasicStroke(3.0f, n3, n4);
        } else if (n2 == 3) {
            stroke = new BasicStroke(1.0f, n3, n4, 10.0f, new float[]{4.0f, 2.0f}, 0.0f);
        } else if (n2 == 4) {
            stroke = new BasicStroke(1.0f, n3, n4, 10.0f, new float[]{2.0f}, 0.0f);
        } else if (n2 == 5 || n2 == 23) {
            stroke = new BasicStroke(3.0f, n3, n4);
        } else if (n2 == 7) {
            stroke = new BasicStroke(1.0f, n3, n4, 10.0f, new float[]{1.0f}, 0.0f);
        } else if (n2 == 8) {
            stroke = new BasicStroke(2.0f, n3, n4, 10.0f, new float[]{8.0f, 2.0f}, 0.0f);
        } else if (n2 == 9) {
            stroke = new BasicStroke(1.0f, n3, n4, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n2 == 10) {
            stroke = new BasicStroke(2.0f, n3, n4, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n2 == 11) {
            stroke = new BasicStroke(1.0f, n3, n4, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n2 == 12) {
            stroke = new BasicStroke(2.0f, n3, n4, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n2 == 13) {
            stroke = new BasicStroke(2.0f, n3, n4, 10.0f, new float[]{8.0f, 4.0f, 2.0f, 4.0f}, 0.0f);
        } else if (n2 == 14) {
            stroke = new BasicStroke(1.0f, n3, n4, 10.0f, new float[]{4.0f}, 0.0f);
        }
        return stroke;
    }

    public static int getLineStyleSize(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 == 2 || n2 == 6 || n2 == 8 || n2 == 10 || n2 == 12 || n2 == 13) {
            return 2;
        }
        if (n2 == 5) {
            return 3;
        }
        return 1;
    }

    public static double stringWidth(String string, Font font, FontRenderContext fontRenderContext) {
        FontProvider fontProvider;
        if (string == null || string.length() <= 0) {
            return 0.0;
        }
        double d2 = font.getStringBounds(string, fontRenderContext).getWidth();
        if (font instanceof FontProvider && ((fontProvider = (FontProvider)((Object)font)).isSuperscript() || fontProvider.isSubscript())) {
            d2 = d2 * 2.0 / 3.0;
        }
        return d2;
    }

    public static int getLocTextWidth(String string, Font font) {
        String string2 = Inter.getLocText(string);
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        return fontMetrics.stringWidth(string2);
    }

    public static int getLocTextWidth(String string) {
        Font font = FRFont.getInstance().applyResolutionNP(96);
        return GraphHelper.getLocTextWidth(string, font);
    }

    public static Dimension2D stringDimensionWithRotation(String string, Font font, int n2, FontRenderContext fontRenderContext) {
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        double d2 = rectangle2D.getWidth();
        double d3 = Math.toRadians(n2);
        return new DoubleDimension2D(d2 * Math.abs(Math.cos(d3)) + rectangle2D.getHeight() * Math.abs(Math.sin(d3)), d2 * Math.abs(Math.sin(d3)) + rectangle2D.getHeight() * Math.abs(Math.cos(d3)));
    }

    public static FontMetrics getFontMetrics(Font font, Graphics2D graphics2D) {
        if (graphics2D == null) {
            return GraphHelper.getFontMetrics(font);
        }
        return graphics2D.getFontMetrics(font);
    }

    public static FontMetrics getFontMetrics(Font font) {
        Serializable serializable;
        if (font == oldFont) {
            return oldFontMetrics;
        }
        if (font == null) {
            serializable = FRContext.getDefaultValues();
            font = serializable.getFRFont();
        }
        if ((serializable = (FontMetrics)fontMetricsHash.get(font)) == null) {
            serializable = Toolkit.getDefaultToolkit().getFontMetrics(font);
            fontMetricsHash.put(font, serializable);
        }
        oldFont = font;
        oldFontMetrics = serializable;
        return serializable;
    }

    public static void paintImage(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, int n8) {
        GraphDrawProcessor graphDrawProcessor = (GraphDrawProcessor)ExtraClassManager.getInstance().getSingle("GraphDrawProcessor");
        if (graphDrawProcessor != null) {
            graphDrawProcessor.paintImage(graphics, n2, n3, image, n4, n5, n6, n7, n8);
        } else {
            GraphHelper.paintImageMoved(graphics, n2, n3, image, n4, n5, n6, n7, n8, 0, 0, false);
        }
    }

    public static void paintImage(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        GraphHelper.paintImageMoved(graphics, n2, n3, image, n4, n5, n6, n7, n8, 0, 0, bl);
    }

    public static void paintImageMoved(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        GraphHelper.paintImageMoved(graphics, n2, n3, image, n4, n5, n6, n7, n8, n9, n10, bl, Color.white);
    }

    public static void paintImageMoved(Graphics graphics, int n2, int n3, Image image, int n4) {
        GraphHelper.paintImageMoved(graphics, n2, n3, image, n4, 0, 0, -1, -1, 0, 0, true, Color.WHITE);
    }

    public static void paintImageMoved(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl, Color color) {
        if (image == null) {
            return;
        }
        CoreGraphHelper.waitForImage(image);
        int n11 = n7 == -1 ? image.getWidth(null) : n7;
        int n12 = n8 == -1 ? image.getHeight(null) : n8;
        if (n11 < 0 || n12 < 0) {
            return;
        }
        if ((n4 = CoreGraphHelper.changeImageLayout4Draw(image, n4, n2, n3)) == 0) {
            GraphHelper.drawLayoutTile(graphics, n2, n3, image, n11, n12, n9, n10, color);
        } else if (n4 == 1) {
            GraphHelper.drawLayoutCenter(graphics, n2, n3, image, n11, n12, n9, n10, bl, color);
        } else if (n4 == 4) {
            GraphHelper.drawLayoutAdjust(graphics, n2, n3, image, n9, n10, color, bl);
        } else if (n4 == 2) {
            for (int i2 = -n9 % n2; i2 < n2; i2 += n2) {
                for (int i3 = -n10 % n3; i3 < n3; i3 += n3) {
                    graphics.drawImage(image, i2, i3, n2, n3, null);
                }
            }
        } else if (n4 == 3) {
            GraphHelper.drawLayoutDefault(graphics, n2, n3, image, n11, n12, n5, n6, n9, n10, bl, color);
        }
    }

    private static void drawLayoutTile(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, Color color) {
        int n8 = -n6;
        int n9 = -n6;
        for (int i2 = -n6; i2 < n2; i2 += n4) {
            if ((i2 + n6) / n2 > (n8 + n6) / n2) {
                i2 = ((n8 + n6) / n2 + 1) * n2 - n6;
            }
            for (int i3 = -n7; i3 < n3; i3 += n5) {
                if ((i3 + n7) / n3 > (n9 + n7) / n3) {
                    i3 = ((n9 + n7) / n3 + 1) * n3 - n7;
                }
                try {
                    graphics.drawImage(image, i2, i3, n4, n5, null);
                }
                catch (Exception exception) {
                    BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage(n4, n5, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.setPaint(color);
                    GraphHelper.paintImage(graphics2D, n4, n5, image, 2, -1, 0, -1, -1);
                    graphics.drawImage(bufferedImage, i2, i3, n4, n5, null);
                }
                n8 = i2;
                n9 = i3;
            }
        }
    }

    private static void drawLayoutCenter(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, boolean bl, Color color) {
        for (int i2 = ((n2 - n4) / 2 - n6) % n2; i2 < n2; i2 += n2) {
            for (int i3 = ((n3 - n5) / 2 - n7) % n3; i3 < n3; i3 += n3) {
                graphics.drawImage(image, Math.max(i2, i2 - (n2 - n4) / 2), Math.max(i3, i3 - (n3 - n5) / 2), i2 > i2 - (n2 - n4) / 2 ? n4 : n2, i3 > i3 - (n3 - n5) / 2 ? n5 : n3, null);
                if (!bl) continue;
                Color color2 = graphics.getColor();
                graphics.setColor(color);
                if (n3 > n5) {
                    graphics.fillRect(n6 % n2, n7 % n3, n2, (n3 - n5) / 2);
                    graphics.fillRect(n6 % n2, Math.max(i3, i3 - (n3 - n5) / 2) + n5, n2, (n3 - n5) / 2);
                }
                if (n2 > n4) {
                    graphics.fillRect(n6 % n2, n7 % n3, (n2 - n4) / 2, n3);
                    graphics.fillRect(Math.max(i2, i2 - (n2 - n4) / 2) + n4, n7 % n3, (n2 - n4) / 2, n3);
                }
                graphics.setColor(color2);
            }
        }
    }

    private static void drawLayoutAdjust(Graphics graphics, int n2, int n3, Image image, int n4, int n5, Color color, boolean bl) {
        if (n2 == 0 || n3 == 0) {
            return;
        }
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        for (int i2 = -n4 % n2; i2 < n2; i2 += n2) {
            for (int i3 = -n5 % n3; i3 < n3; i3 += n3) {
                double d2 = (double)n2 / (double)n6;
                double d3 = (double)n3 / (double)n7;
                int n8 = i2;
                int n9 = i3;
                int n10 = n2;
                int n11 = n3;
                if (d2 > d3) {
                    n10 = (int)((double)n2 * d3 / d2);
                    i2 = (n2 - n10) / 2;
                } else {
                    n11 = (int)((double)n3 * d2 / d3);
                    i3 = (n3 - n11) / 2 + i3;
                }
                Color color2 = graphics.getColor();
                if (bl) {
                    graphics.setColor(color);
                    graphics.fillRect(i2, i3, n2, n3);
                    graphics.setColor(color2);
                }
                graphics.drawImage(image, i2, i3, n10, n11, null);
                if (!bl || n8 != 0 || n9 != 0) continue;
                GraphHelper.drawWhiteRec(graphics, color, n11, n10, n2, n3, color2);
            }
        }
    }

    private static void drawWhiteRec(Graphics graphics, Color color, int n2, int n3, int n4, int n5, Color color2) {
        graphics.setColor(color);
        if (n4 > n3) {
            graphics.fillRect(0, 0, (n4 - n3) / 2, n5);
        }
        if (n5 > n2) {
            graphics.fillRect(0, 0, n4, (n5 - n2) / 2);
        }
        graphics.setColor(color2);
    }

    private static void drawLayoutDefault(Graphics graphics, int n2, int n3, Image image, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, Color color) {
        int n10 = n6 == 4 ? n2 - n4 - n8 : (n6 == 0 ? (n2 - n4) / 2 - n8 : -n8);
        int n11 = n7 == 3 ? n3 - n5 - n9 : (n7 == 0 ? (n3 - n5) / 2 - n9 : -n9);
        if (n4 > 0 && n5 > 0) {
            for (int i2 = n10 % n2; i2 < n2; i2 += n2) {
                for (int i3 = n11 % n3; i3 < n3; i3 += n3) {
                    graphics.drawImage(image, i2, i3, n4, n5, null);
                    if (!bl) continue;
                    Color color2 = graphics.getColor();
                    graphics.setColor(color);
                    if (n2 > n4) {
                        graphics.fillRect(n4, i3, n2 - n4, n3);
                    }
                    if (n3 > n5) {
                        graphics.fillRect(i2, n5, n2, n3 - n5);
                    }
                    graphics.setColor(color2);
                }
            }
        }
    }

    private static class PP {
        private char c;
        private Font font;
        private int textX;

        public PP(char c2, Font font, int n2) {
            this.c = c2;
            this.font = font;
            this.textX = n2;
        }
    }
}

