/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.impl;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.cache.CacheKey;
import com.ibatis.sqlmap.engine.cache.CacheModel;
import com.ibatis.sqlmap.engine.exchange.DataExchangeFactory;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.SqlExecutor;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactory;
import com.ibatis.sqlmap.engine.mapping.statement.InsertStatement;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.PaginatedDataList;
import com.ibatis.sqlmap.engine.mapping.statement.SelectKeyStatement;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import com.ibatis.sqlmap.engine.scope.StatementScope;
import com.ibatis.sqlmap.engine.transaction.Transaction;
import com.ibatis.sqlmap.engine.transaction.TransactionException;
import com.ibatis.sqlmap.engine.transaction.TransactionManager;
import com.ibatis.sqlmap.engine.transaction.TransactionState;
import com.ibatis.sqlmap.engine.transaction.user.UserProvidedTransaction;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SqlMapExecutorDelegate {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private boolean lazyLoadingEnabled;
    private boolean cacheModelsEnabled;
    private boolean enhancementEnabled;
    private boolean useColumnLabel = true;
    private boolean forceMultipleResultSetSupport;
    private TransactionManager txManager;
    private HashMap mappedStatements = new HashMap();
    private HashMap cacheModels = new HashMap();
    private HashMap resultMaps = new HashMap();
    private HashMap parameterMaps = new HashMap();
    protected SqlExecutor sqlExecutor = new SqlExecutor();
    private TypeHandlerFactory typeHandlerFactory = new TypeHandlerFactory();
    private DataExchangeFactory dataExchangeFactory = new DataExchangeFactory(this.typeHandlerFactory);
    private ResultObjectFactory resultObjectFactory;
    private boolean statementCacheEnabled;

    public int getMaxTransactions() {
        return -1;
    }

    public DataExchangeFactory getDataExchangeFactory() {
        return this.dataExchangeFactory;
    }

    public TypeHandlerFactory getTypeHandlerFactory() {
        return this.typeHandlerFactory;
    }

    public boolean isLazyLoadingEnabled() {
        return this.lazyLoadingEnabled;
    }

    public void setLazyLoadingEnabled(boolean lazyLoadingEnabled) {
        this.lazyLoadingEnabled = lazyLoadingEnabled;
    }

    public boolean isCacheModelsEnabled() {
        return this.cacheModelsEnabled;
    }

    public void setCacheModelsEnabled(boolean cacheModelsEnabled) {
        this.cacheModelsEnabled = cacheModelsEnabled;
    }

    public boolean isEnhancementEnabled() {
        return this.enhancementEnabled;
    }

    public void setEnhancementEnabled(boolean enhancementEnabled) {
        this.enhancementEnabled = enhancementEnabled;
    }

    public boolean isUseColumnLabel() {
        return this.useColumnLabel;
    }

    public void setUseColumnLabel(boolean useColumnLabel) {
        this.useColumnLabel = useColumnLabel;
    }

    public TransactionManager getTxManager() {
        return this.txManager;
    }

    public void setTxManager(TransactionManager txManager) {
        this.txManager = txManager;
    }

    public void addMappedStatement(MappedStatement ms) {
        if (this.mappedStatements.containsKey(ms.getId())) {
            throw new SqlMapException("There is already a statement named " + ms.getId() + " in this SqlMap.");
        }
        ms.setBaseCacheKey(this.hashCode());
        this.mappedStatements.put(ms.getId(), ms);
    }

    public Iterator getMappedStatementNames() {
        return this.mappedStatements.keySet().iterator();
    }

    public MappedStatement getMappedStatement(String id) {
        MappedStatement ms = (MappedStatement)this.mappedStatements.get(id);
        if (ms == null) {
            throw new SqlMapException("There is no statement named " + id + " in this SqlMap.");
        }
        return ms;
    }

    public void addCacheModel(CacheModel model) {
        this.cacheModels.put(model.getId(), model);
    }

    public Iterator getCacheModelNames() {
        return this.cacheModels.keySet().iterator();
    }

    public CacheModel getCacheModel(String id) {
        CacheModel model = (CacheModel)this.cacheModels.get(id);
        if (model == null) {
            throw new SqlMapException("There is no cache model named " + id + " in this SqlMap.");
        }
        return model;
    }

    public void addResultMap(ResultMap map) {
        this.resultMaps.put(map.getId(), map);
    }

    public Iterator getResultMapNames() {
        return this.resultMaps.keySet().iterator();
    }

    public ResultMap getResultMap(String id) {
        ResultMap map = (ResultMap)this.resultMaps.get(id);
        if (map == null) {
            throw new SqlMapException("There is no result map named " + id + " in this SqlMap.");
        }
        return map;
    }

    public void addParameterMap(ParameterMap map) {
        this.parameterMaps.put(map.getId(), map);
    }

    public Iterator getParameterMapNames() {
        return this.parameterMaps.keySet().iterator();
    }

    public ParameterMap getParameterMap(String id) {
        ParameterMap map = (ParameterMap)this.parameterMaps.get(id);
        if (map == null) {
            throw new SqlMapException("There is no parameter map named " + id + " in this SqlMap.");
        }
        return map;
    }

    public void flushDataCache() {
        Iterator models = this.cacheModels.values().iterator();
        while (models.hasNext()) {
            ((CacheModel)models.next()).flush();
        }
    }

    public void flushDataCache(String id) {
        CacheModel model = this.getCacheModel(id);
        if (model != null) {
            model.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object insert(SessionScope sessionScope, String id, Object param) throws SQLException {
        Object generatedKey = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            SelectKeyStatement selectKeyStatement = null;
            if (ms instanceof InsertStatement) {
                selectKeyStatement = ((InsertStatement)ms).getSelectKeyStatement();
            }
            Object oldKeyValue = null;
            String keyProperty = null;
            boolean resetKeyValueOnFailure = false;
            if (selectKeyStatement != null && !selectKeyStatement.isRunAfterSQL()) {
                keyProperty = selectKeyStatement.getKeyProperty();
                oldKeyValue = PROBE.getObject(param, keyProperty);
                generatedKey = this.executeSelectKey(sessionScope, trans, ms, param);
                resetKeyValueOnFailure = true;
            }
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                ms.executeUpdate(statementScope, trans, param);
            }
            catch (SQLException e) {
                if (resetKeyValueOnFailure) {
                    PROBE.setObject(param, keyProperty, oldKeyValue);
                }
                throw e;
            }
            finally {
                this.endStatementScope(statementScope);
            }
            if (selectKeyStatement != null && selectKeyStatement.isRunAfterSQL()) {
                generatedKey = this.executeSelectKey(sessionScope, trans, ms, param);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeSelectKey(SessionScope sessionScope, Transaction trans, MappedStatement ms, Object param) throws SQLException {
        Object generatedKey = null;
        InsertStatement insert = (InsertStatement)ms;
        SelectKeyStatement selectKeyStatement = insert.getSelectKeyStatement();
        if (selectKeyStatement != null) {
            StatementScope statementScope = this.beginStatementScope(sessionScope, selectKeyStatement);
            try {
                generatedKey = selectKeyStatement.executeQueryForObject(statementScope, trans, param, null);
                String keyProp = selectKeyStatement.getKeyProperty();
                if (keyProp != null) {
                    PROBE.setObject(param, keyProp, generatedKey);
                }
            }
            finally {
                this.endStatementScope(statementScope);
            }
        }
        return generatedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(SessionScope sessionScope, String id, Object param) throws SQLException {
        int rows = 0;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                rows = ms.executeUpdate(statementScope, trans, param);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return rows;
    }

    public int delete(SessionScope sessionScope, String id, Object param) throws SQLException {
        return this.update(sessionScope, id, param);
    }

    public Object queryForObject(SessionScope sessionScope, String id, Object paramObject) throws SQLException {
        return this.queryForObject(sessionScope, id, paramObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object queryForObject(SessionScope sessionScope, String id, Object paramObject, Object resultObject) throws SQLException {
        Object object = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                object = ms.executeQueryForObject(statementScope, trans, paramObject, resultObject);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return object;
    }

    public List queryForList(SessionScope sessionScope, String id, Object paramObject) throws SQLException {
        return this.queryForList(sessionScope, id, paramObject, 0, -999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryForList(SessionScope sessionScope, String id, Object paramObject, int skip, int max) throws SQLException {
        List list = null;
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                list = ms.executeQueryForList(statementScope, trans, paramObject, skip, max);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryWithRowHandler(SessionScope sessionScope, String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        MappedStatement ms = this.getMappedStatement(id);
        Transaction trans = this.getTransaction(sessionScope);
        boolean autoStart = trans == null;
        try {
            trans = this.autoStartTransaction(sessionScope, autoStart, trans);
            StatementScope statementScope = this.beginStatementScope(sessionScope, ms);
            try {
                ms.executeQueryWithRowHandler(statementScope, trans, paramObject, rowHandler);
            }
            finally {
                this.endStatementScope(statementScope);
            }
            this.autoCommitTransaction(sessionScope, autoStart);
        }
        finally {
            this.autoEndTransaction(sessionScope, autoStart);
        }
    }

    public PaginatedList queryForPaginatedList(SessionScope sessionScope, String id, Object paramObject, int pageSize) throws SQLException {
        return new PaginatedDataList(sessionScope.getSqlMapExecutor(), id, paramObject, pageSize);
    }

    public Map queryForMap(SessionScope sessionScope, String id, Object paramObject, String keyProp) throws SQLException {
        return this.queryForMap(sessionScope, id, paramObject, keyProp, null);
    }

    public Map queryForMap(SessionScope sessionScope, String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List list = this.queryForList(sessionScope, id, paramObject);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object object = list.get(i);
            Object key = PROBE.getObject(object, keyProp);
            Object value = null;
            value = valueProp == null ? (Object)object : PROBE.getObject(object, valueProp);
            map.put(key, value);
        }
        return map;
    }

    public void startTransaction(SessionScope sessionScope) throws SQLException {
        try {
            this.txManager.begin(sessionScope);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + e, e);
        }
    }

    public void startTransaction(SessionScope sessionScope, int transactionIsolation) throws SQLException {
        try {
            this.txManager.begin(sessionScope, transactionIsolation);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not start transaction.  Cause: " + e, e);
        }
    }

    public void commitTransaction(SessionScope sessionScope) throws SQLException {
        try {
            if (sessionScope.isInBatch()) {
                this.executeBatch(sessionScope);
            }
            this.sqlExecutor.cleanup(sessionScope);
            this.txManager.commit(sessionScope);
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Could not commit transaction.  Cause: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(SessionScope sessionScope) throws SQLException {
        try {
            try {
                this.sqlExecutor.cleanup(sessionScope);
            }
            finally {
                this.txManager.end(sessionScope);
            }
        }
        catch (TransactionException e) {
            throw new NestedSQLException("Error while ending transaction.  Cause: " + e, e);
        }
    }

    public void startBatch(SessionScope sessionScope) {
        sessionScope.setInBatch(true);
    }

    public int executeBatch(SessionScope sessionScope) throws SQLException {
        sessionScope.setInBatch(false);
        return this.sqlExecutor.executeBatch(sessionScope);
    }

    public List executeBatchDetailed(SessionScope sessionScope) throws SQLException, BatchException {
        sessionScope.setInBatch(false);
        return this.sqlExecutor.executeBatchDetailed(sessionScope);
    }

    public void setUserProvidedTransaction(SessionScope sessionScope, Connection userConnection) {
        if (sessionScope.getTransactionState() == TransactionState.STATE_USER_PROVIDED) {
            sessionScope.recallTransactionState();
        }
        if (userConnection != null) {
            Connection conn = userConnection;
            sessionScope.saveTransactionState();
            sessionScope.setTransaction(new UserProvidedTransaction(conn));
            sessionScope.setTransactionState(TransactionState.STATE_USER_PROVIDED);
        } else {
            sessionScope.setTransaction(null);
            sessionScope.closePreparedStatements();
            sessionScope.cleanup();
        }
    }

    public DataSource getDataSource() {
        DataSource ds = null;
        if (this.txManager != null) {
            ds = this.txManager.getConfig().getDataSource();
        }
        return ds;
    }

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public Transaction getTransaction(SessionScope sessionScope) {
        return sessionScope.getTransaction();
    }

    protected void autoEndTransaction(SessionScope sessionScope, boolean autoStart) throws SQLException {
        if (autoStart) {
            sessionScope.getSqlMapTxMgr().endTransaction();
        }
    }

    protected void autoCommitTransaction(SessionScope sessionScope, boolean autoStart) throws SQLException {
        if (autoStart) {
            sessionScope.getSqlMapTxMgr().commitTransaction();
        }
    }

    protected Transaction autoStartTransaction(SessionScope sessionScope, boolean autoStart, Transaction trans) throws SQLException {
        Transaction transaction = trans;
        if (autoStart) {
            sessionScope.getSqlMapTxMgr().startTransaction();
            transaction = this.getTransaction(sessionScope);
        }
        return transaction;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        CacheKey key = new CacheKey();
        if (this.txManager != null) {
            key.update(this.txManager);
            if (this.txManager.getConfig().getDataSource() != null) {
                key.update(this.txManager.getConfig().getDataSource());
            }
        }
        key.update(System.identityHashCode(this));
        return key.hashCode();
    }

    protected StatementScope beginStatementScope(SessionScope sessionScope, MappedStatement mappedStatement) {
        StatementScope statementScope = new StatementScope(sessionScope);
        sessionScope.incrementRequestStackDepth();
        mappedStatement.initRequest(statementScope);
        return statementScope;
    }

    protected void endStatementScope(StatementScope statementScope) {
        statementScope.getSession().decrementRequestStackDepth();
    }

    protected SessionScope beginSessionScope() {
        return new SessionScope();
    }

    protected void endSessionScope(SessionScope sessionScope) {
        sessionScope.cleanup();
    }

    public ResultObjectFactory getResultObjectFactory() {
        return this.resultObjectFactory;
    }

    public void setResultObjectFactory(ResultObjectFactory resultObjectFactory) {
        this.resultObjectFactory = resultObjectFactory;
    }

    public boolean isStatementCacheEnabled() {
        return this.statementCacheEnabled;
    }

    public void setStatementCacheEnabled(boolean statementCacheEnabled) {
        this.statementCacheEnabled = statementCacheEnabled;
    }

    public boolean isForceMultipleResultSetSupport() {
        return this.forceMultipleResultSetSupport;
    }

    public void setForceMultipleResultSetSupport(boolean forceMultipleResultSetSupport) {
        this.forceMultipleResultSetSupport = forceMultipleResultSetSupport;
    }
}

