/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.reserve;

import com.fr.base.FRContext;
import com.fr.base.OfflineUtils;
import com.fr.base.mobile.utils.MobileUtils;
import com.fr.base.parameter.ParameterUI;
import com.fr.general.GeneralUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.TemplateWorkBook;
import com.fr.main.parameter.ReportParameterAttr;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.fun.ExportKeepSessionProcessor;
import com.fr.report.fun.FormatActionProvider;
import com.fr.report.fun.ReportPretreatmentProcessor;
import com.fr.report.mobile.ElementCaseMobileAttr;
import com.fr.report.stable.fun.Actor;
import com.fr.stable.ActorFactory;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.JavaScriptPlaceHolder;
import com.fr.stable.fun.StylePlaceHolder;
import com.fr.stable.web.Repository;
import com.fr.stable.web.Weblet;
import com.fr.web.core.ReportRepositoryDeal;
import com.fr.web.core.ReportSessionIDInfor;
import com.fr.web.core.ReportWebUtils;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.reserve.ExportService;
import com.fr.web.core.reserve.FormatActionFactory;
import com.fr.web.reportlet.EmbeddedTplReportlet;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReportletDealWith {
    private static int CACHEEXPIRES = -10;

    private ReportletDealWith() {
    }

    public static void dealWithReportlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        String string = SessionDealWith.generateSessionID((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Weblet)weblet);
        if (string == null || !SessionDealWith.hasSessionID((String)string)) {
            return;
        }
        ReportPretreatmentProcessor reportPretreatmentProcessor = (ReportPretreatmentProcessor)ExtraReportClassManager.getInstance().getSingle("ReportPretreatmentProcessor");
        if (reportPretreatmentProcessor != null) {
            reportPretreatmentProcessor.process(httpServletRequest, httpServletResponse, string);
        }
        if (WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"format") != null) {
            ExportKeepSessionProcessor exportKeepSessionProcessor = (ExportKeepSessionProcessor)ExtraReportClassManager.getInstance().getSingle("ExportKeepSessionProcessor");
            if (exportKeepSessionProcessor != null) {
                exportKeepSessionProcessor.keepAwakenSession(string);
            }
            ReportletDealWith.turnToExport(httpServletRequest, httpServletResponse, string);
            if (exportKeepSessionProcessor != null) {
                exportKeepSessionProcessor.stopAwakenSession(string);
            }
        } else if (WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"isWriteOfflinePage") != null) {
            OfflineUtils.offlineWrite((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (PrintWriter)WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse), (Object)("{sessionID:\"" + string + "\"}"));
        } else {
            Actor actor = ActorFactory.getActor(httpServletRequest);
            ReportletDealWith.dealWithPageHtml(httpServletRequest, httpServletResponse, string, actor);
        }
    }

    public static void turnToExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        String string2 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"format");
        FormatActionProvider formatActionProvider = FormatActionFactory.getReqProcessor(string2);
        if (formatActionProvider != null) {
            formatActionProvider.doAction(httpServletRequest, httpServletResponse);
        } else {
            String string3 = WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"__embed__");
            boolean bl = "true".equals(string3);
            ExportService.dealWithExport(httpServletRequest, httpServletResponse, string, bl);
        }
    }

    public static void dealWithEmbeddedReportlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, EmbeddedTplReportlet embeddedTplReportlet) throws Exception {
        String string = SessionDealWith.generateSessionID((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Weblet)embeddedTplReportlet);
        if (string == null || !SessionDealWith.hasSessionID((String)string)) {
            return;
        }
        ReportletDealWith.dealWithPageHtml(httpServletRequest, httpServletResponse, string, embeddedTplReportlet.getActor());
    }

    private static void dealWithPageHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Actor actor) throws Exception {
        ReportSessionIDInfor reportSessionIDInfor = (ReportSessionIDInfor)SessionDealWith.getSessionIDInfor((String)string);
        if (reportSessionIDInfor == null) {
            return;
        }
        if (WebUtils.getDevice((HttpServletRequest)httpServletRequest).isMobile()) {
            ReportletDealWith.dealWithMobile(httpServletRequest, httpServletResponse, reportSessionIDInfor, actor);
        } else {
            ReportletDealWith.dealWithHtml(httpServletRequest, httpServletResponse, reportSessionIDInfor, actor);
        }
    }

    public static void dealWithMobile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, Actor actor) throws Exception {
        ReportParameterAttr reportParameterAttr;
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        Actor actor2 = reportSessionIDInfor.getActor();
        jSONObject.put("fitConfig", (Object)ReportletDealWith.getFitConfigJson(reportSessionIDInfor));
        jSONObject.put("toolbarConfig", (Object)ReportletDealWith.getToolBarConfigJson(reportSessionIDInfor));
        ElementCaseMobileAttr elementCaseMobileAttr = reportSessionIDInfor.getContextBook().getReportMobileAttr();
        jSONObject.put("isUseHTML", elementCaseMobileAttr.isUseHTML());
        jSONObject.put("hash5", MobileUtils.hasH5());
        JSONObject jSONObject2 = actor2.createReportWebAttr4Mobile(httpServletRequest, reportSessionIDInfor);
        if (jSONObject2 != null) {
            jSONObject.put("reportAttr", (Object)jSONObject2);
        }
        jSONObject.put("sessionid", (Object)reportSessionIDInfor.getSessionID());
        int n2 = reportSessionIDInfor.getReportCount();
        if (n2 > 1) {
            reportParameterAttr = new JSONArray();
            jSONObject.put("sheets", (Object)reportParameterAttr);
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = reportSessionIDInfor.getReportName(i2);
                if (string == null) continue;
                reportParameterAttr.put(string);
            }
        }
        reportParameterAttr = ReportletDealWith.getReportParameterAttr(reportSessionIDInfor);
        ReportRepositoryDeal reportRepositoryDeal = new ReportRepositoryDeal(httpServletRequest, reportSessionIDInfor);
        boolean bl = ReportWebUtils.isShowParameterPanel((Repository)reportRepositoryDeal);
        if (bl && reportParameterAttr != null) {
            jSONObject.put("delay", reportParameterAttr.isDelayPlaying());
            jSONObject.put("isShowWindow", reportParameterAttr.isShowWindow());
            ParameterUI parameterUI = reportParameterAttr.getParameterUI();
            if (parameterUI != null) {
                parameterUI.executeMobileParaWidgets((Repository)reportRepositoryDeal, jSONObject);
            }
        }
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private static JSONObject getFitConfigJson(ReportSessionIDInfor reportSessionIDInfor) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        if (reportSessionIDInfor == null) {
            return jSONObject;
        }
        ElementCaseMobileAttr elementCaseMobileAttr = reportSessionIDInfor.getContextBook().getReportMobileAttr();
        if (elementCaseMobileAttr == null) {
            return jSONObject;
        }
        jSONObject.put("horFit", elementCaseMobileAttr.getHorziontalAttr().getState());
        jSONObject.put("verFit", elementCaseMobileAttr.getVerticalAttr().getState());
        jSONObject.put("isUseHTML", elementCaseMobileAttr.isUseHTML());
        jSONObject.put("hash5", MobileUtils.hasH5());
        return jSONObject;
    }

    private static JSONObject getToolBarConfigJson(ReportSessionIDInfor reportSessionIDInfor) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        if (reportSessionIDInfor == null) {
            return jSONObject;
        }
        ElementCaseMobileAttr elementCaseMobileAttr = reportSessionIDInfor.getContextBook().getReportMobileAttr();
        if (elementCaseMobileAttr == null) {
            return jSONObject;
        }
        jSONObject.put("zoom", elementCaseMobileAttr.isZoom());
        jSONObject.put("refresh", elementCaseMobileAttr.isRefresh());
        return jSONObject;
    }

    private static ReportParameterAttr getReportParameterAttr(ReportSessionIDInfor reportSessionIDInfor) {
        TemplateWorkBook templateWorkBook = reportSessionIDInfor.getWorkBookDefine();
        return templateWorkBook == null ? null : templateWorkBook.getReportParameterAttr();
    }

    private static void dealWithHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ReportSessionIDInfor reportSessionIDInfor, Actor actor) {
        String string;
        Map<String, Object> map = actor.createContext4Tpl(httpServletRequest, reportSessionIDInfor);
        ReportletDealWith.makeSureNotUseCacheWhenBack(httpServletResponse);
        String string2 = (String)reportSessionIDInfor.getParameterValue("fr_locale");
        if (StringUtils.isNotEmpty((String)string2)) {
            map.put("__fr_locale__", string2);
        } else {
            map.put("__fr_locale__", WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fr_locale"));
        }
        map.put("__v__", GeneralUtils.readBuildNO());
        String string3 = ReportletDealWith.createScriptPlaceHolderString();
        if (StringUtils.isNotEmpty((String)string3)) {
            map.put("PageScript", string3);
        }
        if (StringUtils.isNotEmpty((String)(string = ReportletDealWith.createStylePlaceHolderString()))) {
            map.put("PageStyle", string);
        }
        try {
            actor.flushHtml(httpServletRequest, httpServletResponse, map, reportSessionIDInfor);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
        }
    }

    private static String createScriptPlaceHolderString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = ExtraReportClassManager.getInstance().getArray("JavaScriptPlaceHolder");
        for (JavaScriptPlaceHolder javaScriptPlaceHolder : set) {
            stringBuilder.append(javaScriptPlaceHolder.placeHolderContent());
        }
        return stringBuilder.toString();
    }

    private static String createStylePlaceHolderString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = ExtraReportClassManager.getInstance().getArray("StylePlaceHolder");
        for (StylePlaceHolder stylePlaceHolder : set) {
            stringBuilder.append(stylePlaceHolder.placeHolderContent());
        }
        return stringBuilder.toString();
    }

    private static void makeSureNotUseCacheWhenBack(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", (long)CACHEEXPIRES);
    }
}

