/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.base.BaseUtils;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.base.Margin;
import com.fr.base.PaperSize;
import com.fr.base.ParameterMapNameSpace;
import com.fr.base.ResultFormula;
import com.fr.base.TableData;
import com.fr.base.chart.BaseChartCollection;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.FormulaCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.form.FormOperator;
import com.fr.form.ui.Button;
import com.fr.form.ui.CheckBox;
import com.fr.form.ui.CheckBoxGroup;
import com.fr.form.ui.ComboBox;
import com.fr.form.ui.ComboCheckBox;
import com.fr.form.ui.CustomToolBarButton;
import com.fr.form.ui.DateEditor;
import com.fr.form.ui.FileEditor;
import com.fr.form.ui.FreeButton;
import com.fr.form.ui.IframeEditor;
import com.fr.form.ui.Label;
import com.fr.form.ui.ListEditor;
import com.fr.form.ui.MultiFileEditor;
import com.fr.form.ui.NumberEditor;
import com.fr.form.ui.Password;
import com.fr.form.ui.Radio;
import com.fr.form.ui.RadioGroup;
import com.fr.form.ui.Table;
import com.fr.form.ui.TableTree;
import com.fr.form.ui.TextArea;
import com.fr.form.ui.TextEditor;
import com.fr.form.ui.TreeComboBoxEditor;
import com.fr.form.ui.TreeEditor;
import com.fr.form.ui.Widget;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.data.TableDataException;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.main.FineBook;
import com.fr.page.PaperSettingProvider;
import com.fr.page.ReportSettingsProvider;
import com.fr.report.cell.ResultCellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.core.SubReport;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.core.A.N;
import com.fr.report.core.utils.ScriptUtils;
import com.fr.report.report.Report;
import com.fr.report.stable.ReportSettings;
import com.fr.report.web.Printer;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.WebPage;
import com.fr.report.web.WebView;
import com.fr.report.web.WebWrite;
import com.fr.report.web.button.AppletPrint;
import com.fr.report.web.button.Edit;
import com.fr.report.web.button.Email;
import com.fr.report.web.button.Excel;
import com.fr.report.web.button.ExcelL;
import com.fr.report.web.button.ExcelO;
import com.fr.report.web.button.ExcelS;
import com.fr.report.web.button.Export;
import com.fr.report.web.button.FlashPrint;
import com.fr.report.web.button.PDF;
import com.fr.report.web.button.PDFPrint;
import com.fr.report.web.button.PageSetup;
import com.fr.report.web.button.Print;
import com.fr.report.web.button.PrintPreview;
import com.fr.report.web.button.Scale;
import com.fr.report.web.button.ServerPrint;
import com.fr.report.web.button.Word;
import com.fr.report.web.button.page.First;
import com.fr.report.web.button.page.Last;
import com.fr.report.web.button.page.Next;
import com.fr.report.web.button.page.PageNavi;
import com.fr.report.web.button.page.Previous;
import com.fr.report.web.button.page.SetPrinterOffset;
import com.fr.report.web.button.write.AppendColumnRow;
import com.fr.report.web.button.write.DeleteColumnRow;
import com.fr.report.web.button.write.ImportExcelData;
import com.fr.report.web.button.write.ShowCellValue;
import com.fr.report.web.button.write.Submit;
import com.fr.report.web.button.write.SubmitForcibly;
import com.fr.report.web.button.write.Verify;
import com.fr.report.worksheet.CalculatableResWorkSheet;
import com.fr.report.worksheet.WorkSheet;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.html.Html;
import com.fr.stable.html.Tag;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.NameSpace;
import com.fr.stable.unit.MM;
import com.fr.stable.unit.UNIT;
import com.fr.web.attr.ReportWebAttr;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportUtils {
    private static Map widgetIconMap = new HashMap();

    private ReportUtils() {
    }

    public static void initIconMap() {
        if (!widgetIconMap.isEmpty()) {
            return;
        }
        ReportUtils.initWidgetIconMap();
        ReportUtils.initBtnIconMap();
        FormOperator formOperator = (FormOperator)StableFactory.getMarkedInstanceObjectFromClass((String)"FormOperator", FormOperator.class);
        if (formOperator != null) {
            widgetIconMap.putAll(formOperator.getFormIconMap());
        }
        widgetIconMap.put(SetPrinterOffset.class, BaseUtils.readIcon((String)"/com/fr/web/images/pianyi.png"));
    }

    private static void initWidgetIconMap() {
        if (StableFactory.getMarkedClass((String)"SubmitButton", Widget.class) != null) {
            widgetIconMap.put(StableFactory.getMarkedClass((String)"SubmitButton", Widget.class), BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/preview_16.png"));
        }
        widgetIconMap.put(Button.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/button_16.png"));
        widgetIconMap.put(TextEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/text_field_16.png"));
        widgetIconMap.put(DateEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/date_16.png"));
        widgetIconMap.put(TreeEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/tree_16.png"));
        widgetIconMap.put(TreeComboBoxEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/comboboxtree.png"));
        widgetIconMap.put(CheckBoxGroup.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/checkbox_group_16.png"));
        widgetIconMap.put(RadioGroup.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/button_group_16.png"));
        widgetIconMap.put(NumberEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/number_field_16.png"));
        widgetIconMap.put(Label.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/label_16.png"));
        widgetIconMap.put(FreeButton.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/button_16.png"));
        widgetIconMap.put(FileEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/file_up.png"));
        widgetIconMap.put(MultiFileEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/files_up.png"));
        widgetIconMap.put(ComboBox.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/combo_box_16.png"));
        widgetIconMap.put(ComboCheckBox.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/combo_check_16.png"));
        widgetIconMap.put(CheckBox.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/check_box_16.png"));
        widgetIconMap.put(ListEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/list_16.png"));
        widgetIconMap.put(TableTree.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/list_16.png"));
        widgetIconMap.put(Password.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/password_field_16.png"));
        widgetIconMap.put(TextArea.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/text_area_16.png"));
        widgetIconMap.put(IframeEditor.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/iframe_16.png"));
        widgetIconMap.put(Radio.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/radio_button_16.png"));
    }

    private static void initBtnIconMap() {
        widgetIconMap.put(Submit.class, BaseUtils.readIcon((String)"/com/fr/web/images/submit.png"));
        widgetIconMap.put(FlashPrint.class, BaseUtils.readIcon((String)"/com/fr/web/images/flashPrint.png"));
        widgetIconMap.put(AppletPrint.class, BaseUtils.readIcon((String)"/com/fr/web/images/appletPrint.png"));
        widgetIconMap.put(PDF.class, BaseUtils.readIcon((String)"/com/fr/web/images/pdf.png"));
        widgetIconMap.put(PDFPrint.class, BaseUtils.readIcon((String)"/com/fr/web/images/pdfPrint.png"));
        widgetIconMap.put(ServerPrint.class, BaseUtils.readIcon((String)"/com/fr/web/images/serverPrint.png"));
        widgetIconMap.put(Email.class, BaseUtils.readIcon((String)"/com/fr/web/images/email.png"));
        widgetIconMap.put(Excel.class, BaseUtils.readIcon((String)"/com/fr/web/images/excel.png"));
        widgetIconMap.put(ExcelO.class, BaseUtils.readIcon((String)"/com/fr/web/images/excel.png"));
        widgetIconMap.put(ExcelS.class, BaseUtils.readIcon((String)"/com/fr/web/images/excel.png"));
        widgetIconMap.put(ExcelL.class, BaseUtils.readIcon((String)"/com/fr/web/images/excel.png"));
        widgetIconMap.put(Word.class, BaseUtils.readIcon((String)"/com/fr/web/images/word.png"));
        widgetIconMap.put(PageSetup.class, BaseUtils.readIcon((String)"/com/fr/web/images/pageSetup.png"));
        widgetIconMap.put(Export.class, BaseUtils.readIcon((String)"/com/fr/web/images/export.png"));
        widgetIconMap.put(PageNavi.class, BaseUtils.readIcon((String)"/com/fr/web/images/pageNumber.png"));
        widgetIconMap.put(First.class, BaseUtils.readIcon((String)"/com/fr/web/images/first.png"));
        widgetIconMap.put(Last.class, BaseUtils.readIcon((String)"/com/fr/web/images/last.png"));
        widgetIconMap.put(Previous.class, BaseUtils.readIcon((String)"/com/fr/web/images/previous.png"));
        widgetIconMap.put(Next.class, BaseUtils.readIcon((String)"/com/fr/web/images/next.png"));
        widgetIconMap.put(Scale.class, BaseUtils.readIcon((String)"/com/fr/web/images/scale.png"));
        widgetIconMap.put(Print.class, BaseUtils.readIcon((String)"/com/fr/web/images/print.png"));
        widgetIconMap.put(AppendColumnRow.class, BaseUtils.readIcon((String)"/com/fr/web/images/appendRow.png"));
        widgetIconMap.put(DeleteColumnRow.class, BaseUtils.readIcon((String)"/com/fr/web/images/deleteRow.png"));
        widgetIconMap.put(Verify.class, BaseUtils.readIcon((String)"/com/fr/web/images/verify.gif"));
        widgetIconMap.put(SubmitForcibly.class, BaseUtils.readIcon((String)"/com/fr/web/images/save2.png"));
        widgetIconMap.put(ShowCellValue.class, BaseUtils.readIcon((String)"/com/fr/web/images/showValue.png"));
        widgetIconMap.put(ImportExcelData.class, BaseUtils.readIcon((String)"/com/fr/web/images/excel.png"));
        widgetIconMap.put(PrintPreview.class, BaseUtils.readIcon((String)"/com/fr/web/images/preview.png"));
        widgetIconMap.put(Edit.class, BaseUtils.readIcon((String)"/com/fr/web/images/edit.png"));
        widgetIconMap.put(CustomToolBarButton.class, BaseUtils.readIcon((String)"/com/fr/web/images/custom_widget.png"));
        widgetIconMap.put(Table.class, BaseUtils.readIcon((String)"/com/fr/web/images/form/resources/layout_grid.png"));
    }

    public static Icon createWidgetIcon(Class clazz) {
        ReportUtils.initIconMap();
        Icon icon = (Icon)widgetIconMap.get(clazz);
        if (icon == null) {
            icon = BaseUtils.readIcon((String)"com/fr/web/images/custom_widget.png");
        }
        return icon;
    }

    public static Rectangle intersection(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (n2 < n6) {
            n2 = n6;
        }
        if (n4 < n8) {
            n4 = n8;
        }
        if (n3 > n7) {
            n3 = n7;
        }
        if (n5 > n9) {
            n5 = n9;
        }
        n5 -= n4;
        if ((n3 -= n2) < Integer.MIN_VALUE) {
            n3 = Integer.MIN_VALUE;
        }
        if (n5 < Integer.MIN_VALUE) {
            n5 = Integer.MIN_VALUE;
        }
        return new Rectangle(n2, n4, n3, n5);
    }

    public static ToolBarManager[] getToolBarFromWorkBook(FineBook fineBook, int n2) {
        ToolBarManager[] toolBarManagerArray = null;
        if (fineBook != null) {
            toolBarManagerArray = ReportUtils.getToolBarFromWebAttr(fineBook.getReportWebAttr(), n2);
        }
        if (toolBarManagerArray == null) {
            toolBarManagerArray = ReportUtils.getToolBarFromWebAttr((ReportWebAttr)ConfigManager.getProviderInstance().getGlobalAttribute(ReportWebAttr.class), n2);
        }
        return toolBarManagerArray;
    }

    private static ToolBarManager[] getToolBarFromWebAttr(ReportWebAttr reportWebAttr, int n2) {
        ToolBarManager[] toolBarManagerArray = null;
        if (reportWebAttr != null) {
            switch (n2) {
                case 1: {
                    WebWrite webWrite = reportWebAttr.getWebWrite();
                    if (webWrite == null) break;
                    toolBarManagerArray = webWrite.getToolBarManagers();
                    break;
                }
                case 2: {
                    WebView webView = reportWebAttr.getWebView();
                    if (webView == null) break;
                    toolBarManagerArray = webView.getToolBarManagers();
                    break;
                }
                default: {
                    WebPage webPage = reportWebAttr.getWebPage();
                    if (webPage == null) break;
                    toolBarManagerArray = webPage.getToolBarManagers();
                }
            }
        }
        return toolBarManagerArray;
    }

    public static List<PaperSettingProvider> getPaperSettingListFromWorkBook(FineBook fineBook, float[] fArray) {
        if (fineBook == null) {
            return null;
        }
        ArrayList<PaperSettingProvider> arrayList = new ArrayList<PaperSettingProvider>();
        for (int i2 = 0; i2 < fineBook.getReportCount(); ++i2) {
            ReportSettingsProvider reportSettingsProvider = fineBook.getReport(i2).getReportSettings();
            if (reportSettingsProvider == null) {
                reportSettingsProvider = ReportSettings.DEFAULTSETTINGS;
            }
            try {
                MM mM;
                PaperSettingProvider paperSettingProvider = (PaperSettingProvider)reportSettingsProvider.getPaperSetting().clone();
                Margin margin = paperSettingProvider.getMargin();
                if (fArray[1] != 0.0f) {
                    mM = new MM(fArray[1]);
                    margin.setTop((UNIT)margin.getTop().add((UNIT)mM));
                    margin.setBottom((UNIT)margin.getBottom().subtract((UNIT)mM));
                }
                if (fArray[0] != 0.0f) {
                    mM = new MM(fArray[0]);
                    margin.setLeft((UNIT)margin.getLeft().add((UNIT)mM));
                    margin.setRight((UNIT)margin.getRight().subtract((UNIT)mM));
                }
                arrayList.add(paperSettingProvider);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage(), (Throwable)cloneNotSupportedException);
                break;
            }
        }
        return arrayList;
    }

    public static List<PaperSettingProvider> getPaperSettingListFromWorkBook(FineBook fineBook) {
        return ReportUtils.getPaperSettingListFromWorkBook(fineBook, new float[2]);
    }

    public static Background getBrowserBackgroundFromWorkBook(FineBook fineBook) {
        ReportWebAttr reportWebAttr;
        Background background = null;
        if (fineBook != null && (reportWebAttr = fineBook.getReportWebAttr()) != null) {
            background = reportWebAttr.getBackground();
        }
        if (background == null && (reportWebAttr = (ReportWebAttr)ConfigManager.getProviderInstance().getGlobalAttribute(ReportWebAttr.class)) != null) {
            background = reportWebAttr.getBackground();
        }
        return background;
    }

    public static Printer getPrinterFromWorkBook(FineBook fineBook) {
        ReportWebAttr reportWebAttr;
        Printer printer = null;
        if (fineBook != null && (reportWebAttr = fineBook.getReportWebAttr()) != null) {
            printer = reportWebAttr.getPrinter();
        }
        if (printer == null && (reportWebAttr = (ReportWebAttr)ConfigManager.getProviderInstance().getGlobalAttribute(ReportWebAttr.class)) != null) {
            printer = reportWebAttr.getPrinter();
        }
        return printer;
    }

    public static ReportSettingsProvider getReportSettings(Report report) {
        if (report == null) {
            return new ReportSettings();
        }
        ReportSettingsProvider reportSettingsProvider = report.getReportSettings();
        if (reportSettingsProvider == null) {
            reportSettingsProvider = new ReportSettings();
            report.setReportSettings(reportSettingsProvider);
        }
        return reportSettingsProvider;
    }

    public static boolean hasLayerReport4Template(FineBook fineBook) {
        if (fineBook == null) {
            return false;
        }
        for (int i2 = 0; i2 < fineBook.getReportCount(); ++i2) {
            Report report = fineBook.getReport(i2);
            if (!(report instanceof WorkSheet) || ((WorkSheet)report).getLayerReportAttr() == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isLayerReportUsable(WorkSheet workSheet) {
        if (workSheet == null) {
            return false;
        }
        if (workSheet.floatIterator().hasNext()) {
            return false;
        }
        Iterator iterator = workSheet.cellIterator();
        String string = null;
        while (iterator.hasNext()) {
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            if (templateCellElement.getValue() instanceof BaseChartCollection) {
                return false;
            }
            if (templateCellElement.getValue() instanceof SubReport) {
                return false;
            }
            if (templateCellElement.getValue() instanceof DSColumn) {
                DSColumn dSColumn = (DSColumn)((Object)templateCellElement.getValue());
                if (string == null) {
                    string = dSColumn.getDSName();
                } else if (!ComparatorUtils.equals((String)string, (String)dSColumn.getDSName())) {
                    return false;
                }
                if (dSColumn.getCondition() != null) {
                    if (dSColumn.getCondition() instanceof ListCondition && ((ListCondition)dSColumn.getCondition()).getJoinConditionCount() > 0) {
                        return false;
                    }
                    if (dSColumn.getCondition() instanceof FormulaCondition || dSColumn.getCondition() instanceof CommonCondition) {
                        return false;
                    }
                }
            }
            if (templateCellElement.getCellExpandAttr() != null && templateCellElement.getCellExpandAttr().getDirection() == 1) {
                return false;
            }
            if (templateCellElement.getWidget() == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isWebPageViewAtCenter(ReportWebAttr reportWebAttr) {
        WebPage webPage = ReportUtils.getWebPageFromReportOrGlobal(reportWebAttr);
        return webPage == null ? true : webPage.isViewAtCenter();
    }

    public static boolean isWebPagePaintModel(ReportWebAttr reportWebAttr) {
        WebPage webPage = ReportUtils.getWebPageFromReportOrGlobal(reportWebAttr);
        return webPage == null ? false : webPage.isShowAsImage();
    }

    public static boolean isWebPageTDHeavy(ReportWebAttr reportWebAttr) {
        WebPage webPage = ReportUtils.getWebPageFromReportOrGlobal(reportWebAttr);
        return webPage == null ? false : webPage.isTDHeavy();
    }

    private static WebPage getWebPageFromReportOrGlobal(ReportWebAttr reportWebAttr) {
        if (reportWebAttr != null && reportWebAttr.getWebPage() != null) {
            return reportWebAttr.getWebPage();
        }
        if (ConfigManager.getProviderInstance().getGlobalAttribute(ReportWebAttr.class) != null && ((ReportWebAttr)ConfigManager.getProviderInstance().getGlobalAttribute(ReportWebAttr.class)).getWebPage() != null) {
            return ((ReportWebAttr)ConfigManager.getProviderInstance().getGlobalAttribute(ReportWebAttr.class)).getWebPage();
        }
        return null;
    }

    public static UNIT getPaperWidth(PaperSettingProvider paperSettingProvider) {
        if (paperSettingProvider != null) {
            PaperSize paperSize = paperSettingProvider.getPaperSize();
            if (paperSettingProvider.getOrientation() == 1) {
                return paperSize.getHeight();
            }
            return paperSize.getWidth();
        }
        return UNIT.ZERO;
    }

    public static UNIT getPaperHeight(PaperSettingProvider paperSettingProvider) {
        if (paperSettingProvider != null) {
            PaperSize paperSize = paperSettingProvider.getPaperSize();
            if (paperSettingProvider.getOrientation() == 1) {
                return paperSize.getWidth();
            }
            return paperSize.getHeight();
        }
        return UNIT.ZERO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject tableDataToFlexgridObject4WebPreview(TableData tableData, int n2) throws Exception {
        DataModel dataModel;
        Tag tag = new Tag("table");
        tag.cls("frflex");
        JSONArray jSONArray = new JSONArray();
        if (tableData != null) {
            dataModel = null;
            try {
                EmbeddedTableData embeddedTableData = EmbeddedTableData.embedify((TableData)tableData, null, (int)n2);
                dataModel = embeddedTableData.createDataModel(null);
                int n3 = dataModel.getColumnCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    JSONObject jSONObject = new JSONObject();
                    String string = dataModel.getColumnName(i2);
                    jSONObject.put("display", (Object)string).put("name", (Object)string).put("sortable", (Object)"true").put("align", (Object)"center").put("width", 100);
                    jSONArray.put((Object)jSONObject);
                }
                Tag tag2 = new Tag("tr");
                int n4 = dataModel.getRowCount();
                for (int i3 = 0; i3 < n4 && i3 < n2; ++i3) {
                    tag2 = new Tag("tr");
                    for (int i4 = 0; i4 < n3; ++i4) {
                        Tag tag3 = new Tag("td");
                        tag3.sub(dataModel.getValueAt(i3, i4).toString());
                        tag2.sub((Html)tag3);
                    }
                    tag.sub((Html)tag2);
                }
            }
            catch (TableDataException tableDataException) {
                jSONArray = ReportUtils.getFlexgridPreviewErrorTitle();
                tag.sub("<tr><td>get data error:" + tableDataException.getMessage() + "<td></tr>");
                FRContext.getLogger().error(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            catch (Exception exception) {
                jSONArray = ReportUtils.getFlexgridPreviewErrorTitle();
                tag.sub("<tr><td>" + exception.getMessage() + "</td></tr>");
                FRContext.getLogger().error(exception.getMessage(), (Throwable)exception);
            }
            finally {
                if (dataModel != null) {
                    dataModel.release();
                }
            }
        } else {
            throw new Exception("tabledata is null");
        }
        dataModel = new JSONObject();
        dataModel.put("colModel", (Object)jSONArray);
        dataModel.put("content", (Object)tag.toHtml());
        return dataModel;
    }

    public static JSONArray getFlexgridPreviewErrorTitle() throws JSONException {
        return new JSONArray().put((Object)new JSONObject().put("display", (Object)"error").put("name", (Object)"error").put("align", (Object)"center").put("width", 420));
    }

    public static List recalculate(Report report, Calculator calculator, Map map, Iterator iterator) {
        return ReportUtils.recalculate(report, calculator, map, iterator, false);
    }

    public static List recalculate(Report report, Calculator calculator, Map map, Iterator iterator, boolean bl) {
        ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create((Map)map);
        calculator.pushNameSpace((NameSpace)parameterMapNameSpace);
        calculator.setAttribute(ScriptUtils.REC_CE_LIST, new LinkedList());
        calculator.setAttribute(ScriptUtils.RES_FM_LIST, new ArrayList());
        calculator.pushNameSpace(ScriptUtils.SIMPLE_CELL_NAMESPACE);
        ArrayList<ResultCellElement> arrayList = new ArrayList<ResultCellElement>();
        while (iterator.hasNext()) {
            ResultCellElement resultCellElement = (ResultCellElement)iterator.next();
            Object object = resultCellElement.getValue();
            if (!(object instanceof ResultFormula)) continue;
            ResultFormula resultFormula = (ResultFormula)object;
            if (bl) {
                calculator.removeNameSpace(ScriptUtils.SIMPLE_CELL_NAMESPACE);
                String string = calculator.exStatement(ColumnRow.valueOf((int)resultCellElement.getColumn(), (int)resultCellElement.getRow()), ((ResultFormula)object).getContent());
                calculator.pushNameSpace(ScriptUtils.SIMPLE_CELL_NAMESPACE);
                resultFormula.setTransferContent(string);
                arrayList.add(resultCellElement);
            } else if (resultFormula.isExecuted()) continue;
            ScriptUtils.executeCellElementResultFormula((CalculatorProvider)calculator, resultFormula, report, report.getBook(), resultCellElement, true);
            resultFormula.setExecuted();
            try {
                ReportUtils.dealLinkCells(report, arrayList, resultCellElement, object, map);
            }
            catch (StackOverflowError stackOverflowError) {
                FRContext.getLogger().error("Death Cycle: " + resultCellElement);
            }
        }
        calculator.removeNameSpace((NameSpace)parameterMapNameSpace);
        calculator.removeNameSpace(ScriptUtils.SIMPLE_CELL_NAMESPACE);
        ScriptUtils.resetResultFormulaState(calculator);
        return arrayList;
    }

    private static void dealLinkCells(Report report, List list, ResultCellElement resultCellElement, Object object, Map map) {
        if (report instanceof CalculatableResWorkSheet) {
            CalculatableResWorkSheet calculatableResWorkSheet = (CalculatableResWorkSheet)report;
            ColumnRow columnRow = ColumnRow.valueOf((int)resultCellElement.getColumn(), (int)resultCellElement.getRow());
            N n2 = calculatableResWorkSheet.getFormulaRelation(columnRow);
            try {
                Set set;
                if (n2 != null && (set = n2.B()) != null && !set.isEmpty()) {
                    list.addAll(calculatableResWorkSheet.fireCellValueChange(columnRow, map));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

