/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cellcase;

import com.fr.cache.list.FRCacheList;
import com.fr.general.ComparatorUtils;
import com.fr.report.cell.Cell;
import com.fr.report.cell.CellElement;
import com.fr.report.cellcase.CellCase;
import com.fr.report.core.ReportUtils;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DefaultCellCase
implements CellCase {
    private List rowList;
    private int columnCount;

    public DefaultCellCase() {
        this(1, 1);
    }

    public DefaultCellCase(int n2, int n3) {
        this.rowList = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.rowList.add(new Row(n3));
        }
        this.columnCount = n3;
    }

    public void toCache(int n2, int n3, boolean bl) {
        if (!(this.rowList instanceof FRCacheList)) {
            List list = this.rowList;
            this.rowList = new FRCacheList(n2, n3, "CE", bl);
            this.rowList.addAll(list);
            list.clear();
        }
    }

    public void releaseCache() {
        if (this.rowList instanceof FRCacheList) {
            this.rowList.clear();
        }
    }

    public Iterator cellIterator() {
        return new CellIterator();
    }

    public Iterator intersect(int n2, int n3, int n4, int n5) {
        return new IntersectIterator(n2, n3, n4, n5);
    }

    public Iterator getColumn(int n2) {
        return new ColumnIterator(n2);
    }

    public int[] getColumns() {
        return new int[0];
    }

    public int getIndexColumn(int n2) {
        return 0;
    }

    public Iterator getRow(int n2) {
        return new RowIterator(n2);
    }

    public int[] getRows() {
        return new int[0];
    }

    public int getIndexRow(int n2) {
        return 0;
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void add(Cell cell, boolean bl) {
        if (cell == null) {
            return;
        }
        int n2 = cell.getRow();
        int n3 = cell.getRowSpan();
        int n4 = cell.getColumn();
        int n5 = cell.getColumnSpan();
        if (n2 < 0 || n3 <= 0 || n4 < 0 || n5 <= 0) {
            return;
        }
        if (bl) {
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    this.removeCell(n4 + i3, n2 + i2);
                }
            }
        }
        this.__nailCellElement(cell);
        this.columnCount = Math.max(this.columnCount, n4 + n5);
    }

    public Cell get(int n2, int n3) {
        if (n3 >= this.rowList.size() || n3 < 0) {
            return null;
        }
        Row row = (Row)this.rowList.get(n3);
        return row.getElement(n2);
    }

    public Cell removeCell(int n2, int n3) {
        Cell cell = this.get(n2, n3);
        if (this.__liftCellElement(cell)) {
            if (cell.getColumn() + cell.getColumnSpan() == this.columnCount) {
                this.recalculateColumnCount();
            }
            if (cell.getRow() + cell.getRowSpan() == this.rowList.size()) {
                this.recalculateRowCount();
            }
            return cell;
        }
        return null;
    }

    public void clear() {
        this.rowList.clear();
        this.columnCount = 0;
    }

    public void insertColumn(int n2) {
        int n3 = this.rowList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Row row = (Row)this.rowList.get(i2);
            for (int i3 = row.width() - 1; i3 >= n2; --i3) {
                Cell cell = row.getElement(i3);
                if (cell == null || cell.getColumn() != i3 || cell.getRow() != i2) continue;
                cell.setColumn(cell.getColumn() + 1);
            }
            Cell cell = row.getElement(n2);
            row.insert(n2);
            if (cell == null || cell.getColumn() >= n2) continue;
            if (cell.getRow() == i2) {
                cell.setColumnSpan(cell.getColumnSpan() + 1);
            }
            row.setElement(n2, cell);
        }
        ++this.columnCount;
    }

    public void insertRow(int n2) {
        Cell cell;
        int n3;
        int n4;
        Row row;
        if (n2 > this.rowList.size()) {
            return;
        }
        for (int i2 = this.rowList.size() - 1; i2 >= n2; --i2) {
            row = (Row)this.rowList.get(i2);
            n4 = row.width();
            for (n3 = 0; n3 < n4; ++n3) {
                cell = row.getElement(n3);
                if (cell == null || cell.getColumn() != n3 || cell.getRow() != i2) continue;
                cell.setRow(cell.getRow() + 1);
            }
        }
        Row row2 = new Row();
        if (n2 < this.rowList.size()) {
            row = (Row)this.rowList.get(n2);
            n4 = row.width();
            for (n3 = 0; n3 < n4; ++n3) {
                cell = row.getElement(n3);
                if (cell == null || cell.getRow() >= n2) continue;
                if (cell.getColumn() == n3) {
                    cell.setRowSpan(cell.getRowSpan() + 1);
                }
                row2.setElement(n3, cell);
            }
        }
        this.rowList.add(n2, row2);
    }

    private static int removeColumnOrRow(int n2, Proxy proxy) {
        if (!proxy.interrupt(n2)) {
            proxy.processByIndex(n2);
            proxy.processByLGIndex(n2);
        }
        return proxy.count;
    }

    public int removeColumn(int n2) {
        return DefaultCellCase.removeColumnOrRow(n2, new REMOVE_COLUMN_PROXY(this));
    }

    public int removeRow(int n2) {
        return DefaultCellCase.removeColumnOrRow(n2, new REMOVE_ROW_PROXY(this));
    }

    public void recalculate() {
        this.recalculateRowCount();
        this.recalculateColumnCount();
    }

    private void recalculateColumnCount() {
        int n2 = 0;
        int n3 = this.rowList.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = Math.max(n2, ((Row)this.rowList.get(i2)).getNotNullWidth());
        }
        this.columnCount = n2;
    }

    private void recalculateRowCount() {
        for (int i2 = this.rowList.size() - 1; i2 >= 0 && ((Row)this.rowList.get(i2)).getNotNullWidth() == 0; --i2) {
            this.rowList.remove(i2);
        }
    }

    private void ensureCapacity(int n2) {
        while (n2 > this.rowList.size()) {
            this.rowList.add(new Row());
        }
    }

    public void __nailCellElement(Cell cell) {
        int n2 = cell.getRow();
        int n3 = cell.getColumn();
        this.ensureCapacity(n2 + cell.getRowSpan());
        int n4 = cell.getRowSpan();
        for (int i2 = 0; i2 < n4; ++i2) {
            Row row = (Row)this.rowList.get(n2 + i2);
            int n5 = cell.getColumnSpan();
            for (int i3 = 0; i3 < n5; ++i3) {
                row.setElement(n3 + i3, cell);
            }
        }
    }

    public boolean __liftCellElement(Cell cell) {
        if (cell == null) {
            return false;
        }
        int n2 = cell.getRow();
        int n3 = cell.getColumn();
        int n4 = this.rowList.size();
        int n5 = cell.getRowSpan();
        for (int i2 = 0; i2 < n5 && n2 + i2 < n4; ++i2) {
            Row row = (Row)this.rowList.get(n2 + i2);
            int n6 = cell.getColumnSpan();
            for (int i3 = 0; i3 < n6; ++i3) {
                if (row.getElement(n3 + i3) != cell) continue;
                row.setElement(n3 + i3, null);
            }
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultCellCase defaultCellCase = (DefaultCellCase)super.clone();
        defaultCellCase.rowList = new ArrayList(this.rowList.size());
        Iterator iterator = this.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement = (CellElement)iterator.next();
            defaultCellCase.__nailCellElement((CellElement)cellElement.clone());
        }
        return defaultCellCase;
    }

    public boolean equals(Object object) {
        return object instanceof DefaultCellCase && ComparatorUtils.equals((Iterator)this.cellIterator(), (Iterator)((DefaultCellCase)object).cellIterator()) && this.columnCount == ((DefaultCellCase)object).columnCount;
    }

    private class RowIterator
    implements Iterator {
        private int rowIndex;
        int current_column = -1;
        int next_column = 0;
        Cell next;

        public RowIterator(int n2) {
            this.rowIndex = n2;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.current_column, this.rowIndex);
        }

        private void findNext() {
            if (this.rowIndex < 0 || this.rowIndex >= DefaultCellCase.this.rowList.size()) {
                return;
            }
            Row row = (Row)DefaultCellCase.this.rowList.get(this.rowIndex);
            while (this.next_column < row.width()) {
                Cell cell = row.getElement(this.next_column);
                this.current_column = this.next_column++;
                if (cell == null || cell.getColumn() != this.current_column || cell.getRow() != this.rowIndex) continue;
                this.next = cell;
                return;
            }
            this.next = null;
        }
    }

    private class ColumnIterator
    implements Iterator {
        private int columnIndex;
        private int current_row = -1;
        private int next_row = 0;
        private Cell next;

        ColumnIterator(int n2) {
            this.columnIndex = n2;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.columnIndex, this.current_row);
        }

        private void findNext() {
            while (this.next_row < DefaultCellCase.this.rowList.size()) {
                Cell cell = ((Row)DefaultCellCase.this.rowList.get(this.next_row)).getElement(this.columnIndex);
                this.current_row = this.next_row++;
                if (cell == null || cell.getColumn() != this.columnIndex || cell.getRow() != this.current_row) continue;
                this.next = cell;
                return;
            }
            this.next = null;
        }
    }

    private class IntersectIterator
    implements Iterator {
        private int columnFrom;
        private int columnTo;
        private int rowFrom;
        private int rowTo;
        private int thisrow;
        private int thiscol;
        private int nextrow;
        private int nextcol;
        Cell next = null;

        private IntersectIterator(int n2, int n3, int n4, int n5) {
            this.columnFrom = Math.max(n2, 0);
            this.columnTo = Math.min(n2 + n4 - 1, DefaultCellCase.this.columnCount - 1);
            this.rowFrom = Math.max(n3, 0);
            this.rowTo = Math.min(n3 + n5 - 1, DefaultCellCase.this.rowList.size() - 1);
            this.thisrow = -1;
            this.thiscol = -1;
            this.nextrow = this.rowFrom;
            this.nextcol = this.columnFrom - 1;
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.thiscol = this.nextcol;
            this.thisrow = this.nextrow;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.thiscol, this.thisrow);
        }

        private void findNext() {
            int n2 = this.nextcol + 1;
            for (int i2 = this.nextrow; i2 <= this.rowTo && DefaultCellCase.this.rowList.size() > i2; ++i2) {
                Row row = (Row)DefaultCellCase.this.rowList.get(i2);
                while (n2 <= this.columnTo) {
                    Cell cell = row.getElement(n2);
                    if (cell != null) {
                        Rectangle rectangle = ReportUtils.intersection(cell.getColumn(), cell.getColumn() + cell.getColumnSpan(), cell.getRow(), cell.getRow() + cell.getRowSpan(), this.columnFrom, this.columnTo + 1, this.rowFrom, this.rowTo + 1);
                        if (rectangle.width > 0 && rectangle.height > 0 && rectangle.x == n2 && rectangle.y == i2) {
                            this.nextrow = i2;
                            this.nextcol = n2;
                            this.next = cell;
                            return;
                        }
                    }
                    ++n2;
                }
                n2 = this.columnFrom;
            }
            this.next = null;
        }
    }

    private class CellIterator
    implements Iterator {
        int thisrow = -1;
        int thiscol = -1;
        int nextrow = 0;
        int nextcol = -1;
        Cell next = null;

        CellIterator() {
            this.findNext();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("At last element");
            }
            Cell cell = this.next;
            this.thiscol = this.nextcol;
            this.thisrow = this.nextrow;
            this.findNext();
            return cell;
        }

        public void remove() {
            DefaultCellCase.this.removeCell(this.thiscol, this.thisrow);
        }

        private void findNext() {
            int n2 = this.nextcol + 1;
            for (int i2 = this.nextrow; i2 < DefaultCellCase.this.rowList.size(); ++i2) {
                Row row = (Row)DefaultCellCase.this.rowList.get(i2);
                while (n2 < row.width()) {
                    Cell cell = row.getElement(n2);
                    if (cell != null && cell.getColumn() == n2 && cell.getRow() == i2) {
                        this.nextrow = i2;
                        this.nextcol = n2;
                        this.next = cell;
                        return;
                    }
                    ++n2;
                }
                n2 = 0;
            }
            this.next = null;
        }
    }

    private static class Row
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 4518514222514670793L;
        private Cell[] elementData = null;

        Row() {
        }

        Row(int n2) {
            this.elementData = new Cell[n2];
        }

        public void setElement(int n2, Cell cell) {
            this.ensureCapacity(n2 + 1);
            this.elementData[n2] = cell;
            if (cell == null) {
                this.shrink_array();
            }
        }

        private void shrink_array() {
            int n2;
            for (n2 = this.elementData.length - 1; n2 >= 0 && this.elementData[n2] == null; --n2) {
            }
            if (n2 + 1 < this.width()) {
                Cell[] cellArray = this.elementData;
                this.elementData = new CellElement[n2 + 1];
                System.arraycopy(cellArray, 0, this.elementData, 0, this.elementData.length);
            }
        }

        public void insert(int n2) {
            int n3 = this.width();
            if (n2 >= n3 || n2 < 0) {
                return;
            }
            this.ensureCapacity(n3 + 1);
            System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, n3 - n2);
            this.elementData[n2] = null;
        }

        public Cell getElement(int n2) {
            if (n2 >= this.width() || n2 < 0) {
                return null;
            }
            return this.elementData[n2];
        }

        public void removeColumn(int n2) {
            int n3 = this.width();
            if (n2 >= n3 || n2 < 0) {
                return;
            }
            Cell[] cellArray = this.elementData;
            this.elementData = new CellElement[n3 - 1];
            if (n2 > 0) {
                System.arraycopy(cellArray, 0, this.elementData, 0, n2);
            }
            System.arraycopy(cellArray, n2 + 1, this.elementData, n2, this.elementData.length - n2);
        }

        public int width() {
            return this.elementData == null ? 0 : this.elementData.length;
        }

        public int getNotNullWidth() {
            if (this.elementData == null) {
                return 0;
            }
            for (int i2 = this.elementData.length - 1; i2 >= 0; --i2) {
                if (this.elementData[i2] == null) continue;
                return i2 + 1;
            }
            return 0;
        }

        public String toString() {
            return "size:" + this.width();
        }

        private void ensureCapacity(int n2) {
            if (this.elementData == null) {
                this.elementData = new CellElement[n2];
            } else {
                int n3 = this.elementData.length;
                if (n2 > n3) {
                    Cell[] cellArray = this.elementData;
                    this.elementData = new CellElement[n2];
                    System.arraycopy(cellArray, 0, this.elementData, 0, cellArray.length);
                }
            }
        }
    }

    private static class REMOVE_ROW_PROXY
    extends Proxy {
        public REMOVE_ROW_PROXY(DefaultCellCase defaultCellCase) {
            super(defaultCellCase);
        }

        public boolean interrupt(int n2) {
            return n2 < 0 || n2 >= this.target.rowList.size();
        }

        public void processByIndex(int n2) {
            Row row = (Row)this.target.rowList.get(n2);
            int n3 = row.width();
            for (int i2 = 0; i2 < n3; ++i2) {
                this.processCell(row.getElement(i2), i2, n2);
            }
        }

        public boolean isSpanLargerThan1(Cell cell) {
            return cell.getRowSpan() > 1;
        }

        public void modCellOnSpanLargerThan1(Cell cell) {
            cell.setRow(cell.getRow() + 1);
            cell.setRowSpan(cell.getRowSpan() - 1);
        }

        public boolean isCrossCurrentIndex(Cell cell, int n2, int n3) {
            return cell.getRow() < n3 && cell.getColumn() == n2;
        }

        public void decreaseSpan(Cell cell) {
            cell.setRowSpan(cell.getRowSpan() - 1);
        }

        public void processByLGIndex(int n2) {
            int n3 = this.target.rowList.size();
            for (int i2 = n2 + 1; i2 < n3; ++i2) {
                Row row = (Row)this.target.rowList.get(i2);
                int n4 = row.width();
                for (int i3 = 0; i3 < n4; ++i3) {
                    Cell cell = row.getElement(i3);
                    if (cell == null || cell.getColumn() != i3 || cell.getRow() != i2) continue;
                    cell.setRow(cell.getRow() - 1);
                }
            }
            this.target.rowList.remove(n2);
        }
    }

    private static class REMOVE_COLUMN_PROXY
    extends Proxy {
        public REMOVE_COLUMN_PROXY(DefaultCellCase defaultCellCase) {
            super(defaultCellCase);
        }

        public boolean interrupt(int n2) {
            return n2 < 0 || n2 >= this.target.columnCount;
        }

        public void processByIndex(int n2) {
            int n3 = this.target.rowList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                Row row = (Row)this.target.rowList.get(i2);
                this.processCell(row.getElement(n2), n2, i2);
            }
        }

        public boolean isSpanLargerThan1(Cell cell) {
            return cell.getColumnSpan() > 1;
        }

        public void modCellOnSpanLargerThan1(Cell cell) {
            cell.setColumn(cell.getColumn() + 1);
            cell.setColumnSpan(cell.getColumnSpan() - 1);
        }

        public boolean isCrossCurrentIndex(Cell cell, int n2, int n3) {
            return cell.getColumn() < n2 && cell.getRow() == n3;
        }

        public void decreaseSpan(Cell cell) {
            cell.setColumnSpan(cell.getColumnSpan() - 1);
        }

        public void processByLGIndex(int n2) {
            int n3;
            int n4 = this.target.rowList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                Row row = (Row)this.target.rowList.get(n3);
                int n5 = row.width();
                for (int i2 = n2 + 1; i2 < n5; ++i2) {
                    Cell cell = row.getElement(i2);
                    if (cell == null || cell.getColumn() != i2 || cell.getRow() != n3) continue;
                    cell.setColumn(cell.getColumn() - 1);
                }
            }
            n4 = this.target.rowList.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((Row)this.target.rowList.get(n3)).removeColumn(n2);
            }
            this.target.columnCount--;
        }
    }

    private static abstract class Proxy
    implements Serializable {
        protected DefaultCellCase target;
        protected int count = 0;

        protected Proxy(DefaultCellCase defaultCellCase) {
            this.target = defaultCellCase;
        }

        protected abstract boolean interrupt(int var1);

        protected abstract void processByIndex(int var1);

        protected void processCell(Cell cell, int n2, int n3) {
            if (cell == null) {
                return;
            }
            if (cell.getColumn() == n2 && cell.getRow() == n3) {
                this.target.__liftCellElement(cell);
                if (this.isSpanLargerThan1(cell)) {
                    this.modCellOnSpanLargerThan1(cell);
                    this.target.__nailCellElement(cell);
                } else {
                    ++this.count;
                }
            } else if (this.isCrossCurrentIndex(cell, n2, n3)) {
                this.decreaseSpan(cell);
            }
        }

        protected abstract boolean isSpanLargerThan1(Cell var1);

        protected abstract void modCellOnSpanLargerThan1(Cell var1);

        protected abstract boolean isCrossCurrentIndex(Cell var1, int var2, int var3);

        protected abstract void decreaseSpan(Cell var1);

        protected abstract void processByLGIndex(int var1);
    }
}

