/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.cellattr.highlight;

import com.fr.cache.list.IntList;
import com.fr.general.ComparatorUtils;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.report.ExtraReportClassManager;
import com.fr.report.cell.CellElement;
import com.fr.report.cell.cellattr.highlight.Highlight;
import com.fr.report.fun.PageCalObjectProcessor;
import com.fr.script.Calculator;
import com.fr.stable.ColumnRow;
import com.fr.stable.DependenceProvider;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.script.ExTool;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import com.fr.xml.ReportXMLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HighlightGroup
implements XMLable,
DependenceProvider {
    private Highlight[] highlight_array = null;

    public HighlightGroup() {
    }

    public HighlightGroup(Highlight[] highlightArray) {
        this.highlight_array = highlightArray;
    }

    public int size() {
        return this.highlight_array == null ? 0 : this.highlight_array.length;
    }

    public Highlight getHighlight(int n2) {
        return this.highlight_array[n2];
    }

    public String[] dependence(CalculatorProvider calculatorProvider) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < this.size(); ++i2) {
            Highlight highlight = this.getHighlight(i2);
            arrayList.addAll(Arrays.asList(highlight.dependence(calculatorProvider)));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void execute(CellElement cellElement, Calculator calculator) {
        int n2;
        IntList intList = new IntList();
        for (n2 = 0; n2 < this.size(); ++n2) {
            if (!this.getHighlight(n2).eval(cellElement, calculator)) continue;
            intList.add(n2);
        }
        for (n2 = 0; n2 < intList.size(); ++n2) {
            this.getHighlight(intList.get(n2)).action(cellElement, calculator);
        }
        PageCalObjectProcessor pageCalObjectProcessor = (PageCalObjectProcessor)ExtraReportClassManager.getInstance().getSingle("PageCalObjectProcessor");
        if (pageCalObjectProcessor != null) {
            pageCalObjectProcessor.collectPageCalHighlight(cellElement, calculator, this);
        }
    }

    public void analyzeCorrelative(CalculatorProvider calculatorProvider, ExTool exTool, ColumnRow columnRow) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.getHighlight(i2).analyzeCorrelative(calculatorProvider, exTool, columnRow);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HighlightGroup highlightGroup = (HighlightGroup)super.clone();
        if (this.highlight_array != null) {
            highlightGroup.highlight_array = new Highlight[this.highlight_array.length];
            for (int i2 = 0; i2 < highlightGroup.highlight_array.length; ++i2) {
                highlightGroup.highlight_array[i2] = (Highlight)this.getHighlight(i2).clone();
            }
        }
        return highlightGroup;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.size() == 0) {
            return;
        }
        xMLPrintWriter.startTAG("HighlightList");
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Highlight highlight = this.getHighlight(i2);
            GeneralXMLTools.writeXMLable((XMLPrintWriter)xMLPrintWriter, (XMLable)highlight, (String)"Highlight");
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            ArrayList arrayList = new ArrayList();
            xMLableReader.readXMLObject((XMLReadable)new XMLObject(arrayList){

                public void readXML(XMLableReader xMLableReader) {
                    Highlight highlight;
                    if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("Highlight") && (highlight = ReportXMLUtils.readHighlight(xMLableReader)) != null) {
                        ((List)this.getObject()).add(highlight);
                    }
                }
            });
            this.highlight_array = arrayList.isEmpty() ? null : arrayList.toArray(new Highlight[arrayList.size()]);
        }
    }

    public boolean equals(Object object) {
        return object instanceof HighlightGroup && ComparatorUtils.equals((Object[])this.highlight_array, (Object[])((HighlightGroup)object).highlight_array);
    }
}

