/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import netscape.security.PrivilegeManager;

public class IfxSmBlob
extends IfxBaseType {
    private static final short TYPE_IS_BYTE = 0;
    private static final short TYPE_IS_TEXT = 1;
    private static final short TYPE_IS_BLOB = 2;
    private static final short TYPE_IS_CLOB = 3;
    protected static final short BLOB_BUFFER_SIZE = 1024;
    protected static final short LO_READ = 0;
    protected static final short LO_WRITE = 2;
    protected static final short R_W_BUFSIZE = 32000;
    protected static final short FILE_OPEN = 0;
    protected static final short FILE_CLOSE = 1;
    protected static final short FILE_READ = 2;
    protected static final short FILE_WRITE = 3;
    protected static final int LO_O_EXCL = 1;
    protected static final int LO_O_APPEND = 2;
    protected static final int LO_O_TRUNC = 4;
    protected static final int LO_O_RDWR = 8;
    protected static final int LO_O_RDONLY = 16;
    protected static final int LO_O_WRONLY = 32;
    protected static final int LO_O_BINARY = 64;
    protected static final int LO_O_TEXT = 128;
    protected static final short EIO = 5;
    protected static final short ENOENT = 2;
    protected static final short EBADF = 9;
    protected static final short EACCES = 13;
    protected static final short EEXIST = 17;
    protected static final short ESPIPE = 29;
    private static final short BLOB_TYPE_BYTES = 0;
    private static final short BLOB_TYPE_STREAM = 1;
    protected IfxLocator locator;
    protected int loFd = -1;
    protected long sm_size;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short IfxSmBlobType = (short)2;

    public IfxSmBlob() throws SQLException {
    }

    public IfxSmBlob(IfxConnection ifxConnection, IfxLocator ifxLocator) throws SQLException {
        this.conn = ifxConnection;
        this.locator = ifxLocator;
        this.fromLocator();
    }

    public IfxSmBlob(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
    }

    public IfxSmBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    private void fromLocator() throws SQLException {
        try {
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoOpen(this.locator, 8);
            this.sm_size = ifxSmartBlob.IfxLoSize(this.loFd);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79701, this.conn);
        }
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        super.fromIfx(byArray);
        if (!this.isNull()) {
            byte[] byArray2 = this.inputStream.toByteArray();
            this.locator = new IfxLocator(byArray2);
            this.fromLocator();
            return;
        }
        this.locator = null;
        this.nullify();
    }

    public byte[] toIfx() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfx();
    }

    public byte[] toIfxTuple() throws SQLException {
        this.outputStream.reset();
        if (!this.isNull()) {
            this.outputStream.writeBytes(this.locator.getRawLocator());
        }
        return super.toIfxTuple();
    }

    public InputStream toAsciiStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.locator);
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                IfxInputStream ifxInputStream = new IfxInputStream(this.tempBlobFile);
                return ifxInputStream;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79701, this.conn);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        this.sm_size = n;
        this.BlobInputStream = inputStream;
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
        try {
            IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(this.conn);
            this.locator = new IfxLocator();
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, this.locator);
            if (n > 0) {
                ifxSmartBlob.IfxLoWrite(this.loFd, inputStream, n);
            }
            ifxSmartBlob.IfxLoClose(this.loFd);
            return;
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)3;
    }

    public InputStream toBinaryStream() throws SQLException {
        return this.toAsciiStream();
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        this.fromInputStream(inputStream, n);
        this.IfxSmBlobType = (short)2;
    }

    public String toString() {
        IfxCblob ifxCblob = new IfxCblob(this.conn, this.locator);
        ifxCblob.setSize(this.sm_size);
        return ifxCblob.getSubString(1L, (int)this.sm_size);
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = string.length();
        this.blobBuffer = string.getBytes();
        int n = 0;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
        try {
            IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(this.conn);
            this.locator = new IfxLocator();
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, this.locator);
            if (this.sm_size > 0L) {
                n = ifxSmartBlob.IfxLoWrite(this.loFd, this.blobBuffer);
            }
            ifxSmartBlob.IfxLoClose(this.loFd);
            return;
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public Object toObject() throws SQLException {
        return this.toBytes();
    }

    public byte[] toBytes() throws SQLException {
        IfxBblob ifxBblob = new IfxBblob(this.conn, this.locator);
        ifxBblob.setSize(this.sm_size);
        return ifxBblob.getPortion(1L, this.sm_size);
    }

    public void fromBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.sm_size = 0L;
            this.blobBuffer = null;
            this.nullify();
            return;
        }
        this.sm_size = byArray.length;
        this.blobBuffer = byArray;
        this.unnullify();
        int n = 0;
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        try {
            IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(this.conn);
            this.locator = new IfxLocator();
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            this.loFd = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, this.locator);
            if (this.sm_size > 0L) {
                n = ifxSmartBlob.IfxLoWrite(this.loFd, byArray);
            }
            ifxSmartBlob.IfxLoClose(this.loFd);
            return;
        }
        catch (SQLException sQLException) {
            this.sm_size = 0L;
            this.nullify();
            throw sQLException;
        }
    }

    public void clear() {
        this.nullify();
        this.isBlob_loaded = false;
        this.IfxSmBlobType = (short)2;
        this.blobBuffer = null;
        this.locator = null;
        if (this.tempBlobFile != null) {
            if (System.getProperty("java.vendor").startsWith("Netscape")) {
                try {
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (Exception exception) {}
            }
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {}
        }
        this.tempBlobFile = null;
    }

    protected void finalize() {
        try {
            this.clear();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

