/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDecimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.IfxMap;
import com.informix.util.Trace;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

public abstract class IfxObject {
    protected IfxConnection conn;
    protected boolean isNull = true;
    protected Trace trace;
    protected int ifxType;
    protected String extendedName = "";
    protected String extendedOwner = "";
    protected int extendedID;
    protected int encodedLength;
    protected int sourceType;
    boolean isDistinct = false;
    boolean isNamedRow = false;
    DataTruncation warning;
    protected IfxMap typeMap;
    private static final int MAX_TYPES = 13;
    private static final int NO_SCALE = -1;
    static Hashtable objMap = null;

    IfxObject() throws SQLException {
    }

    IfxObject(Object object) throws SQLException {
        this.fromObject(object);
    }

    private Method findMethod(Object object, int n) throws SQLException {
        if (object == null) {
            throw IfxErrMsg.getSQLException(-79755, this.conn);
        }
        Method method = null;
        try {
            Class[] classArray;
            String string = object.getClass().getName();
            String string2 = "from" + objMap.get(string);
            Class<?> clazz = Class.forName(this.getClass().getName());
            if (n != -1) {
                Class[] classArray2 = new Class[]{object.getClass(), Integer.TYPE};
                classArray = classArray2;
            } else {
                Class[] classArray3;
                classArray = classArray3 = new Class[]{object.getClass()};
            }
            method = clazz.getMethod(string2, classArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return method;
    }

    public void fromObject(Object object) throws SQLException {
        if (object != null) {
            try {
                Method method = this.findMethod(object, -1);
                Object[] objectArray = new Object[]{object};
                method.invoke((Object)this, objectArray);
                return;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        this.isNull = true;
    }

    public void fromObject(Object object, int n) throws SQLException {
        if (object != null) {
            try {
                if (this instanceof IfxDecimal) {
                    Method method = this.findMethod(object, n);
                    Object[] objectArray = new Object[]{object, new Integer(n)};
                    method.invoke((Object)this, objectArray);
                    return;
                }
                this.fromObject(object);
                return;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        this.isNull = true;
    }

    public void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
    }

    void setTypeMap(IfxMap ifxMap) {
        this.typeMap = ifxMap;
    }

    public final boolean isNull() {
        return this.isNull;
    }

    public final void nullify() {
        this.isNull = true;
    }

    public final void unnullify() {
        this.isNull = false;
    }

    void setIfxType(int n) throws SQLException {
        this.ifxType = n;
    }

    int getIfxType() {
        return this.ifxType;
    }

    void setExtendedTypeName(String string) {
        this.extendedName = string;
    }

    String getExtendedTypeName() {
        return this.extendedName;
    }

    void setExtendedOwner(String string) {
        this.extendedOwner = string;
    }

    String getExtendedOwner() {
        return this.extendedOwner;
    }

    void setExtendedId(int n) {
        this.extendedID = n;
    }

    int getExtendedId() {
        return this.extendedID;
    }

    void setSourceType(int n) {
        this.sourceType = n;
    }

    int getSourceType() {
        return this.sourceType;
    }

    public void clear() {
        this.isNull = true;
    }

    public short getEncodedLength() {
        return (short)this.encodedLength;
    }

    void setEncodedLength(int n) {
        this.encodedLength = n;
    }

    public DataTruncation getWarning() {
        return this.warning;
    }

    public void clearWarning() {
        this.warning = null;
    }

    void setTrace(Trace trace) {
        this.trace = trace;
    }

    void writeTrace(int n, String string) {
    }

    void writeTrace(int n, byte[] byArray, char c) {
    }

    public boolean equals(Object object) {
        if (this.isNull || object == null) {
            return false;
        }
        return object instanceof IfxObject;
    }

    public String toString() {
        if (this.isNull) {
            return "NULL";
        }
        return super.toString();
    }

    public int toInt() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80008, this.conn);
    }

    public BigDecimal toDecimal() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80014, this.conn);
    }

    public byte toByte() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80015, this.conn);
    }

    public byte[] toBytes() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80016, this.conn);
    }

    public boolean toBoolean() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80018, this.conn);
    }

    public Date toDate() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80024, this.conn);
    }

    public float toFloat() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80020, this.conn);
    }

    public long toLong() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80010, this.conn);
    }

    public short toShort() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80012, this.conn);
    }

    public Time toTime() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80025, this.conn);
    }

    public double toDouble() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80022, this.conn);
    }

    public Timestamp toTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80026, this.conn);
    }

    public InputStream toInputStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80028, this.conn);
    }

    public InputStream toAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80029, this.conn);
    }

    public InputStream toBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80030, this.conn);
    }

    public byte[] toIfx() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80032, this.conn);
    }

    public byte[] toIfxTuple() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80032, this.conn);
    }

    public Object toObject() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80031, this.conn);
    }

    public Interval toInterval() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80038, this.conn);
    }

    public IntervalYM toIntervalYM() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80036, this.conn);
    }

    public IntervalDF toIntervalDF() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80037, this.conn);
    }

    public void fromIfx(byte[] byArray) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] byArray, short s) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromInt(int n) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80008, this.conn);
    }

    public void fromInt(Integer n) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80009, this.conn);
    }

    public void fromString(String string) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80027, this.conn);
    }

    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80014, this.conn);
    }

    public void fromDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80014, this.conn);
    }

    public void fromByte(byte by) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80015, this.conn);
    }

    public void fromByte(Byte by) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80017, this.conn);
    }

    public void fromBytes(byte[] byArray) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80016, this.conn);
    }

    public void fromBoolean(boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80018, this.conn);
    }

    public void fromBoolean(Boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80019, this.conn);
    }

    public void fromDate(Date date) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80024, this.conn);
    }

    public void fromFloat(float f) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80020, this.conn);
    }

    public void fromFloat(Float f) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80021, this.conn);
    }

    public void fromLong(long l) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80010, this.conn);
    }

    public void fromLong(Long l) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80011, this.conn);
    }

    public void fromShort(short s) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80012, this.conn);
    }

    public void fromShort(Short s) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80013, this.conn);
    }

    public void fromTime(Time time) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80025, this.conn);
    }

    public void fromDouble(double d) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80022, this.conn);
    }

    public void fromDouble(Double d) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80023, this.conn);
    }

    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80026, this.conn);
    }

    public void fromAsciiStream(InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80029, this.conn);
    }

    public void fromBinaryStream(InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80030, this.conn);
    }

    public void fromInputStream(InputStream inputStream, int n) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80028, this.conn);
    }

    public void fromIntervalYM(IntervalYM intervalYM) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80036, this.conn);
    }

    public void fromIntervalDF(IntervalDF intervalDF) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80037, this.conn);
    }

    static {
        if (objMap == null) {
            objMap = new Hashtable(13, 1.0f);
            objMap.put("java.lang.Boolean", "Boolean");
            objMap.put("java.lang.Byte", "Byte");
            objMap.put("java.lang.Short", "Short");
            objMap.put("java.lang.Integer", "Int");
            objMap.put("java.lang.Long", "Long");
            objMap.put("java.lang.Float", "Float");
            objMap.put("java.lang.Double", "Double");
            objMap.put("java.lang.Number", "Double");
            objMap.put("java.lang.String", "String");
            objMap.put("java.math.BigDecimal", "Decimal");
            objMap.put("java.sql.Date", "Date");
            objMap.put("java.sql.Time", "Time");
            objMap.put("java.sql.Timestamp", "Timestamp");
            objMap.put("[B", "Bytes");
            objMap.put("com.informix.lang.IntervalYM", "IntervalYM");
            objMap.put("com.informix.lang.IntervalDF", "IntervalDF");
        }
    }
}

