/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDbMetaDataResultSet;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.mdinfo;
import com.informix.jdbc.rowinfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Stack;
import java.util.Vector;

public class IfxDatabaseMetaData
implements DatabaseMetaData {
    private IfxConnection conn;
    private Trace trace;
    private Stack stmtStack;
    private static int nextTempTableId;
    private static int nMdInfoRows;
    private static int nStdRowTypes;
    private static int nXtdRowTypes;
    private static int nXtdRowTypesSupported;
    private static mdinfo[] lmd;
    private static rowinfo[] lrow;

    private synchronized String nextTempTableName() {
        String string = "dbmd" + nextTempTableId;
        ++nextTempTableId;
        return string;
    }

    IfxDatabaseMetaData(IfxConnection ifxConnection) {
        this.conn = ifxConnection;
        if (this.conn != null) {
            this.trace = this.conn.getTrace();
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        if (this.conn != null) {
            return this.conn.getURL();
        }
        return null;
    }

    public String getUserName() throws SQLException {
        if (this.conn != null) {
            return this.conn.getUserName();
        }
        return null;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return true;
    }

    public String getDatabaseProductName() throws SQLException {
        if (this.conn != null) {
            return this.conn.getDbProductName();
        }
        return "Informix Dynamic Server";
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.conn != null) {
            return this.conn.getDbVersion();
        }
        return null;
    }

    public String getDriverName() throws SQLException {
        return "Informix JDBC Driver for Informix Dynamic Server";
    }

    public String getDriverVersion() throws SQLException {
        return "1.50.JC1";
    }

    public int getDriverMajorVersion() {
        try {
            return IfxDriver.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getDriverMinorVersion() {
        try {
            return IfxDriver.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public boolean usesLocalFiles() throws SQLException {
        return !this.conn.isOnLine();
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return !this.conn.isOnLine();
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (this.conn == null) {
            return false;
        }
        return this.conn.isDelimIdentSet();
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this.conn == null || !this.conn.isDelimIdentSet()) {
            return " ";
        }
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return "after,ansi,append,attach,audit,before,bitmap,buffered,byte,cache,call,cluster,clustersize,codeset,database,datafiles,dataskip,datetime,dba,dbdate,dbmoney,debug,define,delimiter,deluxe,detach,dirty,distributions,document,each,elif,exclusive,exit,explain,express,expression,extend,extent,file,fillfactor,foreach,format,fraction,fragment,gk,hash,high,hold,hybrid,if,index,init,labeleq,labelge,labelgt,labelle,labellt,let,listing,lock,log,low,matches,maxerrors,medium,mode,modify,money,mounting,new,nvarchar,off,old,operational,optical,optimization,page,pdqpriority,pload,private,raise,range,raw,recordend,recover,referencing,rejectfile,release,remainder,rename,reserve,resolution,resource,resume,return,returning,returns,ridlist,robin,rollforward,round,row,rowids,sameas,samples,schedule,scratch,serial,share,skall,skinhibit,skshow,smallfloat,stability,standard,start,static,statistics,stdev,step,sync,synonym,system,temp,text,timeout,trace,trigger,units,unlock,variance,wait,while,xload,xunload";
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,mod,pow,root,round,sqrt,exp,logn,log10,cos,sin,tan,asin,acos,atan,atan2";
    }

    public String getStringFunctions() throws SQLException {
        return "trunc,length";
    }

    public String getSystemFunctions() throws SQLException {
        return "avg,max,min,sum,count,range,stdev,variance,trim,hex,filetoblob,filetoclob,lotofile,lotocopy";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "date,day,month,weekday,year,extend,mdy";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        if (this.conn == null) {
            return "";
        }
        if (this.conn.isLongID()) {
            return "$";
        }
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "user";
    }

    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ":";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 256;
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxIndexLength() throws SQLException {
        return 255;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxRowSize() throws SQLException {
        return Short.MAX_VALUE;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return Short.MAX_VALUE;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 128;
        }
        return 18;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        if (this.conn.isLongID()) {
            return 32;
        }
        return 8;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this.conn == null) {
            return 0;
        }
        int n = this.conn.getDatabaseType();
        if (n == 1) {
            return 4;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (this.conn == null) {
            return false;
        }
        int n2 = this.conn.getDatabaseType();
        return n2 == 1 || n2 == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string2 = string2.toLowerCase();
            string3 = string3.toLowerCase();
        }
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        ifxStatement.setAutoFree(true);
        String string4 = "'" + this.conn.getDbName() + "'";
        String string5 = "select unique " + string4 + " as PROCEDURE_CAT, " + "owner" + " as PROCEDURE_SCHEMA, " + "procname as PROCEDURE_NAME, " + "'' as RESERVED1, " + "'' as RESERVED2, " + "'' as RESERVED3, " + "'' as REMARKS, " + "0 as PROCEDURE_TYPE from informix.sysprocedures where " + "procname like '" + string3 + "' " + "and owner like '" + string2 + "'" + " order by 2, 3";
        ResultSet resultSet = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, this.conn);
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        return null;
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4;
        String string5 = this.nextTempTableName();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl5 = this.conn.getAutoCommit();
        boolean bl6 = this.conn.isANSI();
        if (bl6 && bl5) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length && stringArray[n2] != null) {
                if (stringArray[n2].equalsIgnoreCase("TABLE")) {
                    bl = true;
                    ++n;
                } else if (stringArray[n2].equalsIgnoreCase("VIEW")) {
                    bl2 = true;
                    ++n;
                } else if (stringArray[n2].equalsIgnoreCase("SYNONYM") && bl6) {
                    bl4 = true;
                    ++n;
                } else if (stringArray[n2].equalsIgnoreCase("SYNONYM")) {
                    bl3 = true;
                    ++n;
                }
                ++n2;
            }
        }
        String string6 = "'" + this.conn.getDbName() + "'";
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat    varchar(129), " + "  table_schem  varchar(129), " + "  table_name   varchar(129), " + "  table_type   varchar(129), " + "  remarks      varchar(129)) ");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat    char(18), " + "  table_schem  char(18), " + "  table_name   char(40), " + "  table_type   char(18), " + "  remarks      char(18)) ");
            }
            string4 = "select tabname, tabtype, owner from informix.systables where tabid > 99 ";
            int n3 = n;
            if (n > 0) {
                string4 = String.valueOf(string4) + "and tabtype in (";
            }
            if (bl) {
                string4 = String.valueOf(string4) + "'T'";
                if (--n > 0) {
                    string4 = String.valueOf(string4) + ",";
                }
            }
            if (bl2) {
                string4 = String.valueOf(string4) + "'V'";
                if (--n > 0) {
                    string4 = String.valueOf(string4) + ",";
                }
            }
            if (bl3) {
                string4 = String.valueOf(string4) + "'S'";
                if (--n > 0) {
                    string4 = String.valueOf(string4) + ",";
                }
            }
            if (bl4) {
                string4 = String.valueOf(string4) + "'P'";
            }
            if (n3 > 0) {
                string4 = String.valueOf(string4) + ")";
            }
            if (string3 != null) {
                string4 = String.valueOf(string4) + " and tabname like '" + string3 + "'";
            }
            if (string2 != null) {
                string4 = String.valueOf(string4) + " and owner like " + "'" + string2 + "'";
            }
            ResultSet resultSet = ifxStatement.executeQuery(string4);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                String string7;
                String string8 = resultSet.getString(1);
                String string9 = resultSet.getString(2);
                String string10 = resultSet.getString(3);
                switch (string9.charAt(0)) {
                    case 'T': {
                        string7 = "TABLE";
                        break;
                    }
                    case 'V': {
                        string7 = "VIEW";
                        break;
                    }
                    case 'P': 
                    case 'S': {
                        string7 = "SYNONYM";
                        break;
                    }
                    case 'L': {
                        string7 = "LOG";
                        break;
                    }
                    default: {
                        string7 = "UNKNOWN";
                    }
                }
                ifxStatement2.executeUpdate("insert into " + string5 + " values( " + string6 + ", '" + string10 + "', '" + string8 + "', '" + string7 + "', null )");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl6 && bl5) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl5);
            }
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by 4, 2, 3";
        ResultSet resultSet = bl5 && bl6 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl6 && bl5) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl5);
        }
        string5 = null;
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getSchemas() throws SQLException {
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        ifxStatement.setAutoFree(true);
        String string = "select unique owner as TABLE_SCHEM from informix.systables where tabtype != \"\" order by 1";
        ResultSet resultSet = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? ifxStatement.executeQuery(string, true) : ifxStatement.executeQuery(string, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, this.conn);
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getCatalogs() throws SQLException {
        IfxProtocol ifxProtocol;
        int n = 0;
        if (this.conn == null) {
            return null;
        }
        try {
            Class[] classArray = new Class[]{this.conn.getClass()};
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this.conn};
            ifxProtocol = (IfxProtocol)constructor.newInstance(objectArray);
            if (ifxProtocol == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
        ifxProtocol.executeGetDBList();
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(1, this.conn);
        ifxResultSetMetaData.setEncodedLength(1, 128);
        ifxResultSetMetaData.setNullable(1, false);
        ifxResultSetMetaData.setMaxWidth(1, 128);
        ifxResultSetMetaData.setColtitle(1, "DB Name");
        ifxResultSetMetaData.setColumnName(1, "Database");
        ifxResultSetMetaData.setIfxColumnType(1, 0);
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        Vector vector = ifxProtocol.getDBList();
        n = vector.size();
        if (n > 0) {
            ifxClientResultSet.newRow(n);
            int n2 = 0;
            while (n2 < n) {
                ifxClientResultSet.updateString(n2 + 1, 1, (String)vector.elementAt(n2) != null ? stringUtil.trimTrailings((String)vector.elementAt(n2)) : null);
                ++n2;
            }
            ifxClientResultSet.beforeFirst();
        }
        return ifxClientResultSet;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        ifxStatement.setAutoFree(true);
        String string = this.conn.getDatabaseType() == 1 ? "select unique 'SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'P'" : "select unique 'PRIVATE_SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'P'";
        String string2 = "select unique 'TABLE' as TABLE_TYPE from informix.systables where tabtype = 'T' union select unique 'VIEW' as TABLE_TYPE from informix.systables where tabtype = 'V' union select unique 'SYNONYM' as TABLE_TYPE from informix.systables where tabtype = 'S' union " + string;
        ResultSet resultSet = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? ifxStatement.executeQuery(string2, true) : ifxStatement.executeQuery(string2, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, this.conn);
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string5;
        String string6 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (string4 == null || string4 == "") {
            string4 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string5 = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string6 + "( " + "  table_cat          char(50), " + "  table_schem        char(50), " + "  table_name         char(50), " + "  column_name        char(50), " + "  data_type          smallint, " + "  type_name          char(50), " + "  column_size        integer, " + "  buffer_length      smallint, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  column_def         char(18), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3) )");
            } else {
                ifxStatement.executeUpdate("create temp table " + string6 + "( " + "  table_cat          varchar(129), " + "  table_schem        varchar(129), " + "  table_name         varchar(129), " + "  column_name        varchar(129), " + "  data_type          smallint, " + "  type_name          varchar(129), " + "  column_size        integer, " + "  buffer_length      smallint, " + "  decimal_digits     integer, " + "  num_prec_radix     integer, " + "  nullable           integer, " + "  remarks            char(18), " + "  column_def         char(18), " + "  sql_data_type      integer, " + "  sql_datetime_sub   integer, " + "  char_octet_length  integer, " + "  ordinal_position   integer, " + "  is_nullable        char(3) )");
            }
            if (string3 != null) {
                if (!this.conn.isDelimIdentSet()) {
                    string3 = string3.toLowerCase();
                }
                string3 = string3.trim();
            } else {
                string3 = "*";
            }
            if (string4 != null) {
                if (!this.conn.isDelimIdentSet()) {
                    string4 = string4.toLowerCase();
                }
                string4 = string4.trim();
            } else {
                string4 = "";
            }
            if (!this.conn.isDelimIdentSet()) {
                string2 = string2.toLowerCase();
            }
            object = null;
            object = this.conn.isUSVER() ? "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength,  sc.colmin, sc.colmax, st.owner, sx.name from informix.systables st, informix.syscolumns sc,  outer informix.sysxtdtypes sx where st.tabname like '" + string3 + "' and st.owner like " + "'" + string2 + "' and st.tabid = sc.tabid " + "  and sc.extended_id = sx.extended_id " : (this.conn.isOnLine() ? "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength,  sc.colmin, sc.colmax, st.owner from informix.systables st, informix.syscolumns sc where st.tabname like '" + string3 + "' and st.owner like " + "'" + string2 + "' and st.tabid = sc.tabid " : "select st.tabname, sc.colname,  sc.colno, sc.coltype, sc.collength, st.owner from informix.systables st, informix.syscolumns sc where st.tabname like '" + string3 + "' and st.owner like " + "'" + string2 + "' and st.tabid = sc.tabid ");
            if (string4.length() > 0) {
                object = String.valueOf(object) + " and sc.colname like '" + string4 + "'";
            }
            resultSet = ifxStatement.executeQuery((String)object);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                short s = resultSet.getShort(4);
                short s2 = (short)(s & 0xFF);
                short s3 = resultSet.getShort(5);
                int n = s2 == 5 || s2 == 8 ? s3 / 256 : (int)s3;
                String string7 = this.conn.isOnLine() ? resultSet.getString(8) : resultSet.getString(6);
                String string8 = IfxTypes.IfxTypeToName(s2);
                if (this.conn.isUSVER()) {
                    if (s2 == 41 || s2 == 40) {
                        string8 = resultSet.getString(9);
                    }
                    if ((s & 0x800) == 2048) {
                        string8 = resultSet.getString(9);
                    }
                }
                string8 = string8.trim();
                int n2 = IfxTypes.FromIfxToJDBCType(s2);
                if (this.conn.isUSVER()) {
                    if ((s & 0x800) == 2048) {
                        n2 = 2001;
                    }
                    if (string8.equals("boolean")) {
                        n2 = 1111;
                    } else if (string8.equals("lvarchar")) {
                        n2 = -1;
                    } else if (string8.equals("blob")) {
                        n2 = 2004;
                    } else if (string8.equals("clob")) {
                        n2 = 2005;
                    }
                }
                int n3 = 0;
                int n4 = 0;
                if (s2 == 1 || s2 == 2 || s2 == 6) {
                    n4 = 2;
                    n3 = 10;
                } else if (this.conn.isUSVER() && (s2 == 17 || s2 == 18)) {
                    n3 = 10;
                } else if (s2 == 5 || s2 == 8) {
                    n4 = s3 - s3 / 256 * 256;
                    n3 = 10;
                } else if (s2 == 3) {
                    n4 = 15;
                    n3 = 10;
                } else if (s2 == 4) {
                    n4 = 7;
                    n3 = 10;
                } else if (this.conn.isUSVER() && s2 == 41 && (string8.equals("boolean") || (s & 0x4000) == 16384)) {
                    n3 = 2;
                }
                int n5 = 1;
                String string9 = "YES";
                if ((s & 0x100) == 256) {
                    n5 = 0;
                    string9 = "NO";
                }
                short s4 = 0;
                if (s2 == 0) {
                    s4 = s3;
                }
                ifxStatement2.executeUpdate("insert into " + string6 + " values( " + string5 + ", '" + string7 + "', " + "'" + resultSet.getString(1) + "', '" + resultSet.getString(2) + "'," + n2 + ", '" + string8 + "', " + n + "," + "0," + n4 + "," + n3 + "," + n5 + "," + "null," + "null," + "0," + "0," + s4 + "," + resultSet.getShort(3) + ", '" + string9 + "' )");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string5 = "select * from " + string6 + " order by 2,3,17";
        resultSet = bl && bl2 ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        object = new IfxDbMetaDataResultSet(resultSet, string6, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        return object;
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ResultSet resultSet;
        String string5;
        String string6 = this.nextTempTableName();
        String string7 = "NO";
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (string4 == null || string4 == "") {
            string4 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string5 = "'" + this.conn.getDbName() + "'";
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string6 + "( " + "  table_cat     varchar(129), " + "  table_schem   varchar(129), " + "  table_name    varchar(129), " + "  column_name   varchar(129), " + "  grantor       varchar(129), " + "  grantee       varchar(129), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            } else {
                ifxStatement.executeUpdate("create temp table " + string6 + "( " + "  table_cat     char(50), " + "  table_schem   char(50), " + "  table_name    char(50), " + "  column_name   char(18), " + "  grantor       char(18), " + "  grantee       char(18), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            }
            if (string3 != null && !this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            if (string4 != null && !this.conn.isDelimIdentSet()) {
                string4 = string4.toLowerCase();
            }
            if (string2 != null && !this.conn.isDelimIdentSet()) {
                string2 = string2.toLowerCase();
            }
            resultSet = ifxStatement.executeQuery("select sc.colname, sa.grantor, sa.grantee, sa.colauth, st.tabname, st.owner from informix.systables st, informix.syscolumns sc, informix.syscolauth sa where st.tabname = '" + string3 + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + string4 + "' and sc.colno = sa.colno " + "and st.owner like '" + string2 + "'" + "union " + "select sc.colname, sa.grantor, sa.grantee, sa.tabauth, " + "st.tabname, st.owner from informix.systables st, " + "informix.syscolumns sc, informix.systabauth sa where " + "st.tabname = '" + string3 + "' and st.tabid = sa.tabid and " + "sc.tabid = st.tabid and sc.colname like '" + string4 + "' and st.owner like '" + string2 + "'" + " order by 1");
            String string8 = "";
            String string9 = "";
            while (resultSet.next()) {
                String string10 = string8;
                string8 = resultSet.getString(1);
                String string11 = resultSet.getString(4);
                if (string8 != null) {
                    string8 = string8.trim();
                }
                if (string11 != null) {
                    string11 = string11.trim();
                }
                if (!string8.equals(string10)) {
                    string9 = "";
                }
                int n = 0;
                while (n < string11.length()) {
                    String string12 = null;
                    char c = string11.charAt(n);
                    switch (c) {
                        case 'R': 
                        case 'r': {
                            if (string9.indexOf(c) != -1) break;
                            string9 = String.valueOf(string9) + "r";
                            string12 = "REFERENCES";
                            break;
                        }
                        case 'S': 
                        case 's': {
                            if (string9.indexOf(c) != -1) break;
                            string9 = String.valueOf(string9) + "s";
                            string12 = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            if (string9.indexOf(c) != -1) break;
                            string9 = String.valueOf(string9) + "u";
                            string12 = "UPDATE";
                        }
                    }
                    if (string12 != null) {
                        string7 = Character.isUpperCase(c) ? "YES" : "NO";
                        String string13 = resultSet.getString(2);
                        string13 = resultSet.wasNull() || string13.length() < 1 ? "null" : "'" + string13 + "'";
                        ifxStatement2.executeUpdate("insert into " + string6 + " values( " + string5 + ", '" + resultSet.getString(6) + "', '" + resultSet.getString(5) + "', '" + resultSet.getString(1) + "', " + string13 + ", '" + resultSet.getString(3) + "', '" + string12 + "', '" + string7 + "' )");
                    }
                    ++n;
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string5 = "select * from " + string6 + " order by 4, 7";
        resultSet = bl && bl2 ? ifxStatement.executeQuery(string5, true) : ifxStatement.executeQuery(string5, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, string6, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        String string4;
        String string5 = this.nextTempTableName();
        String string6 = "NO";
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = string2.toLowerCase();
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string4 = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat     varchar(129), " + "  table_schem   varchar(129), " + "  table_name    varchar(129), " + "  grantor       varchar(129), " + "  grantee       varchar(129), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat     char(18), " + "  table_schem   char(18), " + "  table_name    char(40), " + "  grantor       char(18), " + "  grantee       char(18), " + "  privilege     char(20), " + "  is_grantable  char(3) )");
            }
            resultSet = ifxStatement.executeQuery("select st.tabname,  sa.grantor, sa.grantee, sa.tabauth, st.owner from informix.systables st, informix.systabauth sa where st.tabname like '" + string3 + "' and " + "st.tabid = sa.tabid and st.owner like '" + string2 + "'");
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(3);
                String string10 = resultSet.getString(4);
                int n = 0;
                while (n < string10.length()) {
                    String string11 = null;
                    char c = string10.charAt(n);
                    switch (c) {
                        case 'S': 
                        case 's': {
                            string11 = "SELECT";
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            string11 = "UPDATE";
                            break;
                        }
                        case 'I': 
                        case 'i': {
                            string11 = "INSERT";
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            string11 = "DELETE";
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            string11 = "INDEX";
                            break;
                        }
                        case 'A': 
                        case 'a': {
                            string11 = "ALTER";
                            break;
                        }
                        case 'R': 
                        case 'r': {
                            string11 = "REFERENCES";
                            break;
                        }
                        case 'N': 
                        case 'n': {
                            string11 = "UNDER";
                        }
                    }
                    if (string11 != null) {
                        string6 = Character.isUpperCase(c) ? "YES" : "NO";
                        ifxStatement2.executeUpdate("insert into " + string5 + " values( " + string4 + ", '" + resultSet.getString(5) + "', '" + string7 + "', '" + string8 + "', '" + string9 + "', '" + string11 + "', '" + string6 + "' )");
                    }
                    ++n;
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by 3, 6, 4, 5, 7";
        resultSet = bl && bl2 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        ResultSet resultSet;
        String string4;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl2 = this.conn.getAutoCommit();
        boolean bl3 = this.conn.isANSI();
        if (bl3 && bl2) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            String string6;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            if (!this.conn.isDelimIdentSet()) {
                string6 = string3.toLowerCase();
                string2 = string2.toLowerCase();
            } else {
                string6 = string3;
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  scope          smallint, " + "  column_name    varchar(129), " + "  data_type      smallint, " + "  type_name      varchar(129), " + "  column_size    integer, " + "  buffer_length  integer, " + "  decimal_digits smallint, " + "  pseudo_column  smallint )");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  scope          smallint, " + "  column_name    char(18), " + "  data_type      smallint, " + "  type_name      char(18), " + "  column_size    integer, " + "  buffer_length  integer, " + "  decimal_digits smallint, " + "  pseudo_column  smallint )");
            }
            string4 = "select sc.colname, sc.colno, sc.coltype, sc.collength from informix.systables st, informix.sysconstraints so, informix.sysindexes si, informix.syscolumns sc where (st.tabname like '" + string3 + "' or " + "st.tabname like '" + string6 + "' ) and " + "st.tabid = so.tabid and " + "so.constrtype = 'P' and " + "so.idxname = si.idxname and " + "sc.tabid = st.tabid and " + "st.owner like '" + string2 + "' and " + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                string4 = String.valueOf(string4) + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            string4 = String.valueOf(string4) + ")";
            resultSet = ifxStatement.executeQuery(string4);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                String string7 = resultSet.getString(1);
                short s = resultSet.getShort(3);
                short s2 = (short)(s & 0xFF);
                s2 = (short)(s & 0xFF);
                short s3 = (short)IfxTypes.FromIfxToJDBCType(s2);
                ifxStatement2.executeUpdate("insert into " + string5 + " values( " + 2 + ", '" + string7 + "', " + s3 + ", '" + IfxTypes.IfxTypeToName(s2) + "', " + resultSet.getShort(4) + ", " + "0, " + "0, " + 1 + ") ");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl3 && bl2) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl2);
            }
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by scope";
        resultSet = bl2 && bl3 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl3 && bl2) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl2);
        }
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = string2.toLowerCase();
        }
        IfxStatement ifxStatement = (IfxStatement)this.conn.createStatement();
        ifxStatement.setAutoFree(true);
        String string4 = "select '' as SCOPE, c.colname as COLUMN_NAME, c.coltype as DATA_TYPE, '' as TYPE_NAME, '' as COLUMN_SIZE, c.collength as BUFFER_LENGTH, 0 as DECIMAL_DIGITS, 1 as PSEUDO_COLUMN from informix.systables t, informix.syscolumns c where t.tabid = c.tabid and t.owner like '" + string2 + "' " + "and t.tabname like '" + string3 + "' " + "and mod(c.coltype,256) = 6";
        ResultSet resultSet = this.conn.getAutoCommit() && this.conn.getDatabaseType() == 1 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, this.conn);
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        String string6 = null;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string6 = string3.toLowerCase();
            string2 = string2.toLowerCase();
        } else {
            string6 = string3;
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        IfxStatement ifxStatement3 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement3 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            ifxStatement3.setAutoFree(true);
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("  create temp table " + string5 + "( " + "  table_cat      varchar(129), " + "  table_schem    varchar(129), " + "  table_name     varchar(129), " + "  column_name    varchar(129), " + "  key_seq        smallint, " + "  pk_name        varchar(129)) ");
            } else {
                ifxStatement.executeUpdate("  create temp table " + string5 + "( " + "  table_cat      char(18), " + "  table_schem    char(18), " + "  table_name     char(18), " + "  column_name    char(18), " + "  key_seq        smallint, " + "  pk_name        char(18) ) ");
            }
            string4 = "  select   sc.colname,  so.constrname,   st.tabname,   st.owner  from  informix.systables st,  informix.sysconstraints so,  informix.sysindexes si,  informix.syscolumns sc    where   ( st.tabname like '" + string3 + "' or " + "  st.tabname like '" + string6 + "' ) and" + "  st.tabid = so.tabid and" + "  so.constrtype = 'P' and" + "  so.idxname = si.idxname and" + "  sc.tabid = st.tabid and" + "  st.owner like '" + string2 + "' and" + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                string4 = String.valueOf(string4) + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            string4 = String.valueOf(string4) + ")";
            ResultSet resultSet = ifxStatement.executeQuery(string4);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string7 = "";
            int n = 1;
            object = "'" + this.conn.getDbName() + "'";
            while (resultSet.next()) {
                String string8 = resultSet.getString(1);
                String string9 = resultSet.getString(2);
                String string10 = resultSet.getString(3);
                String string11 = resultSet.getString(4);
                if (string8 != null) {
                    string8 = string8.trim();
                }
                if (string9 != null) {
                    string9 = string9.trim();
                }
                if (string10 != null) {
                    string10 = string10.trim();
                }
                if (string11 != null) {
                    string11 = string11.trim();
                }
                n = !string7.equals(string9) ? 1 : (int)((short)(n + 1));
                string7 = string9;
                ifxStatement2.executeUpdate(" insert into " + string5 + " values( " + (String)object + ", '" + string11 + "', '" + string10 + "', '" + string8 + "', " + n + ", '" + string9 + "' )");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string4 = " select table_cat as TABLE_CAT,  table_schem as TABLE_SCHEM,  table_name as TABLE_NAME,  column_name as COLUMN_NAME,  key_seq  as KEY_SEQ,  pk_name as PK_NAME  from " + string5 + " order by column_name";
        ResultSet resultSet = bl && bl2 ? ifxStatement3.executeQuery(string4, true) : ifxStatement3.executeQuery(string4, false);
        object = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        string5 = null;
        return object;
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string4 = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string2 = string2.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string5 + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint);");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            object = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner from informix.systables pt, informix.syscolumns pc, informix.sysindexes pi, informix.sysconstraints pk, informix.systables ft, informix.syscolumns fc, informix.sysindexes fi, informix.sysconstraints fk, informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pt.owner like '" + string2 + "' and " + "(pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or " + "pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or " + "pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or " + "pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or " + "pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or " + "pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or " + "pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or " + "pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8)";
            if (this.conn.isOnLine()) {
                object = String.valueOf(object) + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16))";
            }
            object = String.valueOf(object) + "and ft.owner like '" + string2 + "' " + "and ft.tabname like '" + string3 + "' ;";
            resultSet = ifxStatement.executeQuery((String)object);
            while (resultSet.next()) {
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(4);
                String string10 = resultSet.getString(5);
                String string11 = resultSet.getString(6);
                String string12 = resultSet.getString(7);
                String string13 = resultSet.getString(8);
                String string14 = resultSet.getString(9);
                int n = string13.equals("C") ? 0 : 1;
                ifxStatement2.executeUpdate("insert into " + string5 + " values(" + string4 + ", '" + string14 + "', '" + string6 + "', '" + string7 + "', " + string4 + ", '" + string8 + "', '" + string9 + "', '" + string10 + "', " + "1, 1, " + n + ", '" + string11 + "', '" + string12 + "', " + "7)");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by 1,2,3,9";
        resultSet = bl && bl2 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        return object;
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string4 = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string2 = string2.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string5 + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint);");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            object = "select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner from informix.systables pt, informix.syscolumns pc, informix.sysindexes pi, informix.sysconstraints pk, informix.systables ft, informix.syscolumns fc, informix.sysindexes fi, informix.sysconstraints fk, informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and (pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) or pc.colno=ABS(pi.part2) and fc.colno=ABS(fi.part2) or pc.colno=ABS(pi.part3) and fc.colno=ABS(fi.part3) or pc.colno=ABS(pi.part4) and fc.colno=ABS(fi.part4) or pc.colno=ABS(pi.part5) and fc.colno=ABS(fi.part5) or pc.colno=ABS(pi.part6) and fc.colno=ABS(fi.part6) or pc.colno=ABS(pi.part7) and fc.colno=ABS(fi.part7) or pc.colno=ABS(pi.part8) and fc.colno=ABS(fi.part8) ";
            if (this.conn.isOnLine()) {
                object = String.valueOf(object) + "or pc.colno=ABS(pi.part9) and fc.colno=ABS(fi.part9) or pc.colno=ABS(pi.part10) and fc.colno=ABS(fi.part10) or pc.colno=ABS(pi.part11) and fc.colno=ABS(fi.part11) or pc.colno=ABS(pi.part12) and fc.colno=ABS(fi.part12) or pc.colno=ABS(pi.part13) and fc.colno=ABS(fi.part13) or pc.colno=ABS(pi.part14) and fc.colno=ABS(fi.part14) or pc.colno=ABS(pi.part15) and fc.colno=ABS(fi.part15) or pc.colno=ABS(pi.part16) and fc.colno=ABS(fi.part16)) ";
            }
            object = String.valueOf(object) + "and pt.owner like '" + string2 + "' " + "and pt.tabname like '" + string3 + "' ;";
            resultSet = ifxStatement.executeQuery((String)object);
            while (resultSet.next()) {
                String string6 = resultSet.getString(1);
                String string7 = resultSet.getString(2);
                String string8 = resultSet.getString(3);
                String string9 = resultSet.getString(4);
                String string10 = resultSet.getString(5);
                String string11 = resultSet.getString(6);
                String string12 = resultSet.getString(7);
                String string13 = resultSet.getString(8);
                String string14 = resultSet.getString(9);
                int n = string13.equals("C") ? 0 : 1;
                ifxStatement2.executeUpdate("insert into " + string5 + " values(" + string4 + ", '" + string14 + "', '" + string6 + "', '" + string7 + "', " + string4 + ", '" + string8 + "', '" + string9 + "', '" + string10 + "', " + "1, 1, " + n + ", '" + string11 + "', '" + string12 + "', " + "7)");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by 1,2,3,9";
        resultSet = bl && bl2 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        return object;
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        ResultSet resultSet;
        String string7;
        String string8 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string5 == null || string5 == "") {
            string5 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        if (string6 == null || string6 == "") {
            string6 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            string7 = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                string3 = string3.toLowerCase();
                string6 = string6.toLowerCase();
                string2 = string2.toLowerCase();
                string5 = string5.toLowerCase();
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string8 + "(pktable_cat   varchar(129), " + "pktable_schem  varchar(129), " + "pktable_name   varchar(129), " + "pkcolumn_name  varchar(129), " + "fktable_cat    varchar(129), " + "fktable_schem  varchar(129), " + "fktable_name   varchar(129), " + "fkcolumn_name  varchar(129), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        varchar(129), " + "pk_name        varchar(129), " + "deferrability  smallint);");
            } else {
                ifxStatement.executeUpdate("create temp table " + string8 + "(pktable_cat   char(18), " + "pktable_schem  char(18), " + "pktable_name   char(18), " + "pkcolumn_name  char(18), " + "fktable_cat    char(18), " + "fktable_schem  char(18), " + "fktable_name   char(18), " + "fkcolumn_name  char(18), " + "key_seq        smallint, " + "update_rule    smallint, " + "delete_rule    smallint, " + "fk_name        char(18), " + "pk_name        char(18), " + "deferrability  smallint);");
            }
            resultSet = ifxStatement.executeQuery("select pt.tabname, pc.colname, ft.owner, ft.tabname, fc.colname, fk.constrname, pk.constrname, r.delrule, pt.owner from informix.systables pt, informix.syscolumns pc, informix.sysindexes pi, informix.sysconstraints pk, informix.systables ft, informix.syscolumns fc, informix.sysindexes fi, informix.sysconstraints fk, informix.sysreferences r where pt.tabid=pc.tabid and pc.tabid=pi.tabid and pt.tabid=pk.tabid and pk.constrid=r.primary and r.constrid=fk.constrid and pi.idxname=pk.idxname and fi.idxname=fk.idxname and ft.tabid=fc.tabid and fc.tabid=fi.tabid and ft.tabid=fk.tabid and pc.colno=ABS(pi.part1) and fc.colno=ABS(fi.part1) and pt.owner like '" + string2 + "' " + "and ft.owner like '" + string5 + "' " + "and pt.tabname like '" + string3 + "' " + "and ft.tabname like '" + string6 + "' ;");
            while (resultSet.next()) {
                String string9 = resultSet.getString(1);
                String string10 = resultSet.getString(2);
                String string11 = resultSet.getString(3);
                String string12 = resultSet.getString(4);
                String string13 = resultSet.getString(5);
                String string14 = resultSet.getString(6);
                String string15 = resultSet.getString(7);
                String string16 = resultSet.getString(8);
                String string17 = resultSet.getString(9);
                int n = string16.equals("C") ? 0 : 1;
                ifxStatement2.executeUpdate("insert into " + string8 + " values(" + string7 + ", '" + string17 + "', '" + string9 + "', '" + string10 + "', " + "'', '" + string11 + "', '" + string12 + "', '" + string13 + "', " + "1, 1, " + n + ", '" + string14 + "', '" + string15 + "', " + "7)");
            }
            ifxStatement2.close();
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        string7 = "select * from " + string8 + " order by 1,2,3,9";
        resultSet = bl && bl2 ? ifxStatement.executeQuery(string7, true) : ifxStatement.executeQuery(string7, false);
        IfxDbMetaDataResultSet ifxDbMetaDataResultSet = new IfxDbMetaDataResultSet(resultSet, string8, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl2 && bl) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl);
        }
        return ifxDbMetaDataResultSet;
    }

    public ResultSet getTypeInfo() throws SQLException {
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(lmd.length, this.conn);
        int n = 0;
        while (n < lmd.length) {
            int n2 = n + 1;
            ifxResultSetMetaData.setTableName(n2, "SQL_TYPES");
            ifxResultSetMetaData.setColumnName(n2, IfxDatabaseMetaData.lmd[n].colname);
            ifxResultSetMetaData.setIfxColumnType(n2, IfxDatabaseMetaData.lmd[n].coltype & 0xFF);
            ifxResultSetMetaData.setEncodedLength(n2, IfxDatabaseMetaData.lmd[n].collen);
            ifxResultSetMetaData.setNullable(n2, IfxDatabaseMetaData.lmd[n].nullable);
            ifxResultSetMetaData.setColumnStartPosition(n2, IfxDatabaseMetaData.lmd[n].stpos);
            ++n;
        }
        IfxClientResultSet ifxClientResultSet = new IfxClientResultSet(this.conn, ifxResultSetMetaData);
        int n3 = this.conn.isUSVER() ? nXtdRowTypesSupported : nStdRowTypes;
        ifxClientResultSet.newRow(n3);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4 + 1;
            ifxClientResultSet.updateString(n5, 1, IfxDatabaseMetaData.lrow[n4].tname);
            ifxClientResultSet.updateShort(n5, 2, (short)IfxDatabaseMetaData.lrow[n4].jsqltype);
            ifxClientResultSet.updateInt(n5, 3, IfxDatabaseMetaData.lrow[n4].precision);
            ifxClientResultSet.updateString(n5, 4, IfxDatabaseMetaData.lrow[n4].lprefix);
            ifxClientResultSet.updateString(n5, 5, IfxDatabaseMetaData.lrow[n4].lsuffix);
            ifxClientResultSet.updateString(n5, 6, IfxDatabaseMetaData.lrow[n4].cparams);
            ifxClientResultSet.updateShort(n5, 7, (short)IfxDatabaseMetaData.lrow[n4].nullable);
            ifxClientResultSet.updateBoolean(n5, 8, IfxDatabaseMetaData.lrow[n4].casesen);
            ifxClientResultSet.updateShort(n5, 9, (short)IfxDatabaseMetaData.lrow[n4].searchable);
            ifxClientResultSet.updateBoolean(n5, 10, IfxDatabaseMetaData.lrow[n4].unsign);
            ifxClientResultSet.updateBoolean(n5, 11, IfxDatabaseMetaData.lrow[n4].money);
            ifxClientResultSet.updateBoolean(n5, 12, IfxDatabaseMetaData.lrow[n4].autoincrement);
            ifxClientResultSet.updateString(n5, 13, IfxDatabaseMetaData.lrow[n4].ltname);
            ifxClientResultSet.updateShort(n5, 14, (short)IfxDatabaseMetaData.lrow[n4].minscale);
            ifxClientResultSet.updateShort(n5, 15, (short)IfxDatabaseMetaData.lrow[n4].maxscale);
            ifxClientResultSet.updateInt(n5, 16, IfxDatabaseMetaData.lrow[n4].sqldatatype);
            ifxClientResultSet.updateInt(n5, 17, IfxDatabaseMetaData.lrow[n4].sqldatetime);
            ifxClientResultSet.updateInt(n5, 18, IfxDatabaseMetaData.lrow[n4].numradix);
            ++n4;
        }
        ifxClientResultSet.beforeFirst();
        return ifxClientResultSet;
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        ResultSet resultSet;
        Object object;
        String string4;
        String string5 = this.nextTempTableName();
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isDbOpen()) {
            return null;
        }
        boolean bl3 = this.conn.getAutoCommit();
        boolean bl4 = this.conn.isANSI();
        if (bl4 && bl3) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2 == "") {
            string2 = "%";
        }
        if (string3 == null || string3 == "") {
            string3 = "%";
        }
        IfxStatement ifxStatement = null;
        IfxStatement ifxStatement2 = null;
        try {
            String string6;
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement2 = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            ifxStatement2.setAutoFree(true);
            string4 = "'" + this.conn.getDbName() + "'";
            if (!this.conn.isDelimIdentSet()) {
                string6 = string3.toLowerCase();
                string2 = string2.toLowerCase();
            } else {
                string6 = string3;
            }
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat        varchar(129), " + "  table_schem      varchar(129), " + "  table_name       varchar(129), " + "  non_unique       smallint, " + "  index_qualifier  varchar(129), " + "  index_name       varchar(129), " + "  type             smallint, " + "  ordinal_position smallint, " + "  column_name      varchar(129), " + "  asc_or_desc      char(1), " + "  cardinality      integer, " + "  pages            integer, " + "  filer_condition  varchar(129) )");
            } else {
                ifxStatement.executeUpdate("create temp table " + string5 + "( " + "  table_cat        char(18), " + "  table_schem      char(18), " + "  table_name       char(18), " + "  non_unique       smallint, " + "  index_qualifier  char(18), " + "  index_name       char(18), " + "  type             smallint, " + "  ordinal_position smallint, " + "  column_name      char(18), " + "  asc_or_desc      char(1), " + "  cardinality      integer, " + "  pages            integer, " + "  filer_condition  char(18) )");
            }
            object = "select sc.colname, si.idxname, si.clustered, si.idxtype, st.tabname, st.owner from informix.systables st, informix.sysindexes si, informix.syscolumns sc where (st.tabname like '" + string3 + "' or st.tabname like '" + string6 + "') and " + "st.tabid = si.tabid and " + "sc.tabid = st.tabid and " + "st.owner like '" + string2 + "' and " + "  (sc.colno = si.part1 or " + "   sc.colno = si.part2 or " + "   sc.colno = si.part3 or " + "   sc.colno = si.part4 or " + "   sc.colno = si.part5 or " + "   sc.colno = si.part6 or " + "   sc.colno = si.part7 or " + "   sc.colno = si.part8 ";
            if (this.conn.isOnLine()) {
                object = String.valueOf(object) + " or sc.colno = si.part9 or     sc.colno = si.part10 or     sc.colno = si.part11 or     sc.colno = si.part12 or     sc.colno = si.part13 or     sc.colno = si.part14 or     sc.colno = si.part15 or     sc.colno = si.part16 ";
            }
            object = String.valueOf(object) + ") order by si.idxname";
            resultSet = ifxStatement.executeQuery((String)object);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string7 = "";
            int n = 1;
            while (resultSet.next()) {
                String string8 = resultSet.getString(1);
                String string9 = resultSet.getString(2);
                String string10 = resultSet.getString(3);
                String string11 = resultSet.getString(4);
                String string12 = resultSet.getString(5);
                String string13 = resultSet.getString(6);
                n = !string7.equals(string9) ? 1 : (int)((short)(n + 1));
                string7 = string9;
                ifxStatement2.executeUpdate("insert into " + string5 + " values( " + string4 + ", '" + string13 + "', '" + string12 + "', " + (string11.equals("D") ? "1" : "0") + ", " + "null, '" + string9 + "', " + 3 + ", " + n + ", '" + string8 + "', null, " + "0, 0, null )");
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl4 && bl3) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl3);
            }
            throw sQLException;
        }
        string4 = "select * from " + string5 + " order by non_unique, index_name, ordinal_position";
        resultSet = bl3 && bl4 ? ifxStatement.executeQuery(string4, true) : ifxStatement.executeQuery(string4, false);
        object = new IfxDbMetaDataResultSet(resultSet, string5, this.conn);
        IfxConnection ifxConnection = this.conn;
        if (bl4 && bl3) {
            ifxConnection.commit();
            ifxConnection.setAutoCommit(bl3);
        }
        return object;
    }

    void close() throws SQLException {
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1004 || n == 1003;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        return n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        Object object;
        Object object2;
        AutoCloseable autoCloseable;
        Object object3;
        if (this.conn == null) {
            return null;
        }
        if (!this.conn.isUSVER() && !this.conn.isDbOpen()) {
            return null;
        }
        String string4 = this.conn.getDbName();
        if (string == null || string.equals("")) {
            string = string4;
        } else if (!string.equals(string4)) {
            return null;
        }
        boolean bl = this.conn.getAutoCommit();
        boolean bl2 = this.conn.isANSI();
        if (bl2 && bl) {
            this.conn.setAutoCommit(false);
        }
        if (string2 == null || string2.equals("")) {
            string2 = "%";
        }
        if (string3 == null || string3.equals("")) {
            string3 = "%";
        }
        if (!this.conn.isDelimIdentSet()) {
            string3 = string3.toLowerCase();
            string2 = string2.toLowerCase();
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        String string5 = "";
        if (nArray != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < nArray.length) {
                switch (nArray[n2]) {
                    case 2000: {
                        if (bl3) break;
                        bl3 = true;
                        if (++n == 1) {
                            string5 = String.valueOf(string5) + "'B'";
                            break;
                        }
                        string5 = String.valueOf(string5) + ",'B'";
                        break;
                    }
                    case 2002: {
                        if (bl4) break;
                        bl4 = true;
                        if (++n == 1) {
                            string5 = String.valueOf(string5) + "'R'";
                            break;
                        }
                        string5 = String.valueOf(string5) + ",'R'";
                        break;
                    }
                    case 2001: {
                        if (bl5) break;
                        bl5 = true;
                        string5 = ++n == 1 ? String.valueOf(string5) + "'D'" : String.valueOf(string5) + ",'D'";
                    }
                }
                ++n2;
            }
        }
        IfxStatement ifxStatement = null;
        String string6 = null;
        try {
            ifxStatement = (IfxStatement)this.conn.createStatement();
            ifxStatement.setAutoFree(true);
            object3 = (IfxStatement)this.conn.createStatement();
            autoCloseable = (IfxStatement)this.conn.createStatement();
            object2 = "create procedure mode_decode (mode char(1)) returns varchar(26);   if mode = 'B' then      return 'java.sql.Types.JAVA_OBJECT';   elif mode = 'R' then      return 'java.sql.Types.STRUCT';   elif mode = 'D' then      return 'java.sql.Types.DISTINCT';   else      return 'unknown mode';   end if; end procedure; ";
            autoCloseable.executeUpdate((String)object2);
            string6 = this.nextTempTableName();
            if (this.conn.isOnLine()) {
                ifxStatement.executeUpdate("create temp table " + string6 + " ( " + "TYPE_CAT varchar(129), " + "TYPE_SCHEM varchar(129), " + "TYPE_NAME varchar(129), " + "CLASS_NAME varchar(129), " + "DATA_TYPE varchar(129), " + "REMARKS varchar(129) " + " ) ");
            } else {
                ifxStatement.executeUpdate("create temp table " + string6 + " ( " + "TYPE_CAT char(18), " + "TYPE_SCHEM char(18), " + "TYPE_NAME char(18), " + "CLASS_NAME char(25), " + "DATA_TYPE char(30), " + "REMARKS char(255) " + " ) ");
            }
            object = "select owner, name, mode, type, source from informix.sysxtdtypes where owner != 'informix' and owner like '" + string2 + "' " + "and name like '" + string3 + "' ";
            if (!string5.equals("")) {
                object = String.valueOf(object) + "and mode in (" + string5 + ") ";
            }
            ResultSet resultSet = ifxStatement.executeQuery((String)object);
            while (resultSet.next()) {
                String string7 = resultSet.getString("owner");
                String string8 = resultSet.getString("name");
                String string9 = resultSet.getString("mode");
                int n = resultSet.getInt("type");
                int n3 = resultSet.getInt("source");
                String string10 = null;
                if (!(string9 = string9.trim()).equals("D")) {
                    string10 = "java.sql.SQLData";
                } else if (n3 == 0) {
                    string10 = IfxTypes.FromIfxTypeToJava(n & 0xFF);
                } else {
                    boolean bl6 = false;
                    block15: while (!bl6) {
                        switch (n3) {
                            case 1: {
                                string10 = "java.lang.String";
                                bl6 = true;
                                break;
                            }
                            case 5: {
                                string10 = "java.lang.Boolean";
                                bl6 = true;
                                break;
                            }
                            case 11: {
                                string10 = "java.sql.Clob";
                                bl6 = true;
                                break;
                            }
                            case 10: {
                                string10 = "java.sql.Blob";
                                bl6 = true;
                                break;
                            }
                            default: {
                                ResultSet resultSet2 = ((IfxStatement)object3).executeQuery("select type, source from informix.sysxtdtypes where extended_id = " + n3);
                                if (!resultSet2.next()) {
                                    bl6 = true;
                                    string10 = "unknown";
                                    break;
                                }
                                int n4 = resultSet2.getInt("type");
                                n3 = resultSet2.getInt("source");
                                if (n3 != 0) continue block15;
                                string10 = n4 == 40 || n4 == 41 ? "java.sql.SQLData" : IfxTypes.FromIfxTypeToJava(n & 0xFF);
                                bl6 = true;
                            }
                        }
                    }
                }
                String string11 = "insert into " + string6 + " values ( " + "'" + string4 + "', " + "'" + string7 + "', " + "'" + string8 + "', " + "'" + string10 + "', " + "mode_decode(" + "'" + string9 + "'), " + "'' )";
                ((IfxStatement)object3).executeUpdate(string11);
            }
            resultSet.close();
            object2 = "drop procedure mode_decode";
            autoCloseable.executeUpdate((String)object2);
            ((IfxStatement)object3).close();
            autoCloseable.close();
        }
        catch (SQLException sQLException) {
            IfxConnection ifxConnection = this.conn;
            if (bl2 && bl) {
                ifxConnection.commit();
                ifxConnection.setAutoCommit(bl);
            }
            throw sQLException;
        }
        object3 = "select TYPE_CAT, TYPE_SCHEM, TYPE_NAME, CLASS_NAME, DATA_TYPE, REMARKS from " + string6 + " " + "order by DATA_TYPE, TYPE_SCHEM, TYPE_NAME";
        autoCloseable = null;
        autoCloseable = bl && bl2 ? ifxStatement.executeQuery((String)object3, true) : ifxStatement.executeQuery((String)object3, false);
        object2 = new IfxDbMetaDataResultSet((ResultSet)autoCloseable, string6, this.conn);
        object = this.conn;
        if (bl2 && bl) {
            object.commit();
            object.setAutoCommit(bl);
        }
        string6 = null;
        return object2;
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    private void restoreTransMode(Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (bl && bl2) {
            connection.commit();
            connection.setAutoCommit(bl2);
        }
    }

    static {
        int n;
        nextTempTableId = 1;
        nMdInfoRows = 18;
        nStdRowTypes = 19;
        nXtdRowTypes = 29;
        nXtdRowTypesSupported = 25;
        lmd = null;
        lrow = null;
        if (lmd == null) {
            n = 0;
            lmd = new mdinfo[nMdInfoRows];
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("TYPE_NAME", 0, 128, true, 0);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("DATA_TYPE", 1, 2, true, 128);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("PRECISION", 2, 4, true, 130);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LITERAL_PREFIX", 0, 128, true, 134);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LITERAL_SUFFIX", 0, 128, true, 262);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("CREATE_PARAMS", 0, 128, true, 390);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("NULLABLE", 1, 2, true, 518);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("CASE_SENSITIVE", 1, 2, true, 520);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SEARCHABLE", 2, 4, true, 522);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("UNSIGNED_ATTRIBUTE", 1, 2, true, 526);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("FIXED_PREC_SCALE", 1, 2, true, 528);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("AUTO_INCREMENT", 1, 2, true, 530);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("LOCAL_TYPE_NAME", 0, 128, true, 532);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("MINIMUM_SCALE", 1, 2, true, 660);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("MAXIMUM_SCALE", 1, 2, true, 662);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SQL_DATA_TYPE", 2, 4, true, 664);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("SQL_DATETIME_SUB", 2, 4, true, 668);
            IfxDatabaseMetaData.lmd[n++] = new mdinfo("NUM_PREC_RADIX", 2, 4, true, 672);
        }
        if (lrow == null) {
            n = 0;
            lrow = new rowinfo[nXtdRowTypes];
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("byte", -4, Short.MAX_VALUE, "", "", 1, false, 0, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("char", 1, Short.MAX_VALUE, "'", "'", 1, true, 3, false, false, 0, Short.MAX_VALUE, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("character varying", 12, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("date", 91, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("datetime year to fraction(5)", 93, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("decimal", 3, 32, "'", "'", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("double precision", 3, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("float", 6, 8, "'", "'", 1, false, 2, false, false, 1, 8, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("integer", 4, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("interval", 1, 0, "'", "'", 1, false, 2, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("nchar", 1, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("nvarchar", 12, 0, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("money", 3, 32, "'", "'", 1, false, 2, true, false, 16, 32, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("numeric", 2, 32, "'", "'", 1, false, 2, true, false, 1, 32, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("serial", 4, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("smallint", 5, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("smallfloat", 7, 6, "'", "'", 1, false, 2, false, false, 1, 6, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("text", -1, 0, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("varchar", 12, 255, "'", "'", 1, true, 3, false, false, 0, 255, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("boolean", 1111, 0, "'", "'", 1, false, 2, false, false, 0, 0, 2);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("int8", -5, 0, "'", "'", 1, false, 2, false, false, 0, 0, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("serial8", -5, 0, "'", "'", 0, false, 2, false, true, 0, 0, 10);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("clob", 2005, 72, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("blob", 2004, 72, "", "", 1, false, 0, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("lvarchar", -1, 2048, "'", "'", 1, true, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("list", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("multiset", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("set", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
            IfxDatabaseMetaData.lrow[n++] = new rowinfo("unnamed row", 1111, 0, "'", "'", 1, false, 3, false, false, 0, 0, 0);
        }
    }
}

