/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.general.FRLogger;
import com.fr.performance.dao.FileManager;
import com.fr.performance.dao.InfoReader;
import com.fr.performance.dao.JSONInfoReader;
import com.fr.performance.dao.NoHeaderObjectInputStream;
import com.fr.performance.dao.SerializerInfoReader;
import com.fr.performance.info.InfoCreator;
import com.fr.performance.info.PerformanceInfo;
import com.fr.performance.info.ReportPerformanceInfo;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformanceReaderManager {
    private static List<ReportPerformanceInfo> infoList = new ArrayList<ReportPerformanceInfo>();
    private static InfoReader<ReportPerformanceInfo> reportReader;

    public static List<ReportPerformanceInfo> getAllReportInfo() {
        ReportPerformanceInfo reportPerformanceInfo;
        infoList = new ArrayList<ReportPerformanceInfo>();
        reportReader = PerformanceReaderManager.createReportReader();
        while ((reportPerformanceInfo = reportReader.read()) != null) {
            infoList.add(reportPerformanceInfo);
        }
        Collections.sort(infoList, new Comparator<ReportPerformanceInfo>(){

            @Override
            public int compare(ReportPerformanceInfo reportPerformanceInfo, ReportPerformanceInfo reportPerformanceInfo2) {
                return (int)(reportPerformanceInfo2.getTotalMemory() - reportPerformanceInfo.getTotalMemory());
            }
        });
        return infoList;
    }

    public static PerformanceInfo getInfoById(long l) {
        for (ReportPerformanceInfo reportPerformanceInfo : infoList) {
            if (reportPerformanceInfo.getId() != l) continue;
            return reportPerformanceInfo;
        }
        return null;
    }

    public static List<ReportPerformanceInfo> getReportInfoList(int n, int n2) {
        ArrayList<ReportPerformanceInfo> arrayList = new ArrayList<ReportPerformanceInfo>();
        int n3 = Math.min(n + n2, infoList.size());
        for (int i = n; i < n3; ++i) {
            arrayList.add(infoList.get(i));
        }
        return arrayList;
    }

    public static void fresh() {
        infoList = null;
    }

    private static InfoReader<ReportPerformanceInfo> createReportReader() {
        return PerformanceReaderManager.createJSONInfoReader();
    }

    private static InfoReader<ReportPerformanceInfo> createJSONInfoReader() {
        JSONInfoReader<ReportPerformanceInfo> jSONInfoReader = new JSONInfoReader<ReportPerformanceInfo>();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(FileManager.getInfoSaveFile()));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), (Throwable)iOException);
        }
        jSONInfoReader.setInputStream(bufferedInputStream);
        jSONInfoReader.setInfoCreator(InfoCreator.REPORT_INFO_CREATOR);
        return jSONInfoReader;
    }

    private static InfoReader<ReportPerformanceInfo> createSerializerInfoReader() {
        SerializerInfoReader<ReportPerformanceInfo> serializerInfoReader = new SerializerInfoReader<ReportPerformanceInfo>();
        NoHeaderObjectInputStream noHeaderObjectInputStream = null;
        try {
            noHeaderObjectInputStream = new NoHeaderObjectInputStream(new BufferedInputStream(new FileInputStream(FileManager.getInfoSaveFile())));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        serializerInfoReader.setInput(noHeaderObjectInputStream);
        return serializerInfoReader;
    }

    public static void main(String[] stringArray) {
        InfoReader<ReportPerformanceInfo> infoReader = PerformanceReaderManager.createReportReader();
        infoReader.read();
        infoReader.read();
        infoReader.read();
    }
}

