/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.XMLStreamReaderEx;
import org.jvnet.staxex.XMLStreamWriterEx;

public class StreamUtil {
    public static boolean moveToNextElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            reader.next();
            while (reader.getEventType() != 1) {
                if (reader.hasNext()) {
                    reader.next();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean moveToNextStartOREndElement(XMLStreamReader reader) throws XMLStreamException {
        if (reader.hasNext()) {
            reader.next();
            while (StreamUtil.move(reader)) {
                if (reader.hasNext()) {
                    reader.next();
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean moveToNextStartOREndElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        if (reader.hasNext()) {
            reader.next();
            StreamUtil.writeCurrentEvent(reader, writer);
            while (StreamUtil.move(reader)) {
                if (reader.hasNext()) {
                    reader.next();
                    StreamUtil.writeCurrentEvent(reader, writer);
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isStartElement(XMLStreamReader reader) {
        return reader.getEventType() == 1;
    }

    public static boolean _break(XMLStreamReader reader, String localName, String uri) throws XMLStreamException {
        return reader.getEventType() == 2 && reader.getLocalName() == localName && (reader.getNamespaceURI() == uri || reader.getNamespaceURI() == "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512");
    }

    private static boolean move(XMLStreamReader reader) {
        return reader.getEventType() != 1 && reader.getEventType() != 2;
    }

    public static void writeStartElement(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
        int nsCount = reader.getNamespaceCount();
        for (int i = 0; i < nsCount; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            writer.writeNamespace(prefix, reader.getNamespaceURI(i));
        }
        int atCount = reader.getAttributeCount();
        for (int i = 0; i < atCount; ++i) {
            if (reader.getAttributePrefix(i) == "" || reader.getAttributePrefix(i) == null) {
                writer.writeAttribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                continue;
            }
            writer.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
        }
    }

    public static void writeCurrentEvent(XMLStreamReader reader, XMLStreamWriter writer) throws XMLStreamException {
        int event = reader.getEventType();
        switch (event) {
            case 12: {
                writer.writeCData(reader.getText());
                break;
            }
            case 4: {
                writer.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                break;
            }
            case 5: {
                writer.writeComment(reader.getText());
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                writer.writeCharacters(reader.getText());
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                StreamUtil.writeStartElement(reader, writer);
            }
        }
    }

    public static void writeCurrentEvent(XMLStreamReaderEx reader, XMLStreamWriterEx writer) throws XMLStreamException {
        int event = reader.getEventType();
        switch (event) {
            case 12: {
                writer.writeCData(reader.getText());
                break;
            }
            case 4: {
                writer.writeCharacters(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                break;
            }
            case 5: {
                writer.writeComment(reader.getText());
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                break;
            }
            case 2: {
                writer.writeEndElement();
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                writer.writeCharacters(reader.getText());
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                StreamUtil.writeStartElement(reader, writer);
            }
        }
    }

    public static String getWsuId(XMLStreamReader reader) {
        return reader.getAttributeValue("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public static String getId(XMLStreamReader reader) {
        return reader.getAttributeValue(null, "Id");
    }

    public static String getCV(XMLStreamReader reader) throws XMLStreamException {
        StringBuffer content = new StringBuffer();
        int eventType = reader.getEventType();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(reader.getText());
            } else if (eventType == 3 || eventType == 5) {
                // empty if block
            }
            eventType = reader.next();
        }
        return content.toString();
    }

    public static String getCV(XMLStreamReaderEx reader) throws XMLStreamException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            if (reader.getEventType() != 4) break;
            if (reader.getEventType() == 2) break;
            CharSequence charSeq = reader.getPCDATA();
            for (int i = 0; i < charSeq.length(); ++i) {
                sb.append(charSeq.charAt(i));
            }
            reader.next();
        }
        return sb.toString();
    }

    public static String convertDigestAlgorithm(String algo) {
        if ("http://www.w3.org/2000/09/xmldsig#sha1".equals(algo)) {
            return "SHA-1";
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(algo)) {
            return "SHA-256";
        }
        if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(algo)) {
            return "SHA-512";
        }
        return "SHA-1";
    }
}

