/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.charttypes;

import com.fr.chart.base.ChartInternationalNameContentBean;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.charttypes.AreaIndependentChart;
import com.fr.chart.charttypes.BarIndependentChart;
import com.fr.chart.charttypes.BubbleIndependentChart;
import com.fr.chart.charttypes.ColumnIndependentChart;
import com.fr.chart.charttypes.CustomIndependentChart;
import com.fr.chart.charttypes.DonutIndependentChart;
import com.fr.chart.charttypes.FunnelIndependentChart;
import com.fr.chart.charttypes.GanttIndependentChart;
import com.fr.chart.charttypes.GisMapIndependentChart;
import com.fr.chart.charttypes.LineIndependentChart;
import com.fr.chart.charttypes.MapIndependentChart;
import com.fr.chart.charttypes.MeterIndependentChart;
import com.fr.chart.charttypes.PieIndependentChart;
import com.fr.chart.charttypes.RadarIndependentChart;
import com.fr.chart.charttypes.RangeIndependentChart;
import com.fr.chart.charttypes.StockIndependentChart;
import com.fr.chart.charttypes.XYScatterIndependentChart;
import com.fr.chart.fun.IndependentChartProvider;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.plugin.PluginCollector;
import com.fr.plugin.PluginLicenseManager;
import com.fr.plugin.PluginMessage;
import com.fr.plugin.proxy.PluginInstanceProxyFactory;
import com.fr.stable.ArrayUtils;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListSet;
import com.fr.stable.StringUtils;
import com.fr.stable.collections.map.CloseableContainedMap;
import com.fr.stable.fun.Authorize;
import com.fr.stable.fun.Level;
import com.fr.stable.plugin.ExtraChartTypeClassManagerProvider;
import com.fr.stable.plugin.PluginSimplify;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartTypeManager
implements ExtraChartTypeClassManagerProvider {
    private static ClassLoader loader = Thread.currentThread().getContextClassLoader();
    public static final String CHART_PRIORITY = "-1";
    private static String[] DEFAULT_JS = new String[]{"/com/fr/web/core/js/chart.utils.js", "/com/fr/web/core/js/chart.constants.js", "/com/fr/web/core/js/chart.shape.js", "/com/fr/web/core/js/chart.plotattr.js", "/com/fr/web/core/js/chart.axisglyph.js", "/com/fr/web/core/js/chart.datapoint.js", "/com/fr/web/core/js/chart.dataseries.js", "/com/fr/web/core/js/chart.glyph.js", "/com/fr/web/core/js/chart.legend.js", "/com/fr/web/core/js/chart.datasheet.js", "/com/fr/web/core/js/chart.handler.js", "/com/fr/web/core/js/chart.tooltip.js", "/com/fr/web/core/js/chart.report.widget.js", "/com/fr/web/core/js/chart.form.widget.js", "/com/fr/web/core/js/chart.finechart.js"};
    private static ChartTypeManager typeManager;
    private static LinkedHashMap<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> chartTypes;

    public static synchronized ChartTypeManager getInstance() {
        if (typeManager == null) {
            typeManager = new ChartTypeManager();
            chartTypes.clear();
            typeManager.readDefaultChartTypes();
        }
        return typeManager;
    }

    private static synchronized void envChanged() {
        typeManager = null;
    }

    private static void readDefaultChartTypes() {
        CloseableContainedMap closeableContainedMap = new CloseableContainedMap(LinkedHashMap.class);
        closeableContainedMap.put((Object)"FineReportColumnChart", (Object)new ColumnIndependentChart());
        closeableContainedMap.put((Object)"FineReportLineChart", (Object)new LineIndependentChart());
        closeableContainedMap.put((Object)"FineReportBarChart", (Object)new BarIndependentChart());
        closeableContainedMap.put((Object)"FineReportPieChart", (Object)new PieIndependentChart());
        closeableContainedMap.put((Object)"FineReportAreaChart", (Object)new AreaIndependentChart());
        closeableContainedMap.put((Object)"FineReportScatterChart", (Object)new XYScatterIndependentChart());
        closeableContainedMap.put((Object)"FineReportBubbleChart", (Object)new BubbleIndependentChart());
        closeableContainedMap.put((Object)"FineReportRadarChart", (Object)new RadarIndependentChart());
        closeableContainedMap.put((Object)"FineReportStockChart", (Object)new StockIndependentChart());
        closeableContainedMap.put((Object)"FineReportMeterChart", (Object)new MeterIndependentChart());
        closeableContainedMap.put((Object)"FineReportRangeChart", (Object)new RangeIndependentChart());
        closeableContainedMap.put((Object)"FineReportCustomChart", (Object)new CustomIndependentChart());
        closeableContainedMap.put((Object)"FineReportGanttChart", (Object)new GanttIndependentChart());
        closeableContainedMap.put((Object)"FineReportDonutChart", (Object)new DonutIndependentChart());
        closeableContainedMap.put((Object)"FineReportMapChart", (Object)new MapIndependentChart());
        closeableContainedMap.put((Object)"FineReportGisChart", (Object)new GisMapIndependentChart());
        closeableContainedMap.put((Object)"FineReportFunnelChart", (Object)new FunnelIndependentChart());
        chartTypes.put(CHART_PRIORITY, (CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>)closeableContainedMap);
    }

    public static void addChartType(String string, IndependentChartProvider independentChartProvider, String string2) {
        if (chartTypes != null) {
            if (!chartTypes.containsKey(string)) {
                CloseableContainedMap closeableContainedMap = new CloseableContainedMap(LinkedHashMap.class);
                closeableContainedMap.put((Object)string2, (Object)independentChartProvider);
                chartTypes.put(string, (CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>)closeableContainedMap);
            } else {
                Map map = (Map)chartTypes.get(string);
                if (!map.containsKey(string2)) {
                    map.put(string2, independentChartProvider);
                }
            }
        }
    }

    public String[] getUsedJSFiles() {
        ListSet listSet = new ListSet();
        for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
            String string = entry.getKey();
            Map map = (Map)chartTypes.get(string);
            for (Map.Entry entry2 : map.entrySet()) {
                IndependentChartProvider independentChartProvider = (IndependentChartProvider)entry2.getValue();
                for (String string2 : independentChartProvider.getRequiredJS()) {
                    listSet.add(string2);
                }
            }
        }
        return (String[])ArrayUtils.addAll((Object[])DEFAULT_JS, (Object[])listSet.toArray(new String[0]));
    }

    public void addChartTypeProvider(String string, String string2, String string3, PluginSimplify pluginSimplify) {
        if (StringUtils.isNotBlank((String)string2)) {
            try {
                Class<?> clazz = Class.forName(string2);
                Authorize authorize = clazz.getAnnotation(Authorize.class);
                if (authorize != null) {
                    PluginLicenseManager.getInstance().registerPaid(authorize, pluginSimplify);
                }
                IndependentChartProvider independentChartProvider = (IndependentChartProvider)new PluginInstanceProxyFactory(clazz, pluginSimplify).addProxy("isClosed").getProxyObj();
                if (PluginCollector.getCollector().isError((Level)independentChartProvider, 3, pluginSimplify.getPluginName())) {
                    PluginMessage.remindUpdate((String)string2);
                } else {
                    ChartTypeManager.getInstance();
                    ChartTypeManager.addChartType(string, independentChartProvider, string3);
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("class not found:" + exception.getMessage());
            }
        }
    }

    public void readXML(XMLableReader xMLableReader) {
        this.readXML(xMLableReader, null, PluginSimplify.NULL);
    }

    public void readXML(XMLableReader xMLableReader, List<String> list, PluginSimplify pluginSimplify) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (list != null) {
                list.add(string);
            }
            if (ComparatorUtils.equals((String)string, (String)"IndependentChartProvider")) {
                String string2 = xMLableReader.getAttrAsString("class", "");
                String string3 = xMLableReader.getAttrAsString("plotID", "");
                String string4 = xMLableReader.getAttrAsString("priority", CHART_PRIORITY);
                this.addChartTypeProvider(string4, string2, string3, pluginSimplify);
            }
        }
    }

    public Chart[] getChartTypes(String string) {
        if (chartTypes != null) {
            for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
                String string2 = entry.getKey();
                Chart[] chartArray = this.getChartTypes(string2, string);
                if (chartArray.length == 0) continue;
                return chartArray;
            }
        }
        return new Chart[0];
    }

    public String getWrapperName(String string) {
        if (chartTypes != null) {
            for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
                String string2 = entry.getKey();
                String string3 = this.getWrapperName(string2, string);
                if (!StringUtils.isNotEmpty((String)string3)) continue;
                return string3;
            }
        }
        return "";
    }

    public String getChartImagePath(String string) {
        if (chartTypes != null) {
            for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
                String string2 = entry.getKey();
                String string3 = this.getChartImagePath(string2, string);
                if (!StringUtils.isNotEmpty((String)string3)) continue;
                return string3;
            }
        }
        return "";
    }

    public boolean containsPlot(String string) {
        if (chartTypes != null) {
            Iterator<Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>>> iterator = chartTypes.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry = iterator.next();
                String string2 = entry.getKey();
                boolean bl2 = this.containsPlot(string2, string);
                if (!bl2) continue;
                return bl2;
            }
        }
        return false;
    }

    public ChartInternationalNameContentBean[] getAllChartBaseNames() {
        ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray;
        int n;
        List<Integer> list = ChartTypeManager.getPriorityInOrder();
        ArrayList<ChartInternationalNameContentBean[]> arrayList = new ArrayList<ChartInternationalNameContentBean[]>();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            chartInternationalNameContentBeanArray = String.valueOf(list.get(n));
            ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray2 = this.getAllChartBaseNames((String)chartInternationalNameContentBeanArray);
            arrayList.add(chartInternationalNameContentBeanArray2);
        }
        n = 0;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            chartInternationalNameContentBeanArray = (ChartInternationalNameContentBean[])arrayList.get(n2);
            n += chartInternationalNameContentBeanArray.length;
        }
        ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray3 = new ChartInternationalNameContentBean[n];
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray4 = (ChartInternationalNameContentBean[])arrayList.get(i);
            for (int j = 0; j < chartInternationalNameContentBeanArray4.length; ++j) {
                chartInternationalNameContentBeanArray3[n3++] = chartInternationalNameContentBeanArray4[j];
            }
        }
        return chartInternationalNameContentBeanArray3;
    }

    public static List<Integer> orderInPriority(List<Integer> list) {
        if (list == null) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (list.size() > 0) {
            int n = 0;
            int n2 = list.size();
            for (int i = 1; i < n2; ++i) {
                if (list.get(i) <= list.get(n)) continue;
                n = i;
            }
            arrayList.add(list.get(n));
            list.remove(n);
        }
        return arrayList;
    }

    public static Chart getFirstChart() {
        if (chartTypes == null || chartTypes.isEmpty()) {
            return new Chart();
        }
        List<Integer> list = ChartTypeManager.getPriorityInOrder();
        if (list.size() == 0) {
            ChartTypeManager.getDefaultFirstChart();
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = String.valueOf(list.get(i));
            Map map = (Map)chartTypes.get(string);
            if (map == null || map.isEmpty()) {
                return new Chart();
            }
            Iterator iterator = map.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            return ((IndependentChartProvider)map.get(string2)).getChartTypes()[0];
        }
        return new Chart();
    }

    private static Chart getDefaultFirstChart() {
        if (chartTypes == null || chartTypes.isEmpty()) {
            return new Chart();
        }
        for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
            String string = entry.getKey();
            Map map = (Map)chartTypes.get(string);
            if (map == null || map.isEmpty()) {
                return new Chart();
            }
            Iterator iterator = map.entrySet().iterator();
            if (!iterator.hasNext()) continue;
            Map.Entry entry2 = iterator.next();
            String string2 = (String)entry2.getKey();
            return ((IndependentChartProvider)map.get(string2)).getChartTypes()[0];
        }
        return new Chart();
    }

    private static List<Integer> getPriorityInOrder() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry : chartTypes.entrySet()) {
            String string = entry.getKey();
            arrayList.add(Integer.valueOf(string));
        }
        return ChartTypeManager.orderInPriority(arrayList);
    }

    public String[] getRequiredJS(String string) {
        if (chartTypes != null) {
            Iterator<Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>>> iterator = chartTypes.entrySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Map.Entry<String, CloseableContainedMap<String, IndependentChartProvider, LinkedHashMap>> entry = iterator.next();
                String string2 = entry.getKey();
                String[] stringArray = this.getRequiredJS(string2, string);
                if (ComparatorUtils.equals((Object)stringArray, (Object)ArrayUtils.EMPTY_BOOLEAN_ARRAY)) continue;
                return stringArray;
            }
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private Chart[] getChartTypes(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return ((IndependentChartProvider)chartTypes.get(string).get((Object)string2)).getChartTypes();
        }
        return new Chart[0];
    }

    private String getWrapperName(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return ((IndependentChartProvider)chartTypes.get(string).get((Object)string2)).getWrapperName();
        }
        return "";
    }

    private String[] getRequiredJS(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return ((IndependentChartProvider)chartTypes.get(string).get((Object)string2)).getRequiredJS();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private String getChartImagePath(String string, String string2) {
        if (this.containsPlot(string, string2)) {
            return ((IndependentChartProvider)chartTypes.get(string).get((Object)string2)).getChartImagePath();
        }
        return "";
    }

    private boolean containsPlot(String string, String string2) {
        return chartTypes != null && chartTypes.containsKey(string) && chartTypes.get(string).containsKey((Object)string2);
    }

    private ChartInternationalNameContentBean[] getAllChartBaseNames(String string) {
        Map map = (Map)chartTypes.get(string);
        int n = map.size();
        ChartInternationalNameContentBean[] chartInternationalNameContentBeanArray = new ChartInternationalNameContentBean[n];
        Iterator iterator = map.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            IndependentChartProvider independentChartProvider = (IndependentChartProvider)entry.getValue();
            chartInternationalNameContentBeanArray[n2++] = new ChartInternationalNameContentBean(independentChartProvider.getChartName(), string2);
        }
        return chartInternationalNameContentBeanArray;
    }

    private String[] getUsedJSFiles(String string) {
        ListSet listSet = new ListSet();
        Map map = (Map)chartTypes.get(string);
        for (Map.Entry entry : map.entrySet()) {
            IndependentChartProvider independentChartProvider = (IndependentChartProvider)entry.getValue();
            for (String string2 : independentChartProvider.getRequiredJS()) {
                listSet.add(string2);
            }
        }
        return (String[])ArrayUtils.addAll((Object[])DEFAULT_JS, (Object[])listSet.toArray(new String[0]));
    }

    public static Chart getFirstChart(String string) {
        if (chartTypes == null || chartTypes.isEmpty()) {
            return null;
        }
        Map map = (Map)chartTypes.get(string);
        if (map == null || map.isEmpty()) {
            return null;
        }
        Iterator iterator = map.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            return ((IndependentChartProvider)map.get(string2)).getChartTypes()[0];
        }
        return null;
    }

    static {
        chartTypes = new LinkedHashMap();
        GeneralContext.addEnvChangedListener((EnvChangedListener)new EnvChangedListener(){

            public void envChanged() {
                ChartTypeManager.getInstance();
                ChartTypeManager.envChanged();
            }
        });
    }
}

