/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.GraphHelper;
import com.fr.base.background.ColorBackground;
import com.fr.base.chart.Glyph;
import com.fr.chart.base.AttrBackground;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartglyph.ConditionAttrFactory;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.data.condition.Result;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;

public abstract class GeneralGlyph
implements Glyph {
    private static final long serialVersionUID = 4345757209449259564L;
    private GeneralInfo info = new GeneralInfo();
    private boolean is3DIE6 = false;

    public void setGeneralInfo(GeneralInfo generalInfo) {
        this.info = generalInfo;
    }

    public GeneralInfo getGeneralInfo() {
        return this.info;
    }

    public Background getBackground() {
        return this.info.getBackground();
    }

    public void setBackground(Background background) {
        this.info.setBackground(background);
    }

    public float getAlpha() {
        return this.info.getAlpha();
    }

    public void setAlpha(float f) {
        this.info.setAlpha(f);
    }

    public Color getBorderColor() {
        return this.info.getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.info.setBorderColor(color);
    }

    public int getBorderStyle() {
        return this.info.getBorderStyle();
    }

    public void setBorderStyle(int n) {
        this.info.setBorderStyle(n);
    }

    public int getRoundRadius() {
        return this.info.getRoundRadius();
    }

    public boolean isShadow() {
        return this.info.isShadow();
    }

    public boolean isRoundBorder() {
        return this.info.isRoundBorder();
    }

    public void setRoundBorder(boolean bl) {
        this.info.setRoundBorder(bl);
    }

    public void dealCondition(ConditionCollection conditionCollection, Result result, Color[] colorArray) {
        conditionCollection.changeStyleConditionWithInfo(this.info, result, colorArray);
    }

    public void dealConditionWithSeriesColor(ConditionCollection conditionCollection, Result result, Color[] colorArray) {
        DataSeriesCondition dataSeriesCondition = conditionCollection.getAttrByResult(result).getExisted(AttrBackground.class);
        if (dataSeriesCondition == null && (dataSeriesCondition = conditionCollection.getDefaultAttr().getExisted(AttrBackground.class)) == null && result instanceof DataPoint) {
            DataPoint dataPoint = (DataPoint)result;
            dataSeriesCondition = ConditionAttrFactory.createConditionAttr(AttrBackground.class, dataPoint.getCategoryIndex(), colorArray);
        }
        this.info.changeStyleAttrBackground((AttrBackground)dataSeriesCondition);
    }

    public abstract Shape getOutline4Fill();

    public void draw(Graphics graphics, int n) {
        this.paint(graphics);
    }

    public void drawWithOutBorder(Graphics graphics, int n) {
        Shape shape = this.getOutline4Fill();
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        this.paintBackground(graphics2D, shape);
        graphics2D.setComposite(composite);
        graphics2D.setPaint(paint);
    }

    public void drawOnlyBorder(Graphics graphics, int n) {
        Shape shape = this.getOutline4Fill();
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paintBorder(graphics2D, shape);
    }

    protected void paint(Graphics graphics) {
        Shape shape = this.getOutline4Fill();
        if (shape == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getAlpha()));
        this.paintBackground(graphics2D, shape);
        graphics2D.setComposite(composite);
        this.paintBorder(graphics2D, shape);
        graphics2D.setPaint(paint);
    }

    protected void paintBackground(Graphics2D graphics2D, Shape shape) {
        if (this.getBackground() != null) {
            this.getBackground().paint((Graphics)graphics2D, shape);
        } else if (this.getBackground() == null && this.is3DIE6) {
            Background background = this.getBackground();
            this.setBackground((Background)ColorBackground.getInstance((Color)Color.white));
            this.getBackground().paint((Graphics)graphics2D, shape);
            this.setBackground(background);
        }
    }

    private void paintBorder(Graphics2D graphics2D, Shape shape) {
        int n = this.getBorderStyle();
        Color color = this.getBorderColor();
        if (n != 0 && color != null) {
            Stroke stroke = graphics2D.getStroke();
            Stroke stroke2 = GraphHelper.getStroke((int)n);
            graphics2D.setStroke(stroke2);
            graphics2D.setPaint(color);
            graphics2D.draw(shape);
            graphics2D.setStroke(stroke);
        }
    }

    public void is3DIE6(boolean bl) {
        this.is3DIE6 = bl;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.info != null) {
            jSONObject.put("info", (Object)this.info.toJSONObject(repository));
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        return object instanceof GeneralGlyph && ComparatorUtils.equals((Object)((GeneralGlyph)object).info, (Object)this.info);
    }

    public Object clone() throws CloneNotSupportedException {
        GeneralGlyph generalGlyph = (GeneralGlyph)super.clone();
        if (this.info != null) {
            generalGlyph.info = (GeneralInfo)this.info.clone();
        }
        return generalGlyph;
    }
}

