/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartglyph.Bar2DPlotGlyph;
import com.fr.chart.chartglyph.DataPoint4Gantt;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.chart.chartglyph.DiamondFilledMarker;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.chart.chartglyph.TriangleFilledMarker;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.util.Date;

public class GanttPlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 7888272466260745014L;
    private static final float PLAN_UI = 0.8f;
    private static final double MARKERSCALE = 4.0;
    private Image errorImage;
    private String errorToopTip;

    public void setErrorImage(Image image) {
        this.errorImage = image;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public void setErrorToopTip(String string) {
        this.errorToopTip = string;
    }

    public String getErrorToopTip() {
        return this.errorToopTip;
    }

    public String getPlotGlyphType() {
        return "GanttPlotGlyph";
    }

    public void layoutAxisGlyph(int n) {
        this.layoutDoubleAxisGlyph(this.getxAxisGlyph(), this.getyAxisGlyph(), this.getSecondAxisGlyph(), n);
        this.getyAxisGlyph().getOrigin().setLocation(this.getyAxisGlyph().getOrigin().getX(), this.getyAxisGlyph().getBounds().getY());
    }

    public void layoutDataSeriesGlyph(int n) {
        if (this.errorImage != null) {
            return;
        }
        Bar2DPlotGlyph bar2DPlotGlyph = new Bar2DPlotGlyph();
        bar2DPlotGlyph.setCategoryIntervalPercent(0.0);
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                DataPoint4Gantt dataPoint4Gantt = (DataPoint4Gantt)dataSeries.getDataPoint(j);
                if (dataPoint4Gantt.isValueIsNull()) continue;
                this.layoutDataPoint4Gantt(bar2DPlotGlyph, dataPoint4Gantt);
            }
        }
    }

    private void layoutDataPoint4Gantt(Bar2DPlotGlyph bar2DPlotGlyph, DataPoint4Gantt dataPoint4Gantt) {
        AttrColor attrColor = (AttrColor)this.getConditionCollection().getDataSeriesCondition(AttrColor.class, dataPoint4Gantt, this.createColors4Series());
        AttrAlpha attrAlpha = (AttrAlpha)this.getConditionCollection().getDataSeriesCondition(AttrAlpha.class, dataPoint4Gantt, null);
        Rectangle2D rectangle2D = bar2DPlotGlyph.getBarShape4GanttPlot(dataPoint4Gantt.getPlanStart(), dataPoint4Gantt.getPlanEnd(), dataPoint4Gantt.getCategoryIndex(), this.getyAxisGlyph(), this.getxAxisGlyph(), this.getSeriesSize(), dataPoint4Gantt.getSeriesIndex());
        ShapeGlyph shapeGlyph = new ShapeGlyph(rectangle2D);
        shapeGlyph.setBackground((Background)ColorBackground.getInstance((Color)ChartBaseUtils.saturationDown(attrColor.getSeriesColor())));
        shapeGlyph.setAlpha(0.8f);
        dataPoint4Gantt.setPlanImpl(shapeGlyph);
        this.dealProgress4DataPoint(bar2DPlotGlyph, dataPoint4Gantt, attrColor, attrAlpha);
        this.dealRealStart4DataPoint(dataPoint4Gantt, rectangle2D, attrAlpha);
        this.dealRealEnd4DataPoint(dataPoint4Gantt, rectangle2D, attrAlpha);
    }

    private void dealProgress4DataPoint(Bar2DPlotGlyph bar2DPlotGlyph, DataPoint4Gantt dataPoint4Gantt, AttrColor attrColor, AttrAlpha attrAlpha) {
        if (dataPoint4Gantt.getProgress() >= 0.0) {
            Rectangle2D rectangle2D = bar2DPlotGlyph.getBarShape4GanttPlot(dataPoint4Gantt.getPlanStart(), dataPoint4Gantt.getPlanStart() + (dataPoint4Gantt.getPlanEnd() - dataPoint4Gantt.getPlanStart()) * dataPoint4Gantt.getProgress(), dataPoint4Gantt.getCategoryIndex(), this.getyAxisGlyph(), this.getxAxisGlyph(), this.getSeriesSize(), dataPoint4Gantt.getSeriesIndex());
            ShapeGlyph shapeGlyph = new ShapeGlyph(rectangle2D);
            shapeGlyph.setBackground((Background)ColorBackground.getInstance((Color)attrColor.getSeriesColor()));
            shapeGlyph.setAlpha(attrAlpha.getAlpha());
            dataPoint4Gantt.setProgressImpl(shapeGlyph);
        }
    }

    private void dealRealStart4DataPoint(DataPoint4Gantt dataPoint4Gantt, Rectangle2D rectangle2D, AttrAlpha attrAlpha) {
        if (dataPoint4Gantt.getRealStart() >= 0.0) {
            Date date = ChartBaseUtils.long2Date((long)dataPoint4Gantt.getRealStart(), 6);
            double d = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)this.getxAxisGlyph()).getMainType());
            double d2 = this.getxAxisGlyph().getPoint2D(d).getX();
            double d3 = rectangle2D.getHeight();
            TriangleFilledMarker triangleFilledMarker = new TriangleFilledMarker();
            triangleFilledMarker.setSize(d3 / 4.0);
            triangleFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)Color.black));
            MarkerGlyph markerGlyph = new MarkerGlyph(triangleFilledMarker, Color.black);
            markerGlyph.setShape(new Rectangle2D.Double(d2 - d3 / 4.0, rectangle2D.getY() + d3 / 2.0, d3 / 2.0, d3 / 2.0));
            markerGlyph.setAlpha(attrAlpha.getAlpha());
            dataPoint4Gantt.setRealStartImpl(markerGlyph);
        }
    }

    private void dealRealEnd4DataPoint(DataPoint4Gantt dataPoint4Gantt, Rectangle2D rectangle2D, AttrAlpha attrAlpha) {
        if (dataPoint4Gantt.getRealEnd() >= 0.0) {
            Date date = ChartBaseUtils.long2Date((long)dataPoint4Gantt.getRealEnd(), 6);
            double d = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)this.getxAxisGlyph()).getMainType());
            double d2 = this.getxAxisGlyph().getPoint2D(d).getX();
            double d3 = rectangle2D.getHeight();
            DiamondFilledMarker diamondFilledMarker = new DiamondFilledMarker();
            diamondFilledMarker.setSize(d3 / 4.0);
            diamondFilledMarker.setBackground((Background)ColorBackground.getInstance((Color)new Color(122, 225, 108)));
            MarkerGlyph markerGlyph = new MarkerGlyph(diamondFilledMarker, new Color(122, 225, 108));
            markerGlyph.setShape(new Rectangle2D.Double(d2 - d3 / 4.0, rectangle2D.getY() + d3 / 2.0, d3 / 2.0, d3 / 2.0));
            markerGlyph.setAlpha(attrAlpha.getAlpha());
            dataPoint4Gantt.setRealEndImpl(markerGlyph);
        }
    }

    public void draw(Graphics graphics, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.getBounds().getX(), this.getBounds().getY());
        if (this.errorImage != null) {
            int n2 = (int)(this.getBounds().getWidth() - (double)this.errorImage.getWidth(null)) / 2;
            int n3 = (int)(this.getBounds().getHeight() - (double)this.errorImage.getHeight(null)) / 2;
            graphics2D.drawImage(this.errorImage, n2, n3, null);
        }
        graphics2D.translate(-this.getBounds().getX(), -this.getBounds().getY());
        super.draw(graphics2D, n);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("errorToopTip", (Object)this.errorToopTip);
        if (this.errorImage != null) {
            ChartBaseUtils.image2JS(repository, jSONObject, this.errorImage);
        }
        return jSONObject;
    }

    public String getChartType() {
        return "Gantt";
    }
}

