/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.Bar3DPlotGlyph;
import com.fr.chart.chartglyph.BarDataWithAxisGlyph;
import com.fr.chart.chartglyph.Cubic;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSheet;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.LegendItem;
import com.fr.chart.chartglyph.Plot3DGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.ValueAxisGlyph;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class CategoryPlotGlyph
extends RectanglePlotGlyph {
    private static final long serialVersionUID = 4363652839224475272L;
    protected static final int ZP = 100;
    private static final double SCALE = 0.1;
    private boolean isStacked = false;
    protected Cubic threeDBase = null;

    public boolean isStacked() {
        return this.isStacked;
    }

    public void setStacked(boolean bl) {
        this.isStacked = bl;
    }

    protected byte[] get3DBaseCover() {
        return new byte[]{1};
    }

    protected boolean is3DBaseHorizontal() {
        return false;
    }

    public void doLayout(DataSheetGlyph dataSheetGlyph) {
        int n = this.getxAxisGlyph().getPosition();
        Rectangle2D rectangle2D = this.getBounds();
        if (n == 1 || n == 3) {
            dataSheetGlyph.setBeginX(this.getxAxisGlyph().getBounds().getX() + this.getBounds().getX());
            dataSheetGlyph.setUnitLength(this.getxAxisGlyph().getBounds().getWidth() / (double)this.getCategoryCount());
            rectangle2D.setRect(rectangle2D.getX() + 0.0, rectangle2D.getY(), dataSheetGlyph.getBeginX() + this.getxAxisGlyph().getAxisLength() - rectangle2D.getX(), rectangle2D.getHeight());
        } else {
            dataSheetGlyph.setBeginX(this.getyAxisGlyph().getBounds().getX() + this.getBounds().getX());
            dataSheetGlyph.setUnitLength((this.getBounds().getX() + this.getBounds().getWidth() - dataSheetGlyph.getBeginX()) / (double)this.getCategoryCount());
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), dataSheetGlyph.getBeginX() + this.getyAxisGlyph().getAxisLength() - rectangle2D.getX(), rectangle2D.getHeight());
        }
        this.setBounds(rectangle2D);
        dataSheetGlyph.setCrossValue(this.getxAxisGlyph().getCrossValue());
        dataSheetGlyph.setArrowValue(this.getxAxisGlyph().getArrowValue());
    }

    public DataSheetGlyph createDataSheetGlyph(DataSheet dataSheet, LegendItem[] legendItemArray) {
        return this.createSheetGlyphAndNotShowAxisGlyph(dataSheet, legendItemArray);
    }

    protected void resetPlotBoundsWith3DDeepAndProjectionBeforeAxisGlyph() {
        Plot3DGlyph plot3DGlyph = (Plot3DGlyph)((Object)this);
        Rectangle2D rectangle2D = this.getBounds();
        double d = 0.1;
        plot3DGlyph.set3DDeepBase((int)(d * rectangle2D.getHeight()));
        int n = this.get3DDeep(plot3DGlyph);
        double d2 = rectangle2D.getWidth();
        double d3 = rectangle2D.getHeight();
        double d4 = d3 - plot3DGlyph.getProjection().projecteeRY(d2, d3, n);
        double d5 = plot3DGlyph.getProjection().projecteeRX(d2, d3, n) - d2;
        rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + d4, d2 - d5, d3 - d4);
        this.setBounds(rectangle2D);
        this.threeDBase = new Cubic(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
        this.threeDBase.setDeep(n);
        this.threeDBase.setProjection(plot3DGlyph.getProjection());
        this.threeDBase.setGeneralInfo(this.getGeneralInfo());
        this.threeDBase.setCubicPosition(rectangle2D.getX(), rectangle2D.getY());
        this.getxAxisGlyph().setCubic(this.threeDBase);
        this.getyAxisGlyph().setCubic(this.threeDBase);
        if (this.getSecondAxisGlyph() != null) {
            this.getSecondAxisGlyph().setCubic(this.threeDBase);
        }
    }

    protected void layoutDoubleAxisGlyph(AxisGlyph axisGlyph, AxisGlyph axisGlyph2, AxisGlyph axisGlyph3, boolean bl, int n) {
        if (bl) {
            this.resetPlotBoundsWith3DDeepAndProjectionBeforeAxisGlyph();
            this.layoutAxisGlyph4ThreeD(axisGlyph, axisGlyph2, axisGlyph3, n);
            this.threeDBase.setCovers(this.get3DBaseCover());
            this.threeDBase.setIsHorizontal(this.is3DBaseHorizontal());
        } else {
            this.layoutDoubleAxisGlyph(axisGlyph, axisGlyph2, axisGlyph3, n);
        }
    }

    protected void layoutAxisGlyph4ThreeD(AxisGlyph axisGlyph, AxisGlyph axisGlyph2, AxisGlyph axisGlyph3, int n) {
        Rectangle2D rectangle2D = this.getBounds();
        Rectangle2D rectangle2D2 = this.getBounds();
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph, rectangle2D);
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph2, rectangle2D);
        this.initAxisGlyphBoundsAndZeroBounds(axisGlyph3, rectangle2D);
        this.dealPlotBoundsWithAxisGlyph(axisGlyph, rectangle2D2, n);
        if (axisGlyph2 != null) {
            axisGlyph2.dealPlotBoundsWithAxisTitle(rectangle2D2, n);
        }
        if (axisGlyph3 != null) {
            axisGlyph3.dealPlotBoundsWithAxisTitle(rectangle2D2, n);
        }
        this.threeDBase.setCubicWidthHeight(rectangle2D2.getWidth(), rectangle2D2.getHeight());
        this.threeDBase.setCubicPosition(rectangle2D2.getX(), rectangle2D2.getY());
        if (axisGlyph2 != null) {
            axisGlyph2.dealPlotBoundsWithLabel(rectangle2D2, n);
            ((ValueAxisGlyph)axisGlyph2).dealPlotBoundsWithAlert(rectangle2D2, n);
        }
        if (axisGlyph3 != null) {
            axisGlyph3.dealPlotBoundsWithLabel(rectangle2D2, n);
            ((ValueAxisGlyph)axisGlyph3).dealPlotBoundsWithAlert(rectangle2D2, n);
        }
        boolean bl = this instanceof Bar3DPlotGlyph ? ((Bar3DPlotGlyph)this).isHorizontal : false;
        this.dealPlotBoundsBefore(rectangle2D2, bl);
        this.calculateAxisGlyphAttr(axisGlyph, rectangle2D2);
        this.calculateAxisGlyphAttr(axisGlyph2, rectangle2D2);
        this.calculateAxisGlyphAttr(axisGlyph3, rectangle2D2);
        this.dealPlotBoundsAfter(rectangle2D2, bl);
        this.dealAxisGridLength(axisGlyph2, axisGlyph3);
        this.setBounds(rectangle2D2);
    }

    private void dealAxisGridLength(AxisGlyph axisGlyph, AxisGlyph axisGlyph2) {
        if (axisGlyph != null && axisGlyph2 != null) {
            double d = axisGlyph.getAxisGridLength() - axisGlyph2.getAxisLabelWidth();
            axisGlyph.setAxisGridLength(d);
            axisGlyph2.setAxisGridLength(d);
        }
    }

    private void dealPlotBoundsBefore(Rectangle2D rectangle2D, boolean bl) {
        double d = this.threeDBase.getGapHeight();
        double d2 = this.threeDBase.getGapWidth();
        if (bl) {
            double d3 = rectangle2D.getX();
            double d4 = rectangle2D.getY() + 2.0 * d;
            double d5 = rectangle2D.getWidth();
            double d6 = rectangle2D.getHeight() - 2.0 * d;
            rectangle2D.setRect(d3, d4, d5, d6);
        } else {
            double d7 = rectangle2D.getX() + 2.0 * d2;
            double d8 = rectangle2D.getY();
            double d9 = rectangle2D.getWidth() - 2.0 * d2;
            double d10 = rectangle2D.getHeight();
            rectangle2D.setRect(d7, d8, d9, d10);
        }
    }

    private void dealPlotBoundsAfter(Rectangle2D rectangle2D, boolean bl) {
        double d = this.threeDBase.getGapHeight();
        double d2 = this.threeDBase.getGapWidth();
        if (bl) {
            double d3 = rectangle2D.getX();
            double d4 = rectangle2D.getY() - d;
            double d5 = rectangle2D.getWidth();
            double d6 = rectangle2D.getHeight() + 2.0 * d;
            rectangle2D.setRect(d3, d4, d5, d6);
        } else {
            double d7 = rectangle2D.getX() - d2;
            double d8 = rectangle2D.getY();
            double d9 = rectangle2D.getWidth() + 2.0 * d2;
            double d10 = rectangle2D.getHeight();
            rectangle2D.setRect(d7, d8, d9, d10);
        }
    }

    protected int get3DDeep(Plot3DGlyph plot3DGlyph) {
        int n = plot3DGlyph.getDeep();
        if (n == -1) {
            n = plot3DGlyph.getProjection().projecteeDeep(plot3DGlyph.getDeepBase());
        }
        if (this.isNeedDefaultDeep()) {
            n = 100;
        }
        return n;
    }

    protected void drawAxisGlyph4ThreeD(AxisGlyph axisGlyph, Graphics graphics, int n) {
        if (axisGlyph != null) {
            axisGlyph.draw4ThreeD(graphics, n);
        }
    }

    public void draw3DInfo(Graphics graphics, int n) {
        if (this.threeDBase != null) {
            this.paint(graphics);
            this.threeDBase.draw3DBase(graphics, n);
        }
    }

    public Shape getOutline4Fill() {
        if (this.is3DPlotGlyph()) {
            Point2D point2D = this.threeDBase.getBasePoint();
            double d = this.getyAxisGlyph().getBounds().getWidth();
            double d2 = this.threeDBase.getWidth() - d;
            double d3 = this.threeDBase.getHeight();
            return new Rectangle2D.Double(point2D.getX() + d, point2D.getY(), d2, d3);
        }
        return super.getOutline4Fill();
    }

    public double getPreSum4Line(int n, int n2) {
        return this.getPreSum4Area(n, n2);
    }

    public double getPreSum4Area(int n, int n2) {
        double d = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            d += this.getDataPointPercentValue(this.getSeries(i), n2);
        }
        return d;
    }

    public double getPreSum4Bar(int n, int n2, boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = n - 1; i >= 0; --i) {
            double d3 = this.getDataPointPercentValue(this.getSeries(i), n2);
            if (d3 > 0.0) {
                d += d3;
                continue;
            }
            d2 += d3;
        }
        if (bl) {
            return d2;
        }
        return d;
    }

    public double getBarPercent(int n) {
        return 0.0;
    }

    public double getBarStartPercent(double d, int n, BarDataWithAxisGlyph barDataWithAxisGlyph) {
        return 0.0;
    }

    public double getDataPointPercentValue(int n, int n2) {
        return this.getDataPointPercentValue(this.getSeries(n), n2);
    }

    private double getDataPointPercentValue(DataSeries dataSeries, int n) {
        double d = dataSeries.getDataPoint(n).getValue();
        if (!this.getyAxisGlyph().isPercentage()) {
            return d;
        }
        double d2 = 0.0;
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            DataSeries dataSeries2 = this.getSeries(i);
            d2 += Math.abs(dataSeries2.getDataPoint(n).getValue());
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        return d / d2;
    }

    public boolean equals(Object object) {
        return object instanceof CategoryPlotGlyph && super.equals(object) && ((CategoryPlotGlyph)object).isStacked() == this.isStacked;
    }

    public boolean isNeedDefaultDeep() {
        return false;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isStacked", this.isStacked);
        return jSONObject;
    }
}

