/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.background.ColorBackground;
import com.fr.chart.base.AttrAlpha;
import com.fr.chart.base.AttrColor;
import com.fr.chart.base.AttrCurveLine;
import com.fr.chart.base.AttrLineStyle;
import com.fr.chart.base.AttrMarkerType;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.base.LineStyleInfo;
import com.fr.chart.base.OuterLight;
import com.fr.chart.base.Shadow;
import com.fr.chart.chartglyph.AreaHighLightChartStyle;
import com.fr.chart.chartglyph.AreaPlane3DStyle;
import com.fr.chart.chartglyph.AreaTopDownShadeStyle;
import com.fr.chart.chartglyph.AreaTransparentChartStyle;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartStyle;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.chart.chartglyph.ConditionCollection;
import com.fr.chart.chartglyph.DataPoint;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.DataSeries4Area;
import com.fr.chart.chartglyph.FoldLine;
import com.fr.chart.chartglyph.MarkerGlyph;
import com.fr.chart.chartglyph.ShapeGlyph;
import com.fr.general.Background;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Arc2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;

public class AreaPlotGlyph
extends CategoryPlotGlyph {
    public static final String XML_TAG = "AreaPlotGlyph";
    private static final long serialVersionUID = -8812027062679027417L;
    private static final double MARKERRAD = 5.0;
    private boolean isCurve = false;

    public void setCurve(boolean bl) {
        this.isCurve = bl;
    }

    public boolean isCurve(DataSeries dataSeries) {
        DataSeriesCondition dataSeriesCondition = this.conditionCollection.getDataSeriesCondition(AttrCurveLine.class, dataSeries);
        if (dataSeriesCondition != null) {
            return ((AttrCurveLine)dataSeriesCondition).isCurve();
        }
        return this.isCurve;
    }

    public void drawShape4Series(Graphics graphics, int n) {
        int[] nArray = this.getDrawSequence();
        int n2 = this.getSeriesSize();
        for (int i = 0; i < n2; ++i) {
            this.getSeries(nArray[i]).draw(graphics, n);
        }
    }

    public void layoutDataSeriesGlyph(int n) {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            this.dealAreaShape4PlotGlyph((DataSeries4Area)this.getSeries(i), this, this.getxAxisGlyph(), this.getSeriesAxisGlyph(i), n);
        }
        this.dealLabelBoundsInOrder();
    }

    public void dealAreaShape4PlotGlyph(DataSeries4Area dataSeries4Area, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, int n) {
        if (dataSeries4Area == null) {
            return;
        }
        GeneralPath generalPath = new GeneralPath(1);
        LineStyleInfo lineStyleInfo = new LineStyleInfo();
        this.fillLineStyleInfo(dataSeries4Area, generalPath, lineStyleInfo);
        GeneralPath generalPath2 = new GeneralPath(1);
        GeneralPath generalPath3 = new GeneralPath(1);
        ShapeGlyph shapeGlyph = new ShapeGlyph(generalPath2);
        dataSeries4Area.setDrawImpl(shapeGlyph);
        shapeGlyph.dealCondition(this.getConditionCollection(), dataSeries4Area, this.createColors4Series());
        if (!this.isExistAttrByResult(dataSeries4Area, AttrAlpha.class)) {
            shapeGlyph.setAlpha(0.5f);
        }
        this.dealLineStyle(shapeGlyph, lineStyleInfo);
        this.dealPath4DataSeriese(dataSeries4Area, categoryPlotGlyph, axisGlyph, axisGlyph2, generalPath, generalPath3, generalPath2, n);
        this.addChartStyle4DataSeries(this.plotStyle, dataSeries4Area, shapeGlyph, generalPath2);
    }

    private void addChartStyle4DataSeries(int n, DataSeries4Area dataSeries4Area, ShapeGlyph shapeGlyph, GeneralPath generalPath) {
        if (shapeGlyph.getBackground() instanceof ColorBackground) {
            Color color = ((ColorBackground)shapeGlyph.getBackground()).getColor();
            ChartStyle chartStyle = null;
            boolean bl = this.getyAxisGlyph().hasAxisReversed();
            if (n == 1) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(0));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaPlane3DStyle(color, true, generalPath, bl);
            } else if (n == 2) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaHighLightChartStyle(color, true, generalPath, bl);
            } else if (n == 4) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaTopDownShadeStyle(color, true, generalPath, bl);
            } else if (n == 5) {
                LineStyleInfo lineStyleInfo = new LineStyleInfo();
                lineStyleInfo.setAttrLineColor(new AttrColor(color));
                lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
                dataSeries4Area.getTopFoldLine().setLineStyleInfo(lineStyleInfo);
                chartStyle = new AreaTransparentChartStyle(color, true, generalPath);
            }
            if (chartStyle != null) {
                dataSeries4Area.setDataSeriesStyle(chartStyle);
            }
        }
    }

    private void fillLineStyleInfo(DataSeries4Area dataSeries4Area, GeneralPath generalPath, LineStyleInfo lineStyleInfo) {
        FoldLine foldLine = new FoldLine(generalPath);
        dataSeries4Area.setTopFoldLine(foldLine);
        foldLine.setLineStyleInfo(lineStyleInfo);
        OuterLight outerLight = new OuterLight();
        outerLight.setOuterAlpha(0.4f);
        outerLight.setOutSize(10);
        outerLight.setOuterColor(Color.gray);
        lineStyleInfo.setOuterLight(outerLight);
        Shadow shadow = new Shadow();
        shadow.setShadowAlpha(0.2f);
        shadow.setShadowColor(Color.gray);
        shadow.setShadowSize(4);
        lineStyleInfo.setShadow(shadow);
    }

    private void dealLineStyle(ShapeGlyph shapeGlyph, LineStyleInfo lineStyleInfo) {
        Color color = Color.blue;
        Background background = shapeGlyph.getBackground();
        if (background instanceof ColorBackground) {
            color = ((ColorBackground)background).getColor();
        }
        lineStyleInfo.setAttrLineColor(new AttrColor(color));
        lineStyleInfo.setAttrLineStyle(new AttrLineStyle(5));
    }

    private void dealPath4DataSeriese(DataSeries dataSeries, CategoryPlotGlyph categoryPlotGlyph, AxisGlyph axisGlyph, AxisGlyph axisGlyph2, GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, int n) {
        boolean bl = this.isCurve(dataSeries);
        double[] dArray = new double[dataSeries.getDataPointCount()];
        double d = axisGlyph2.getCrossValueInPlot();
        float f = (float)axisGlyph2.getPoint2D(d).getY();
        for (int i = 0; i < dataSeries.getDataPointCount(); ++i) {
            DataPoint dataPoint = dataSeries.getDataPoint(i);
            if (dataPoint.isValueIsNull()) continue;
            double d2 = categoryPlotGlyph.getDataPointPercentValue(dataSeries.getSeriesIndex(), i);
            float f2 = (float)axisGlyph.getPoint2D(axisGlyph.getTickIndex4Value(i)).getX();
            if (this.isDataPointXNotInPlotBounds(f2)) continue;
            double d3 = categoryPlotGlyph.getPreSum4Area(dataSeries.getSeriesIndex(), i);
            float f3 = (float)(axisGlyph2.getBounds().getY() + (double)((float)axisGlyph2.getPoint2D(d3 + d2).getY()));
            dArray[i] = axisGlyph2.getBounds().getY() + (double)((float)axisGlyph2.getPoint2D(d3).getY());
            this.movePathWithEveryDataPoint(generalPath2, generalPath, generalPath3, i, f2, f3, bl);
            dataPoint.setShape(new Arc2D.Double(f2 - 3.0f, f3 - 3.0f, 6.0, 6.0, 0.0, 360.0, 2));
            this.initMarkerGlyph(dataPoint, f2, f3);
            this.dealDataPointLabel(dataPoint, n);
        }
        this.completionCurve(generalPath2, generalPath, generalPath3, bl);
        this.areaAndCurvePathMove(dataSeries, generalPath2, generalPath3, axisGlyph, dArray, f, bl);
    }

    private void initMarkerGlyph(DataPoint dataPoint, float f, float f2) {
        this.checkComMarker();
        MarkerGlyph markerGlyph = new MarkerGlyph();
        markerGlyph.dealCondition4Line(this.getConditionCollection(), dataPoint, this.createColors4Series());
        markerGlyph.setShape(new Rectangle2D.Double((double)f - 5.0, (double)f2 - 5.0, 10.0, 10.0));
        markerGlyph.getMarker().setPlotBackground(this.getBackground() != null ? this.getBackground() : this.getWholeChartBackground());
        dataPoint.setDrawImpl(markerGlyph);
    }

    private void checkComMarker() {
        ConditionCollection conditionCollection = this.getConditionCollection();
        ConditionAttr conditionAttr = conditionCollection.getDefaultAttr();
        AttrMarkerType attrMarkerType = conditionAttr.getExisted(AttrMarkerType.class);
        if (attrMarkerType == null) {
            conditionAttr.addDataSeriesCondition(new AttrMarkerType("NullMarker"));
        }
    }

    private void movePathWithXAxisGlyph(DataSeries dataSeries, AxisGlyph axisGlyph, GeneralPath generalPath, GeneralPath generalPath2, int n, float f) {
        if (n == 0) {
            generalPath.moveTo((float)axisGlyph.getPoint2D(n - 1).getX(), f);
        }
        if (n > 0) {
            generalPath.lineTo((float)axisGlyph.getPoint2D(n - 1).getX(), f);
            generalPath2.lineTo((float)axisGlyph.getPoint2D(n - 1).getX(), f);
        }
        generalPath.lineTo((float)axisGlyph.getPoint2D(n).getX(), f);
        generalPath2.lineTo((float)axisGlyph.getPoint2D(n).getX(), f);
        if (n < dataSeries.getDataPointCount() && dataSeries.getDataPointCount() > 1) {
            generalPath2.lineTo((float)axisGlyph.getPoint2D(n + 1).getX(), f);
            generalPath.lineTo((float)axisGlyph.getPoint2D(n + 1).getX(), f);
        }
    }

    private void movePathWithEveryDataPoint(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, int n, float f, float f2, boolean bl) {
        if (bl) {
            if (n == 0 || generalPath.getCurrentPoint() == null) {
                generalPath.moveTo(f, f2);
            } else {
                generalPath.lineTo(f, f2);
            }
        } else {
            if (n == 0 || generalPath2.getCurrentPoint() == null) {
                generalPath2.moveTo(f, f2);
            } else {
                generalPath2.lineTo(f, f2);
            }
            if (n == 0 || generalPath3.getCurrentPoint() == null) {
                generalPath3.moveTo(f, f2);
            } else {
                generalPath3.lineTo(f, f2);
            }
        }
    }

    private void completionCurve(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, boolean bl) {
        if (bl) {
            ChartUtils.curveTo(generalPath2, generalPath);
            ChartUtils.curveTo(generalPath3, generalPath);
            generalPath.reset();
        }
    }

    private void areaAndCurvePathMove(DataSeries dataSeries, GeneralPath generalPath, GeneralPath generalPath2, AxisGlyph axisGlyph, double[] dArray, float f, boolean bl) {
        this.pathMoveWithStacked(dataSeries, generalPath, generalPath2, axisGlyph, dArray, bl);
    }

    private void pathMoveWithStacked(DataSeries dataSeries, GeneralPath generalPath, GeneralPath generalPath2, AxisGlyph axisGlyph, double[] dArray, boolean bl) {
        if (bl) {
            for (int i = dArray.length - 1; i >= 0; --i) {
                float f;
                if (dataSeries.getDataPoint(i).isValueIsNull() || this.isDataPointXNotInPlotBounds(f = (float)axisGlyph.getPoint2D(axisGlyph.getTickIndex4Value(i)).getX())) continue;
                if (i == dArray.length - 1) {
                    generalPath.moveTo(f, (float)dArray[i]);
                    continue;
                }
                generalPath.lineTo(f, (float)dArray[i]);
            }
            ChartUtils.curveTo(generalPath2, generalPath);
            generalPath.reset();
        } else {
            for (int i = dArray.length - 1; i >= 0; --i) {
                float f;
                if (dataSeries.getDataPoint(i).isValueIsNull() || this.isDataPointXNotInPlotBounds(f = (float)axisGlyph.getPoint2D(axisGlyph.getTickIndex4Value(i)).getX())) continue;
                generalPath2.lineTo(f, (float)dArray[i]);
            }
        }
    }

    protected Rectangle2D getDataPointLabelBoundsWithPosition(Dimension2D dimension2D, Rectangle2D rectangle2D, int n) {
        return this.getDataPointLabelBoundsWithPosition4Line(dimension2D, rectangle2D, n);
    }

    public int[] getDrawSequence() {
        if (this.isStacked()) {
            int n = this.getSeriesSize();
            int[] nArray = new int[n];
            for (int i = 0; i < this.getSeriesSize(); ++i) {
                nArray[i] = n - i - 1;
            }
            return nArray;
        }
        Integer[] integerArray = new Integer[this.getSeriesSize()];
        final double[] dArray = new double[this.getSeriesSize()];
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            integerArray[i] = new Integer(i);
            dArray[i] = -1.0;
            DataSeries dataSeries = this.getSeries(i);
            for (int j = 0; j < dataSeries.getDataPointCount(); ++j) {
                if (dataSeries.getDataPoint(j).isValueIsNull() || !(Math.abs(dataSeries.getDataPoint(j).getValue()) > dArray[i])) continue;
                dArray[i] = Math.abs(dataSeries.getDataPoint(j).getValue());
            }
        }
        Arrays.sort(integerArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Integer n = (Integer)object;
                Integer n2 = (Integer)object2;
                return dArray[n] > dArray[n2] ? -1 : (dArray[n] < dArray[n2] ? 1 : 0);
            }
        });
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        return nArray;
    }

    public boolean equals(Object object) {
        return object instanceof AreaPlotGlyph && super.equals(object) && ((AreaPlotGlyph)object).isCurve == this.isCurve;
    }

    public Object clone() throws CloneNotSupportedException {
        AreaPlotGlyph areaPlotGlyph = (AreaPlotGlyph)super.clone();
        return areaPlotGlyph;
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = super.toJSONObject(repository);
        jSONObject.put("isCurve", this.isCurve);
        return jSONObject;
    }

    public String getPlotDetailType() {
        String string = XML_TAG;
        if (this.isStacked()) {
            string = string + "-Stack";
        }
        if (this.getyAxisGlyph().isPercentage()) {
            string = string + "-Percent";
        }
        return string;
    }

    public String getPlotGlyphType() {
        return XML_TAG;
    }

    public String getChartType() {
        return "Area";
    }
}

