/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.chartattr.PiePlot;
import com.fr.chart.chartglyph.DataSeries;
import com.fr.chart.chartglyph.LineMarkerIcon;
import com.fr.chart.chartglyph.Object3D;
import com.fr.chart.chartglyph.Pie3DPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.Projection;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class Pie3DPlot
extends PiePlot
implements Object3D {
    private static final long serialVersionUID = -5601071892216143828L;
    private static final int THREE_D_PIE_CHART = 1;
    private int depth = 20;
    private Projection projection = new Projection();

    public Pie3DPlot() {
        this.projection.setRotation(0);
        this.projection.setElevation(25);
        this.projection.setFocus(800);
    }

    public PlotGlyph createPlotGlyph(ChartData chartData) {
        Pie3DPlotGlyph pie3DPlotGlyph = new Pie3DPlotGlyph();
        chartData = this.create65Data4New(chartData);
        this.install4PlotGlyph(pie3DPlotGlyph, chartData);
        return pie3DPlotGlyph;
    }

    public void install4PlotGlyph(Pie3DPlotGlyph pie3DPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(pie3DPlotGlyph, chartData);
        pie3DPlotGlyph.setDepth(this.depth);
        pie3DPlotGlyph.setProjection(this.projection);
    }

    public boolean isSupportLeadLine() {
        return true;
    }

    protected void dealCondition(LineMarkerIcon lineMarkerIcon, DataSeries dataSeries, Color[] colorArray) {
        this.dealColorCondition(lineMarkerIcon, dataSeries, colorArray);
    }

    public void setProjection(Projection projection) {
        this.projection = projection;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public String getPlotName() {
        return Inter.getLocText((String)"FR-Chart-Chart_3D") + super.getPlotName();
    }

    public boolean is3D() {
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Projection".equals(string)) {
                this.projection = (Projection)xMLableReader.readXMLObject((XMLReadable)new Projection());
            } else if ("Depth".equals(string)) {
                this.depth = xMLableReader.getAttrAsInt("value", 20);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("Plot");
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Depth").attr("value", this.depth).end();
        if (this.projection != null) {
            this.projection.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public boolean isSupportSeriesDrag() {
        return false;
    }

    public boolean needAnalysisLinePane() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        Pie3DPlot pie3DPlot = (Pie3DPlot)super.clone();
        if (this.projection != null) {
            pie3DPlot.projection = (Projection)this.projection.clone();
        }
        return pie3DPlot;
    }

    public boolean isSupport3D() {
        return true;
    }

    public boolean equals(Object object) {
        return object instanceof Pie3DPlot && super.equals(object) && ((Pie3DPlot)object).depth == this.depth && ComparatorUtils.equals((Object)((Pie3DPlot)object).getProjection(), (Object)this.projection);
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/pie/1";
    }

    public int getDetailType() {
        return 1;
    }
}

