/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.Style;
import com.fr.base.chart.BaseChartPainter;
import com.fr.base.chart.ChangeConfigProvider;
import com.fr.chart.base.AttrChangeConfig;
import com.fr.chart.chartattr.EChartPaintUtils;
import com.fr.chart.chartglyph.AbstractChartPainter;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.general.NameObject;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.CoreGraphHelper;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.html.Tag;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ChartPainter
extends AbstractChartPainter
implements BaseChartPainter {
    private static final long serialVersionUID = 7601506246912210545L;
    private transient int width = 0;
    private transient int height = 0;
    private transient String ID;
    private transient String[] widgetDependenced = new String[0];
    private transient int sheetIndex;
    private transient String ecName;
    private AttrChangeConfig changeConfig;
    private double fontScale = 1.0;

    public ChangeConfigProvider getChangConfig() {
        return this.changeConfig;
    }

    public void setChangeConfig(AttrChangeConfig attrChangeConfig) {
        this.changeConfig = attrChangeConfig;
    }

    public double getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(double d) {
        this.fontScale = d;
    }

    public void addNamedGlyph(String string, Object object) {
        this.nameObjectList.add(new NameObject(string, object));
    }

    public String getGlyphName(int n) {
        return ((NameObject)this.nameObjectList.get(n)).getName();
    }

    public Object getGlyph(int n) {
        return ((NameObject)this.nameObjectList.get(n)).getObject();
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public String getID() {
        return this.ID;
    }

    public void setSheetIndex(int n) {
        this.sheetIndex = n;
    }

    public void setECName(String string) {
        this.ecName = string;
    }

    public String getECName() {
        return this.ecName;
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public void setWidgetDependenced(String[] stringArray) {
        this.widgetDependenced = stringArray;
    }

    public String[] getWidgetDependenced() {
        return this.widgetDependenced;
    }

    public BufferedImage toFloatImage(int n, int n2, int n3) {
        BufferedImage bufferedImage = CoreGraphHelper.createBufferedImage((int)n, (int)n2, (int)6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        Object object = this.getGlyph(this.getSelectedIndex());
        if (object != null) {
            if (object instanceof ChartGlyph) {
                ChartGlyph chartGlyph = (ChartGlyph)object;
                Image image = chartGlyph.toImage(n, n2, n3);
                graphics2D.drawImage(image, 0, 0, null);
                image = null;
            } else if (object instanceof Image) {
                graphics2D.drawImage((Image)object, 0, 0, null);
            }
        }
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }

    public void refreshWithNewPaint(BaseChartPainter baseChartPainter) {
        ChartPainter chartPainter = this;
        chartPainter.removeAllNameObject();
        chartPainter.setWidth(baseChartPainter.getWidth());
        chartPainter.setHeight(baseChartPainter.getHeight());
        for (int i = 0; i < baseChartPainter.getGlyphCount(); ++i) {
            chartPainter.addNamedGlyph(baseChartPainter.getGlyphName(i), baseChartPainter.getGlyph(i));
        }
    }

    public void paint(Graphics graphics, int n, int n2, int n3, Style style) {
        this.paintIndexGlyph(graphics, n, n2, style, this.getSelectedIndex(), n3);
    }

    private void paintIndexGlyph(Graphics graphics, int n, int n2, Style style, int n3, int n4) {
        if (n == 0 || n2 == 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.getGlyphCount() > 0) {
            int n5 = Math.min(Math.max(0, n3), this.getGlyphCount() - 1);
            Object object = this.getGlyph(n5);
            if (object instanceof ChartGlyph) {
                ChartGlyph chartGlyph = (ChartGlyph)object;
                chartGlyph.setExport(true);
                Image image = chartGlyph.toImage(n, n2, n4);
                graphics2D.drawImage(image, 0, 0, null);
                image = null;
            } else if (object instanceof Image) {
                graphics2D.drawImage((Image)object, 0, 0, null);
            }
        }
    }

    public JSONObject createJSONConfig(Repository repository, int n, int n2) {
        return EChartPaintUtils.createJSon4ChartPainter(null, this, repository, n, n2);
    }

    public boolean useChangeModel() {
        return this.changeConfig != null && this.changeConfig.isEnable();
    }

    public JSONObject createJSONConfig(NodeVisitor nodeVisitor, Repository repository, int n, int n2) {
        return EChartPaintUtils.createJSon4ChartPainter(nodeVisitor, this, repository, n, n2);
    }

    public JSONObject toJSONObject(NodeVisitor nodeVisitor, Repository repository, int n, int n2) throws JSONException {
        return this.createJSONConfig(nodeVisitor, repository, n, n2);
    }

    public void paintTag(Repository repository, int n, int n2, Style style, Tag tag) {
        tag.attr("widget", this.createJSONConfig(null, repository, n, n2).toString());
        tag.css("vertical-align", "top");
    }

    public Object clone() throws CloneNotSupportedException {
        ChartPainter chartPainter = (ChartPainter)((Object)super.clone());
        return chartPainter;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("CP");
        super.writeXML(xMLPrintWriter);
        if (this.nameObjectList != null && this.getGlyphCount() > 0) {
            for (int i = 0; i < this.nameObjectList.size(); ++i) {
                if (this.getGlyph(i) instanceof ChartGlyph) {
                    ChartGlyph chartGlyph = (ChartGlyph)this.getGlyph(i);
                    xMLPrintWriter.startTAG("NameGlyph");
                    xMLPrintWriter.startTAG("Name").attr("value", this.getGlyphName(i)).end();
                    chartGlyph.setExport(true);
                    Image image = chartGlyph.toImage(this.getWidth(), this.getHeight(), 96);
                    GeneralXMLTools.writeImage((XMLPrintWriter)xMLPrintWriter, (Image)image);
                    image = null;
                    xMLPrintWriter.end();
                    continue;
                }
                if (!(this.getGlyph(i) instanceof Image)) continue;
                xMLPrintWriter.startTAG("NameGlyph");
                xMLPrintWriter.startTAG("Name").attr("value", this.getGlyphName(i)).end();
                GeneralXMLTools.writeImage((XMLPrintWriter)xMLPrintWriter, (Image)((Image)this.getGlyph(i)));
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals("NameGlyph")) {
            xMLableReader.readXMLObject(new XMLReadable(){
                String glyphName = null;
                Object glyph = null;

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isChildNode()) {
                        String string;
                        String string2 = xMLableReader.getTagName();
                        if (string2.equals("Name") && (string = xMLableReader.getAttrAsString("value", null)) != null) {
                            this.glyphName = string;
                        }
                        if ("IM".equals(string2)) {
                            this.glyph = GeneralXMLTools.readImage((XMLableReader)xMLableReader);
                        }
                        if (this.glyphName != null && this.glyph != null) {
                            ChartPainter.this.addNamedGlyph(this.glyphName, this.glyph);
                        }
                    }
                }
            });
        }
    }

    public boolean equals(Object object) {
        return object instanceof ChartPainter && super.equals(object);
    }
}

