/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.AttrAxisPosition;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.chartattr.CategoryAxis;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartattr.RectanglePlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.DateAxisGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.DateUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;
import java.util.Date;

public abstract class CategoryPlot
extends RectanglePlot {
    private static final long serialVersionUID = 6344220409249871761L;
    public static final double GAP_BETWEEN_PLOTS = 1.0;
    public static final String XML_TAG = "CategoryPlot";
    protected boolean isStacked = false;

    public CategoryPlot() {
        this.setxAxis(new CategoryAxis());
        this.setyAxis(new ValueAxis());
        this.setSecondAxis(new ValueAxis(4));
    }

    public void install4PlotGlyph(CategoryPlotGlyph categoryPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(categoryPlotGlyph, chartData);
        categoryPlotGlyph.setStacked(this.isStacked);
    }

    public void installAxisGlyph(CategoryPlotGlyph categoryPlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        categoryPlotGlyph.setxAxisGlyph(axisGlyph);
        axisGlyph.setAxisType("xAxis");
        categoryPlotGlyph.axisExtendsMaxMinValueWithTrendLine(axisGlyph);
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        categoryPlotGlyph.setyAxisGlyph(axisGlyph2);
        axisGlyph2.setAxisType("yAxis");
        axisGlyph2.initMinMaxValue(this.getMinValueFromData(chartData, axisGlyph2.isLog(), axisGlyph), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT, axisGlyph));
        if (this.isUseSecondAxis()) {
            AxisGlyph axisGlyph3 = this.getSecondAxis().createAxisGlyph(chartData);
            categoryPlotGlyph.setSecondAxisGlyph(axisGlyph3);
            axisGlyph3.setAxisType("secondAxis");
            axisGlyph3.initMinMaxValue(this.getMinValueFromData(chartData, axisGlyph3.isLog(), axisGlyph), this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_RIGHT, axisGlyph));
        }
        super.installAxisGlyph(categoryPlotGlyph, chartData);
    }

    public boolean isStacked() {
        return this.isStacked;
    }

    public void setStacked(boolean bl) {
        this.isStacked = bl;
    }

    public boolean isSupportAxisReverse() {
        return true;
    }

    public boolean isSupportCate() {
        return true;
    }

    public double getMaxValueFromData(ChartData chartData, ChartAxisPosition chartAxisPosition, AxisGlyph axisGlyph) {
        if (this.isStacked) {
            return this.getMaxValue4Stack(chartData, chartAxisPosition, axisGlyph);
        }
        return this.getMaxValue4Normal(chartData, chartAxisPosition, axisGlyph);
    }

    private double getMaxValue4Normal(ChartData chartData, ChartAxisPosition chartAxisPosition, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d = 0.0;
        for (int i = 0; i < normalChartData.getCategoryLabelCount(); ++i) {
            boolean bl = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i));
            for (int j = 0; j < normalChartData.getSeriesCount() && bl; ++j) {
                Number number = normalChartData.getValueAt(j, i);
                if (number == null) continue;
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, j);
                if (!(number.doubleValue() > d) || !ComparatorUtils.equals((Object)((Object)attrAxisPosition.getAxisPosition()), (Object)((Object)chartAxisPosition))) continue;
                d = number.doubleValue();
            }
        }
        if (this.getMinValueFromData((ChartData)normalChartData, false, axisGlyph) == d) {
            return d + 10.0;
        }
        return d;
    }

    private double getMaxValue4Stack(ChartData chartData, ChartAxisPosition chartAxisPosition, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < normalChartData.getCategoryLabelCount(); ++i) {
            double d3 = 0.0;
            boolean bl = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i));
            for (int j = 0; j < normalChartData.getSeriesCount() && bl; ++j) {
                Number number = normalChartData.getValueAt(j, i);
                AttrAxisPosition attrAxisPosition = (AttrAxisPosition)this.getConditionCollection().getDataSeriesCondition(AttrAxisPosition.class, j);
                if (number == null || !(number.doubleValue() >= 0.0) || !ComparatorUtils.equals((Object)((Object)attrAxisPosition.getAxisPosition()), (Object)((Object)chartAxisPosition))) continue;
                d3 += number.doubleValue();
            }
            double d4 = d = d3 > d ? d3 : d;
            if (!bl || !this.getyAxis().isPercentage()) continue;
            d2 = this.getMinMaxValue(d2, i, normalChartData, true, d3);
        }
        if (this.getyAxis().isPercentage()) {
            return d2;
        }
        if (this.getMinValueFromData(chartData, false, axisGlyph) == d) {
            return d + 10.0;
        }
        return d;
    }

    private double getMinValueFromData(ChartData chartData, boolean bl, AxisGlyph axisGlyph) {
        if (this.isStacked) {
            return this.getMinValue4Stack(chartData, bl, axisGlyph);
        }
        return this.getMinValue4Normal(chartData, bl, axisGlyph);
    }

    private double getMinValue4Normal(ChartData chartData, boolean bl, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d = 0.0;
        if (bl) {
            d = Double.MAX_VALUE;
        }
        for (int i = 0; i < normalChartData.getCategoryLabelCount(); ++i) {
            boolean bl2 = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i));
            for (int j = 0; j < normalChartData.getSeriesCount() && bl2; ++j) {
                Number number = normalChartData.getValueAt(j, i);
                if (number == null) continue;
                d = bl ? (number.doubleValue() < d && number.doubleValue() > 0.0 ? number.doubleValue() : d) : (number.doubleValue() < d ? number.doubleValue() : d);
            }
        }
        if (d == Double.MAX_VALUE) {
            return 1.0;
        }
        return d;
    }

    private double getMinValue4Stack(ChartData chartData, boolean bl, AxisGlyph axisGlyph) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        double d = 0.0;
        double d2 = 0.0;
        if (bl) {
            d = Double.MAX_VALUE;
        }
        for (int i = 0; i < normalChartData.getCategoryLabelCount(); ++i) {
            double d3 = 0.0;
            boolean bl2 = this.isInCategoryField(axisGlyph, normalChartData.getCategoryOriginalLabel(i));
            for (int j = 0; j < normalChartData.getSeriesCount() && bl2; ++j) {
                Number number = normalChartData.getValueAt(j, i);
                if (number == null) continue;
                if (number.doubleValue() <= 0.0) {
                    d3 += number.doubleValue();
                    continue;
                }
                if (!bl) continue;
                d = number.doubleValue() < d ? number.doubleValue() : d;
            }
            if (!bl) {
                double d4 = d = d3 < d ? d3 : d;
            }
            if (!bl2 || !this.getyAxis().isPercentage()) continue;
            d2 = this.getMinMaxValue(d2, i, normalChartData, false, d3);
        }
        if (this.getyAxis().isPercentage()) {
            return d2;
        }
        if (d == Double.MAX_VALUE) {
            return 1.0;
        }
        return d;
    }

    protected boolean isInCategoryField(AxisGlyph axisGlyph, Object object) {
        if (axisGlyph instanceof DateAxisGlyph) {
            double d;
            double d2 = axisGlyph.getMinValue();
            double d3 = axisGlyph.getMaxValue();
            Date date = DateUtils.object2Date((Object)object, (boolean)true);
            if (date != null && ((d = ChartBaseUtils.date2Int(date, ((DateAxisGlyph)axisGlyph).getMainType())) < d2 || d > d3)) {
                return false;
            }
        }
        return true;
    }

    private double getMinMaxValue(double d, int n, ChartData chartData, boolean bl, double d2) {
        NormalChartData normalChartData = (NormalChartData)chartData;
        if (this.getyAxis().isPercentage()) {
            double d3 = 0.0;
            for (int i = 0; i < normalChartData.getSeriesCount(); ++i) {
                Number number = normalChartData.getValueAt(i, n);
                if (number == null) continue;
                d3 += Math.abs(number.doubleValue());
            }
            d = bl ? (d2 / d3 > d ? d2 / d3 : d) : (d2 / d3 < d ? d2 / d3 : d);
        }
        return d;
    }

    public boolean match4GUI(Plot plot) {
        if (!(plot instanceof CategoryPlot)) {
            return false;
        }
        boolean bl = ((CategoryPlot)plot).getyAxis().isPercentage();
        return super.match4GUI(plot) && this.isStacked == ((CategoryPlot)plot).isStacked && this.getyAxis().isPercentage() == bl;
    }

    public boolean isSupportDataSheet() {
        return true;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "CateAttr".equals(string = xMLableReader.getTagName())) {
            this.setStacked(xMLableReader.getAttrAsBoolean("isStacked", false));
            if (xMLableReader.getAttrAsBoolean("bgStagger", false)) {
                this.setVerticalIntervalBackgroundColor(xMLableReader.getAttrAsColor("bgColor", Color.black));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("CateAttr").attr("isStacked", this.isStacked);
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        return categoryPlot;
    }

    public boolean equals(Object object) {
        return object instanceof CategoryPlot && super.equals(object) && ((CategoryPlot)object).isStacked() == this.isStacked;
    }
}

