/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.BackgroundProcess;
import org.apache.struts2.util.TokenHelper;
import org.apache.struts2.views.freemarker.FreemarkerResult;

public class ExecuteAndWaitInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = -2754639196749652512L;
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteAndWaitInterceptor.class);
    public static final String KEY = "__execWait";
    public static final String WAIT = "wait";
    protected int delay;
    protected int delaySleepInterval = 100;
    protected boolean executeAfterValidationPass = false;
    private int threadPriority = 5;
    private Container container;

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    protected BackgroundProcess getNewBackgroundProcess(String name, ActionInvocation actionInvocation, int threadPriority) {
        return new BackgroundProcess(name + "BackgroundThread", actionInvocation, threadPriority);
    }

    protected String getBackgroundProcessName(ActionProxy proxy) {
        return proxy.getActionName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doIntercept(ActionInvocation actionInvocation) throws Exception {
        ActionProxy proxy = actionInvocation.getProxy();
        String name = this.getBackgroundProcessName(proxy);
        ActionContext context = actionInvocation.getInvocationContext();
        Map session = context.getSession();
        HttpSession httpSession = ServletActionContext.getRequest().getSession(true);
        Boolean secondTime = true;
        if (this.executeAfterValidationPass) {
            secondTime = (Boolean)context.get(KEY);
            if (secondTime == null) {
                context.put(KEY, (Object)true);
                secondTime = false;
            } else {
                secondTime = true;
                context.put(KEY, null);
            }
        }
        HttpSession httpSession2 = httpSession;
        synchronized (httpSession2) {
            BackgroundProcess bp = (BackgroundProcess)session.get(KEY + name);
            if ((!this.executeAfterValidationPass || secondTime.booleanValue()) && bp == null) {
                bp = this.getNewBackgroundProcess(name, actionInvocation, this.threadPriority);
                session.put(KEY + name, bp);
                this.performInitialDelay(bp);
                secondTime = false;
            }
            if (!(this.executeAfterValidationPass && secondTime.booleanValue() || bp == null || bp.isDone())) {
                Map results;
                actionInvocation.getStack().push(bp.getAction());
                String token = TokenHelper.getToken();
                if (token != null) {
                    TokenHelper.setSessionToken(TokenHelper.getTokenName(), token);
                }
                if (!(results = proxy.getConfig().getResults()).containsKey(WAIT)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("ExecuteAndWait interceptor has detected that no result named 'wait' is available. Defaulting to a plain built-in wait page. It is highly recommend you provide an action-specific or global result named 'wait'.", new String[0]);
                    }
                    FreemarkerResult waitResult = new FreemarkerResult();
                    this.container.inject((Object)waitResult);
                    waitResult.setLocation("/org/apache/struts2/interceptor/wait.ftl");
                    waitResult.execute(actionInvocation);
                    return "none";
                }
                return WAIT;
            }
            if (!(this.executeAfterValidationPass && secondTime.booleanValue() || bp == null || !bp.isDone())) {
                session.remove(KEY + name);
                actionInvocation.getStack().push(bp.getAction());
                if (bp.getException() != null) {
                    throw bp.getException();
                }
                return bp.getResult();
            }
            return actionInvocation.invoke();
        }
    }

    protected void performInitialDelay(BackgroundProcess bp) throws InterruptedException {
        int step;
        if (this.delay <= 0 || this.delaySleepInterval <= 0) {
            return;
        }
        int steps = this.delay / this.delaySleepInterval;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delaying for " + this.delay + " millis. (using " + steps + " steps)", new String[0]);
        }
        for (step = 0; step < steps && !bp.isDone(); ++step) {
            Thread.sleep(this.delaySleepInterval);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sleeping ended after " + step + " steps and the background process is " + (bp.isDone() ? " done" : " not done"), new String[0]);
        }
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDelaySleepInterval(int delaySleepInterval) {
        this.delaySleepInterval = delaySleepInterval;
    }

    public void setExecuteAfterValidationPass(boolean executeAfterValidationPass) {
        this.executeAfterValidationPass = executeAfterValidationPass;
    }
}

