/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.range.component;

import com.fr.chart.base.ChartBaseUtils;
import com.fr.design.event.UIObserver;
import com.fr.design.event.UIObserverListener;
import com.fr.design.mainframe.DesignerContext;
import com.fr.design.style.background.gradient.SelectColorPointBtn;
import com.fr.design.style.color.ColorCell;
import com.fr.design.style.color.ColorSelectConfigManager;
import com.fr.design.style.color.ColorSelectDetailPane;
import com.fr.design.style.color.ColorSelectDialog;
import com.fr.design.style.color.ColorSelectable;
import com.fr.plugin.chart.range.GradualIntervalConfig;
import com.fr.plugin.chart.range.glyph.GradualColorDist;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LegendGradientBar
extends JComponent
implements ColorSelectable,
UIObserver {
    private List<SelectColorPointBtn> selectColorPointBtnList;
    private int startPos = 4;
    private int endPos;
    private SelectColorPointBtn selectColorSlotBtnStart;
    private SelectColorPointBtn selectColorSlotBtnEnd;
    private static final int MOUSE_OFFSET = 4;
    private static final int REC_HEIGHT = 30;
    private static final int MAX_VERTICAL = 45;
    private int colorSelectionBtnNum;
    private Color subColor;
    private int max = 154;
    private int min = 4;
    private Color color;
    private boolean pointIsMoving = false;
    private Color[] colors;
    private float[] dist;
    private static final int OFFSETSTEP = 2;
    int index = -1;
    private UIObserverListener uiObserverListener;
    private List<ChangeListener> changeListenerList = new ArrayList<ChangeListener>();

    public LegendGradientBar() {
        this.endPos = this.max;
        this.setSubColor(new Color(36, 167, 255));
        this.setColorSelectionBtnNum(3);
        this.initColorsAndDist();
        this.initMouseListener();
        this.iniListener();
        this.setPreferredSize(new Dimension(10 + this.max, 45));
    }

    private void initColorsAndDist() {
        this.colors = this.initColors(this.subColor, this.colorSelectionBtnNum);
        this.initColorSelectBtn(this.colors, this.colorSelectionBtnNum);
        this.dist = this.initDist(this.colorSelectionBtnNum);
    }

    private void iniListener() {
        if (this.shouldResponseChangeListener()) {
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (LegendGradientBar.this.uiObserverListener == null) {
                        return;
                    }
                    LegendGradientBar.this.uiObserverListener.doChange();
                }
            });
        }
    }

    private float[] initDist(int n) {
        float[] fArray = new float[n];
        fArray[0] = 0.0f;
        for (int i = 0; i < n - 2; ++i) {
            fArray[i + 1] = (float)((this.selectColorPointBtnList.get(i).getX() - 4.0) / (double)(this.max - 4));
        }
        fArray[n - 1] = 1.0f;
        return fArray;
    }

    private void initMouseListener() {
        this.addMouseEnteredListener();
        this.addMouseClickListener();
        this.addMouseReleasedListener();
        this.addMouseDragListener();
        this.addMouseExitedListener();
    }

    private Color[] initColors(Color color, int n) {
        Color[] colorArray = this.getColorArray(color, n);
        Color[] colorArray2 = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorArray2[i] = colorArray[n - 1 - i];
        }
        return colorArray2;
    }

    private void initColorSelectBtn(Color[] colorArray, int n) {
        int n2;
        Color color = colorArray[0];
        Color color2 = colorArray[n - 1];
        Color[] colorArray2 = new Color[n - 2];
        for (n2 = 0; n2 < colorArray2.length; ++n2) {
            colorArray2[n2] = colorArray[n2 + 1];
        }
        this.selectColorSlotBtnStart = new SelectColorPointBtn((double)this.startPos, 30.0, color, new Color(138, 138, 138));
        this.selectColorSlotBtnEnd = new SelectColorPointBtn((double)this.endPos, 30.0, color2, new Color(138, 138, 138));
        this.selectColorPointBtnList = new ArrayList<SelectColorPointBtn>();
        for (n2 = 0; n2 < colorArray2.length; ++n2) {
            SelectColorPointBtn selectColorPointBtn = new SelectColorPointBtn((double)((this.startPos + this.endPos) / (colorArray2.length + 1) * (n2 + 1)), 30.0, colorArray2[n2]);
            this.selectColorPointBtnList.add(selectColorPointBtn);
        }
        this.repaint();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListenerList.add(changeListener);
    }

    private void addMouseEnteredListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LegendGradientBar.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
    }

    private void addMouseExitedListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                LegendGradientBar.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private void addMouseDragListener() {
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                if (!LegendGradientBar.this.pointIsMoving) {
                    LegendGradientBar.this.index = -1;
                    for (n = 0; n < LegendGradientBar.this.selectColorPointBtnList.size(); ++n) {
                        if (!((SelectColorPointBtn)LegendGradientBar.this.selectColorPointBtnList.get(n)).contains((double)mouseEvent.getX(), (double)mouseEvent.getY())) continue;
                        LegendGradientBar.this.index = n;
                        LegendGradientBar.this.pointIsMoving = true;
                        break;
                    }
                }
                int n2 = n = mouseEvent.getX() <= LegendGradientBar.this.max && mouseEvent.getX() >= LegendGradientBar.this.min ? 1 : 0;
                if (LegendGradientBar.this.index != -1 && n != 0 && mouseEvent.getY() < 45 && mouseEvent.getY() > 0) {
                    ((SelectColorPointBtn)LegendGradientBar.this.selectColorPointBtnList.get(LegendGradientBar.this.index)).setX((double)LegendGradientBar.this.setOffset(mouseEvent.getX(), LegendGradientBar.this.index, 2));
                }
                LegendGradientBar.this.repaint();
            }
        });
    }

    private int setOffset(int n, int n2, int n3) {
        for (int i = 0; i < this.selectColorPointBtnList.size(); ++i) {
            if (i == n2 || (double)n != this.selectColorPointBtnList.get(i).getX()) continue;
            if (n >= (this.min + this.max) / 2) {
                n -= n3;
                n = this.setOffset(n, n2, n3 + 2);
                continue;
            }
            n += n3;
            n = this.setOffset(n, n2, n3 + 2);
        }
        if (n <= this.min) {
            n = this.min + (n2 + 1) * 2;
        } else if (n >= this.max) {
            n = this.max - (n2 + 1) * 2;
        }
        return n;
    }

    private void addMouseClickListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getX() < LegendGradientBar.this.max + 4 && mouseEvent.getX() > 0) {
                    int n = -1;
                    for (int i = 0; i < LegendGradientBar.this.selectColorPointBtnList.size(); ++i) {
                        if (!((SelectColorPointBtn)LegendGradientBar.this.selectColorPointBtnList.get(i)).contains((double)mouseEvent.getX(), (double)mouseEvent.getY())) continue;
                        n = i;
                        break;
                    }
                    if (n >= 0) {
                        ColorSelectDetailPane colorSelectDetailPane = new ColorSelectDetailPane(Color.WHITE);
                        ColorSelectDialog.showDialog((Frame)DesignerContext.getDesignerFrame(), (ColorSelectDetailPane)colorSelectDetailPane, (Color)Color.WHITE, (ColorSelectable)LegendGradientBar.this);
                        Color color = LegendGradientBar.this.getColor();
                        if (color != null) {
                            ColorSelectConfigManager.getInstance().addToColorQueue(color);
                            ((SelectColorPointBtn)LegendGradientBar.this.selectColorPointBtnList.get(n)).setColorInner(color);
                            LegendGradientBar.this.repaint();
                        }
                    } else if (LegendGradientBar.this.selectColorSlotBtnStart.contains((double)mouseEvent.getX(), (double)mouseEvent.getY())) {
                        ColorSelectDetailPane colorSelectDetailPane = new ColorSelectDetailPane(Color.WHITE);
                        ColorSelectDialog.showDialog((Frame)DesignerContext.getDesignerFrame(), (ColorSelectDetailPane)colorSelectDetailPane, (Color)Color.WHITE, (ColorSelectable)LegendGradientBar.this);
                        Color color = LegendGradientBar.this.getColor();
                        if (color != null) {
                            ColorSelectConfigManager.getInstance().addToColorQueue(color);
                            LegendGradientBar.this.selectColorSlotBtnStart.setColorInner(color);
                            LegendGradientBar.this.repaint();
                        }
                    } else if (LegendGradientBar.this.selectColorSlotBtnEnd.contains((double)mouseEvent.getX(), (double)mouseEvent.getY())) {
                        ColorSelectDetailPane colorSelectDetailPane = new ColorSelectDetailPane(Color.WHITE);
                        ColorSelectDialog.showDialog((Frame)DesignerContext.getDesignerFrame(), (ColorSelectDetailPane)colorSelectDetailPane, (Color)Color.WHITE, (ColorSelectable)LegendGradientBar.this);
                        Color color = LegendGradientBar.this.getColor();
                        if (color != null) {
                            ColorSelectConfigManager.getInstance().addToColorQueue(color);
                            LegendGradientBar.this.selectColorSlotBtnEnd.setColorInner(color);
                            LegendGradientBar.this.repaint();
                        }
                    }
                    LegendGradientBar.this.repaint();
                }
            }
        });
    }

    private void addMouseReleasedListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                LegendGradientBar.this.pointIsMoving = false;
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Float float_ = new Point2D.Float(4.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(this.max, 0.0f);
        this.refreshColorsAndDist(this.selectColorPointBtnList);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(float_, float_2, this.dist, this.colors);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fillRect(4, 0, this.max - 4, 30);
        graphics2D.setColor(new Color(138, 138, 138));
        graphics2D.drawRect(4, 0, this.max - 4, 30);
        this.selectColorSlotBtnStart.paint((Graphics)graphics2D);
        this.selectColorSlotBtnEnd.paint((Graphics)graphics2D);
        for (int i = 0; i < this.selectColorPointBtnList.size(); ++i) {
            this.selectColorPointBtnList.get(i).paint((Graphics)graphics2D);
        }
    }

    private void refreshColorsAndDist(List<SelectColorPointBtn> list) {
        int n;
        ArrayList<SelectColorPointBtn> arrayList = new ArrayList<SelectColorPointBtn>(list);
        Collections.sort(arrayList);
        this.colors[0] = this.selectColorSlotBtnStart.getColorInner();
        for (n = 0; n < this.colorSelectionBtnNum - 2; ++n) {
            this.colors[n + 1] = ((SelectColorPointBtn)arrayList.get(n)).getColorInner();
        }
        this.colors[this.colorSelectionBtnNum - 1] = this.selectColorSlotBtnEnd.getColorInner();
        this.dist = new float[this.colorSelectionBtnNum];
        this.dist[0] = 0.0f;
        for (n = 0; n < this.colorSelectionBtnNum - 2; ++n) {
            this.dist[n + 1] = (float)((((SelectColorPointBtn)arrayList.get(n)).getX() - 4.0) / (double)(this.max - 4));
        }
        this.dist[this.colorSelectionBtnNum - 1] = 1.0f;
        this.fireColorAndDistChangeListener();
    }

    public void refreshSubColor(Color color) {
        this.setSubColor(color);
        Color[] colorArray = this.initColors(color, this.colorSelectionBtnNum);
        this.initColorSelectBtn(colorArray, this.colorSelectionBtnNum);
    }

    public void refreshColorSelectionBtnNum(int n) {
        this.colorSelectionBtnNum = n + 1;
        this.colors = this.initColors(this.subColor, this.colorSelectionBtnNum);
        this.initColorSelectBtn(this.colors, this.colorSelectionBtnNum);
        this.dist = this.initDist(this.colorSelectionBtnNum);
    }

    private Color[] getColorArray(Color color, int n) {
        return ChartBaseUtils.createColorsWithHSB((Color)color, (int)n);
    }

    public Color getSubColor() {
        return this.subColor;
    }

    public void setSubColor(Color color) {
        this.subColor = color;
    }

    public int getColorSelectionBtnNum() {
        return this.colorSelectionBtnNum;
    }

    public void setColorSelectionBtnNum(int n) {
        this.colorSelectionBtnNum = n;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void colorSetted(ColorCell colorCell) {
    }

    public void populate(GradualIntervalConfig gradualIntervalConfig) {
        if (gradualIntervalConfig == null) {
            return;
        }
        this.setSubColor(gradualIntervalConfig.getSubColor());
        this.setColorSelectionBtnNum((int)(gradualIntervalConfig.getDivStage() + 1.0));
        this.populateColorAndDist(gradualIntervalConfig.getGradualColorDistList());
        this.refreshColorSelectBtn(this.colors, this.dist);
    }

    private void populateColorAndDist(ArrayList<GradualColorDist> arrayList) {
        int n = arrayList.size();
        this.colors = new Color[n];
        this.dist = new float[n];
        for (int i = 0; i < n; ++i) {
            this.colors[i] = arrayList.get(i).getColor();
            this.dist[i] = arrayList.get(i).getPosition();
        }
    }

    public void update(GradualIntervalConfig gradualIntervalConfig) {
        ArrayList<GradualColorDist> arrayList = new ArrayList<GradualColorDist>();
        for (int i = 0; i < this.getColorSelectionBtnNum(); ++i) {
            arrayList.add(new GradualColorDist(this.dist[i], this.colors[i]));
        }
        gradualIntervalConfig.setGradualColorDistList(arrayList);
    }

    private void refreshColorSelectBtn(Color[] colorArray, float[] fArray) {
        int n;
        Color color = colorArray[0];
        Color color2 = colorArray[colorArray.length - 1];
        Color[] colorArray2 = new Color[colorArray.length - 2];
        for (int i = 0; i < colorArray2.length; ++i) {
            colorArray2[i] = colorArray[i + 1];
        }
        float[] fArray2 = new float[fArray.length - 2];
        for (n = 0; n < fArray2.length; ++n) {
            fArray2[n] = fArray[n + 1] * (float)(this.max - 4) + 4.0f;
        }
        this.selectColorSlotBtnStart = new SelectColorPointBtn((double)this.startPos, 30.0, color, new Color(138, 138, 138));
        this.selectColorSlotBtnEnd = new SelectColorPointBtn((double)this.endPos, 30.0, color2, new Color(138, 138, 138));
        this.selectColorPointBtnList = new ArrayList<SelectColorPointBtn>();
        for (n = 0; n < colorArray2.length; ++n) {
            SelectColorPointBtn selectColorPointBtn = new SelectColorPointBtn((double)fArray2[n], 30.0, colorArray2[n]);
            this.selectColorPointBtnList.add(selectColorPointBtn);
        }
        this.repaint();
    }

    public void registerChangeListener(UIObserverListener uIObserverListener) {
        this.uiObserverListener = uIObserverListener;
    }

    public boolean shouldResponseChangeListener() {
        return true;
    }

    public void fireColorAndDistChangeListener() {
        if (!this.changeListenerList.isEmpty()) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.changeListenerList.size(); ++i) {
                this.changeListenerList.get(i).stateChanged(changeEvent);
            }
        }
    }
}

