/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.glyph;

import com.fr.base.background.ColorBackground;
import com.fr.base.background.GradientBackground;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.chart.attr.VanChartAttrHelper;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public class VanChartLegendGlyph
extends LegendGlyph {
    private static final long serialVersionUID = -4016910054344665747L;
    private boolean floating;
    private double floatPercentX;
    private double floatPercentY;
    private boolean limitSize;
    private double maxHeight;

    public void setFloating(boolean bl) {
        this.floating = bl;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloatPercentX(double d) {
        this.floatPercentX = d;
    }

    public double getFloatPercentX() {
        return this.floatPercentX;
    }

    public void setFloatPercentY(double d) {
        this.floatPercentY = d;
    }

    public double getFloatPercentY() {
        return this.floatPercentY;
    }

    public void setLimitSize(boolean bl) {
        this.limitSize = bl;
    }

    public boolean isLimitSize() {
        return this.limitSize;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    protected void setLegendBounds(Rectangle2D rectangle2D) {
        this.setBounds(ChartBaseUtils.rectangle2RoundRectangle((Rectangle2D)rectangle2D, (double)this.getRoundRadius()));
    }

    protected void refreshChartBoundsWithLegendBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double d, double d2) {
        if (this.isFloating()) {
            return;
        }
        super.refreshChartBoundsWithLegendBounds(rectangle2D, rectangle2D2, d, d2);
    }

    private boolean limitHeight() {
        return this.getPosition() == 1 || this.getPosition() == 3;
    }

    private boolean limitWidth() {
        return this.getPosition() == 4 || this.getPosition() == 8 || this.getPosition() == 2;
    }

    protected double getLegendX(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (this.isFloating()) {
            return rectangle2D.getX() + rectangle2D.getWidth() * this.getFloatPercentX() / 100.0;
        }
        return super.getLegendX(rectangle2D, rectangle2D2, n);
    }

    protected double getLegendY(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (this.isFloating()) {
            return rectangle2D.getY() + rectangle2D.getHeight() * this.getFloatPercentY() / 100.0;
        }
        return super.getLegendY(rectangle2D, rectangle2D2, n);
    }

    protected double getLegendWidth(Rectangle2D rectangle2D, int n) {
        if (this.isFloating()) {
            return super.getLegendWidth(rectangle2D, n);
        }
        if (this.isLimitSize() && this.limitWidth()) {
            return Math.min(super.getLegendWidth(rectangle2D, n), rectangle2D.getWidth() * this.getMaxHeight() / 100.0);
        }
        return super.getLegendWidth(rectangle2D, n);
    }

    protected double getLegendHeight(Rectangle2D rectangle2D, int n) {
        if (this.isFloating()) {
            return super.getLegendHeight(rectangle2D, n);
        }
        if (this.isLimitSize() && this.limitHeight()) {
            return Math.min(super.getLegendHeight(rectangle2D, n), rectangle2D.getHeight() * this.getMaxHeight() / 100.0);
        }
        return super.getLegendHeight(rectangle2D, n);
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("enabled", this.isVisible());
        if (!this.isVisible()) {
            return jSONObject;
        }
        if (this.getBorderColor() != null) {
            jSONObject.put("borderColor", (Object)StableUtils.javaColorToCSSColor((Color)this.getBorderColor()));
        } else {
            jSONObject.put("borderColor", (Object)"rgba(255,255,255,0)");
        }
        jSONObject.put("borderWidth", VanChartAttrHelper.getAxisLineStyle(this.getBorderStyle()));
        jSONObject.put("borderRadius", this.getRoundRadius());
        Background background = this.getBackground();
        if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"ColorBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getRGBAColorWithColorAndAlpha(((ColorBackground)background).getColor(), this.getAlpha()));
        } else if (background != null && ComparatorUtils.equals((Object)background.getBackgroundType(), (Object)"GradientBackground")) {
            jSONObject.put("backgroundColor", (Object)VanChartAttrHelper.getGradientBackgroundJSON((GradientBackground)background, this.getAlpha()));
        }
        jSONObject.put("shadow", this.isShadow());
        if (this.isFloating()) {
            jSONObject.put("floating", this.isFloating());
            jSONObject.put("x", (Object)(this.getFloatPercentX() + "%"));
            jSONObject.put("y", (Object)(this.getFloatPercentY() + "%"));
        } else {
            jSONObject.put("position", (Object)ChartUtils.getPositionString((int)this.getPosition()));
            if (this.isLimitSize()) {
                if (this.getPosition() == 1 || this.getPosition() == 3) {
                    jSONObject.put("maxHeight", (Object)(this.getMaxHeight() + "%"));
                } else {
                    jSONObject.put("maxWidth", (Object)(this.getMaxHeight() + "%"));
                }
            }
        }
        jSONObject.put("style", (Object)VanChartAttrHelper.getCSSFontJSONWithFont(this.getFont()));
        return jSONObject;
    }

    public void addLegendJSON(JSONObject jSONObject, Repository repository) throws JSONException {
        jSONObject.put("legend", (Object)this.toJSONObject(repository));
    }
}

