/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.designer.style.tooltip;

import com.fr.chart.base.DataSeriesCondition;
import com.fr.chart.chartattr.Chart;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartglyph.ConditionAttr;
import com.fr.design.dialog.BasicScrollPane;
import com.fr.general.Inter;
import com.fr.plugin.chart.attr.plot.VanChartPlot;
import com.fr.plugin.chart.base.AttrTooltip;
import com.fr.plugin.chart.designer.PlotFactory;
import com.fr.plugin.chart.designer.style.VanChartStylePane;
import com.fr.plugin.chart.designer.style.tooltip.VanChartPlotTooltipPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class VanChartTooltipPane
extends BasicScrollPane<Chart> {
    private static final long serialVersionUID = -2974722365840564105L;
    private VanChartPlotTooltipPane tooltipPane;
    private Chart chart;
    protected VanChartStylePane parent;

    public VanChartTooltipPane(VanChartStylePane vanChartStylePane) {
        this.parent = vanChartStylePane;
    }

    protected JPanel createContentPane() {
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.chart == null) {
            return jPanel;
        }
        this.tooltipPane = this.getTooltipPane(this.chart.getPlot());
        jPanel.add((Component)((Object)this.tooltipPane), "North");
        return jPanel;
    }

    public void populateBean(Chart chart) {
        this.chart = chart;
        if (this.tooltipPane == null) {
            this.remove(this.leftcontentPane);
            this.layoutContentPane();
            this.parent.initAllListeners();
        }
        Plot plot = this.chart.getPlot();
        DataSeriesCondition dataSeriesCondition = ((VanChartPlot)plot).getAttrTooltipFromConditionCollection();
        if (this.tooltipPane != null) {
            this.tooltipPane.populate((AttrTooltip)dataSeriesCondition);
        }
    }

    public void updateBean(Chart chart) {
        AttrTooltip attrTooltip;
        if (chart == null) {
            return;
        }
        ConditionAttr conditionAttr = chart.getPlot().getConditionCollection().getDefaultAttr();
        DataSeriesCondition dataSeriesCondition = ((VanChartPlot)chart.getPlot()).getAttrTooltipFromConditionCollection();
        if (dataSeriesCondition != null) {
            conditionAttr.remove(dataSeriesCondition);
        }
        if ((attrTooltip = this.tooltipPane.update()) != null) {
            conditionAttr.addDataSeriesCondition((DataSeriesCondition)attrTooltip);
        }
    }

    protected String title4PopupWindow() {
        return Inter.getLocText((String)"Plugin-Chart_Tooltip");
    }

    protected VanChartPlotTooltipPane getTooltipPane(Plot plot) {
        return PlotFactory.createPlotTooltipPane(plot, this.parent);
    }
}

