/*
 * Decompiled with CFR 0.152.
 */
package com.fr.plugin.chart.attr;

import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.chart.chartattr.Title;
import com.fr.chart.chartglyph.GeneralInfo;
import com.fr.general.FRFont;
import com.fr.general.Inter;
import com.fr.plugin.chart.glyph.VanChartTitleGlyph;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class VanChartTitle
extends Title {
    private static final long serialVersionUID = -618243870663433046L;
    public static final String XML_TAG = "Title4VanChart";
    private boolean useHtml = false;
    private boolean floating = false;
    private double floatPercentX;
    private double floatPercentY;
    private boolean limitSize = false;
    private double maxHeight = 15.0;

    public VanChartTitle() {
        FRFont fRFont = FRFont.getInstance((String)"Microsoft YaHei", (int)0, (float)16.0f, (Color)new Color(51, 51, 51));
        this.getTextAttr().setFRFont(fRFont);
        this.setTextObject(Inter.getLocText((String)"FR-Chart-Title_NewTitle"));
    }

    public VanChartTitle(Object object) {
        super(object);
    }

    public void setUseHtml(boolean bl) {
        this.useHtml = bl;
    }

    public boolean isUseHtml() {
        return this.useHtml;
    }

    public void setFloating(boolean bl) {
        this.floating = bl;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloatPercentX(double d) {
        this.floatPercentX = d;
    }

    public double getFloatPercentX() {
        return this.floatPercentX;
    }

    public void setFloatPercentY(double d) {
        this.floatPercentY = d;
    }

    public double getFloatPercentY() {
        return this.floatPercentY;
    }

    public void setLimitSize(boolean bl) {
        this.limitSize = bl;
    }

    public boolean isLimitSize() {
        return this.limitSize;
    }

    public void setMaxHeight(double d) {
        this.maxHeight = d;
    }

    public double getMaxHeight() {
        return this.maxHeight;
    }

    public VanChartTitleGlyph createGlyph() {
        Object object;
        String string = Utils.objectToString((Object)this.getTextObject());
        if (this.getTextObject() instanceof Formula && (object = (Formula)this.getTextObject()).getResult() != null) {
            string = Utils.objectToString((Object)object.getResult());
        }
        object = new VanChartTitleGlyph(string.trim(), this.getTextAttr());
        object.setGeneralInfo((GeneralInfo)this);
        object.setPosition(this.getPosition());
        object.setVisible(this.isTitleVisible());
        ((VanChartTitleGlyph)((Object)object)).setUseHtml(this.isUseHtml());
        ((VanChartTitleGlyph)((Object)object)).setFloating(this.isFloating());
        ((VanChartTitleGlyph)((Object)object)).setFloatPercentX(this.getFloatPercentX());
        ((VanChartTitleGlyph)((Object)object)).setFloatPercentY(this.getFloatPercentY());
        ((VanChartTitleGlyph)((Object)object)).setMaxHeight(this.getMaxHeight());
        ((VanChartTitleGlyph)((Object)object)).setLimitSize(this.isLimitSize());
        return object;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "Attr4VanChart".equals(string = xMLableReader.getTagName())) {
            this.setUseHtml(xMLableReader.getAttrAsBoolean("useHtml", false));
            this.setFloating(xMLableReader.getAttrAsBoolean("floating", false));
            this.setFloatPercentX(xMLableReader.getAttrAsInt("x", 0));
            this.setFloatPercentY(xMLableReader.getAttrAsInt("y", 0));
            this.setLimitSize(xMLableReader.getAttrAsBoolean("limitSize", false));
            this.setMaxHeight(xMLableReader.getAttrAsFloat("maxHeight", 0.0f));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attr4VanChart").attr("useHtml", this.isUseHtml()).attr("floating", this.isFloating()).attr("x", this.getFloatPercentX()).attr("y", this.getFloatPercentY()).attr("limitSize", this.isLimitSize()).attr("maxHeight", this.getMaxHeight()).end();
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof VanChartTitle && super.equals(object) && ((VanChartTitle)((Object)object)).isUseHtml() == this.isUseHtml() && ((VanChartTitle)((Object)object)).isFloating() == this.isFloating() && ((VanChartTitle)((Object)object)).getFloatPercentX() == this.getFloatPercentX() && ((VanChartTitle)((Object)object)).getFloatPercentY() == this.getFloatPercentY() && ((VanChartTitle)((Object)object)).isLimitSize() == this.isLimitSize() && ((VanChartTitle)((Object)object)).getMaxHeight() == this.getMaxHeight();
    }

    public Object clone() throws CloneNotSupportedException {
        VanChartTitle vanChartTitle = (VanChartTitle)((Object)super.clone());
        vanChartTitle.setUseHtml(this.isUseHtml());
        vanChartTitle.setFloating(this.isFloating());
        vanChartTitle.setFloatPercentX(this.getFloatPercentX());
        vanChartTitle.setFloatPercentY(this.getFloatPercentY());
        vanChartTitle.setLimitSize(this.isLimitSize());
        vanChartTitle.setMaxHeight(this.getMaxHeight());
        return vanChartTitle;
    }
}

