/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.openwebflow.identity.IdentityMembershipManager;
import org.openwebflow.identity.UserDetailsEntity;
import org.openwebflow.identity.UserDetailsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdentityUtils {
    public static List<Group> getGroupsFromIds(List<String> groupIds) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String groupId : groupIds) {
            groups.add((Group)new GroupEntity(groupId));
        }
        return groups;
    }

    public static List<String> getInvolvedUsers(TaskService taskService, Task task, IdentityMembershipManager membershipManager) throws Exception {
        HashMap<String, Object> userIds = new HashMap<String, Object>();
        String assignee = task.getAssignee();
        if (assignee != null) {
            userIds.put(assignee, new Object());
        } else {
            for (IdentityLink link : taskService.getIdentityLinksForTask(task.getId())) {
                String groupId;
                String userId = link.getUserId();
                if (userId != null) {
                    userIds.put(userId, new Object());
                }
                if ((groupId = link.getGroupId()) == null) continue;
                for (String gUserId : membershipManager.findUserIdsByGroup(groupId)) {
                    userIds.put(gUserId, new Object());
                }
            }
        }
        return new ArrayList<String>(userIds.keySet());
    }

    public static List<UserDetailsEntity> getUserDetailsFromIds(List<String> userIds, UserDetailsManager userDetailsManager) throws Exception {
        ArrayList<UserDetailsEntity> detailsList = new ArrayList<UserDetailsEntity>();
        for (String userId : userIds) {
            detailsList.add(userDetailsManager.findUserDetails(userId));
        }
        return detailsList;
    }
}

