/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.mgr.mem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.openwebflow.identity.IdentityMembershipManager;
import org.openwebflow.mgr.ext.IdentityMembershipManagerEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryMembershipManager
implements IdentityMembershipManager,
IdentityMembershipManagerEx {
    private Map<String, Group> _groups = new HashMap<String, Group>();
    private List<Membership> _memberships = new ArrayList<Membership>();

    public Group createGroup(String groupId, String groupName) {
        Group group = this._groups.get(groupId);
        if (group == null) {
            group = new GroupEntity(groupId);
            this._groups.put(groupId, group);
        }
        if (groupName != null) {
            group.setName(groupName);
        }
        return group;
    }

    @Override
    public List<String> findGroupIdsByUser(String userId) {
        HashMap<String, Object> groupIds = new HashMap<String, Object>();
        for (Membership ms : this._memberships) {
            if (!userId.equals(ms._userId)) continue;
            groupIds.put(ms._groupId, new Object());
        }
        return new ArrayList<String>(groupIds.keySet());
    }

    @Override
    public List<String> findUserIdsByGroup(String groupId) {
        HashMap<String, Object> userIds = new HashMap<String, Object>();
        for (Membership ms : this._memberships) {
            if (!groupId.equals(ms._groupId)) continue;
            userIds.put(ms._userId, new Object());
        }
        return new ArrayList<String>(userIds.keySet());
    }

    protected Group getGroupById(String groupId) {
        return this.createGroup(groupId, null);
    }

    public Collection<Group> getGroups() {
        return this._groups.values();
    }

    @Override
    public void removeAll() {
        this._groups.clear();
        this._memberships.clear();
    }

    @Override
    public void saveMembership(String userId, String groupId) {
        this._memberships.add(new Membership(userId, groupId));
    }

    public void setGroupsText(String text) {
        for (String pair : text.split(";")) {
            String[] gp = pair.split(":");
            this.createGroup(gp[0], gp[1]);
        }
    }

    public void setPermissionsText(String text) {
        for (String pair : text.split(";")) {
            String[] gp = pair.split(":");
            this.saveMembership(gp[0], gp[1]);
        }
    }

    class Membership {
        String _groupId;
        String _userId;

        public Membership(String userId, String group) {
            this._userId = userId;
            this._groupId = group;
        }
    }
}

