/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.core;

import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.io.SplitOutputStream;
import com.fr.zip4j.model.AESExtraDataRecord;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.LocalFileHeader;
import com.fr.zip4j.model.Zip64EndCentralDirLocator;
import com.fr.zip4j.model.Zip64EndCentralDirRecord;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.util.Raw;
import com.fr.zip4j.util.Zip4jUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class HeaderWriter {
    private final int ZIP64_EXTRA_BUF = 50;

    public int writeLocalFileHeader(ZipModel zipModel, LocalFileHeader localFileHeader, OutputStream outputStream) throws ZipException {
        if (localFileHeader == null) {
            throw new ZipException("input parameters are null, cannot write local file header");
        }
        try {
            Object object;
            ArrayList arrayList = new ArrayList();
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = new byte[8];
            byte[] byArray4 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
            Raw.writeIntLittleEndian(byArray2, 0, localFileHeader.getSignature());
            this.copyByteArrayToArrayList(byArray2, arrayList);
            Raw.writeShortLittleEndian(byArray, 0, (short)localFileHeader.getVersionNeededToExtract());
            this.copyByteArrayToArrayList(byArray, arrayList);
            this.copyByteArrayToArrayList(localFileHeader.getGeneralPurposeFlag(), arrayList);
            Raw.writeShortLittleEndian(byArray, 0, (short)localFileHeader.getCompressionMethod());
            this.copyByteArrayToArrayList(byArray, arrayList);
            int n = localFileHeader.getLastModFileTime();
            Raw.writeIntLittleEndian(byArray2, 0, n);
            this.copyByteArrayToArrayList(byArray2, arrayList);
            Raw.writeIntLittleEndian(byArray2, 0, (int)localFileHeader.getCrc32());
            this.copyByteArrayToArrayList(byArray2, arrayList);
            boolean bl = false;
            long l = localFileHeader.getUncompressedSize();
            if (l + 50L >= 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(byArray3, 0, 0xFFFFFFFFL);
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, arrayList);
                this.copyByteArrayToArrayList(byArray2, arrayList);
                zipModel.setZip64Format(true);
                bl = true;
                localFileHeader.setWriteComprSizeInZip64ExtraRecord(true);
            } else {
                Raw.writeLongLittleEndian(byArray3, 0, localFileHeader.getCompressedSize());
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, arrayList);
                Raw.writeLongLittleEndian(byArray3, 0, localFileHeader.getUncompressedSize());
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, arrayList);
                localFileHeader.setWriteComprSizeInZip64ExtraRecord(false);
            }
            Raw.writeShortLittleEndian(byArray, 0, (short)localFileHeader.getFileNameLength());
            this.copyByteArrayToArrayList(byArray, arrayList);
            int n2 = 0;
            if (bl) {
                n2 += 20;
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                n2 += 11;
            }
            Raw.writeShortLittleEndian(byArray, 0, (short)n2);
            this.copyByteArrayToArrayList(byArray, arrayList);
            if (Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getFileNameCharset())) {
                object = localFileHeader.getFileName().getBytes(zipModel.getFileNameCharset());
                this.copyByteArrayToArrayList((byte[])object, arrayList);
            } else {
                this.copyByteArrayToArrayList(Zip4jUtil.convertCharset(localFileHeader.getFileName()), arrayList);
            }
            if (bl) {
                Raw.writeShortLittleEndian(byArray, 0, (short)1);
                this.copyByteArrayToArrayList(byArray, arrayList);
                Raw.writeShortLittleEndian(byArray, 0, (short)16);
                this.copyByteArrayToArrayList(byArray, arrayList);
                Raw.writeLongLittleEndian(byArray3, 0, localFileHeader.getUncompressedSize());
                this.copyByteArrayToArrayList(byArray3, arrayList);
                this.copyByteArrayToArrayList(byArray4, arrayList);
            }
            if (localFileHeader.getAesExtraDataRecord() != null) {
                object = localFileHeader.getAesExtraDataRecord();
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getSignature());
                this.copyByteArrayToArrayList(byArray, arrayList);
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getDataSize());
                this.copyByteArrayToArrayList(byArray, arrayList);
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getVersionNumber());
                this.copyByteArrayToArrayList(byArray, arrayList);
                this.copyByteArrayToArrayList(((AESExtraDataRecord)object).getVendorID().getBytes(), arrayList);
                byte[] byArray5 = new byte[]{(byte)((AESExtraDataRecord)object).getAesStrength()};
                this.copyByteArrayToArrayList(byArray5, arrayList);
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getCompressionMethod());
                this.copyByteArrayToArrayList(byArray, arrayList);
            }
            object = this.byteArrayListToByteArray(arrayList);
            outputStream.write((byte[])object);
            return ((Object)object).length;
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public int writeExtendedLocalHeader(LocalFileHeader localFileHeader, OutputStream outputStream) throws ZipException, IOException {
        if (localFileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write extended local header");
        }
        ArrayList arrayList = new ArrayList();
        byte[] byArray = new byte[4];
        Raw.writeIntLittleEndian(byArray, 0, 134695760);
        this.copyByteArrayToArrayList(byArray, arrayList);
        Raw.writeIntLittleEndian(byArray, 0, (int)localFileHeader.getCrc32());
        this.copyByteArrayToArrayList(byArray, arrayList);
        long l = localFileHeader.getCompressedSize();
        if (l >= Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        Raw.writeIntLittleEndian(byArray, 0, (int)l);
        this.copyByteArrayToArrayList(byArray, arrayList);
        long l2 = localFileHeader.getUncompressedSize();
        if (l2 >= Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        Raw.writeIntLittleEndian(byArray, 0, (int)l2);
        this.copyByteArrayToArrayList(byArray, arrayList);
        byte[] byArray2 = this.byteArrayListToByteArray(arrayList);
        outputStream.write(byArray2);
        return byArray2.length;
    }

    public void finalizeZipFile(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file");
        }
        try {
            this.processHeaderData(zipModel, outputStream);
            long l = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
            ArrayList arrayList = new ArrayList();
            int n = this.writeCentralDirectory(zipModel, outputStream, arrayList);
            if (zipModel.isZip64Format()) {
                if (zipModel.getZip64EndCentralDirRecord() == null) {
                    zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
                }
                if (zipModel.getZip64EndCentralDirLocator() == null) {
                    zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
                }
                zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(l + (long)n);
                if (outputStream instanceof SplitOutputStream) {
                    zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(((SplitOutputStream)outputStream).getCurrSplitFileCounter());
                    zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(((SplitOutputStream)outputStream).getCurrSplitFileCounter() + 1);
                } else {
                    zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(0);
                    zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(1);
                }
                this.writeZip64EndOfCentralDirectoryRecord(zipModel, outputStream, n, l, arrayList);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel, outputStream, arrayList);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, outputStream, n, l, arrayList);
            this.writeZipHeaderBytes(zipModel, outputStream, this.byteArrayListToByteArray(arrayList));
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public void finalizeZipFileWithoutValidations(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        }
        try {
            ArrayList arrayList = new ArrayList();
            long l = zipModel.getEndCentralDirRecord().getOffsetOfStartOfCentralDir();
            int n = this.writeCentralDirectory(zipModel, outputStream, arrayList);
            if (zipModel.isZip64Format()) {
                if (zipModel.getZip64EndCentralDirRecord() == null) {
                    zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
                }
                if (zipModel.getZip64EndCentralDirLocator() == null) {
                    zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
                }
                zipModel.getZip64EndCentralDirLocator().setOffsetZip64EndOfCentralDirRec(l + (long)n);
                this.writeZip64EndOfCentralDirectoryRecord(zipModel, outputStream, n, l, arrayList);
                this.writeZip64EndOfCentralDirectoryLocator(zipModel, outputStream, arrayList);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, outputStream, n, l, arrayList);
            this.writeZipHeaderBytes(zipModel, outputStream, this.byteArrayListToByteArray(arrayList));
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void writeZipHeaderBytes(ZipModel zipModel, OutputStream outputStream, byte[] byArray) throws ZipException {
        if (byArray == null) {
            throw new ZipException("invalid buff to write as zip headers");
        }
        try {
            if (outputStream instanceof SplitOutputStream && ((SplitOutputStream)outputStream).checkBuffSizeAndStartNextSplitFile(byArray.length)) {
                this.finalizeZipFile(zipModel, outputStream);
                return;
            }
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private void processHeaderData(ZipModel zipModel, OutputStream outputStream) throws ZipException {
        try {
            int n = 0;
            if (outputStream instanceof SplitOutputStream) {
                zipModel.getEndCentralDirRecord().setOffsetOfStartOfCentralDir(((SplitOutputStream)outputStream).getFilePointer());
                n = ((SplitOutputStream)outputStream).getCurrSplitFileCounter();
            }
            if (zipModel.isZip64Format()) {
                if (zipModel.getZip64EndCentralDirRecord() == null) {
                    zipModel.setZip64EndCentralDirRecord(new Zip64EndCentralDirRecord());
                }
                if (zipModel.getZip64EndCentralDirLocator() == null) {
                    zipModel.setZip64EndCentralDirLocator(new Zip64EndCentralDirLocator());
                }
                zipModel.getZip64EndCentralDirLocator().setNoOfDiskStartOfZip64EndOfCentralDirRec(n);
                zipModel.getZip64EndCentralDirLocator().setTotNumberOfDiscs(n + 1);
            }
            zipModel.getEndCentralDirRecord().setNoOfThisDisk(n);
            zipModel.getEndCentralDirRecord().setNoOfThisDiskStartOfCentralDir(n);
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private int writeCentralDirectory(ZipModel zipModel, OutputStream outputStream, List list) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write central directory");
        }
        if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null || zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < zipModel.getCentralDirectory().getFileHeaders().size(); ++i) {
            FileHeader fileHeader = (FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(i);
            int n2 = this.writeFileHeader(zipModel, fileHeader, outputStream, list);
            n += n2;
        }
        return n;
    }

    private int writeFileHeader(ZipModel zipModel, FileHeader fileHeader, OutputStream outputStream, List list) throws ZipException {
        if (fileHeader == null || outputStream == null) {
            throw new ZipException("input parameters is null, cannot write local file header");
        }
        try {
            Object object;
            int n = 0;
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = new byte[8];
            byte[] byArray4 = new byte[]{0, 0};
            byte[] byArray5 = new byte[]{0, 0, 0, 0};
            boolean bl = false;
            boolean bl2 = false;
            Raw.writeIntLittleEndian(byArray2, 0, fileHeader.getSignature());
            this.copyByteArrayToArrayList(byArray2, list);
            n += 4;
            Raw.writeShortLittleEndian(byArray, 0, (short)fileHeader.getVersionMadeBy());
            this.copyByteArrayToArrayList(byArray, list);
            n += 2;
            Raw.writeShortLittleEndian(byArray, 0, (short)fileHeader.getVersionNeededToExtract());
            this.copyByteArrayToArrayList(byArray, list);
            n += 2;
            this.copyByteArrayToArrayList(fileHeader.getGeneralPurposeFlag(), list);
            n += 2;
            Raw.writeShortLittleEndian(byArray, 0, (short)fileHeader.getCompressionMethod());
            this.copyByteArrayToArrayList(byArray, list);
            n += 2;
            int n2 = fileHeader.getLastModFileTime();
            Raw.writeIntLittleEndian(byArray2, 0, n2);
            this.copyByteArrayToArrayList(byArray2, list);
            n += 4;
            Raw.writeIntLittleEndian(byArray2, 0, (int)fileHeader.getCrc32());
            this.copyByteArrayToArrayList(byArray2, list);
            n += 4;
            if (fileHeader.getCompressedSize() >= 0xFFFFFFFFL || fileHeader.getUncompressedSize() + 50L >= 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(byArray3, 0, 0xFFFFFFFFL);
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, list);
                n += 4;
                this.copyByteArrayToArrayList(byArray2, list);
                n += 4;
                bl = true;
            } else {
                Raw.writeLongLittleEndian(byArray3, 0, fileHeader.getCompressedSize());
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, list);
                n += 4;
                Raw.writeLongLittleEndian(byArray3, 0, fileHeader.getUncompressedSize());
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, list);
                n += 4;
            }
            Raw.writeShortLittleEndian(byArray, 0, (short)fileHeader.getFileNameLength());
            this.copyByteArrayToArrayList(byArray, list);
            n += 2;
            byte[] byArray6 = new byte[4];
            if (fileHeader.getOffsetLocalHeader() > 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(byArray3, 0, 0xFFFFFFFFL);
                System.arraycopy(byArray3, 0, byArray6, 0, 4);
                bl2 = true;
            } else {
                Raw.writeLongLittleEndian(byArray3, 0, fileHeader.getOffsetLocalHeader());
                System.arraycopy(byArray3, 0, byArray6, 0, 4);
            }
            int n3 = 0;
            if (bl || bl2) {
                n3 += 4;
                if (bl) {
                    n3 += 16;
                }
                if (bl2) {
                    n3 += 8;
                }
            }
            if (fileHeader.getAesExtraDataRecord() != null) {
                n3 += 11;
            }
            Raw.writeShortLittleEndian(byArray, 0, (short)n3);
            this.copyByteArrayToArrayList(byArray, list);
            n += 2;
            this.copyByteArrayToArrayList(byArray4, list);
            n += 2;
            Raw.writeShortLittleEndian(byArray, 0, (short)fileHeader.getDiskNumberStart());
            this.copyByteArrayToArrayList(byArray, list);
            n += 2;
            this.copyByteArrayToArrayList(byArray4, list);
            n += 2;
            if (fileHeader.getExternalFileAttr() != null) {
                this.copyByteArrayToArrayList(fileHeader.getExternalFileAttr(), list);
            } else {
                this.copyByteArrayToArrayList(byArray5, list);
            }
            n += 4;
            this.copyByteArrayToArrayList(byArray6, list);
            n += 4;
            if (Zip4jUtil.isStringNotNullAndNotEmpty(zipModel.getFileNameCharset())) {
                object = fileHeader.getFileName().getBytes(zipModel.getFileNameCharset());
                this.copyByteArrayToArrayList((byte[])object, list);
                n += ((byte[])object).length;
            } else {
                this.copyByteArrayToArrayList(Zip4jUtil.convertCharset(fileHeader.getFileName()), list);
                n += Zip4jUtil.getEncodedStringLength(fileHeader.getFileName());
            }
            if (bl || bl2) {
                zipModel.setZip64Format(true);
                Raw.writeShortLittleEndian(byArray, 0, (short)1);
                this.copyByteArrayToArrayList(byArray, list);
                n += 2;
                int n4 = 0;
                if (bl) {
                    n4 += 16;
                }
                if (bl2) {
                    n4 += 8;
                }
                Raw.writeShortLittleEndian(byArray, 0, (short)n4);
                this.copyByteArrayToArrayList(byArray, list);
                n += 2;
                if (bl) {
                    Raw.writeLongLittleEndian(byArray3, 0, fileHeader.getUncompressedSize());
                    this.copyByteArrayToArrayList(byArray3, list);
                    n += 8;
                    Raw.writeLongLittleEndian(byArray3, 0, fileHeader.getCompressedSize());
                    this.copyByteArrayToArrayList(byArray3, list);
                    n += 8;
                }
                if (bl2) {
                    Raw.writeLongLittleEndian(byArray3, 0, fileHeader.getOffsetLocalHeader());
                    this.copyByteArrayToArrayList(byArray3, list);
                    n += 8;
                }
            }
            if (fileHeader.getAesExtraDataRecord() != null) {
                object = fileHeader.getAesExtraDataRecord();
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getSignature());
                this.copyByteArrayToArrayList(byArray, list);
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getDataSize());
                this.copyByteArrayToArrayList(byArray, list);
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getVersionNumber());
                this.copyByteArrayToArrayList(byArray, list);
                this.copyByteArrayToArrayList(((AESExtraDataRecord)object).getVendorID().getBytes(), list);
                byte[] byArray7 = new byte[]{(byte)((AESExtraDataRecord)object).getAesStrength()};
                this.copyByteArrayToArrayList(byArray7, list);
                Raw.writeShortLittleEndian(byArray, 0, (short)((AESExtraDataRecord)object).getCompressionMethod());
                this.copyByteArrayToArrayList(byArray, list);
                n += 11;
            }
            return n;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void writeZip64EndOfCentralDirectoryRecord(ZipModel zipModel, OutputStream outputStream, int n, long l, List list) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write zip64 end of central directory record");
        }
        try {
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[]{0, 0};
            byte[] byArray3 = new byte[4];
            byte[] byArray4 = new byte[8];
            Raw.writeIntLittleEndian(byArray3, 0, 101075792);
            this.copyByteArrayToArrayList(byArray3, list);
            Raw.writeLongLittleEndian(byArray4, 0, 44L);
            this.copyByteArrayToArrayList(byArray4, list);
            if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
                Raw.writeShortLittleEndian(byArray, 0, (short)((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(0)).getVersionMadeBy());
                this.copyByteArrayToArrayList(byArray, list);
                Raw.writeShortLittleEndian(byArray, 0, (short)((FileHeader)zipModel.getCentralDirectory().getFileHeaders().get(0)).getVersionNeededToExtract());
                this.copyByteArrayToArrayList(byArray, list);
            } else {
                this.copyByteArrayToArrayList(byArray2, list);
                this.copyByteArrayToArrayList(byArray2, list);
            }
            Raw.writeIntLittleEndian(byArray3, 0, zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            this.copyByteArrayToArrayList(byArray3, list);
            Raw.writeIntLittleEndian(byArray3, 0, zipModel.getEndCentralDirRecord().getNoOfThisDiskStartOfCentralDir());
            this.copyByteArrayToArrayList(byArray3, list);
            int n2 = 0;
            int n3 = 0;
            if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid central directory/file headers, cannot write end of central directory record");
            }
            n2 = zipModel.getCentralDirectory().getFileHeaders().size();
            if (zipModel.isSplitArchive()) {
                this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            } else {
                n3 = n2;
            }
            Raw.writeLongLittleEndian(byArray4, 0, n3);
            this.copyByteArrayToArrayList(byArray4, list);
            Raw.writeLongLittleEndian(byArray4, 0, n2);
            this.copyByteArrayToArrayList(byArray4, list);
            Raw.writeLongLittleEndian(byArray4, 0, n);
            this.copyByteArrayToArrayList(byArray4, list);
            Raw.writeLongLittleEndian(byArray4, 0, l);
            this.copyByteArrayToArrayList(byArray4, list);
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void writeZip64EndOfCentralDirectoryLocator(ZipModel zipModel, OutputStream outputStream, List list) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write zip64 end of central directory locator");
        }
        try {
            byte[] byArray = new byte[4];
            byte[] byArray2 = new byte[8];
            Raw.writeIntLittleEndian(byArray, 0, 117853008);
            this.copyByteArrayToArrayList(byArray, list);
            Raw.writeIntLittleEndian(byArray, 0, zipModel.getZip64EndCentralDirLocator().getNoOfDiskStartOfZip64EndOfCentralDirRec());
            this.copyByteArrayToArrayList(byArray, list);
            Raw.writeLongLittleEndian(byArray2, 0, zipModel.getZip64EndCentralDirLocator().getOffsetZip64EndOfCentralDirRec());
            this.copyByteArrayToArrayList(byArray2, list);
            Raw.writeIntLittleEndian(byArray, 0, zipModel.getZip64EndCentralDirLocator().getTotNumberOfDiscs());
            this.copyByteArrayToArrayList(byArray, list);
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void writeEndOfCentralDirectoryRecord(ZipModel zipModel, OutputStream outputStream, int n, long l, List list) throws ZipException {
        if (zipModel == null || outputStream == null) {
            throw new ZipException("zip model or output stream is null, cannot write end of central directory record");
        }
        try {
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            byte[] byArray3 = new byte[8];
            Raw.writeIntLittleEndian(byArray2, 0, (int)zipModel.getEndCentralDirRecord().getSignature());
            this.copyByteArrayToArrayList(byArray2, list);
            Raw.writeShortLittleEndian(byArray, 0, (short)zipModel.getEndCentralDirRecord().getNoOfThisDisk());
            this.copyByteArrayToArrayList(byArray, list);
            Raw.writeShortLittleEndian(byArray, 0, (short)zipModel.getEndCentralDirRecord().getNoOfThisDiskStartOfCentralDir());
            this.copyByteArrayToArrayList(byArray, list);
            int n2 = 0;
            int n3 = 0;
            if (zipModel.getCentralDirectory() == null || zipModel.getCentralDirectory().getFileHeaders() == null) {
                throw new ZipException("invalid central directory/file headers, cannot write end of central directory record");
            }
            n2 = zipModel.getCentralDirectory().getFileHeaders().size();
            n3 = zipModel.isSplitArchive() ? this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndCentralDirRecord().getNoOfThisDisk()) : n2;
            Raw.writeShortLittleEndian(byArray, 0, (short)n3);
            this.copyByteArrayToArrayList(byArray, list);
            Raw.writeShortLittleEndian(byArray, 0, (short)n2);
            this.copyByteArrayToArrayList(byArray, list);
            Raw.writeIntLittleEndian(byArray2, 0, n);
            this.copyByteArrayToArrayList(byArray2, list);
            if (l > 0xFFFFFFFFL) {
                Raw.writeLongLittleEndian(byArray3, 0, 0xFFFFFFFFL);
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, list);
            } else {
                Raw.writeLongLittleEndian(byArray3, 0, l);
                System.arraycopy(byArray3, 0, byArray2, 0, 4);
                this.copyByteArrayToArrayList(byArray2, list);
            }
            int n4 = 0;
            if (zipModel.getEndCentralDirRecord().getComment() != null) {
                n4 = zipModel.getEndCentralDirRecord().getCommentLength();
            }
            Raw.writeShortLittleEndian(byArray, 0, (short)n4);
            this.copyByteArrayToArrayList(byArray, list);
            if (n4 > 0) {
                this.copyByteArrayToArrayList(zipModel.getEndCentralDirRecord().getCommentBytes(), list);
            }
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public void updateLocalFileHeader(LocalFileHeader localFileHeader, long l, int n, ZipModel zipModel, byte[] byArray, int n2, SplitOutputStream splitOutputStream) throws ZipException {
        if (localFileHeader == null || l < 0L || zipModel == null) {
            throw new ZipException("invalid input parameters, cannot update local file header");
        }
        try {
            boolean bl = false;
            SplitOutputStream splitOutputStream2 = null;
            if (n2 != splitOutputStream.getCurrSplitFileCounter()) {
                File file = new File(zipModel.getZipFile());
                String string = file.getParent();
                String string2 = Zip4jUtil.getZipFileNameWithoutExt(file.getName());
                String string3 = string + System.getProperty("file.separator");
                string3 = n2 < 9 ? string3 + string2 + ".z0" + (n2 + 1) : string3 + string2 + ".z" + (n2 + 1);
                splitOutputStream2 = new SplitOutputStream(new File(string3));
                bl = true;
            } else {
                splitOutputStream2 = splitOutputStream;
            }
            long l2 = splitOutputStream2.getFilePointer();
            switch (n) {
                case 14: {
                    splitOutputStream2.seek(l + (long)n);
                    splitOutputStream2.write(byArray);
                    break;
                }
                case 18: 
                case 22: {
                    this.updateCompressedSizeInLocalFileHeader(splitOutputStream2, localFileHeader, l, n, byArray, zipModel.isZip64Format());
                    break;
                }
            }
            if (bl) {
                splitOutputStream2.close();
            } else {
                splitOutputStream.seek(l2);
            }
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    private void updateCompressedSizeInLocalFileHeader(SplitOutputStream splitOutputStream, LocalFileHeader localFileHeader, long l, long l2, byte[] byArray, boolean bl) throws ZipException {
        if (splitOutputStream == null) {
            throw new ZipException("invalid output stream, cannot update compressed size for local file header");
        }
        try {
            if (localFileHeader.isWriteComprSizeInZip64ExtraRecord()) {
                if (byArray.length != 8) {
                    throw new ZipException("attempting to write a non 8-byte compressed size block for a zip64 file");
                }
                long l3 = l + l2 + 4L + 4L + 2L + 2L + (long)localFileHeader.getFileNameLength() + 2L + 2L + 8L;
                if (l2 == 22L) {
                    l3 += 8L;
                }
                splitOutputStream.seek(l3);
                splitOutputStream.write(byArray);
            } else {
                splitOutputStream.seek(l + l2);
                splitOutputStream.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new ZipException(iOException);
        }
    }

    private void copyByteArrayToArrayList(byte[] byArray, List list) throws ZipException {
        if (list == null || byArray == null) {
            throw new ZipException("one of the input parameters is null, cannot copy byte array to array list");
        }
        for (int i = 0; i < byArray.length; ++i) {
            list.add(Byte.toString(byArray[i]));
        }
    }

    private byte[] byteArrayListToByteArray(List list) throws ZipException {
        if (list == null) {
            throw new ZipException("input byte array list is null, cannot conver to byte array");
        }
        if (list.size() <= 0) {
            return null;
        }
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = Byte.parseByte((String)list.get(i));
        }
        return byArray;
    }

    private int countNumberOfFileHeaderEntriesOnDisk(ArrayList arrayList, int n) throws ZipException {
        if (arrayList == null) {
            throw new ZipException("file headers are null, cannot calculate number of entries on this disk");
        }
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FileHeader fileHeader = (FileHeader)arrayList.get(i);
            if (fileHeader.getDiskNumberStart() != n) continue;
            ++n2;
        }
        return n2;
    }
}

