/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.upload;

import com.fr.web.core.upload.SmartFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class SmartFiles {
    private Hashtable m_files = new Hashtable();
    private int m_counter = 0;

    SmartFiles() {
    }

    protected void addFile(SmartFile smartFile) {
        if (smartFile == null) {
            throw new IllegalArgumentException("newFile cannot be null.");
        }
        this.m_files.put(new Integer(this.m_counter), smartFile);
        ++this.m_counter;
    }

    public SmartFile getFile(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("File's index cannot be a negative value (1210).");
        }
        SmartFile smartFile = (SmartFile)this.m_files.get(new Integer(n));
        if (smartFile == null) {
            throw new IllegalArgumentException("Files' name is invalid or does not exist (1205).");
        }
        return smartFile;
    }

    public int getCount() {
        return this.m_counter;
    }

    public long getSize() throws IOException {
        long l = 0L;
        for (int i = 0; i < this.m_counter; ++i) {
            l += (long)this.getFile(i).getSize();
        }
        return l;
    }

    public Collection getCollection() {
        return this.m_files.values();
    }

    public Enumeration getEnumeration() {
        return this.m_files.elements();
    }
}

