/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.html.Tag;
import com.fr.stable.web.BrowserProvider;
import com.fr.web.J2EEContainer;
import com.fr.web.utils.WebUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class Browser
implements BrowserProvider {
    private String userAgent;
    private String browser;
    private String version;
    private boolean boxModel = true;
    private static Pattern[] uaPatterns = new Pattern[]{Pattern.compile("(webkit)[ \\/]([\\w.]+)"), Pattern.compile("(opera)(?:.*version)?[ \\/]([\\w.]+)"), Pattern.compile("(msie) ([\\w.]+)"), Pattern.compile("(mozilla)(?:.*? rv:([\\w.]+))?")};

    public static Browser resolve(HttpServletRequest httpServletRequest) {
        String string = String.valueOf(httpServletRequest.getHeader("user-agent")).toLowerCase();
        Browser browser = new Browser();
        browser.userAgent = string;
        for (int i = 0; i < uaPatterns.length; ++i) {
            Matcher matcher = uaPatterns[i].matcher(string);
            if (!matcher.find()) continue;
            browser.browser = matcher.group(1);
            browser.version = matcher.group(2);
            break;
        }
        if ("false".equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "__boxModel__"))) {
            browser.boxModel = false;
        }
        return browser;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getBrowser() {
        return this.browser;
    }

    public boolean supportBoxModel() {
        return this.boxModel;
    }

    public boolean isLowIEVersion() {
        return this.isIE() && this.versionLessThan("9.0");
    }

    public boolean isLowIEVersionQuicksModel() {
        return this.isIE() && this.versionLessThan("9.0") && this.isQuirksModel();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isIE() {
        return "msie".equals(this.browser) || this.userAgent.contains("trident") || this.userAgent.contains("edge");
    }

    private boolean isOpera() {
        return "opera".equals(this.browser);
    }

    public boolean isWebkit() {
        return "webkit".equals(this.browser);
    }

    public boolean isFireFox() {
        return "mozilla".equals(this.browser);
    }

    public boolean isNeedAppendBlankTD() {
        return this.isWebkit() && this.userAgent.toLowerCase().indexOf("chrome") == -1;
    }

    private boolean versionLessThan(String string) {
        if (this.version == null) {
            return true;
        }
        String[] stringArray = this.version.split("\\.");
        String[] stringArray2 = string.split("\\.");
        int n = Math.max(stringArray2.length, stringArray.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = stringArray.length > i ? Integer.parseInt(stringArray[i]) : 0;
            int n4 = n2 = stringArray2.length > i ? Integer.parseInt(stringArray2[i]) : 0;
            if (n3 < n2) {
                return true;
            }
            if (n3 <= n2) continue;
            return false;
        }
        return false;
    }

    public String getEncodedFileName4Download(String string) throws UnsupportedEncodingException {
        boolean bl;
        boolean bl2 = bl = this.isIE() || this.isIE11() || this.userAgent != null && this.userAgent.indexOf("chromeframe") != -1;
        if (bl) {
            return URLEncoder.encode(string, "UTF-8");
        }
        return new String(string.getBytes("UTF-8"), "ISO8859-1");
    }

    public boolean supportTransparentImage() {
        return !this.isIE() || !this.versionLessThan("7.0");
    }

    public boolean shouldLoadCanvas() {
        return this.isIE() || this.isIE11();
    }

    public boolean shouldSetContentTypeOnZipDownload() {
        return !this.isIE();
    }

    public boolean supportGzip() {
        return !this.isIE() && (!this.isWebkit() || !J2EEContainer.isWebLogic());
    }

    public void setHrefOnArea(Tag tag) {
        if (!this.isFireFox()) {
            if (this.isIE() && !this.versionLessThan("6.0")) {
                tag.attr("href", "###");
            } else {
                tag.attr("href", "javascript:void(0)");
            }
        }
    }

    public boolean shouldWrapCenter() {
        return this.isIE();
    }

    public boolean shouldModifyWidth4PainterAccordingToBorderWidth() {
        return this.isIE();
    }

    public boolean shouldDoSomeStuff4MissingRightBorderOfTable() {
        return this.isWebkit();
    }

    public boolean justDealWithTheHiddenRowsOfTail(boolean bl) {
        return this.isIE() && (this.versionLessThan("8.0") || (ComparatorUtils.equals(this.version, "8.0") || ComparatorUtils.equals(this.version, "9.0")) && this.isQuirksModel());
    }

    private boolean lessInIEOr8NotTrandition(boolean bl) {
        return this.versionLessThan("8.0") || ComparatorUtils.equals(this.version, "8.0") && !bl;
    }

    public boolean isNoBlurInImage() {
        return this.isIE() || !this.isFireFox() || this.isWebkit();
    }

    public boolean shouldConsiderHeavyTD() {
        return !this.isIE() || this.versionLessThan("6.0") || !this.isQuirksModel();
    }

    public boolean supportIMAGEBase64Decode() {
        return !this.isIE() || !this.versionLessThan("9.0");
    }

    public boolean supportCanvas() {
        return !this.lessFireFox4Canvas() && !this.lessWebkit4Canvas();
    }

    public boolean isIE11() {
        return this.isFireFox() && ComparatorUtils.equals(this.version, "11.0");
    }

    private boolean lessFireFox4Canvas() {
        return this.isFireFox() && this.versionLessThan("2.0.1");
    }

    private boolean lessWebkit4Canvas() {
        return this.isWebkit() && this.versionLessThan("533.1");
    }

    public boolean needAdjustLineHeight() {
        return this.isWebkit();
    }

    public boolean shouldWriteResizableFeature() {
        return this.isIE();
    }

    public boolean shouldConsiderVML() {
        return this.isIE() && this.versionLessThan("7.0");
    }

    public boolean shouldRelativePosition4ZoomCSS() {
        return this.isIE();
    }

    public String getFlashPlayerInstallerURL() {
        if (this.isIE()) {
            return "\\flashplayers\\flash_player_windows_ie.exe";
        }
        return "\\flashplayers\\flash_player_windows_other.exe";
    }

    public boolean isQuirksModel() {
        return !this.boxModel;
    }

    public boolean shouldConsiderLineBorder() {
        return this.isIE() && this.versionLessThan("6.0") && this.boxModel;
    }

    public boolean shouldCheckHTMLType() {
        return this.isIE() && this.versionLessThan("9.0");
    }

    public boolean shouldAddHiddenTr() {
        return this.isIE() && (ComparatorUtils.equals(this.version, "9.0") || ComparatorUtils.equals(this.version, "10.0"));
    }

    public boolean isMobile() {
        return this.isIPhoneBrowser() || this.isIPadBrowser() || this.isAndroidBrowser();
    }

    public boolean isIOSBrowser() {
        return this.isIPhoneBrowser() || this.isIPadBrowser();
    }

    public boolean isIPhoneBrowser() {
        return this.userAgent.indexOf("iphone") > 0;
    }

    public boolean isIPadBrowser() {
        return this.userAgent.indexOf("ipad") > 0;
    }

    public boolean isAndroidBrowser() {
        return this.userAgent.indexOf("android") > 0;
    }

    public boolean isUseTDWidthInTable() {
        return this.isIE() && ComparatorUtils.equals(this.version, "10.0");
    }

    public boolean countHiddenItemForSpan() {
        return this.isIE() && (ComparatorUtils.equals(this.version, "8.0") || ComparatorUtils.equals(this.version, "9.0")) && this.isQuirksModel();
    }

    public void setBrowser(String string) {
        this.browser = string;
    }

    public boolean skipEmptyPart() {
        return this.isIE() && ComparatorUtils.equals(this.version, "6.0");
    }

    public boolean addHiddenTRAhead() {
        return this.isIE() && !this.isQuirksModel() && (ComparatorUtils.equals(this.version, "6.0") || ComparatorUtils.equals(this.version, "7.0"));
    }

    public boolean fixRowByBorder() {
        return this.isIE() && !this.isQuirksModel() && (ComparatorUtils.equals(this.version, "6.0") || ComparatorUtils.equals(this.version, "7.0"));
    }

    public boolean fixFrozenOffsetByBorder() {
        return this.isFireFox() || this.isIE() && !this.versionLessThan("7.0");
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("Browser", this.browser);
            jSONObject.put("Version", this.version);
            jSONObject.put("Agent", this.userAgent);
            jSONObject.put("BoxModel", this.boxModel);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().error(jSONException.getMessage());
        }
        return jSONObject.toString();
    }
}

