/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSet<T>
implements Iterable<T> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    T[] keyTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private ObjectSetIterator iterator1;
    private ObjectSetIterator iterator2;

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int n) {
        this(n, 0.8f);
    }

    public ObjectSet(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n);
        }
        if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n);
        }
        this.capacity = n;
        if (f <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f);
        }
        this.loadFactor = f;
        this.threshold = (int)((float)this.capacity * f);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
    }

    public ObjectSet(ObjectSet objectSet) {
        this((int)Math.floor((float)objectSet.capacity * objectSet.loadFactor), objectSet.loadFactor);
        this.stashSize = objectSet.stashSize;
        System.arraycopy(objectSet.keyTable, 0, this.keyTable, 0, objectSet.keyTable.length);
        this.size = objectSet.size;
    }

    public boolean add(T t) {
        int n;
        if (t == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        T[] TArray = this.keyTable;
        int n2 = t.hashCode();
        int n3 = n2 & this.mask;
        T t2 = TArray[n3];
        if (t.equals(t2)) {
            return false;
        }
        int n4 = this.hash2(n2);
        T t3 = TArray[n4];
        if (t.equals(t3)) {
            return false;
        }
        int n5 = this.hash3(n2);
        T t4 = TArray[n5];
        if (t.equals(t4)) {
            return false;
        }
        int n6 = n + this.stashSize;
        for (n = this.capacity; n < n6; ++n) {
            if (!t.equals(TArray[n])) continue;
            return false;
        }
        if (t2 == null) {
            TArray[n3] = t;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (t3 == null) {
            TArray[n4] = t;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (t4 == null) {
            TArray[n5] = t;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        this.push(t, n3, t2, n4, t3, n5, t4);
        return true;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int n, int n2) {
        if (n + n2 > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + array.size);
        }
        this.addAll(array.items, n, n2);
    }

    public void addAll(T ... TArray) {
        this.addAll(TArray, 0, TArray.length);
    }

    public void addAll(T[] TArray, int n, int n2) {
        int n3;
        this.ensureCapacity(n2);
        int n4 = n3 + n2;
        for (n3 = n; n3 < n4; ++n3) {
            this.add(TArray[n3]);
        }
    }

    public void addAll(ObjectSet<T> objectSet) {
        this.ensureCapacity(objectSet.size);
        for (Object e : objectSet) {
            this.add(e);
        }
    }

    private void addResize(T t) {
        int n = t.hashCode();
        int n2 = n & this.mask;
        T t2 = this.keyTable[n2];
        if (t2 == null) {
            this.keyTable[n2] = t;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n3 = this.hash2(n);
        T t3 = this.keyTable[n3];
        if (t3 == null) {
            this.keyTable[n3] = t;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash3(n);
        T t4 = this.keyTable[n4];
        if (t4 == null) {
            this.keyTable[n4] = t;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(t, n2, t2, n3, t3, n4, t4);
    }

    private void push(T t, int n, T t2, int n2, T t3, int n3, T t4) {
        T t5;
        T[] TArray = this.keyTable;
        int n4 = this.mask;
        int n5 = 0;
        int n6 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    t5 = t2;
                    TArray[n] = t;
                    break;
                }
                case 1: {
                    t5 = t3;
                    TArray[n2] = t;
                    break;
                }
                default: {
                    t5 = t4;
                    TArray[n3] = t;
                }
            }
            int n7 = t5.hashCode();
            n = n7 & n4;
            t2 = TArray[n];
            if (t2 == null) {
                TArray[n] = t5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = this.hash2(n7);
            t3 = TArray[n2];
            if (t3 == null) {
                TArray[n2] = t5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash3(n7);
            t4 = TArray[n3];
            if (t4 == null) {
                TArray[n3] = t5;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n5 == n6) break;
            t = t5;
        }
        this.addStash(t5);
    }

    private void addStash(T t) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.add(t);
            return;
        }
        int n = this.capacity + this.stashSize;
        this.keyTable[n] = t;
        ++this.stashSize;
        ++this.size;
    }

    public boolean remove(T t) {
        int n = t.hashCode();
        int n2 = n & this.mask;
        if (t.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            --this.size;
            return true;
        }
        n2 = this.hash2(n);
        if (t.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            --this.size;
            return true;
        }
        n2 = this.hash3(n);
        if (t.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            --this.size;
            return true;
        }
        return this.removeStash(t);
    }

    boolean removeStash(T t) {
        int n;
        T[] TArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!t.equals(TArray[n])) continue;
            this.removeStashIndex(n);
            --this.size;
            return true;
        }
        return false;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            this.keyTable[n] = this.keyTable[n2];
        }
    }

    public void shrink(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n);
        }
        if (this.size > n) {
            n = this.size;
        }
        if (this.capacity <= n) {
            return;
        }
        n = MathUtils.nextPowerOfTwo(n);
        this.resize(n);
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        T[] TArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (n-- > 0) {
            TArray[n] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean contains(T t) {
        int n = t.hashCode();
        int n2 = n & this.mask;
        if (!(t.equals(this.keyTable[n2]) || t.equals(this.keyTable[n2 = this.hash2(n)]) || t.equals(this.keyTable[n2 = this.hash3(n)]))) {
            return this.containsKeyStash(t);
        }
        return true;
    }

    private boolean containsKeyStash(T t) {
        int n;
        T[] TArray = this.keyTable;
        int n2 = n + this.stashSize;
        for (n = this.capacity; n < n2; ++n) {
            if (!t.equals(TArray[n])) continue;
            return true;
        }
        return false;
    }

    public T first() {
        T[] TArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            if (TArray[i] == null) continue;
            return TArray[i];
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public void ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / this.loadFactor)));
        }
    }

    private void resize(int n) {
        int n2 = this.capacity + this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(n) / 8);
        T[] TArray = this.keyTable;
        this.keyTable = new Object[n + this.stashCapacity];
        int n3 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n3 > 0) {
            for (int i = 0; i < n2; ++i) {
                T t = TArray[i];
                if (t == null) continue;
                this.addResize(t);
            }
        }
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.capacity + this.stashSize;
        for (int i = 0; i < n2; ++i) {
            if (this.keyTable[i] == null) continue;
            n += this.keyTable[i].hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectSet)) {
            return false;
        }
        ObjectSet objectSet = (ObjectSet)object;
        if (objectSet.size != this.size) {
            return false;
        }
        int n = this.capacity + this.stashSize;
        for (int i = 0; i < n; ++i) {
            if (this.keyTable[i] == null || objectSet.contains(this.keyTable[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return '{' + this.toString(", ") + '}';
    }

    public String toString(String string) {
        T t;
        if (this.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        T[] TArray = this.keyTable;
        int n = TArray.length;
        while (n-- > 0) {
            t = TArray[n];
            if (t == null) continue;
            stringBuilder.append(t);
            break;
        }
        while (n-- > 0) {
            t = TArray[n];
            if (t == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(t);
        }
        return stringBuilder.toString();
    }

    @Override
    public ObjectSetIterator<T> iterator() {
        if (this.iterator1 == null) {
            this.iterator1 = new ObjectSetIterator(this);
            this.iterator2 = new ObjectSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static <T> ObjectSet<T> with(T ... TArray) {
        ObjectSet<T> objectSet = new ObjectSet<T>();
        objectSet.addAll(TArray);
        return objectSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectSetIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public boolean hasNext;
        final ObjectSet<K> set;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public ObjectSetIterator(ObjectSet<K> objectSet) {
            this.set = objectSet;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            T[] TArray = this.set.keyTable;
            int n = this.set.capacity + this.set.stashSize;
            while (++this.nextIndex < n) {
                if (TArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.set.capacity) {
                this.set.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.set.keyTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.set.size;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object t = this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return (K)t;
        }

        @Override
        public ObjectSetIterator<K> iterator() {
            return this;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.set.size));
        }
    }
}

