/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.allocation;

import com.fr.general.ComparatorUtils;
import com.fr.privilege.allocation.FileFrag;
import com.fr.privilege.allocation.FileFragList;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Allocation
implements XMLable {
    private static final long serialVersionUID = -2914825417693733767L;
    public static final String XML_TAG = "Allocation";
    private FileFragList designList = new FileFragList();
    private FileFragList viewList = new FileFragList();
    private FileFragList formList = new FileFragList();
    private FileFragList writeList = new FileFragList();
    private FileFragList excelSubmitList = new FileFragList();
    private HashSet<String> dsPrivilegeSet = new HashSet();

    public Allocation() {
    }

    public Allocation(HashSet<String> hashSet) {
        this.dsPrivilegeSet = hashSet;
    }

    public void addDSPrivilege(String string) {
        this.dsPrivilegeSet.add(string);
    }

    public void setDSPrivilege(HashSet<String> hashSet) {
        this.dsPrivilegeSet = hashSet;
    }

    public HashSet<String> getDSPrivilege() {
        return this.dsPrivilegeSet;
    }

    public void removeDSPrivilege(String string) {
        this.dsPrivilegeSet.remove(string);
    }

    public void clearDSPrivilege() {
        this.dsPrivilegeSet.clear();
    }

    public void addDesign(FileFrag fileFrag) {
        if (!this.designList.contains(fileFrag)) {
            this.designList.addFileFrag(fileFrag);
        }
    }

    public void addDesign(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.addDesign(fileFragArray[i]);
            }
        }
    }

    public int getDesignCount() {
        return this.designList.size();
    }

    public String designString() {
        return StableUtils.join(this.designList.toArray(), ",");
    }

    public FileFrag getDesign(int n) {
        return this.designList.getFileFrag(n);
    }

    public void clearDesign() {
        this.designList.clear();
    }

    public void removeDesign(FileFrag fileFrag) {
        this.designList.remove(fileFrag);
    }

    public void removeDesign(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.removeDesign(fileFragArray[i]);
            }
        }
    }

    public void addView(FileFrag fileFrag) {
        if (!this.viewList.contains(fileFrag)) {
            this.viewList.addFileFrag(fileFrag);
        }
    }

    public void addView(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.addView(fileFragArray[i]);
            }
        }
    }

    public int getViewCount() {
        return this.viewList.size();
    }

    public FileFrag getView(int n) {
        return this.viewList.getFileFrag(n);
    }

    public void clearView() {
        this.viewList.clear();
    }

    public void removeView(FileFrag fileFrag) {
        this.viewList.remove(fileFrag);
    }

    public void removeView(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.removeView(fileFragArray[i]);
            }
        }
    }

    public void addForm(FileFrag fileFrag) {
        if (!this.formList.contains(fileFrag)) {
            this.formList.addFileFrag(fileFrag);
        }
    }

    public void addForm(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.addForm(fileFragArray[i]);
            }
        }
    }

    public int getFormCount() {
        return this.formList.size();
    }

    public FileFrag getForm(int n) {
        return this.formList.getFileFrag(n);
    }

    public void clearForm() {
        this.formList.clear();
    }

    public void removeForm(FileFrag fileFrag) {
        this.formList.remove(fileFrag);
    }

    public void removeForm(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.removeForm(fileFragArray[i]);
            }
        }
    }

    public void addWrite(FileFrag fileFrag) {
        if (!this.writeList.contains(fileFrag)) {
            this.writeList.addFileFrag(fileFrag);
        }
    }

    public void addWrite(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.addWrite(fileFragArray[i]);
            }
        }
    }

    public int getWriteCount() {
        return this.writeList.size();
    }

    public FileFrag getWrite(int n) {
        return this.writeList.getFileFrag(n);
    }

    public void clearWrite() {
        this.writeList.clear();
    }

    public void removeWrite(FileFrag fileFrag) {
        this.writeList.remove(fileFrag);
    }

    public void removeWrite(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.removeWrite(fileFragArray[i]);
            }
        }
    }

    public void addExcelSubmit(FileFrag fileFrag) {
        if (!this.excelSubmitList.contains(fileFrag)) {
            this.excelSubmitList.addFileFrag(fileFrag);
        }
    }

    public void addExcelSubmit(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.addExcelSubmit(fileFragArray[i]);
            }
        }
    }

    public int getExcelSubmitCount() {
        return this.excelSubmitList.size();
    }

    public FileFrag getExcelSubmit(int n) {
        return this.excelSubmitList.getFileFrag(n);
    }

    public void clearExcelSubmit() {
        this.excelSubmitList.clear();
    }

    public void removeExcelSubmit(FileFrag fileFrag) {
        this.excelSubmitList.remove(fileFrag);
    }

    public void removeExcelSubmit(FileFrag[] fileFragArray) {
        if (fileFragArray != null && fileFragArray.length > 0) {
            for (int i = 0; i < fileFragArray.length; ++i) {
                this.removeExcelSubmit(fileFragArray[i]);
            }
        }
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearDesign();
            this.clearView();
            this.clearForm();
            this.clearWrite();
            this.clearExcelSubmit();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("Designs", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addDesign(fileFragArray);
            } else if (ComparatorUtils.equals("Views", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addView(fileFragArray);
            } else if (ComparatorUtils.equals("Forms", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addForm(fileFragArray);
            } else if (ComparatorUtils.equals("Writes", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addWrite(fileFragArray);
            } else if (ComparatorUtils.equals("ExcelSubmit", string)) {
                FileFrag[] fileFragArray = this.readFileFrags(xMLableReader);
                this.addExcelSubmit(fileFragArray);
            } else if (ComparatorUtils.equals("DSPrivilege", string)) {
                final HashSet<String> hashSet = new HashSet<String>();
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if ("DSName".equals(xMLableReader.getTagName())) {
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    String string;
                                    if (xMLableReader.isAttr() && (string = xMLableReader.getAttrAsString("dsName", null)) != null) {
                                        hashSet.add(string);
                                    }
                                }
                            });
                        }
                    }
                });
                this.setDSPrivilege(hashSet);
            }
        }
    }

    private FileFrag[] readFileFrags(XMLableReader xMLableReader) {
        final FileFragList fileFragList = new FileFragList();
        xMLableReader.readXMLObject(new XMLReadable(){

            public void readXML(XMLableReader xMLableReader) {
                if ("FileFrag".equals(xMLableReader.getTagName())) {
                    FileFrag fileFrag = new FileFrag();
                    xMLableReader.readXMLObject(fileFrag);
                    fileFragList.addFileFrag(fileFrag);
                }
            }
        });
        return fileFragList.toArray();
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        int n;
        xMLPrintWriter.startTAG(XML_TAG);
        if (this.designList.size() > 0) {
            xMLPrintWriter.startTAG("Designs");
            for (n = 0; n < this.designList.size(); ++n) {
                this.designList.getFileFrag(n).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.viewList.size() > 0) {
            xMLPrintWriter.startTAG("Views");
            for (n = 0; n < this.viewList.size(); ++n) {
                this.viewList.getFileFrag(n).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.formList.size() > 0) {
            xMLPrintWriter.startTAG("Forms");
            for (n = 0; n < this.formList.size(); ++n) {
                this.formList.getFileFrag(n).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.writeList.size() > 0) {
            xMLPrintWriter.startTAG("Writes");
            for (n = 0; n < this.writeList.size(); ++n) {
                this.writeList.getFileFrag(n).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.excelSubmitList.size() > 0) {
            xMLPrintWriter.startTAG("ExcelSubmit");
            for (n = 0; n < this.excelSubmitList.size(); ++n) {
                this.excelSubmitList.getFileFrag(n).writeXML(xMLPrintWriter);
            }
            xMLPrintWriter.end();
        }
        if (this.dsPrivilegeSet.size() > 0) {
            xMLPrintWriter.startTAG("DSPrivilege");
            for (String string : this.dsPrivilegeSet) {
                xMLPrintWriter.startTAG("DSName");
                xMLPrintWriter.attr("dsName", string);
                xMLPrintWriter.end();
            }
            xMLPrintWriter.end();
        }
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Allocation allocation = (Allocation)super.clone();
        FileFragList fileFragList = new FileFragList();
        for (int i = 0; i < this.designList.size(); ++i) {
            fileFragList.addFileFrag((FileFrag)this.designList.getFileFrag(i).clone());
        }
        allocation.designList = fileFragList;
        FileFragList fileFragList2 = new FileFragList();
        for (int i = 0; i < this.viewList.size(); ++i) {
            fileFragList2.addFileFrag((FileFrag)this.viewList.getFileFrag(i).clone());
        }
        allocation.viewList = fileFragList2;
        FileFragList fileFragList3 = new FileFragList();
        for (int i = 0; i < this.formList.size(); ++i) {
            fileFragList3.addFileFrag((FileFrag)this.formList.getFileFrag(i).clone());
        }
        allocation.formList = fileFragList3;
        FileFragList fileFragList4 = new FileFragList();
        for (int i = 0; i < this.writeList.size(); ++i) {
            fileFragList4.addFileFrag((FileFrag)this.writeList.getFileFrag(i).clone());
        }
        allocation.writeList = fileFragList4;
        return allocation;
    }
}

