/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.form.ui.IndexWidget;
import com.fr.form.ui.Widget;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Table
extends Widget {
    public static final String XML_TAG = "Table";
    private String dataURL = null;
    private List indexWidgets = new ArrayList();

    public void setIndexWidgets(IndexWidget[] indexWidgetArray) {
        this.indexWidgets = Arrays.asList(indexWidgetArray);
    }

    public IndexWidget[] getIndexWidgets() {
        return this.indexWidgets.toArray(new IndexWidget[0]);
    }

    public String getDataURL() {
        return this.dataURL;
    }

    public void setDataURL(String string) {
        this.dataURL = string;
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        if (StringUtils.isNotBlank(this.dataURL)) {
            jSONObject.put("dataURL", this.getDataURL());
        }
        if (this.indexWidgets.size() > 0) {
            JSONArray jSONArray = new JSONArray();
            int n = this.indexWidgets.size();
            for (int i = 0; i < n; ++i) {
                jSONArray.put(((IndexWidget)this.indexWidgets.get(i)).createJSONConfig(repository, calculator, nodeVisitor));
            }
            jSONObject.put("editors", jSONArray);
        }
        return jSONObject;
    }

    public String getXType() {
        return "table";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[]{"beforeedit"};
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals(XML_TAG)) {
                this.setDataURL(xMLableReader.getAttrAsString("dataurl", null));
            } else if (string.equals("IndexWidget")) {
                IndexWidget indexWidget = new IndexWidget();
                indexWidget.readXML(xMLableReader);
                this.indexWidgets.add(indexWidget);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG(XML_TAG).attr("dataurl", this.getDataURL());
        if (this.indexWidgets.size() > 0) {
            int n = this.indexWidgets.size();
            for (int i = 0; i < n; ++i) {
                ((IndexWidget)this.indexWidgets.get(i)).writeXML(xMLPrintWriter);
            }
        }
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof Table && ComparatorUtils.equals(this.dataURL, ((Table)object).dataURL) && ComparatorUtils.equals((Object)this.indexWidgets, (Object)((Table)object).indexWidgets);
    }

    public Object clone() throws CloneNotSupportedException {
        Table table = (Table)super.clone();
        table.setDataURL(this.dataURL);
        if (this.indexWidgets.size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = this.indexWidgets.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(((IndexWidget)this.indexWidgets.get(i)).clone());
            }
            table.indexWidgets = arrayList;
        }
        return table;
    }
}

